@extends('layouts.app')
@section('content')
<!-- END PAGE HEADER-->
<!-- BEGIN TAB PORTLET--> 
<div class="row"> 
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.ServiceClassList') </span>
            </div>
            @permission('serviceClass-create')
            <div class="btn-group pull-right">
                    <a href="{{route('serviceClass.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button>
                </a> 
            </div>
            @endpermission
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="serviceClass">
                <thead>
                <tr> 
                    <th>@lang('layout.Name')</th>
                    <th>@lang('layout.Description')</th>
                    <th>@lang('layout.CreatedAt')</th>
                    <th>@lang('layout.UpdatedAt') </th>
                    <th>@lang('layout.Actions') </th>
                </tr>
                </thead> 
            </table>
        </div>
    </div>
</div> 
@stop

@push('scripts')

<script>
     $(document).ready(function() { 
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#serviceClass').DataTable( {
            ajax:           '{{route("serviceClass.index")}}',
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollY:        450,
            scrollCollapse: true,
            serverSide: true,
            paging:         true,
            columns: [
            { data: 'name', name: 'name' },
            { data: 'description', name: 'description' },
            { data: 'created_at', name: 'created_at' },
            { data: 'updated_at', name: 'updated_at' },
            { data: 'action', name: 'action', orderable: false, searchable: false },
 
            ] 
    }); 
    });

</script>


@endpush
