@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ServiceClassEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
            </div>
            <div class="portlet-body form" id="serviceClass" v-cloak>
                <!-- BEGIN FORM-->
                {!! Form::model($serviceClass,['method' => 'PATCH','route' => ['serviceClass.update',$serviceClass->id],'class'=>'form-horizontal']) !!}
                    <div class="form-body">
                        <div class="col-md-9"> 
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.ClassName'):</label>
                                <div class="col-md-9">
                                    {{Form::text('name',null,['class' => 'form-control','v-validate'=>'"required"','data-vv-as'=>__('layout.ClassName'),'placeholder' => __('layout.ClassName')])}}
                                     <span class="required">@{{ errors.first('name') }}</span>
                                </div>
                            </div> 
                             <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Description'):</label>
                                <div class="col-md-9">
                                  {!! Form::textarea('description', null, array('class' => 'form-control','rows' => 6, 'cols' => 30)) !!}
                                </div>
                            </div>
                        </div>  
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button @click="handleSubmit($event)" type="button" class="btn green">@lang('layout.Submit')</button>
                        <button href="{{url('serviceClass.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel') </button>
                     </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 
@endsection
@push('scripts')
<script type="text/javascript">
@if(App::getLocale())
  Vue.use(VeeValidate, {
      locale: '{{App::getLocale()}}',
  });
  @else
Vue.use(VeeValidate, {
    locale: 'en',
});
@endif

  let vu = new Vue({
        el: '#serviceClass',
        data:{

        },
        methods:{
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        regForm(e.target);
                    }
                });
            },
        }
    })
</script>
@endpush