@extends('layouts.app')
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'sendMoney'"
                      @closed="closeModal">
            <div slot=body>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.ContractNumber') </label>
                            <!--   <v-select class="vue-select2" v-model="selectedMember" label="name"
                                        :options="member">
                              </v-select> -->
                            <input type="number" name="number" class="form-control" autocomplete="off">
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <!--   <v-select class="vue-select2" v-model="selectedMember" label="name"
                                        :options="member">
                              </v-select> -->
                            <select class="form-control" name="type_name">
                                <option value="">@lang('layout.SelectType')</option>
                                <option value="return">@lang('layout.ReturnTheMoney')</option>
                                <option value="send">@lang('layout.SendTheMoney')</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>

                                <div slot="date">
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" autocomplete="off"
                                               name="from_date">

                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" autocomplete="off"
                                               name="to_date">

                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>



    @include('layouts.modal')


    <!-- END PAGE HEADER-->


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.SendMoneyList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('sendMoney-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                 </span>
                    @endpermission
                    @permission('sendMoney-create')
                    <a href="{{route('sendMoney.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" id="sendMoney">
                    <thead>
                    <tr>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.ContractName')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Bank')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Commission')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Total')
                            <span>{{getHomeCurrency()['code']}}</span>
                        </th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table =$('#sendMoney').DataTable({
                // 'order': [[ 8, 'desc' ]],

                ajax: '{{route("sendMoney.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:0}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                // scrollY: 450,
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'Date', name: 'date', searchable: false},
                    {data: 'Contract_Name', name: 'contracts.company_name'},
                    {data: 'type', name: 'send_moneys.type'},
                    {data: 'Account', name: 'accounts.name'},
                    {data: 'Amount', name: 'amount', orderable: false, searchable: false},
                    {data: 'commAmount', name: 'commAmount', orderable: false, searchable: false},
                    {data: 'Currency', name: 'transactions.unit'},
                    {data: 'Rate', name: 'rate', orderable: false, searchable: false},
                    {data: 'dollarAmount', name: 'dollarAmount', orderable: false, searchable: false},
                    {data: 'user', name: 'users.name'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},

                ]
            });
        });

 
        // for new modal

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',

                selectedMember: null,
                memberlist: [],

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },

                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        // /for new modal

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });
    </script>
@endpush
