@extends('layouts.app')
 @section('style')
<style type="text/css" href="{{url('vue/select2/select2.min.css')}}"></style>
@stop
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditSendMoney') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="app">
                <!-- BEGIN FORM-->
                {!! Form::model($sendMoney,array('route' => ['sendMoney.update',$sendMoney->id], 'method'=>'PATCH','class'=>'form-horizontal')) !!}
                {{ csrf_field() }} 
                    <div class="form-body"  v-cloak>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.ContractName')</label>
                                    <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedContract" label="company_name"
                                            :options="{{$contract}}">
                                    </v-select>
                                    <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id"  v-validate="'required'" data-vv-as="@lang('layout.ContractName')">
                                     <span class="required">@{{ errors.first('contract_id') }}</span>
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                        <select  class="form-control" v-model="selectedCurrency">
                                            <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                        </select>
                                    <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Account')</label>
                                    <select class="form-control" name="account_id" v-model="selectedAccount">
                                        <option v-for="Account in accountUpdate" :value="Account.id">@{{
                                            Account.name }}
                                        </option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Rate')</label>
                                     <div class="input-group">
                                        <input  v-model="selectedCurrency.exchange_rate" class="form-control"
                                                               type="number" min="0" >
                                        <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                    </div>
                                    <input type="hidden" name="rate" :value="selectedCurrency.exchange_rate">
                                </div>
                                 
                                 <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Amount')</label>
                                    {{Form::number('amount',ABS($transaction->amount),['class' => 'form-control',"v-validate"=>"'required'","data-vv-as"=>__('layout.Amount')])}}
                                     <span class="required">@{{ errors.first('amount') }}</span>
                                </div>
                            </div>  
                            <div class="col-md-6">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input class="form-control date" id="range-from-example" name="date" autocomplete="off" value="{{$sendMoney->date}}">
                                </div>
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <select class="form-control" name="type" v-model = "sendMoneyType">
                                        <option value="send">@lang('layout.SendTheMoney')</option>
                                        <option value="return">@lang('layout.ReturnTheMoney')</option>
                                    </select>
                                </div>
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {{--{!! Form::textarea('description', null, array('placeholder' => "__('layout.Description')",'class' => 'form-control','rows' => 4, 'cols' => 4)) !!} --}}
                                    <textarea name="description" class="form-control" rows="4" cols="4" placeholder="@lang('layout.Description')">{{$sendMoney->description}}</textarea>
                                </div> 
                            </div>
                            <div class="col-md-6">
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Expense') </label>
                                    <v-select label="name" :options="expense"
                                                v-model="selectedExpense" ></v-select>
                                    <input type="hidden" name="expense_id" v-bind:value="(!selectedExpense)?null:selectedExpense.id" />
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Commission')</label>
                                    {{Form::number('Commission_amount',null,['class' => 'form-control',"placeholder"=>__('layout.Amount')])}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 col-md-offset-4 text-center">
                        
                        <button  type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                        <a href="{{route('sendMoney.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
            </div>           
                 
            <!-- END FORM-->
        </div>
    </div> 
@endsection 
@push('scripts') 


<script src="{{url('/vue/sweetalert1.min.js')}}"></script>

<script>

    @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
        
     Vue.component("v-select", VueSelect.VueSelect);

        var Banks     = {!! $bank!!}
        var Currency ={!! $currency!!}
        var sendMoney = {!! $sendMoney !!};
        let expense = {!! $expense !!};

    new Vue({
        el: '#app',
        data: {

            // selectedCurrency:{!! json_encode(Currency()->getCurrency()) !!},
            selectedCurrency:null,
            sendMoney:sendMoney,
            currency:{!!  json_encode(getCurrencies()) !!},
            listAccounts:[],
            selectedContract:null,
            expense: expense,
            selectedExpense: null,
            currencyList: Currency,
            type: 'bank',
            account: {},
            contracts: {!!$contract!!},
            selectedAccount: null,
            accountChecked: false,
            sendMoneyType:sendMoney.type,
        },
        mounted(){
            this.selectedAccount = this.sendMoney.account_id;

            for(var a = 0; a<this.contracts.length; a++){
                if(this.contracts[a].id == this.sendMoney.contract_id){
                    this.selectedContract = this.contracts[a];
                    break; 
                }
            }
            for(var x in this.currency){
                for(var y in this.currency[x]){
                    if(this.currency[x][y] == "{{$transaction->unit}}"){
                        this.selectedCurrency = this.currency[x];
                        this.selectedCurrency.exchange_rate = {{$transaction->rate}};
                        console.log('selectcurrency',this.selectedCurrency);
                        break; 
                    }
                }
            }
            if(this.sendMoney.expense_id != null){
                this.selectedExpense = _.find(this.expense, (e) => e.id == this.sendMoney.expense_id);
            }
            
        },
        computed: {
            accountUpdate() {
                var b = _.clone(Banks);
                var Allaccounts = this.accounts = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                });
                if(this.accountChecked){
                    this.selectedAccount = Allaccounts[0].id;
                }
                this.accountChecked = true;

                return Allaccounts;
            },
        },
        methods: {
            handleSubmit(e) {
                
                this.$validator.validate().then(valid => {
                if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
            },
             onComplete: function () {
                document.getElementById("account-form").submit()
//                this.$emit('on-complete')
//                alert('Yay. Done!');
            },
          
        }
    });   
</script>
@endpush
 