@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('money_transfer');
$_code=in_array('code', $report);
$_date=in_array('date', $report);
$_contract_name=in_array('contract_name', $report);
$_bank=in_array('bank', $report);
$_amount=in_array('amount', $report);
$_currency=in_array('currency', $report);
$_rate=in_array('rate', $report);
$_total_in_home_currency=in_array('total_in_home_currency', $report);
$_type=in_array('type', $report);

?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.SendMonyReport')</h3>
<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>

@if($type)
<table   class="main-table">
  <tr>
    @if($type)
   <td>
    <span>@lang('layout.Type')</span>:
    @if($type =='send')
    <span >@lang('layout.SendTheMoney')</span>
    @endif
    @if($type =='return')
    <span>@lang('layout.ReturnTheMoney')</span>
    @endif
  </td>
  @endif
  
</tr>
</table>
@endif

<br>
<table class="main-table">
<thead>
  <tr class="bg">
 @if($_code)<td   class="center" ><div > @lang('layout.Code') </div></td>@endif
 @if($_date)<td   class="center"  ><div > @lang('layout.Date')</div></td>@endif
 @if($_contract_name)<td   class="center"  ><div > @lang('layout.Description')</div></td>@endif
 @if(!$type)
 @if($_type)<td   class="center"  ><div > @lang('layout.Type')</div></td>@endif
 @endif
 @if($_contract_name)<td   class="center"  ><div > @lang('layout.ContractName')</div></td>@endif
 @if($_bank)<td    class="center" ><div > @lang('layout.Bank')</div></td>@endif
 @if($_amount)<td   class="center"  ><div > @lang('layout.Amount')</div></td>@endif
 @if($_amount)<td   class="center"  ><div > @lang('layout.Commission')</div></td>@endif
 @if($_currency)<td   class="center" ><div > @lang('layout.Currency')</div></td>@endif
  @if($_rate)<td   class="center"  ><div > @lang('layout.Rate')</div></td>@endif
  
  @if($_total_in_home_currency)<td class="center"><div > @lang('layout.TotalInDollar')</div></td> @endif
  <td   class="center" ><div > @lang('layout.User')</div></td>

</tr>
</thead>
<?php
$count = 0;
$total_home_currency=0;
  $currencies=[];
  $currencies_re=[];
?>
@foreach($data AS $record)
<tr>
<?php
  if($record->type =='send'){
    if(systemConfig()[30] == 1){
      $total_home_currency+=$record->Amount/ $record->static_rate * $record->Rate;
    }else{
      $total_home_currency+=$record->Amount/$record->Rate;
    }
  }elseif($record->type =='return'){
    if(systemConfig()[30] == 1){
      $total_home_currency+=($record->Amount * -1)/ $record->static_rate * $record->Rate;
    }else{
      $total_home_currency+=($record->Amount * -1)/$record->Rate;
    }
  }
   if(array_key_exists($record->Currency, $currencies))
   {
    if($record->type =='send'){
      $currencies[$record->Currency]=$currencies[$record->Currency]+$record->Amount;
    }
  }
  else
  {
    if($record->type =='send'){
      $currencies[$record->Currency]=$record->Amount;
    }
  }
   if(array_key_exists($record->Currency, $currencies_re))
   {
    if($record->type =='return'){
      $currencies_re[$record->Currency]=$currencies_re[$record->Currency]+$record->Amount;
    }
  }
  else
  {
    if($record->type =='return'){
      $currencies_re[$record->Currency]=$record->Amount;
    }
  }
  ?>

@if($_code)<td  class="center">{{$record->Number}}</td>@endif
@if($_date)<td class="center">{{convertDate($record->Date)}}</td>@endif
@if($_contract_name)<td  class="center">{{$record->description}}</td>@endif

@if(!$type)
@if($_type)<td  class="center">
      @if($record->type =='send')
      <span >@lang('layout.SendTheMoney')</span>
      @endif
      @if($record->type =='return')
      <span>@lang('layout.ReturnTheMoney')</span>
      @endif
</td>@endif
@endif
@if($_contract_name)<td  class="center">{{$record->Contract_Name}}</td>@endif
@if($_bank)<td class="center">{{$record->Account}}</td>@endif
@if($_amount)<td  class="center">{{myRound($record->Amount)}}</td>@endif
@if($_amount)<td  class="center">{{myRound($record->commAmount)}}</td>@endif
@if($_currency)<td  class="center">{{$record->Currency}}</td>@endif
@if($_rate)<td class="center">{{$record->Rate}}</td>@endif
@if($_total_in_home_currency)<td  class="center">{{myRound($record->dollarAmount)}}</td>@endif
<td  class="center">{{$record->user}}</td>
</tr>
@endforeach

</table>
<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.SendTheMoney')</div></td>
</tr>
<tr>
  <td><div class="center"> @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency )
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>

<tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.ReturnTheMoney')</div></td>
</tr>
<tr>
  <td><div class="center"> @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies_re As $key=>$currency )
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>
</table>
<table border="1" style="width: 100%;border-collapse: collapse;margin-top: 20px;">
  <tr class="bg">
    <td colspan="2" style="text-align: center;font-size: 14px;"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
    <td style="text-align: center;font-size: 14px;"><div class="center">{{round($total_home_currency,2)}} {{getHomeCurrency()[getCurrencyType()]}}</div></td>
   </tr>
</table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection