@extends('layouts.app')
@section('content')
    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.GiftDetails')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th>
                                <i class="fa  fa-bars"></i>@lang('layout.SalesNumber') 
                            </th>
                            <th class="hidden-xs">
                                <i class="fa fa-text-width"></i>@lang('layout.Type')
                            </th>
                            <th class="hidden-xs">
                                <i class="fa fa-user"></i>  @lang('layout.Customer')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Date')
                            </th>
                            <!--th>
                                <i class="fa fa-file-excel-o"></i> @lang('layout.Account')
                            </th>
                            <th>
                                <i class="fa  "></i> @lang('layout.Rate')
                            </th>
                            <th> 
                                <i class="fa "></i>@lang('layout.Amount') 
                            </th>
                            <th> 
                                <i class="fa "></i>@lang('layout.Discount') 
                            </th>
                            <th>
                                <i class="fa  "></i>@lang('layout.Currency') 
                            </th -->
                            <th>
                                <i class="fa fa-text-width"></i>@lang('layout.Description') 
                            </th>
                        </tr> 
                    </thead>
                    <tbody>
                        <tr>  
                            <td class="hidden-xs"> {{ $sale->number}}  </td>
                            <td class="hidden-xs"> {{ $sale->type }}  </td>
                            <td class="hidden-xs"> {{ $sale->member_name }}  </td>
                            <td class="hidden-xs"> {{ convertDate($sale->date) }}  </td>
                            <!-- td class="hidden-xs"> {{ $sale->account_name}}  </td>
                            <td class="hidden-xs"> {{ $sale->rate }}  </td>
                            <td class="hidden-xs"> {{ myRound($sale->amount) }}  </td>
                            <td class="hidden-xs"> {{ myRound($sale->discount) }}  </td>
                            <td class="hidden-xs"> {{ $sale->currency }}  </td -->
                            <td class="hidden-xs"> {{ $sale->description }}  </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
     <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.Details')</span>
                    </div>
                    <div class="tools"></div>
                     <div class="actions">
                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="Sale_Details"/>
                           <input type="hidden" name="id" value="{{$sale->sale_id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="Sale_Details"/>
                           <input type="hidden" name="id" value="{{$sale->sale_id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="sales">
                        <thead>
                            <tr>
                                @if(getSerailNumber() =="true")
                                <th>@lang('layout.SerialNum')</th>
                                @endif
                                <th>@lang('layout.ItemName')</th>
                                <th>@lang('layout.Unit')</th>
                                <th>@lang('layout.PurchaseDate')</th>
                                <th>@lang('layout.SleepStaff')</th>
                                <th>@lang('layout.Quantity')</th>
                                <th>@lang('layout.Price')</th>
                                <th>@lang('layout.Cost')</th>
                                <th>@lang('layout.Income')</th>
                                <th>@lang('layout.Total')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
 @push('scripts')
<script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#sales').DataTable({
            ajax:'{{route("saleGift.show",$sale->sale_id)}}',
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [
				@if(getSerailNumber() =="true"){ data: 'number', name: 'number', orderable:false,searchable:false },@endif
				{ data: 'name', name: 'name', orderable:false,searchable:false },
                { data: 'symbol', name: 'symbol', orderable:false,searchable:false },
                { data: 'stocks_date', name: 'stocks_date', orderable:false,searchable:false },
                { data: 'sleepDate', name: 'sleepDate', orderable:false,searchable:false },
                { data: 'qty', name: 'qty', orderable:false,searchable:false },
                { data: 'price', name: 'price', orderable:false,searchable:false},
                { data: 'avgCost', name: 'avgCost', orderable:false,searchable:false},
                { data: 'income', name: 'income', orderable:false,searchable:false},
                { data: 'total', name: 'total', orderable:false,searchable:false},
        ]
        });

    });
</script>


@endpush 