@extends('layouts.app')
@section('content')

<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"  :value-type="selectedType" 
        @closed="closeModal">

        <div slot="body">
            <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop"> 
                    <ul class="nav nav-tabs"> 
                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['EmployeeRewards-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul>

                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <div class="row">
                                        
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.SelectMember') </label>
                                        <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                                :options="memberlist">
                                        </v-select>
                                        <input type="hidden" name="member_id"
                                            v-model.number="(!selectedMember)?null:selectedMember.id">
                                    </div>

                                    <div class="col-md-3">
                                        <label class="control-label ">@lang('layout.SelectType') </label>
                                        <select v-model="selectedType" class="form-control">
                                            <option value="SaleGiftList">@lang('layout.Simple')</option>
                                            <option value="GeneralSaleReportCustomerGift">@lang('layout.Details')</option>
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-3">
                                        <div class="form-group">
                                        <label class="control-label"> @lang('layout.ItemName')</label>
                                        <v-select label="name" v-model="selected_assembly_item" :options="temp_items" @search="onItemsSearch" ></v-select>
                                        <input type="hidden" name="item_id" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(!selected_assembly_item)?null:selected_assembly_item.id">
                                        </div>
                                    </div>



                                    </div>
                                    <div class="row">
                                        <div class="form-group">
                                           
                                            <div class="col-md-12" v-show="period == 'CustomDates'">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                    <div class="input-group">
                                                        <input class="form-control date" id="range-from-example"
                                                            v-model="from_date" name="from_date" autocomplete="off">
                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                        <input class="form-control date" id="range-to-example"
                                                            v-model="to_date" name="to_date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="sales_gift_index">


                                        <div class="col-md-12 col-sm-12 col-xs-12">

                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div> 
        </div>
    </report-modal>
</div>



    @include('sales.modal')
    <!-- END PAGE HEADER-->
    <!-- BEGIN TAB PORTLET-->
    <div id="ww" v-cloak>
        {{Form::open(['route' => 'refund.findRefund','method' => 'POST','class' => 'inline'])}}
        <button id="show-modalww" style="display: none" type="button" @click="editExampleww">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.InvoiceNumber') </label>
                            <!--  <v-select class="vue-select2" v-model="selectedMember" label="name"
                                       :options="member">
                                   </v-select> -->
                            <input type="number" name="number" class="form-control">
                            <input type="hidden" name="type" value="SaleGiftList">
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
    <div id="app" v-cloak>
        {{Form::open(['route'=> 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="SaleGiftList"/>
        <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">

                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                      :options="memberlist">
                            </v-select>
                            <input type="hidden" name="member_id"
                                   v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>
                         
                     

                        <div class="col-md-3">
                            <div class="form-group">
                              <label class="control-label"> @lang('layout.ItemName')</label>
                              <v-select label="name" v-model="selected_assembly_item" :options="temp_items" @search="onItemsSearch" ></v-select>
                              <input type="hidden" name="item_id" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(!selected_assembly_item)?null:selected_assembly_item.id">
                            </div>
                          </div>
 
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
    <!-- app -->
    <div id="app2" v-cloak>
        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="SaleGiftList"/>
        <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">

                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                      :options="memberlist">
                            </v-select>
                            <input type="hidden" name="member_id"
                                   v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>


                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example2" name="from_date">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example2" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>



    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.SaleGiftList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">

                    @permission('saleGift-export')
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                    @endpermission

                    @permission('saleGift-export')

                    {{-- <button type="submit" id="excell_all" class="btn btn-success"><i
                                class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>

                    <button type="button" class="btn btn-success" id="print_pdf_all"><i
                                class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button> --}}
                    @endpermission
                    @permission('saleGift-create')
                    <a href="{{route('saleGift.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                <!-- <button class="btn btn-success" id="addNewRefundd">
                                <i class="icon-action-redo"></i> @lang('menu.Refund')
                        </button> -->
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered " cellspacing="0" id="sale">
                    <thead>
                        <tr>
                            <th>@lang('layout.SalesNumber')</th>
                            <th>@lang('layout.CustomerName')</th>
                            <th>@lang('layout.SalesType')</th>
                        <!-- th>@lang('layout.Account')</th -->
                            <th>@lang('layout.Date')</th>
                        <!-- th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Discount')</th -->
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    <!-- for factor begin -->

    <div id="factor-obj">

    </div>
    <iframe id="saleFrames" style="display: none;"></iframe>

    <!-- end for factor -->



@stop
@include('groupCompanyFilter.select')
@push('scripts')
@include('print.modal')

    <script>

        @if(Session('sale_id') && getFactorPrint()== "automatic")
        factorPrint("{{Session('sale_id')}}")

        @endif

        var cust_rep = {!!customeReportNewData('sales_gift_index')!!};


        function factorPrint(id) {


            var a = document.createElement('a');
            a.href = "{{url('giftFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);

        }


        let data_table;

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            data_table = $('#sale').DataTable({
                ajax: '{{route("saleGift.index")}}',
                order: [["{{orderByColumn()=='number'?0:3}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [

                    {data: 'number', name: 'sales.number'},
                    {data: 'member_name', name: 'members.name'},
                    {data: 'type', name: 'type', orderable: false, searchable: false},
                    {data: 'date', name: 'sales.date'},
                    {data: 'username', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]


            });


            $('#btnPrint').click(function () {
                $.ajax({
                    // This PHP file will generate the PDF and save it to your server
                    // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    url: '{{route("saleGift.show",1)}}',
                    type: 'get',
                    cache: false,

                }).done(function () {

                    var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                    $('#factor-obj').html(s);


                    // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                })
                    .fail(function () {
                        console.log("error");
                    });

                // window.print();
                // window.open("data:application/pdf," + escape(data=""));
                $.ajax({
                    // This PHP file will generate the PDF and save it to your server
                    // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    url: '{{route("saleGift.show",1)}}',
                    type: 'get',
                    cache: false,

                }).done(function () {

                    var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                    $('#factor-obj').html(s);


                    // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                })
                    .fail(function () {
                        console.log("error");
                    });

            });


        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });
        // start app
       var vmn = new Vue({
            el: '#app',
            data: {
                showModal: false,
                selectedMember: null,
                memberlist: [],
                temp_items: [],
                selected_assembly_item: null
            },
            methods: {
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },


                onItemsSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                    method_name: 'items_search_assebley',
                    'type': 'builds_statistic',
                    keyword: search,
                    }
                })
                .then(function(response) {
                    vmn.temp_items = [];
                    if (response.data.length > 0) {
                    
                    vmn.temp_items = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    console.log(error);
                })
            }, getDebounceTime()),


                //ajax call to get items
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample: function () {


                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
        $('#print_pdf_all').on('click', function (e) {
            $('#show-modal').click();
            e.preventDefault();
        })
        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#app2',
            data: {
                showModal: false,
                selectedMember: null,
                memberlist: [],
            },
            methods: {
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },

                //ajax call to get items
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample2: function () {


                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
        $('#excell_all').on('click', function (e) {
            $('#show-modal2').click();
            e.preventDefault();
        })

        new Vue({
            el: '#ww',
            data: {
                showModal: false
            },
            methods: {
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExampleww: function () {

                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }

            },
        });
        $('#addNewRefundd').on('click', function (e) {
            $('#show-modalww').click();
            e.preventDefault();
        })



        
        

        var vmPrint = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                selectedMember: null,
                selectedType: 'SaleGiftList',
                memberlist: [],
                temp_items: [],
                selected_assembly_item: null,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                customReportData:
                [
                {Name: '@lang("layout.SaleNumber")', column_name: 'sale_number',checkedColumn:(cust_rep.sale_number)?'checked':'',column_percentage:(cust_rep.sale_number___percent)?cust_rep.sale_number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(cust_rep.reference_number)?'checked':'',column_percentage:(cust_rep.reference_number___percent)?cust_rep.reference_number___percent:''},
                 {Name: '@lang("layout.Class")', column_name: 'class',checkedColumn:(cust_rep.class)?'checked':'',column_percentage:(cust_rep.class___percent)?cust_rep.class___percent:''},
                 {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(cust_rep.customer)?'checked':'',column_percentage:(cust_rep.customer___percent)?cust_rep.customer___percent:''},
                 {Name: '@lang("layout.Site")', column_name: 'site',checkedColumn:(cust_rep.site)?'checked':'',column_percentage:(cust_rep.site___percent)?cust_rep.site___percent:''},
                 {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_rep.item_name)?'checked':'',column_percentage:(cust_rep.item_name___percent)?cust_rep.item_name___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(cust_rep.unit)?'checked':'',column_percentage:(cust_rep.unit___percent)?cust_rep.unit___percent:''},
                 {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_rep.price)?'checked':'',column_percentage:(cust_rep.price___percent)?cust_rep.price___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                ],
                cust_rep:cust_rep
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                }, 
                onItemsSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                    method_name: 'items_search_assebley',
                    'type': 'builds_statistic',
                    keyword: search,
                    }
                })
                .then(function(response) {
                    vmPrint.temp_items = [];
                    if (response.data.length > 0) {
                    
                    vmPrint.temp_items = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    console.log(error);
                })
            }, getDebounceTime()),



             searchMember(search, loading, vmPrint) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vmPrint.memberlist = response.data;
                                // console.log('data', vmPrint.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vmPrint.getDate(vmPrint.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vmPrint.from_date = null;
                        vmPrint.to_date = null;
                        if (response.data) {
                            vmPrint.from_date = response.data.start;
                            vmPrint.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vmPrint.period = 'CustomDates';
                        vmPrint.from_date = null;
                        vmPrint.to_date = null;
                        })
                    } else {
                        vmPrint.from_date = null;
                        vmPrint.to_date = null;
                    }
                    }
                },
            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vmPrint.$data.is_show = true;
                }
            }
        });
    </script>


@endpush
