@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('sales');
$_date=in_array('date', $report);
$sale_number=in_array('sale_number', $report);
$_customer=in_array('customer', $report);
$_account_name=in_array('account_name', $report);
$_amount=in_array('amount', $report);
$_unit=in_array('unit', $report);
$_rate=in_array('rate', $report);
$_discount_type=in_array('discount_type', $report);
$_discount=in_array('discount', $report);
$_description=in_array('description', $report);
?>
<h4></h4>
<table>
<tr>
<td><span>@lang('layout.FromDate'):</span>{{convertDate($from_date)}}</td>
<td><span>@lang('layout.ToDate'):</span>{{convertDate($to_date)}}</td>

</tr>
</table>
<h3 class="table-caption" style="text-align: center;">@lang('layout.GeneralSaleReportCustomer')</h3>
<table class="main-table">

<thead>
  <tr class="bg">
 <td class="center" ><div> @lang('layout.Record') </div></td>
 @if($sale_number)<td class="center" ><div> @lang('layout.SaleNumber') </div></td>@endif

  @if($_date)<td class="center" ><div> @lang('layout.Date')</div></td>@endif
   @if($_customer)<td class="center" ><div> @lang('layout.Customer')</div></td>@endif
 <td class="center"  ><div> @lang('layout.Site')</div></td>
 <td class="center"  ><div> @lang('layout.ItemName')</div></td>
 <td class="center"  ><div> @lang('layout.Quantity')</div></td>
 <td class="center"  ><div> @lang('layout.Unit')</div></td>
   @if($_amount)<td class="center" ><div> @lang('layout.Amount')</div></td>@endif
   @if($_unit)<td class="center" ><div> @lang('layout.Unit')</div></td>@endif
   @if($_rate)<td class="center" ><div> @lang('layout.Rate')</div></td>@endif
   
 </tr>
</thead>
<?php
$count = 0;
$total_home_currency=0;
  $currencies=[];
?>
@foreach($data AS $record)
<tr>
<?php
   $total_home_currency+=$record->exchanged_amount;
   if(array_key_exists($record->Currency, $currencies))
   {
    $currencies[$record->Currency]=$currencies[$record->Currency]+$record->Amount;
  }
  else
  {

    $currencies[$record->Currency]=$record->Amount;
  }
  ?>

<td class="center">{{++$count}}</td>
@if($sale_number)<td class="center">{{$record->Number}}</td>@endif

 @if($_date)<td  class="center">{{convertDate($record->Date)}}</td>@endif
 @if($_customer)<td class="center">{{$record->Name}}</td>@endif
<td  class="center">{{$record->site_name}}</td>
<td  class="center">{{$record->item_name}}</td>
<td  class="center">{{$record->quantityOut}}</td>
<td  class="center">{{$record->um}}</td>
 @if($_amount)<td class="center">{{round($record->Amount,2)}}</td>@endif
 @if($_unit)<td  class="center">{{$record->Unit}}</td>@endif
 @if($_rate)<td class="center">{{$record->rate}}</td>@endif



</tr>
@endforeach   
</table>


<h3 class="table-caption" style="text-align: center;">@lang('layout.TotalSale')</h3>



<table class="main-table">

<thead>
  <tr class="bg">
 <td><div class="center"> @lang('layout.Record') </div></td>
   @if($_date)<td><div class="center"> @lang('layout.Date')</div></td>@endif
 <td ><div class="center"> @lang('layout.ItemName')</div></td>
 <td ><div class="center"> @lang('layout.Quantity')</div></td>
 <td ><div class="center"> @lang('layout.Unit')</div></td>
   @if($_amount)<td><div class="center"> @lang('layout.Amount')</div></td>@endif
   @if($_unit)<td><div class="center"> @lang('layout.Unit')</div></td>@endif

 </tr>
</thead>
<?php
$count = 0;
?>
@foreach($summary AS $record)
<tr>
<td class="center">{{++$count}}</td>
 @if($_date)<td  class="center">{{convertDate($record->Date)}}</td>@endif
<td  class="center">{{$record->item_name}}</td>
<td  class="center">{{$record->quantityOut}}</td>
<td  class="center">{{$record->um}}</td>
 @if($_amount)<td class="center">{{round($record->Amount,2)}}</td>@endif
 @if($_unit)<td  class="center">{{$record->Unit}}</td>@endif

</tr>
@endforeach   
</table>










<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center"> @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>
<tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{round($total_home_currency,2)}} {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>

</table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection