@extends('layouts.factor-master')

@section('content')
<?php

$report = customeReportNew('sales_gift_index');
 
$_sale_number = !in_array('sale_number', $report);
$_date = !in_array('date', $report);
$_reference_number = !in_array('reference_number', $report);
$_class = !in_array('class', $report);
$_customer = !in_array('customer', $report);
$_site = !in_array('site', $report);
$_item_name = !in_array('item_name', $report);
$_quantity = !in_array('quantity', $report);
$_unit = !in_array('unit', $report);
$_price = !in_array('price', $report);
$_total = !in_array('total', $report);

// dd($_record);

$report_percent = customeReportNewPercent('sales_gift_index');
$_sale_number_percent= (array_key_exists('sale_number___percent', $report_percent))?$report_percent['sale_number___percent']:null;
$_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
$_reference_number_percent= (array_key_exists('reference_number___percent', $report_percent))?$report_percent['reference_number___percent']:null;
$_class_percent= (array_key_exists('class___percent', $report_percent))?$report_percent['class___percent']:null;
$_customer_percent= (array_key_exists('customer___percent', $report_percent))?$report_percent['customer___percent']:null;
$_site_percent= (array_key_exists('site___percent', $report_percent))?$report_percent['site___percent']:null;
$_item_name_percent= (array_key_exists('item_name___percent', $report_percent))?$report_percent['item_name___percent']:null;
$_quantity_percent= (array_key_exists('quantity___percent', $report_percent))?$report_percent['quantity___percent']:null;
$_unit_percent= (array_key_exists('unit___percent', $report_percent))?$report_percent['unit___percent']:null;
$_price_percent= (array_key_exists('price___percent', $report_percent))?$report_percent['price___percent']:null;
$_total_percent= (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
 
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.DetailsReportGift')</h3>

<table>
@if($from_date || $to_date)
<tr>
  @if($from_date)
  <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
@endif
</table>
 

<table class="main-table">

  <thead>
    <tr class="bg">
      <td>
        <div class="center"> @lang('layout.Record') </div>
      </td>
      @if($_sale_number)
      <td  @if($_sale_number_percent) width="{{$_sale_number_percent}}%" @endif>
        <div class="center"> @lang('layout.SaleNumber') </div>
      </td>
      @endif
      @if($_date)
      <td  @if($_date_percent) width="{{$_date_percent}}%" @endif>
        <div class="center"> @lang('layout.Date')</div>
      </td>
      @endif
      @if($_reference_number)
    
      <td  @if($_reference_number_percent) width="{{$_reference_number_percent}}%" @endif>
        <div class="center"> @lang('layout.ReferenceNumber') </div>
      </td>
      @endif
      @if($_class)
      <td  @if($_class_percent) width="{{$_class_percent}}%" @endif>
        <div class="center"> @lang('layout.Class')</div>
      </td>
      @endif
      @if($_customer)
      <td  @if($_customer_percent) width="{{$_customer_percent}}%" @endif>
        <div class="center"> @lang('layout.Customer')</div>
      </td>
      @endif
      @if($_site)
      <td  @if($_site_percent) width="{{$_site_percent}}%" @endif>
        <div class="center"> @lang('layout.Site')</div>
      </td>
      @endif
      @if($_item_name)
      <td  @if($_item_name_percent) width="{{$_item_name_percent}}%" @endif>
        <div class="center"> @lang('layout.ItemName')</div>
      </td>
      @endif
      @if($_quantity)
      <td  @if($_quantity_percent) width="{{$_quantity_percent}}%" @endif>
        <div class="center"> @lang('layout.Quantity')</div>
      </td>
      @endif
      @if($_unit)
      <td  @if($_unit_percent) width="{{$_unit_percent}}%" @endif>
        <div class="center"> @lang('layout.Unit')</div>
      </td>
      @endif
      @if($_price)
      <td  @if($_price_percent) width="{{$_price_percent}}%" @endif>
        <div class="center"> @lang('layout.Price')</div>
      </td>
      @endif
      @if($_total)
      <td  @if($_total_percent) width="{{$_total_percent}}%" @endif>
        <div class="center"> @lang('layout.Total')</div>
      </td>
      @endif
      <!-- td><div class="center"> @lang('layout.Amount')</div></td -->
      <!-- td><div class="center"> @lang('layout.Unit')</div></td -->
      <!-- td><div class="center"> @lang('layout.Rate')</div></td -->





    </tr>
  </thead>
  <?php
  $count = 0;
  $total_home_currency = 0;
  $measures = [];
  $total_col_span = 11;
  ?>
  @foreach($data AS $record)
  <tr>
    <?php
    $total_home_currency += ($record->price * $record->quantityOut);

    if (array_key_exists($record->um, $measures)) {
        $measures[$record->um] = $measures[$record->um] + $record->quantityOut;
    } else {
        $measures[$record->um] = $record->quantityOut;
    }
    ?>
    <td class="center">{{++$count}}</td>
    @if($_sale_number)
    <td class="center">{{$record->Number}}</td> 
    @endif
    @if($_date)
    <td class="center">{{convertDate($record->Date)}}</td>
    @endif
    @if($_reference_number)
    <td class="center">{{$record->refNo}}</td>
    @endif
    @if($_class)
    <td class="center">{{$record->className}}</td>
    @endif
    @if($_customer)
    <td class="center">{{$record->Name}}</td>
    @endif
    @if($_site)
    <td class="center">{{$record->site_name}}</td>
    @endif
    @if($_item_name)
    <td class="center">{{$record->item_name}}</td>
    @endif
    @if($_quantity)
    <td class="center">{{$record->quantityOut}}</td>
    @endif
    @if($_unit)
    <td class="center">{{$record->um}}</td>
    @endif
    @if($_price)
    <td class="center">{{myRound($record->price)}}</td>
    @endif
    @if($_total)
    <td class="center">{{myRound($record->price * $record->quantityOut)}}</td>
    @endif
    <!-- td class="center">{{round($record->Amount,2)}}</td -->
    <!-- td  class="center">{{$record->Unit}}</td -->
    <!-- td class="center">{{$record->rate}}</td --> 
  </tr>
  @endforeach

  @if(!$_sale_number)   <?php  $total_col_span = $total_col_span-1;  ?>       @endif
  @if(!$_date)   <?php  $total_col_span = $total_col_span-1;  ?>       @endif
  @if(!$_reference_number)   <?php  $total_col_span = $total_col_span-1;  ?>       @endif
  @if(!$_class)   <?php  $total_col_span = $total_col_span-1;  ?>       @endif
  @if(!$_customer)   <?php  $total_col_span = $total_col_span-1;  ?>       @endif
  @if(!$_site)   <?php  $total_col_span = $total_col_span-1;  ?>       @endif
  @if(!$_item_name)   <?php  $total_col_span = $total_col_span-1;  ?>       @endif
  @if(!$_quantity)   <?php  $total_col_span = $total_col_span-1;  ?>       @endif
  @if(!$_unit)   <?php  $total_col_span = $total_col_span-1;  ?>       @endif
  @if(!$_price)   <?php  $total_col_span = $total_col_span-1;  ?>       @endif
  @if(!$_total)   <?php  $total_col_span = $total_col_span-1;  ?>       @endif


  <tr class="bg">
    <td colspan="{{$total_col_span}}" class="center">@lang('layout.Total')</td>
    <td> {{myRound($total_home_currency)}} </td>
  </tr>
</table>


<table class="main-table" style="margin-top: 20px">
  <tr class="bg">
    <td colspan="3" class="center">
        @lang('layout.Record')
    </td>
    <td colspan="8" class="center">
         @lang('layout.Measure') 
    </td>
    <td colspan="8" class="center">
         @lang('layout.Quantity') 
    </td>
</tr>
<?php
$count = 0;
foreach ($measures as $key => $meas) {
?>
    <tr>
        <td colspan="3" class="center">
            {{++$count}}
        </td>
        <td colspan="8" class="center">
            {{$key}}
        </td>
        <td colspan="8" class="center">
            {{myRound($meas)}}
        </td>
    </tr>
<?php
}
?> 
</table>
 
<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection