@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>
.required{padding-left: 0px !important; color: red;}
</style>
@stop
@section('content')
@include("layouts.Cmodal")
<div class="row"> 
    <div class="portlet light bordered">
          <!-- BEGIN TAB PORTLET-->
          <div class="portlet light bordered sale">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>&nbsp;
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.SaleGift')</span>
                    </div>
                    <div class="actions">
                    </div>
                </div>
                <div id="app" class="portlet-body">
        
                    <div class="tabbable tabbable-tabdrop">
          
                        
            
                          <div>
                            {{Form::open(['route' => 'saleGift.store','method' => 'POST','class' => 'form-horizontal','id'=>'sales-form'])}}
                                    {{ csrf_field() }}
                          <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                               <div  v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                    <!-- BEGIN FORM-->
                                    

                                        <div class="form-body">
                                          <div class="row">
                                            <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                                              <!-- begin inputs -->
                                               <div class="row" v-show="showWhat('member_class')=='yes'">
        
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                                          
                                                        <div class="col-md-12">
                                                          <label class="control-label">@lang('layout.CustomerClass')</label>
                                                            
                                                             <v-select  label="name":options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                                             <input type="hidden" name="class_id"   :value="!selected_class?null:selected_class.id" >
                                                          </div>
                                                    </div> 
                                                  </div>

                                                </div>
                                              <div class="row">
                                                <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                                                  <div class="form-group">
                                                      
                                                      <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Customer')</label>
                              
                                                           <v-select  label="name" @input="memberChange()" @search="MemberSearch" :options="customer" v-model="selected_customer"></v-select>
                                                           <input type="hidden" name="customer" v-validate="'required'" data-vv-as="@lang('layout.Customer')" :value="!selected_customer?null:selected_customer.id" required>
                                                           <input type="hidden" name="customer_id" :value="Customer_id">
														                                <input type="hidden" name="c_gift_id" :value="gift_id">
                            														<span class="required">@{{ errors.first('customer') }}</span>
                            													 </div>
                                                  </div> 
                                                </div>

                                                <!-- div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                  <div class="form-group">
                                                      <div class="col-md-12">
                                                      <label class="control-label col-md-12"><br></label>
                                                          
                                                          <button type="button" class="btn blue" @click="showModal = true">@lang('layout.NewCustomer')</button>
                                                      </div>
                                                  </div> 
                                                </div -->
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                  <div class="form-group">
                                                      
                                                      <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.InvoiceNumber')</label>
                            
                                                           <input type="number" name="number" v-validate="'required|numeric'" data-vv-as="@lang('layout.InvoiceNumber')" v-model="number" class="form-control">
														                                 <span class="required">@{{ errors.first('number') }}</span>
														   
                                                      </div>
                                                  </div> 
                                                </div>

                                              

                                              </div>

                                            <!-- div class="row">
                                               
                                              
                                              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                      
                                                      <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Currency')</label>
                            
                                                        
                                                          <v-select  label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                                                          <input type="hidden" name="currency"  v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
														                               <span class="required">@{{ errors.first('currency') }}</span>

                                                      </div>
                                                  </div> 
                                              </div>

                                               <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                  <div class="form-group">
                                                      
                                                      <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Rate')</label>
                            
                                                           <input type="number" name="currency_rate" name="rate" v-validate="'required'" data-vv-as="@lang('layout.Rate')" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                    														<span class="required">@{{ errors.first('currency_rate') }}</span>

                    													  </div>
                                                  </div> 
                                              </div>
                                              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                  <div class="form-group">
                                                      
                                                      <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Discount')</label>
                                                            
                                                             <div class="input-group">
                                                           
                                                            <input  v-model="discountFiled" class="form-control"
                                                           type="number" min="0" max="100">
                                                                <span  v-if="discountIsAmount"  @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}}
                                                                  <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                                              </span>
                                                              <span  v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon" >%
                                                                  <input type="hidden" name="discount_type" value="percent">
                                                              </span>
                                                              <input type="hidden" name="discountTotal" :value="discount">
                                                              <input type="hidden" name="discount" :value="discountFiled">
                                                         </div>

                                                      </div>
                                                  </div> 
                                              </div>
                                            </div -->

                                            <div class="row">
                                                <!-- div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                  <div class="form-group">
                                                      <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Account')</label>
                            
                                                           <v-select  label="name"  :options="approperiateBank" v-model="selected_banks"></v-select>
                                                           <input type="hidden" name="bank_account"  v-validate="'required'" data-vv-as="@lang('layout.Account')" :value="(this.selected_banks==null)?null:selected_banks.id">
                          															<span class="required">@{{ errors.first('bank_account') }}</span>
                          													  </div>
                                                  </div> 
                                              </div -->
                                              <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                                                  <div class="form-group">
                                                      <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Description')</label>
                            
                                                            <textarea  name="description" class="form-control" rows="1"></textarea>
                                                      </div>
                                                  </div> 
                                              </div>
                                              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                  <div class="form-group">
                                                      
                                                      <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Date')</label>
                            
                                                           <input type="text" name="date"  class="form-control date now" autocomplete="off">
                                                      </div>
                                                  </div> 
                                              </div>
                                            </div>
                                              <!-- end inputs -->
                                          </div>
                                           <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" v-show="seePrice == true">

                                            <!-- begin total -->
                                               <!-- div class="dashboard-stat2 ">
                                                <table class="dashboard-tabel" width="100%">
                                                  <tr>
                                                      <td>
                                                          <small>@lang('layout.Total') :</small>
                                                      </td>
                                                      <td class="text-right"><span data-counter="counterup"
                                                         data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(precision())}}</span>
                                                         <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                                     </td>
                                                 </tr>

                                                 <tr>
													  <td>
														  <small>@lang('layout.Discount'): (@{{ Number.parseFloat(discount).toFixed(precision()) }}%)</small>
													  </td>
													  <td class="text-right">
													   <span class="text-right" data-counter="counterup"
													   data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
													   <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
												   </td>
											   </tr>

                                              <tr>
                                                  <td>
                                                      <small>@lang('layout.Sub-Total'):</small>
                                                  </td>
                                                  <td class="text-right">
                                                      <span class="text-right" data-counter="counterup"
                                                      data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                                      <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                                  </td>
                                              </tr>


                                          </table>

                                               </div -->

                                            <!-- end total -->
                                           </div>

                                          </div>

                                           <div class="row" style="overflow-x: scroll;">
                                               <table id="table_content" class="table table-bordered table-advance">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
														<th v-show="showWhat('sale_category')=='yes'"
                                                            style="min-width: 130px">@lang('layout.Category') </th>
                                                        @if(getSerailNumber() =="true")
														  <th style="min-width: 80px">@lang('layout.SerialNum') </th>
														  @endif
                                                        <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                                        <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                                        <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                                         <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') :2</th>
                                                        <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                        <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                                        <th v-show="showWhat('other_measure')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue') </th>
                                                        <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                        <!-- th v-show="seePrice == true" style="min-width: 20px">@lang('layout.Cost') </th>
                                                        <th v-show="seePrice == true" style="min-width: 100px">@lang('layout.NewPrice') </th>
														
														  @if(getFactorOtherMeasure() =="true")
														  <th style="min-width: 100px">@lang('layout.Measure1') </th>
														  <th style="min-width: 100px">@lang('layout.Measure2') </th>
														  @endif
                                                         <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th>
                                                        <th v-show="seePrice == true" style="min-width: 100px">@lang('layout.Total') </th -->
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(item,index) in inventories">
                                                        <td>@{{index+1}}</td>
														<td v-show="showWhat('sale_category')=='yes'">
                                                            <v-select label="name" v-model="item.item_category"
                                                                      :options="inventory_category"
                                                                      @input="itemCategoryChange(index)"></v-select>
                                                            <input type="hidden" :name="'inventory_category_id['+index+']'"
                                                                   :value="(!item.item_category)?null:item.item_category.id">
                                                        </td>
                                                        
														@if(getSerailNumber() =="true")
														   <td>
																<input :value="(!item.item)?null:item.item.number" class="form-control input-style input-number"  placeholder="@lang('layout.SerialNum')" disabled>
															</td>
														  @endif
                                                        <td class="highlight">
                                                            <v-select label="name" @keyup.native="onItemload(index)" @Click.native="onItemload(index)" v-model="item.inventory" :options="temp_items" @search="onItemSearch"></v-select>
                                                            <input type="hidden" :name="'inventory_id['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
															<span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                                            <input type="hidden" :name="'gift_id['+index+']'" :value="(item.item && item.item.gift_id)?item.item.gift_id:null">
														</td>
                                                         <td class="highlight">
                                                            <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                                               <option value="null">@lang('layout.Select')</option>
                                                               <span v-if="(item.item != null)">
                                                                <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                  @{{site.site_name}}
                                                                </option> 
                                                              </span>
                                                            </select>
                                                           
                                                            <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                        </td>
                                                        <td v-show="showWhat('sale_description')=='yes'">
                                                           <input type="text" placeholder="@lang('layout.Description')" name="inventory_description[]" class="form-control">
                                                        </td>
                                                        <td v-show="showWhat('sale_description')=='yes'">
                                                           <input type="text" placeholder="@lang('layout.Description')" name="description2[]" class="form-control">
                                                        </td>
                                                      
                                                        <td>


                                                           <input type="number" :name="'inventory_quantity['+index+']'" v-validate="''" data-vv-as="@lang('layout.Quantity')" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number"  placeholder="@lang('layout.Quantity')">
                            															<span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                            														</td>

                                                        <td>
                                                           @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                                        </td>
                                                        <td v-show="showWhat('other_measure')=='yes'">
                                                       <input type="number" name="other_measure_amount[]"  class="form-control input-style input-number"  placeholder="@lang('layout.OMeasureValue')">
                                                    </td>
                                                          <td class="highlight">
                                                            <select  v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                    @{{measure.measure_name}}
                                                                  </option> 
                                                                </span>
                                                                
                                                               
                                                            </select>
                                                           
                                                            <input type="hidden" name="inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>
                                                         <!-- td v-show="seePrice==true">
                                                          <div class="input-group">
                                                            <input type="number"  placeholder="@lang('layout.Price')"   v-bind:value="(item.item==null)?null:(item.item.LasCost*selected_currency.rate)"  class="form-control" disabled="disabled">
                                                            <span class="input-group-addon">
                                                              @{{selected_currency.symbol}}
                                                            </span>
                                                          </div>
                                                           
                                                        </td>  
                                  
                                                        <td v-show="seePrice == true">
                                                          <div class="input-group">
                                                            <input type="number" name="inventory_price[]"  placeholder="@lang('layout.Price')"   :value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate)" ref="in" @input="setNewRate('inventory',index)" class="form-control">
                                                            <span class="input-group-addon">
                                                              @{{selected_currency.symbol}}
                                                            </span>
                                                          </div>
                                                           
                                                        </td>
														
														@if(getFactorOtherMeasure() =="true")
														  <td>
															  <select name="measure1[]" class="form-control">
																  <option value="null">@lang('layout.Select')</option>
																  <span v-if="(item.item ==null)?false:true">
																	  <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
																	  @{{measure.measure_name}}
																	</option> 
																  </span>
															  </select>
														  </td>
														  <td>
															  <select name="measure2[]" class="form-control">
																  <option value="null">@lang('layout.Select')</option>
																  <span v-if="(item.item ==null)?false:true">
																	  <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
																	  @{{measure.measure_name}}
																	</option> 
																  </span>
															  </select>
														  </td>
														  @endif
														
                                                        <td v-show="showWhat('sale_discount')=='yes'">
                                                          <div class="input-group">
                                                            <input type="number" name="inventory_discount[]"  placeholder="@lang('layout.Discount')"  v-model.number="(item.item==null)?null:item.item.discount"  class="form-control">
                                                            <span class="input-group-addon" v-if="discountIsAmount">
                                                              @{{selected_currency.symbol}}
                                                            </span>
                                                            <span class="input-group-addon" v-if="!discountIsAmount">
                                                              %
                                                            </span>

                                                          </div>
                                                           
                                                        </td>
                                                        <td v-show="seePrice == true">
                                                               <div class="input-group">
                                                                <input type="number" class="form-control inner_input" :value="(item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount)" placeholder="@lang('layout.Total')" disabled>
                                                              <span class="input-group-addon" >
                                                                  <b>@{{selected_currency.symbol}}</b>
                                                              </span>
                                                               </div>
                                                        </td -->
                                                        <td>
                                                             <span  v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                             <!--span  @click="addNew('inventory',index)"><i class="paddint-both glyphicon glyphicon-plus"></i></span -->
                                                        </td>
                                                    </tr>
                          													<tr style="background-color: #ffffff;">
                          														<td></td>
                          														<td><center> 
                          															<button type="button" @click="addNew('inventory',100)" class="btn btn-success" ><i class="fa fa-plus"></i></button>
                          														</center></td>
                          														<td></td>
                          														<td></td>
                          														<td></td>
                          														<td></td>
                          														<td></td>
                          													</tr> 
                                                </tbody>
                                            </table>

                                           <hr>
                                              <!-- begin service -->
                                               <table v-if="services.length>0" id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-center" style="min-width: 8px;"> # </th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>
                                                            
                                                            <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                            <th></th>
                                                      
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for="(service,index) in services">
                                                            <td>@{{index+1}}</td>
                                                            <td class="highlight">
                                                                <v-select label="name" v-model="service.item"  :options="(service.items)" @click.native="addNew('service',index)" @input="checkExistingService(index)">
                                                                  
                                                                </v-select>
                                                                <input type="hidden" name="service_id[]" :value="(service.item==null)?null:service.item.id">
                                                            </td>
                                                        
                                                            <td>
                                                              <input class="form-control" name="service_quantity[]" v-model.number="(!service.item)?null:service.item.quantity" placeholder="@lang('layout.Quantity')">
                                                            </td>
                                                            <td class="highlight">
                                                                <select  v-model="(service.item == null)?null:service.item.measure" class="form-control" @change="measureChangeservice(index)">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(service.item ==null)?false:true">
                                                                        <option  v-for="measure in (service.item==null)?null:service.item.measure_list" :value="measure">
                                                                        @{{measure.measure_name}}
                                                                      </option> 
                                                                    </span>
                                                                    
                                                                </select>
                                                               
                                                                <input type="hidden" name="service_measure[]" :value="(service.item==null)?null:service.item.measure.measure_id">
                                                            </td>
                                                            <td>
                                                                <div class="input-group">
                                                                  <input type="number" name="service_price[]"  placeholder="@lang('layout.Cost')"   :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate, null, selected_currency.static_rate)" ref="ser" @input="setNewRate('service',index)" class="form-control">
                                                                  <span class="input-group-addon">
                                                                    @{{selected_currency.symbol}}
                                                                  </span>
                                                                </div>
                                                              
                                                            </td>
                                                            <td>
                                                                <div class="input-group">
                                                                      <input type="number" class="form-control inner_input"   :value="(service.item==null)?null:getItemTotalService(service.item,selected_currency.rate, null, selected_currency.static_rate)" placeholder="@lang('layout.Total')" disabled>
                                                                  <span class="input-group-addon" >
                                                                      <b>@{{selected_currency.symbol}}</b>
                                                                  </span>
                                                                   </div>
                                                            </td>
                                                            <td>
                                                                 <span  v-on:click="deleteItem('service',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                               <!-- end service -->
                                          
                                           
                                           </div>
                                                            
                                                       
                                         
                                        </div>
                                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                            <button type="button" v-if="!isError" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                                            <!-- button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button -->

                                            <a href="{{route('inventorySite.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                        </div>  
                                   
                                    <cmodal :show='showModal' @close="showModal=false">
                                      
                                    </cmodal>
                                </div>  
                                                             
                            </div>


                             {!! Form::close() !!}
                        </div>
                          </div>
                    </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
          </div>
          <!-- END TAB PORTLET-->
    </div>
</div> 
@endsection
@push('scripts')


<script type="text/javascript">
        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif



  Vue.component('v-select', VueSelect.VueSelect);
  Vue.component("cmodal",{
    template:'#cmodal-template',

    props: ['show'],
    data(){
        return {
            types: [],
            receivables: [],
            payables: [],
            code: null,
            selectType: null,
            selectPay: null,
            selectReceive: null,
            classes:[],
            selectedClass: null,

        }
    },
    created(){
      
      axios.get('{{route("customer.create")}}').then(
        response=>{
          this.types = response.data.types;
          if(this.types)
          {
            for(var i=0;i<this.types.length;i++)
            {
              if(this.types[i].type=="Customer")
              {
                 this.selectType=this.types[i];
              }
            }
          }
          this.receivables = response.data.receivable;
          this.payables = response.data.payable;
          this.code = response.data.code;
           this.classes = response.data.member_class;
          if(this.receivables.length>0)
          {
              this.selectReceive=this.receivables[0];
          }
          if(this.payables.length>0)
          {
              this.selectPay=this.payables[0];
          }

        }).catch(error=> console.log(error));
    },
    methods:{
      onSubmit(){

        v.showModal = false;
        //this.member.type = this.member.type.id;
        var datas = $("#modalForm").serializeArray();
        $.ajax({
          headers:{'X-CSRF-TOKEN':"{{csrf_token()}}"},
          url:'{{route("customer.store")}}',
          method:'post',
          data: {"name":datas[0]['value'],'email':datas[1]['value'],'phone':datas[2]['value'],'address1':datas[3]['value'],'type':this.selectType.id,'receivable':this.selectReceive.id,'payable':this.selectPay.id,'class':(this.selectedClass)?this.selectedClass.id:null},
          dataType: 'json',

        }).done(function(response){
          axios.get('{{route("invoice.create")}}').then(response=>{
            
            v.customer =response.data.customer;
            document.getElementById("modalForm").reset();

          }).catch(error=> console.log(error));

        }).fail(function(error){
          console.log('error',error);
        });
        
      }
    }
  });

  var id = @if($id){!! $id !!}; @else 0; @endif
  var selectedCustomer= {!! $selectedCustomer !!};
  var Customer_id= {!! $Customer_id !!};
  var seePrice={!! $seePrice !!};
  var currency={!! $currency !!};
  var banks = {!! $banks !!};
  var all_services = {!! $all_services !!};
  var inventory_category = {!! $inventory_category !!};
   var memberClass = {!! $memberClass !!};
  var v = new Vue({
    el: '#app',
    data: {
       number:"{{$number}}",
       old_number:"{{$number}}",
       showModal: false,
       customer: [],
       all_customer: [],
       selected_customer:selectedCustomer,
       seePrice:seePrice,
       id:id,
       gift_id:id,
       Customer_id:Customer_id,
       member_id:null,
       banks:banks,
       all_services:all_services,
       selected_banks:null,
       currency:currency,
       selected_currency:{!!json_encode(getHomeCurrency()) !!},
       rate:0,
       discountFiled: 0,
       discountIsAmount:false,
       temp_items:[],
       totalAmountes: [],
       inventory_category:inventory_category,
        selected_iventory_category:null,
       selected_index:0,
       newCost:[
       null,
       null,
       null,
       null],
       inventories:[
          {inventory:null,item:null,item_category:null},
       ],
       services:[
              // {
                  // items: all_services,
                  // item: null,
              // },
              // {
                  // items: all_services,
                  // item: null,
              // },
        ],
        payments: [
                {
                    items: all_services,
                    item: null,
                }
        ],
        memberClass:memberClass,
        selected_class:null,
    },
    computed:{
      selectedRate()
      {            
         this.rate= (this.selected_currency)?this.selected_currency.rate:0;
      },
        discount()
        {
          if(this.discountIsAmount){

              if(this.subtotal>0 && this.discountFiled) {
                  return  (parseFloat(this.discountFiled) * 100) / (this.subtotal);
              }else {
                  return 0;
              }
              }else {

                  return this.discountFiled
              }

          },

          // calculate subtotal
          subtotal: function ()
          {
                var sum = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item !=null)
                    {  

                        var quantity=this.inventories[i]['item']['quantity'];
                        var rate=this.inventories[i]['item']['rate'];
                        var new_rate=this.inventories[i]['item']['new_rate'];
                        var smeasure_unit=this.inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit=this.inventories[i]['item']['measure_unit'];
                        if(new_rate !=rate && quantity>0)
                        {
                          @if(systemConfig()[30] == 1)
                           sum +=new_rate*quantity*this.selected_currency.static_rate / this.selected_currency.rate;
                          @else 
                           sum +=new_rate*quantity*this.selected_currency.rate;
                          @endif

                        }
                        else
                        {
                          @if(systemConfig()[30] == 1)
                          sum +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.static_rate / this.selected_currency.rate);
                          @else 
                          sum +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
                          @endif
                        }
                        
                    }

                }
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item && this.services[i].item !=null)
                    {

                        var rate=this.services[i]['item']['rate'];
                        var new_rate=this.services[i]['item']['new_rate'];
                        var smeasure_unit=this.services[i]['item']['measure']['measure_unit'];
                        var measure_unit=this.services[i]['item']['measure_unit'];
                         var quantity=this.services[i]['item']['quantity'];
                        if(new_rate !=rate && quantity>0)
                        { 
                          @if(systemConfig()[30] == 1)
                           sum +=new_rate*quantity* this.selected_currency.static_rate /  this.selected_currency.rate;
                           @else 
                           sum +=new_rate*quantity*this.selected_currency.rate;
                           @endif
                        }
                        else
                        {
                          @if(systemConfig()[30] == 1)
                           sum += quantity *((rate*smeasure_unit/measure_unit)*this.selected_currency.static_rate / this.selected_currency.rate);
                          @else 
                           sum += quantity *((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
                          @endif
                        }
                       
                    }
                }
                return sum;
          },

          // check payed amount
          payeds: function ()
           {
              var sum = 0;
              for (var i = 0; i < this.payments.length; i++)
               {

                  if(this.payments[i].item !=null && this.payments[i].item)
                  {
                     if (this.payments[i].item !=null && this.payments[i]['item']['rate']>0)
                     {
                      //
                          @if(systemConfig()[30] == 1)
                          sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                          @else 
                          sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                          @endif
                    }
                  }
                }
                return sum;
            },

            // check data validation
            isError: function () 
            {
                var isError = false;
                var flag=false;
                 /**for (var i = 0; i < this.inventories.length; i++)
                 {
                    
                    if (this.inventories[i].item)
                    {
                      flag=true;
                      if(((this.inventories[i]['item']['rate'] <=0) ))
                      {
                        rate=this.inventories[i]['item']['rate'];
                        new_rate=this.inventories[i]['item']['new_rate'];
                        if(rate <=0 && new_rate <=0)
                        {
                             isError = true;
                        }
                       
                      }
                    } 
                 } **/
                 if( this.selected_customer==undefined || this.selected_customer==null)
                 {
                    isError = true;
                 }
                return isError;
              

            },
            // filter the banks according to selected currency
            approperiateBank:function()
           {
                var bankCopy=this.banks.slice();
                var tempBank=bankCopy.filter((account)=>{
                    return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                });
                if(tempBank.length>0)
                {
                    this.selected_banks=tempBank[0];
                }
                return tempBank;
           },
    },
    methods:
    {
        memberClassChange() {
            if (v.selected_class) {
                v.customer = [];
                // v.selected_customer = null;
                let class_id = v.selected_class.id;
            
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember',
                        class_id: class_id,
                        type: 'Customer'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        v.customer = [];
                        v.customer = response.data;
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
            }
        },
        MemberSearch: _.debounce((search, loading) => {
            loading(true);
            let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
            
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: 'SearchMember', 
                    keyword: search,
                    class_id: class_id,
                    type: 'Customer'
                }
            })
            .then(function(response) {
                if (response.data.length > 0) {
                    // console.log(response.data);
                    v.customer = [];
                    v.customer = response.data;
                }
                loading(false);
            })
            .catch(function(error) {
                loading(false);
                console.log(error);
            })
        }, getDebounceTime()),
			
		handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
						// alert(e.target);
                        v.submitForm(e.target);
                    }
                });
            },
  
       // calculate item price based on measure change
       measureChange(index)
       {
    
           if(this.inventories[index].item !=null){
            var item=this.inventories[index].item;
          
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit));
            result=Number.parseFloat(temp).toFixed(precision());

            this.inventories[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            
            }
       },
       
           // calculate item price based on measure change
       measureChangeservice(index)
       {
    
           if(this.services[index].item !=null){
            var item=this.services[index].item;
            @if(systemConfig()[30] == 1)
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit)*this.selected_currency.static_rate / this.selected_currency.rate);
            @else 
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit)*this.selected_currency.rate);
            @endif
            result=Number.parseFloat(temp).toFixed(precision());

            this.services[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            
            }
       },
       // detect member change and searh
       memberChange()
       {
           if(this.selected_customer)
           {
			  v.id = '';
			  v.member_id = this.selected_customer.id;
            // get member contract
             this.getsalesGift(this.selected_customer.id,this);
             
           }
       },
       // set new price
       setNewRate(type=null,index)
       {
          if(type=='inventory')
          { 
              if(this.inventories[index].item)
              {
                @if(systemConfig()[30] == 1)
                 this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.static_rate * this.selected_currency.rate;
                @else  
                 this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
                @endif
              }
          }
          if(type=='service')
          {
              if(this.services[index].item)
              {
                @if(systemConfig()[30] == 1)
                 this.services[index].item.new_rate = this.$refs.ser[index].value/this.selected_currency.static_rate * this.selected_currency.rate;
                @else 
                 this.services[index].item.new_rate = this.$refs.ser[index].value/this.selected_currency.rate;
                @endif
              }
          }
          

       },
      // begin item search


        onItemSearch:_.debounce((search,loading) =>{
			
          loading(true);
          let inventory_category_id = (v.inventories[v.selected_index]['item_category'] !=undefined)?v.inventories[v.selected_index]['item_category'].id:'';

          axios.get("{{route('callMethod.search')}}",{
            params:{
              member_id:v.member_id,
              method_name:'itemesSearchSale',
              keyword:search,
              inventory_category_id:inventory_category_id,
            }
          })
          .then(function(response){
            v.temp_items = [];
            if(response.data.length >0)
            {
              v.temp_items = response.data;
            }
            loading(false);
          })
          .catch(function(error){
            console.log(error);
          })
        },getDebounceTime()),

          onItemload(index){
            v.selected_index=index;
            if(v.inventories[index].inventory !=null){
            // console.log('klk',v.inventories[index].inventory,v.inventories);
                  var inventory_id = v.inventories[index].inventory.id;
              let inventory_category_id = (v.inventories[index]['item_category'] !=undefined)?v.inventories[index]['item_category'].id:'';

              axios.get("{{route('callMethod.search')}}",{
              params:{
                member_id:v.member_id,
                method_name:'itemSearchSale',
                inventory_id:inventory_id,
                inventory_category_id:inventory_category_id,
              }
              })
              .then(function(response){
               v.inventories[index].item = null;
              if(response.data.length >0)
              {
                v.inventories[index].item = response.data[0];
              }
              })
              .catch(function(error){
              console.log(error);
              })
            }
          },

       //ajax call to get items
        setIndex(e)
        {
           //v.temp_items=[];
          this.selected_index=e;
        },
        itemCategoryChange(index){
           v.setIndex(index);
            v.selected_iventory_category=this.inventories[this.selected_index]['item_category'];
          if(this.inventories[this.selected_index]['item_category'] !=null)
          {
           let inventory_category_id = (v.inventories[v.selected_index]['item_category'] !=undefined)?v.inventories[v.selected_index]['item_category'].id:'';
           
           axios.get("{{route('callMethod.search')}}",{
            params:{
              member_id:v.member_id,
              method_name:'itemesSearchSale',
              inventory_category_id: inventory_category_id
            }
          })
          .then(function(response){
            v.temp_items = [];
            if(response.data.length >0)
            {
              v.temp_items = response.data;
            }
          })
          .catch(function(error){
            console.log(error);
          });
        }

        },

       // end item search


		getsalesGift(member_id)
       {
        this.showModalSaleOrder = false;
        axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'SaleGiftItems',
              member_id:member_id,
			  id: v.id
            }
           })
           .then(function (response)
           {
             if(response.data.length>0)
             {
                v.inventories = [];
                for(var r = 0; r<response.data.length; r++){
                  v.inventories.push({inventory:response.data[r],item:response.data[r],item_category:response.data[r].item_category});
                }
                  // v.inventories.push({item:null});
                  // console.log('test check',v.selected_sale_order);

                  // v.invoiceDescription = v.selected_sale_order.description;

                  // for(var a=0;a<this.currency.length;a++)
                  // {
                     // if(v.currency[a].code==v.selected_sale_order.currency)
                     // {
                      // v.selected_currency=v.currency[a];
                      // v.selected_currency.rate=v.selected_sale_order.rate;
                     // }
                  // }
             }else{
				 v.inventories = [];
			 }
           })
           .catch(function (error)
           {
              console.log(error);
           })
       },
       // end contract search

       // contract search


        contractSearch(id,vm)
       {
           vm.contract=[];
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'member_contract',
              member_id:id
            }
           })
           .then(function (response)
           {
             if(response.data.length>0)
             {
                vm.contract=response.data;
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           })
       },
       // end contract search

       // generic function for adding item to list
       addNew(type=null,index)
       {
          this.temp_items=[];
          if(type !=null)
          {
             if(type=='inventory')
             {
                if(this.inventories[index+1]==undefined)
                {
                  this.temp_items=[];
                  this.inventories.push({inventory:null,item:null,item_category:this.selected_iventory_category});
                }
             }
            if(type=='service')
             {
                if(this.services[index+1]==undefined)
                {
                  this.checkExistingService(index,'');
                  this.services.push({
                    items: this.all_services,
                    item: null,
                });
                }
             }
             if(type=='payment')
             {
                if(this.payments[index+1]==undefined)
                {
                  this.checkExistingPayment(index,'');
                  this.payments.push({
                    items: this.banks,
                    item: null,
                });
                }
             }
          }
          
       },

       // in here you can check and decide to allow duplicate bank for payment or not
       checkExistingPayment(index=null,name='')
       {      
              var bank_temp=this.banks.slice();
              var bank_temp1=[];
              for(var i=0;i<this.payments.length;i++)
              {
                  if(this.payments[i].item !=null)
                  {
                      var fined=bank_temp.findIndex((item)=> item.name == this.payments[i].item.name);
                      if(fined !=-1)
                      {
                        var o=bank_temp.splice(bank_temp.findIndex((item)=>item.name == this.payments[i].item.name),1);
                      }
                  }
              }
              this.payments[index].items = bank_temp.filter((item) => {
                        return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                    });
               //this.payments[index].items =bank_temp; 


       },

        // in here you can check and decide to allow duplicate service or not
       checkExistingService(index=null,name='')
       {      
              var service_temp=this.all_services.slice();
              var service_temp1=[];
              for(var i=0;i<this.services.length;i++)
              {
                  if(this.services[i].item !=null)
                  {
                      var fined=service_temp.findIndex((item)=> item.name == this.services[i].item.name);
                      if(fined !=-1)
                      {
                        var o=service_temp.splice(service_temp.findIndex((item)=>item.name == this.services[i].item.name),1);
                      }
                  }
              }
              this.services[index].items = service_temp.filter((item) => {
                        return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                    });
               //this.payments[index].items =bank_temp; 


       },
       // delete item from list
       deleteItem(type=null,index)
       {
         if(type !=null)
         {
             console.log(type);
             if(type=='inventory')
             {
                this.inventories.splice(index, 1);
             }
              if(type=='service')
             {
                this.services.splice(index, 1);
             }
              if(type=='payment')
             {
                this.payments.splice(index, 1);
             }
         }
          
       },
       // submit the form
       submitForm() 
       {

          if(this.isError==true) {
            alert('there is no item');
            return false;
          }
          swal({
                title:"@lang('layout.AreYouSure?')",
                buttons: ["@lang('layout.Cancel')","@lang('layout.Submit')"],
                text: "",
                icon: "info",
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete)
                {
                    document.getElementById("sales-form").submit()

                }
                else
                {

                }
            });

        },
        defaultValue()
        {
          this.selected_customer=null;
          this.selected_index=0;
         
         this.inventories=[
            {inventory:null,item:null,item_category:this.selected_iventory_category},
         ];
         this.services=[
                {
                    items: all_services,
                    item: null,
                },
                {
                    items: all_services,
                    item: null,
                },
          ];
          this.payments= [
                  {
                      items: all_services,
                      item: null,
                  }
          ];

          this.invoiceDescription= null;
          this.saleOrderList=[];
          this.selected_sale_order=null;
          this.member_id=null;
          this.discountFiled=0;
           this.temp_items = [];

        },
        saveAndNew()
        {
             this.$validator.validate()
            .then(valid =>{
                if(valid)
                {
                  
                  var url="{{route('sale.store')}}";
                  form_id='sales-form';
                  var data= $('#'+form_id).serialize();
              
                  axios.post(url,data)
                  .then(function(response){
                           if(response.data.result==1)
                           {
                              $('#'+form_id).trigger('reset');
                              //$('#success-sound')[0].play();
                              toastr.success('',response.data.message); 
                              v.number=Number(v.old_number)+1;
                              v.old_number=Number(v.old_number)+1;

                              v.defaultValue();
                           }
                           else
                           {
                              var message="{{__('message.Warning')}}";
                              //$('#error-sound')[0].play();
                              toastr.warning('',message);
                           }
                  })
                  .catch(function(error){
                      console.log(error);
                      var message="{{__('message.Warning')}}";
                      //$('#error-sound')[0].play();
                      toastr.warning('',message);
                  });
                 
                }
            })
        },
    },
    created:function()
    {

    }

  });

</script>


@endpush