@extends('layouts.app')

@section('content')

    <div class="portlet"> 
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.SaleOrderInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th class="">
                                <i class="fa fa"></i>  @lang('layout.Category')
                            </th>
                            <th class="">
                                <i class="fa fa"></i>  @lang('layout.Number')
                            </th>
                            <th class="">
                                <i class="fa fa"></i>  @lang('layout.SaleCode')
                            </th>
                            <th class="">
                                <i class="fa fa-user"></i>  @lang('layout.Customer')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Date')
                            </th>
                            <th>
                                <i class="fa  "></i> @lang('layout.TotalQuantity')
                            </th>
                            <th>
                                <i class="fa  "></i> @lang('layout.Rate')
                            </th>
                            <th> 
                                <i class="fa "></i> @lang('layout.Amount') 
                            </th>
                            <th> 
                                <i class="fa "></i> @lang('layout.Discount') 
                            </th>
                            <th>
                                <i class="fa  "></i> @lang('layout.Currency') 
                            </th>
                        </tr>
                    </thead> 
                    <tbody>
                        <tr>   
                            <td class=""> {{ __('layout.'.ucfirst($saleOrder->category))}}  </td>
                            <td class=""> {{ $saleOrder->number }}  </td>
                            <td class=""> {{ $saleOrder->sale_code }}  </td>
                            <td class=""> {{ $saleOrder->name }}  </td>
                            <td class=""> {{ convertDate($saleOrder->date)}}  </td>
                            <td class=""> {{ myRound($saleOrder->quatity) }}  </td>
                            <td class=""> {{ $saleOrder->rate }}  </td>
                            <td class=""> {{ myRound($total) }}  </td>
                            <td class=""> {{ myRound($saleOrder->discount) }}  </td>
                            <td class=""> {{ $saleOrder->currency }}  </td>      
                        </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th width="">
                            <i class=" fa fa-text-width"></i> @lang('layout.Description')
                        </th>
                        <th width=" ">
                            <i class=" fa fa-text-width"></i> @lang('layout.Memo')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class=" "> <?php
                            $des = wordwrap($saleOrder->description,80,"<br/>\n",false);
                            echo $des;
                        ?>  
                        </td>
                        <td class=" "> {{ $saleOrder->memo}}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
     <div class="row">

     <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.SaleOrderDetails') </span>
                    </div>
                    <div class="tools"></div>
                     <div class="actions">
                        @permission('salesOrder-export')
                            {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="Sale_Order_Details"/>
                            <input type="hidden" name="id" value="{{$saleOrder->id}}"/> 
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                            {{Form::close()}} 

                            {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="Sale_Order_Details"/>
                            <input type="hidden" name="id" value="{{$saleOrder->id}}"/> 
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                            {{Form::close()}}
                        @endpermission  
                    </div>
                </div>
                <div class="portlet-body">

     <div class="tabbable-line tabbable-custom-profile">
    <ul class="nav nav-tabs">  
            <li class="active">
            <a href="#both" data-toggle="tab" id="tab-on" >
            <i class="fa  "></i><b> @lang('layout.Item') </b></a>
            </li> 
            <li class="">
                <a href="#ex-transport" data-toggle="tab" id="tab-trasnport">
                <i class="fa  "></i><b> @lang('layout.Service') </b></a>
            </li>
            <li>
                <a href="#attach" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
            </li>  
            <li>
                <a href="#sales_percentage" data-toggle="tab" id="tab_payment">@lang('layout.PercentageList')</a>
            </li> 
    </ul>  
    <br>
   <div class="tab-content padding" style="padding: 0px;">
        <div class="tab-pane active" id="both">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" id="sales">
                            <thead>
                                <tr>  
                                    <th>@lang('layout.ItemName')</th>
                                    <th>@lang('layout.Site')</th>
                                    @if(searchByCodeLocation()=="true")
                                    <th>@lang('layout.Location')</th>
                                    @endif
                                    <th>@lang('layout.MeasureUnit')</th>
                                    <th>@lang('layout.Quantity')</th>
                                    @if(systemConfig()[4] == 1)
                                    <th>@lang('layout.Bundl')</th>
                                    @endif
                                    @if(getOtherMeasure()=="true")
                                    <th>@lang('layout.OMeasureValue1')</th>
                                    @endif
                                    @if(getOtherMeasure2()=="true")
                                    <th>@lang('layout.OMeasureValue2')</th>
                                    @endif
                                    <th>@lang('layout.Price')</th>
                                    <th>@lang('layout.Total')</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div> 

        <div class="tab-pane" id="ex-transport">
            <div class="portlet light bordered">
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="service">
                        <thead>
                            <tr>  
                                <th>@lang('layout.ServiceName')</th>
                                <th>@lang('layout.MeasureUnit')</th>
                                <th>@lang('layout.Quantity')</th>
                                <th>@lang('layout.Price')</th>
                                <th>@lang('layout.Total')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
        <div class="tab-pane" id="attach">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="portlet light bordered">
                        <div class="portlet-body">

                            <form role="form" action="{{route('attachment.store')}}" method="post"
                                  enctype="multipart/form-data">

                                @csrf
                                <input type="hidden" name="redirect_route" value="salesOrder.show">
                                <input type="hidden" name="foreign_data_id" value="{{$saleOrder->id}}">
                                <input type="hidden" name="path" value="uploads/salesOrder">
                                <input type="hidden" name="table_name" value="sales_orders">

                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                            <input type="text" name="title" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="description" class="form-control" rows="1"></textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <div class="fileinput fileinput-new" data-provides="fileinput">
                                                <div class="fileinput-new thumbnail"
                                                     style="width: 140px; height: 70px;">
                                                    <img src="" alt=""></div>
                                                <div class="fileinput-preview fileinput-exists thumbnail"
                                                     style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                <div>
                                                            <span class="btn default btn-file">
                                                                <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                <input type="hidden" value="" name=""><input
                                                                        type="file" name="photo"> </span>

                                                    <a href="javascript:;" class="btn default fileinput-exists"
                                                       data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="margiv-top-10" style="text-align: center">
                                    <button type="button" onclick="regForm(this)"
                                            class="btn green"> @lang('layout.Submit') </button>
                                    <a href="{{route('salesOrder.index')}}"
                                       class="btn default">@lang('layout.Cancel')</a>
                                </div>
                            </form>
                        </div>
                    </div>
                    <table class="table table-striped table-bordered table-hover" id="attachment">
                        <thead>
                        <tr>
                            <th>@lang('layout.AttachmentTitle')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Action')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>     


        <div class="tab-pane" id="sales_percentage">
            <div class="portlet light bordered">
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="sales_percentages">
                        <thead>
                            <tr>  
                                <th>@lang('layout.FromPercentage')</th>
                                <th>@lang('layout.ToPercentage')</th>
                                <th>@lang('layout.Amount')</th> 
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
</div>
</div>
</div>
</div>
    </div>
@endsection
@push('scripts')
<script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
                $('#sales').DataTable({
                    ajax:{
                        url:'{{route("salesOrder.show",$saleOrder->id)}}',
                        data:{type:'items'}
                    },
                    pageLength:'{{getPageRows()}}',
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    columns: [

                        { data: 'item', name: 'item' },
                        { data: 'site', name: 'site' , orderable:false,searchable:false },
                        @if(searchByCodeLocation()=="true")
                        { data: 'location', name: 'location' , orderable:false,searchable:false },
                        @endif                        
                        { data: 'measure_unit', name: 'measure_unit', orderable:false,searchable:false  },
                        { data: 'quatity', name: 'quatity',orderable:false,searchable:false },
                        @if(systemConfig()[4] == 1)
                        { data: 'bundl', name: 'bundl',orderable:false,searchable:false },
                        @endif
                        @if(getOtherMeasure()=="true")
                        { data: 'other_measure', name: 'other_measure',orderable:false,searchable:false },
                        @endif
                        @if(getOtherMeasure2()=="true")
                        { data: 'other_measure2', name: 'other_measure2',orderable:false,searchable:false },
                        @endif

                        { data: 'price', name: 'price',orderable:false,searchable:false},
                        { data: 'total', name: 'total',orderable:false,searchable:false}
                ]
            });               
            
             $('#service').DataTable({
                    ajax:{
                        url:'{{route("salesOrder.show",$saleOrder->id)}}',
                        data:{type:'service'}
                    },
                    pageLength:'{{getPageRows()}}',
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    columns: [

                        { data: 'item', name: 'items.name' },
                        { data: 'measure_unit', name: 'measure_unit', orderable:false,searchable:false  },
                        { data: 'qty', name: 'sale_order_services.qty'},
                        { data: 'price', name: 'sale_order_services.price'},
                        { data: 'total', name: 'total', orderable:false,searchable:false}
                ]
            });

            $('#attachment').DataTable({
                ajax: {
                    url:'{{route("salesOrder.show",$saleOrder->id)}}',
                    data:{type:'attachment'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'title', name: 'attachments.title'},
                    {data: 'description', name: 'attachments.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            }); 

 

            $('#sales_percentages').DataTable({
                ajax: {
                    url:'{{route("salesOrder.show",$saleOrder->id)}}',
                    data:{type:'sales_percentag'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'from_percentage', name: 'from_percentage'},
                    {data: 'to_percentage', name: 'to_percentage'},
                    {data: 'amount', name: 'amount'},
                ]
            }); 





    });
</script>



@endpush
