@extends('layouts.app')
@section('style')
    <link rel="stylesheet" href="{{url('/vue/v-autocomplete.css')}}">
    <link rel="stylesheet" href="{{url('/vue/style.css')}}">

    <style>
        .dashboard-stat2 {
            padding: 0; 
        }
        table {
            border-collapse: collapse;
            border-spacing: 0;
            width: 100%;
            border: 1px solid #ddd;
        }

        th, td {
            text-align: left;
            padding-bottom: 0px;
        }

        tr {
            border-bottom: 1px solid #ddd;
        }

        tr:nth-child(even) {

            background-color: #f2f2f2
        }

        [v-cloak] {
            display: none;
        }

        .row-height {
            height: 55px;
        }

        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            padding: 5px 15px;
        }

        .v-autocomplete-list {
            z-index: 1000 !important;
        }

        .v-autocomplete .v-autocomplete-list {
            position: absolute;

        }
        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            height: 22px;
            font-size: 16px;
        }

        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }
        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }




        .dashboard-stat2 {
            padding-bottom: 0;
        }

        .dashboard-tabel td {
            padding: 0 4px;

        }

        .badge3 {
            ext-align: center;
            width: 100%;
            font-size: 18px !important;
            line-height: 34px;
            height: 34px;
            color: #fff;
            padding: 3px 6px;
        }

        .paddint-both {
            padding: 5px;
        }

        .paddint-both:hover {
            color: red;
        }
    </style>

    <style type="text/css">
        #table_content thead th {
            background-color: rgb(84, 199, 211);
            color: #ffffff;
            font-size: 14px;
        }
        #table_content>tbody>tr.odd>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: rgb(224, 234, 234);
        }

        #table_content>tbody>tr.even>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: #eceff361;
        }

        #table_content>tbody>tr.even>td.td_one, #table_content>tbody>tr.odd>td.td_one{
            font-size: 14px;
            color: #404040;
            font-weight: bold;

        }
        .input_style {
            min-width: 110px;


        }
        .inner_input {
            min-width: 80px;
            height: 30px;
        }

        td a i {
            color: #686868;
            font-size: 16px;
            margin: 10px;
            vertical-align: middle;
            border: none;
        }


        #table_content tr.even td input:focus,#table_content tr.odd td input:focus {
            outline: 2px solid #191919 !important;
        }
        #table_content>tbody>tr.odd>td>.input-group>.input-group-addon {
            border: none;
            background-color: rgb(197, 200, 208);
        }
        #table_content>tbody>tr.even>td>.input-group>.input-group-addon {
            border: none;
        }
        #table_content tr:nth-child(odd) { background-color:#eee !important; }
        #table_content tr:nth-child(even) { background-color:#fff !important; }


        .inpu-number-fild{
            background-color: white;
            height: 34px;
            border: none;
        }
        #table_content input[type=number], select {
            height: 34px;
            border: none !important;
        }
        .input-has-error {
            outline: 1px solid #ff0000 !important;
            background-color: #ff000014;
        }
        .cmodal-container
        {
            width: 800px !important;
        }
            /* border: none !important; */
        .have-border
        {
            border: 1px solid lightgray !important;

        }
        cmodal[v-cloak] {
            display: none;
        }

    </style>

@stop



@section('content')
    @include('inventories.cmodal')

    <div class="row" id="salse" v-cloak>
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateSalesOrder')</span>
                    {{--<span class="caption-helper">some info...</span>--}}
                </div>
                <div class="tools"> 
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div>
            </div>

            <div class="portlet-body form" id="item-service">
                
                {{Form::open(['route' => 'salesOrder.store','method' => 'POST','class' => 'form-horizontal','id'=>'sales-form'])}}


                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-6 col-xs-12">
                            <div class="row">
                                
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">@lang('layout.Currency') </label>
                                        <div class="col-md-8">
                                            <select class="form-control " v-model="selectedCurrency"  required="required" @change='myRound'>

                                                <option v-for="optionCurrency in currencyList"
                                                        :value="optionCurrency">@{{optionCurrency.code}}
                                                </option>
                                            </select>

                                            <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>

                                        </div>
                                    </div> 
                                </div>

                                <div  class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">@lang('layout.Rate') </label>
                                        <div class="col-md-8 " >
                                            <div class="input-group">
                                                <input  v-model="roundData" class="form-control"
                                                        type="number" min="0" >
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>


                                            </div> 
                                        </div>
                                    </div>
                                    <input type="hidden" name="currency_rate" :value="selectedCurrency.rate">
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">@lang('layout.Discount') </label>
                                        <div class="col-md-8 ">
                                            <div class="input-group" :class="{'has-error':discount<0 || discount>100 }">
                                                <input  v-model="discountFiled" class="form-control"
                                                       type="number" min="0"
                                                       max="100">

                                                <span  v-if="discountIsAmount"  @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selectedCurrency.symbol}}
                                                    <input type="hidden" name="discount_type" value="currency">
                                                </span>
                                                <span  v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon" >%
                                                    <input type="hidden" name="discount_type" value="percent">
                                                </span>
                                                <input type="hidden" name="discount" :value="discountFiled">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">@lang('layout.Description') </label>
                                         <div class="col-md-8">
                                             <textarea  name="description" class="form-control" rows="1"></textarea>
                                        </div>
                                    </div>
                                    
                                </div>
                                

                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                            <div class="dashboard-stat2 ">

                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') :</small>
                                        </td>
                                        <td class="text-right"><span data-counter="counterup"
                                                                     data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))).toFixed(2)}}</span>
                                            <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Discount'): (@{{ Number.parseFloat(discount).toFixed(2) }}%)</small>
                                        </td>
                                        <td class="text-right">
                                                   <span class="text-right" data-counter="counterup"
                                                         data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(2) }}</span>
                                            <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td>
                                            <small>Sub-Total:</small>
                                        </td>
                                        <td class="text-right">
                                                    <span class="text-right" data-counter="counterup"
                                                          data-value="7800">@{{ subtotal.toFixed(2)}}</span>
                                            <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                        </td>
                                    </tr>


                                </table>

                            </div>
                        </div>


                    </div>

                    <div v-if="inventories.length >0 " class="row">
                        <div class="table-responsive333">
                            <table id="table_content" class="table table-bordered table-striped">
                                <thead>
                                <tr>
                                    <th class="text-center" style="min-width: 8px;"> # </th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                                    <th class="text-center" style="min-width: 120px;"> Inventory Site </th>
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                    <th class="text-center" style="min-width: 60px;"> @lang('layout.OnHand')</th>
                                    <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                    <th class="text-center" style="min-width: 60px;"> @lang('layout.Cost')</th>
                                    <th class="text-center" style="min-width: 60px;"> @lang('layout.Price')</th>
                                    <th class="text-center" style="min-width: 90px;"> @lang('layout.Total')</th>
                                    <th style="min-width: 20px;"></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(inventory,InventoryIndex) in inventories" class="even">
                                    <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{InventoryIndex}} </span>
                                        </td>
                                    <td class="td_one">
                                        <v-autocomplete :items="inventory.items" v-model="invenList[InventoryIndex].item" :get-label='getLabel'
                                                        :min-len='0'
                                                        :component-item='tpl' v-on:update-items='update'
                                                        :input-attrs="{}"
                                                        @focus="setFocus(InventoryIndex)"
                                                         placeholder="@lang('layout.SelectItem')"
                                                        style="min-width: 220px;">
                                        </v-autocomplete>
                                        <input type="hidden" name="inventory_id[]" :value="(!invenList[InventoryIndex].item)?null:invenList[InventoryIndex].item.id">
                                    </td>
                                    <td>
                                        <select  class="form-control input_style"
                                                 placeholder="@lang('layout.Quantity')"
                                                 v-model="!itemSite[InventoryIndex]?null:itemSite[InventoryIndex].site"
                                                required="required">

                                            <option v-if="invenList[InventoryIndex].item"
                                                    v-for="sites in (!invenList[InventoryIndex].item?null:invenList[InventoryIndex].item.siteList)"
                                                    :value="sites">@{{sites.site_name}}
                                            </option>
                                        </select>
                                        <input type="hidden" name="site_id[]" :value="(!invenList[InventoryIndex].item)?null:(itemSite[InventoryIndex].site)?itemSite[InventoryIndex].site.site_id:null">
                                    </td>
                                    <td >
                                        <input name="inventory_qty[]" class="form-control inpu-number-fild"  :class="{'input-has-error':(!invenList[InventoryIndex].item)?null:(invenList[InventoryIndex].item.qty < 0)}" type="number" v-model.number="(!itemQuantity[InventoryIndex])?null:itemQuantity[InventoryIndex].value" placeholder="@lang('layout.Quantity')" />
                                    </td>
                                    <td>
                                        <input class="form-control spinner input_style" type="number" :value="(!invenList[InventoryIndex].item)?null:(!invenList[InventoryIndex].item.site)?null:((invenList[InventoryIndex].item.site.OnHand * invenList[InventoryIndex].item.measure_unit/invenList[InventoryIndex].item.measure.measure_unit).toFixed(2)) - itemQuantity[InventoryIndex].value" placeholder="@lang('layout.OnHand')" disabled/>
                                    </td>
                                    <td>
                                        <select  class="form-control input_style"
                                                 placeholder="@lang('layout.Measure')"
                                                 v-model="!itemMeasuer[InventoryIndex]?null:itemMeasuer[InventoryIndex].measure"
                                                 required="required">

                                            <option v-if="invenList[InventoryIndex].item"
                                                    v-for="measures in (!invenList[InventoryIndex].item?null:invenList[InventoryIndex].item.measureList)"
                                                    :value="measures">@{{ measures.measure_name }}</option>
                                        </select>

                                        <input type="hidden" name="inventory_measure[]" :value="(!invenList[InventoryIndex].item)?null:(itemMeasuer[InventoryIndex].measure)?itemMeasuer[InventoryIndex].measure.measure_id:null">
                                    </td>
                                    <td>
                                        <div class="input-group input_style">

                                            <input type="number" class="form-control inner_input"  placeholder="@lang('layout.Cost')" :value="(!invenList[InventoryIndex].item)?null:((invenList[InventoryIndex].item.avg_cost*invenList[InventoryIndex].item.measure.measure_unit/invenList[InventoryIndex].item.measure_unit)*selectedCurrency.rate).toFixed(2)" disabled>
                                            <span class="input-group-addon">
                                            <b>@{{selectedCurrency.symbol}}</b>
                                        </span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input_style">
                                            <input type="number" name="inventory_price[]" class="form-control inner_input" :class="{'input-has-error':(!invenList[InventoryIndex].item)?null:invenList[InventoryIndex].item.rate<0}" placeholder="@lang('layout.Price')" v-model="(!itemPrice[InventoryIndex])?null:itemPrice[InventoryIndex].value" >
                                            <span class="input-group-addon">
                                            <b>@{{selectedCurrency.symbol}}</b>
                                        </span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input_style">
                                            <input type="number" class="form-control inner_input"  placeholder="@lang('layout.Total')" :value="(!invenList[InventoryIndex].item)?null:itemQuantity[InventoryIndex].value * itemPrice[InventoryIndex].value" disabled>
                                            <span class="input-group-addon">
                                            <b>@{{selectedCurrency.symbol}}</b>
                                        </span>
                                        </div>
                                    </td>
                                    <td>
                                        <span  v-on:click="deleteItem(InventoryIndex)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                        {{--<a href="#"><i class="glyphicon glyphicon-trash"></i></a>--}}
                                    </td>
                                </tr>

                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="row">

                            <button v-if="inventories.length <= 0 " type="button" class="btn default" @click="addInventory">@lang('layout.AddItem')
                            </button>
                            <button  v-if="isError" type="button" class="btn green" @click="submitForm">@lang('layout.Submit')</button>
                    </div>
                {{Form::close()}}
            </div>
            
        </div>
    </div>


    <script type="text/x-template" id="checkbox-template">

        <div>
            <b>#@{{item.id}}</b>
            <span>@{{ item.name }}</span>
            {{--<span>@{{item.qty }}</span>--}}
            {{--<span>@{{item.description}}</span>--}}
        </div>
    </script>
@endsection

@push('scripts')
    <script>

        // $('.date-picker').datepicker({
        //     autoclose: true
        // });

    </script>
    <script src="{{url('/vue/sweetalert1.min.js')}}"></script>
    <script src="{{url('/vue/v-autocomplete.js')}}"></script>
    <script>


        var Currency     = {!! $currency!!}
        var InventoryAll = {!! $inventoryList!!};
        
        Vue.use(VAutocomplete.default)
        Vue.use(VeeValidate);

        var temp = Vue.component('my-checkbox', {
            template: '#checkbox-template',
            props: {
                item: {required: true},
                searchText: {required: true}
            }

        });

        Vue.component('cmodal', {
            template: '#cmodal-template',
            props: ['show']
        });

        var sales = new Vue({
            el:'#salse',
            data:{
                code: 0,
                inventories: [
                    {
                        items: [],
                        item: null,
                    },
                    {
                        items: [],
                        item: null,
                    },
                    {
                        items: [],
                        item: null,
                    },
                    {
                        items: [],
                        item: null,

                    }
                ],
                roundData:1,
                inventoryIndex:0,
                inventoryList:InventoryAll,
                currencyRate:1,
                selectedCurrency: {
                    id: parseInt('{{getHomeCurrency()["id"]}}'),
                    code: '{{getHomeCurrency()["code"]}}',
                    symbol: '{{getHomeCurrency()["code"]}}',
                    rate: '{{getHomeCurrency()["rate"]}}'
                },
                discountFiled: 0,
                discountIsAmount:false,
                currencyList: Currency,
                tpl: temp,
                itemQuantity:[
                    {value:null},
                    {value:null},
                    {value:null},
                    {value:null}
                ],
                itemPrice:[
                    {value:null},
                    {value:null},
                    {value:null},
                    {value:null}
                ],
                invenList:[
                    {item:null},
                    {item:null},
                    {item:null},
                    {item:null}
                ],
                itemMeasuer:[
                    {measure:null},
                    {measure:null},
                    {measure:null},
                    {measure:null}
                ],
                itemSite:[
                    {site:null},
                    {site:null},
                    {site:null},
                    {site:null}
                ],

            },
            computed:{
                myRound() {
                    this.roundData = Number.parseFloat(this.selectedCurrency.rate).toFixed(3);
                },
                discount(){
                    if(this.discountIsAmount){

                        if(this.subtotal>0 && this.discountFiled) {
                           return  (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        }else {
                           return 0;
                        }
                    }else {

                        return this.discountFiled
                    }

                },
                subtotal: function () {
                    var sum = 0;
                    if(this.itemPrice[this.inventoryIndex].value == null){
                        if(this.invenList[this.inventoryIndex].item){
                            this.itemPrice[this.inventoryIndex].value = this.invenList[this.inventoryIndex]['item']['rate'];
                            if(this.invenList[this.inventoryIndex]['item']['site']){

                                this.itemSite[this.inventoryIndex].site = this.invenList[this.inventoryIndex]['item']['site'];
                            }

                            if(this.invenList[this.inventoryIndex]['item']['measure']){
                                this.itemMeasuer[this.inventoryIndex].measure = this.invenList[this.inventoryIndex]['item']['measure'];
                            }
                        }

                    }
                    for (var i = 0; i < this.inventories.length; i++) {

                        if (this.invenList[i].item){
                            sum += this.itemQuantity[i].value * this.itemPrice[i].value;
                        }
                            

                    }

                    return sum;
                },
                isError: function () {
                    var isError = false
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && ((this.inventories[i]['item']['qty'] > this.inventories[i]['item']['onHand']) || (this.inventories[i]['item']['qty'] < 0) || (this.inventories[i]['item']['rate'] < 0))){
                            isError = true;
                        }


                    }
                    if((isError) || (this.discount < 0) || (this.discount > 100 )){
                        return false;
                    }else {
                        return true;
                    }

                },

            },
            methods:{
                itemSelected (item) {
                    alert('selected');
                    console.log('Selected item!', item)
                },
                itemClicked (item) {
                    console.log('You clicked an item!', item)
                    alert('clicked');
                },
                getLabel (item) {
                    if (item) {
                        return item.name
                    }
                    return ''
                },
                deleteItem(index) {
                    this.inventories.splice(index, 1);
                    this.invenList.splice(index, 1);
                    this.itemQuantity.splice(index, 1);
                    this.itemPrice.splice(index, 1);
                    this.itemSite.splice(index, 1);
                    this.itemMeasuer.splice(index, 1);
                },
                update (text) {
                    var Animals1 = InventoryAll.slice();
                    var data = Animals1.filter((item) => {
                        return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase());
                    });

                  
                    this.inventories[this.inventoryIndex].items = data;
                    if (this.inventoryIndex == this.inventories.length - 1 && this.inventories.length-3 < InventoryAll.length ) {
                        this.addInventory()
                    }
                    
                    // if (this.rows[this.inventoryIndex].item != null)
                    //     this.priceUpdate(this.inventoryIndex)
                },
                setFocus(index){
                  // this.inventories[index].item = item;
                  this.inventoryIndex = index;
                  this.update('');
                  
                },
                addInventory(){
                    this.inventories.push({
                        items: [],
                        item: null,
                        }
                    );
                    this.invenList.push({item: null});
                    this.itemQuantity.push({value: null});
                    this.itemPrice.push({value: null});
                    this.itemSite.push({site: null});
                    this.itemMeasuer.push({measure: null});
                    
                },
                submitForm() {

                    swal({
                        title:"@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')","@lang('layout.Submit')"],
                        text: "",
                        icon: "info",
                        dangerMode: true,
                    }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("sales-form").submit()

                            } else {

                            }
                        });

                },


            }
        });


    </script>
 
@endpush