@extends('layouts.app')
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'saleOrder'" @closed="closeModal">
            <div slot=body>
                <div class="row">
                    <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 ) @permission(['customreport-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1"> 
                                    <div class="portlet light bordered">
                                    <div class="row">
                                        
                                        <div class="form-group">
                                            <div class="col-md-3">
                                                <label class="control-label ">@lang('layout.SaleArea') </label>
                                                <v-select class="vue-select2" v-model="selectedArea" label="name" @search="onSaleAreaSearch" :options="saleArealist">
                                                </v-select>
                                                <input type="hidden" name="sale_area_id" v-model.number="(!selectedArea)?null:selectedArea.id">
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Type')</label>
                                                    <select name="report_type" class="form-control">
                                                        <option value="">@lang('layout.SelectType')</option>
                                                        <option value="saleDetails">@lang('layout.SaleDetails')</option>
                                                        <option value="with_item">@lang('layout.WithItem')</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div  class="col-md-3">
                                                <label class="control-label ">@lang('layout.Number') </label>
                                                <input type="text" name="code" class="form-control"  autocomplete="off">
                                            </div>

                                            <div class="col-md-1">
                                                <div class="form-group">
                                                    <h3> <label class="control-label"> @lang('layout.All') <input name="all" type="checkbox" value="true"> </label> </h3>
                                                </div>
                                            </div>

                                            <div class="col-md-1">
                                                <div class="form-group">
                                                    <h3> <label class="control-label"> @lang('layout.OnHand') <input name="onhand" type="checkbox" value="true"> </label> </h3>
                                                </div>
                                            </div>

                                        </div>
                                    </div>   
                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                                <label class="control-label">@lang('layout.Customer')</label>
                                                <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                        v-model="selectedCustomer" label="name" :options="customer" @search="onMemberSearch" >
                                                </v-select>
                                                <input type="hidden" name="customer_id" v-model.number="(!selectedCustomer)?null:selectedCustomer.id" />
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Status')</label>
                                                    <select name="status" class="form-control">
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option value="false">@lang('layout.On')</option>
                                                        <option value="true">@lang('layout.Off')</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Forgivness')</label>
                                                    <select name="forgivness" class="form-control form-select">
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option value="forgivness">@lang('layout.Forgivness')</option>
                                                        <option value="withoutForgivness">@lang('layout.WithoutForgivness')</option>
                                                    </select>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.SaleCode')</label> 
                                                    <input type="text" name="sale_code" class="form-control"  autocomplete="off">
                                                </div>
                                            </div>

                                        </div>
                                    </div>   
                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-3">
                                                <label class="control-label ">@lang('layout.MemberClass') </label>
                                                <v-select class="vue-select2" v-model="selectedClass" label="name" @search="searchClass" :options="classlist">
                                                </v-select>
                                                <input type="hidden" name="class_id" v-model.number="(!selectedClass)?null:selectedClass.id">
                                            </div>
                                        </div>
                                    </div>   
                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.Date')</label>
                                                            <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                            <option value="CustomDates">@lang('type.CustomDates')</option>
                                                            <option value="Today">@lang('type.Today')</option>
                                                            <option value="Yesterday">@lang('type.Yesterday')</option>
                                                            <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                            <option value="LastWeek">@lang('type.LastWeek')</option>
                                                            <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                            <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                            <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                            <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                            <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                            <option value="ThisYear">@lang('type.ThisYear')</option>
                                                            <option value="YearToDate">@lang('type.YearToDate')</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-8" v-show="period == 'CustomDates'">
                                                        <div class="form-group">
                                                            <label class="control-label"> @lang('layout.Date')</label>
                                                            <div class="input-group">
                                                                <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                                <span class="input-group-addon"> @lang('layout.To') </span>
                                                                <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    </div>
                            </div> 

                            <div class="tab-pane" id="tab2"> 
                                <div class="portlet light bordered">
                                        <div class="portlet-body">

                                            <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                @csrf
                                                <input type="hidden" name="part_name" value="sale_order_index">


                                                <div class="col-md-12 col-sm-12 col-xs-12">

                                                    <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                        <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                                        <tr>
                                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td style="text-align: center;">
                                                                                <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                                <label class="switch">
                                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                    :checked="row.checkedColumn" >
                                                                                    <span class="slider round"></span>
                                                                                </label>
                                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="2">2 %</option>
                                                                                    <option value="6">6 %</option>
                                                                                    <option value="10">10 %</option>
                                                                                    <option value="15">15 %</option>
                                                                                    <option value="20">20 %</option>
                                                                                    <option value="25">25 %</option>
                                                                                    <option value="30">30 %</option>
                                                                                    <option value="40">40 %</option>
                                                                                    <option value="50">50 %</option>
                                                                                    <option value="60">60 %</option>
                                                                                </select>
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                            <!-- <label> @{{ row.Name }}</label> 
                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                            <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                <span class="slider round"></span>
                                                            </label> -->

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="margiv-top-10">
                                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                    <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                </div>
                                        </form>
                                        </div>
                                </div>
                            </div>
                    </div>
                </div>

            </div>
            </div>
        </report-modal>
    </div>
    <!-- END PAGE HEADER-->


    <!-- BEGIN TAB PORTLET-->
    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.SalesOrderList')</span>
                </div>
                <div class="tools">

                </div>
                <div class="pull-right">
                    <a href="{{route('salesOrder.graphicalshow')}}">
                        <button class="btn btn-success">@lang('layout.GraphicalPresintation')</button>
                    </a>

                    @permission('salesOrder-export')

                    <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                     </span>
                    @endpermission
                    @permission('salesOrder-create')
                    <a href="{{route('salesOrder.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_filter_data">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered " cellspacing="0" id="saleOrder">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Member')</th>
                        <th>@lang('layout.Category')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Discount')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.SaleArea')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <div id="factor-obj">
    <!-- @if (Session('message'))
        <object  data="{{url('factor22.pdf')}}" type="application/pdf" width="0" height="0"> </object>

        @endif -->
    </div>



    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        @if (Session('sale_id'))
        saleOrderfactorPrint("{{Session('sale_id')}}")
        @endif

        function saleOrderfactorPrint(id,sendWhatsapp = null) {
            if (sendWhatsapp == null || sendWhatsapp == '') {
                sendWhatsapp = 'not';
            }
            var a = document.createElement('a');
            a.href = "{{url('saleOrderFactorPrint')}}/" + id + "/" + sendWhatsapp;
            // a.href = "{{url('saleOrderFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }


        
        function sendVoucherToWhatsapp(id,sendWhatsapp) {
            if (id && sendWhatsapp) {
                axios.get("{{url('saleFactorPrintWhatsapp')}}/" + id + "/1", {
                })
                .then(function(response) { 
                    if (response.data) { 
                        console.log(response.data); 
                        if (sendWhatsapp == 1) {
                            var a = document.createElement('a');
                            a.href = "https://wa.me/?text=" + response.data;
                            a.target = "_blank";
                            document.body.appendChild(a);
                            a.click();
                            document.body.removeChild(a);
                        }
                        if (sendWhatsapp == 2) {
                            var a = document.createElement('a');
                            a.href = "https://telegram.me/share/url?url=Hi&text=" + response.data;
                            a.target = "_blank";
                            document.body.appendChild(a);
                            a.click();
                            document.body.removeChild(a);
                        }
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
            }
        }         


        function factorPrint(id) {
            $.ajax({
                url: "{{url('/')}}/salePrint/" + id,
                type: 'get',
                cache: false,

            }).done(function () {

                var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                $('#factor-obj').html(s);


                // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
            })
                .fail(function () {
                    console.log("error");
                });


        }

        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#saleOrder').DataTable({
                ajax: '{{route("salesOrder.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:5}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [

                    {data: 'number', name: 'sales_orders.number'},
                    {data: 'name', name: 'members.name'},
                    {data: 'category', name: 'sales_orders.category' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'currency', name: 'sales_orders.currency'},
                    {data: 'rate', name: 'rate', orderable: false, searchable: false},
                    {data: 'date', name: 'date' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'discount', name: 'sales_orders.discount' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'totalAmount', name: 'totalAmount', orderable: false, searchable: false},
                    {data: 'description', name: 'sales_orders.description' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'SalesArea', name: 'sale_areas.name' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'user', name: 'users.name' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}

                ]


            });


            $('#btnPrint').click(function () {
                $.ajax({
                    // This PHP file will generate the PDF and save it to your server
                    // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    url: '{{route("sale.show",1)}}',
                    type: 'get',
                    cache: false,

                }).done(function () {

                    var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                    $('#factor-obj').html(s);


                    // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                })
                    .fail(function () {
                        console.log("error");
                    });

                // window.print();
                // window.open("data:application/pdf," + escape(data=""));
                $.ajax({
                    // This PHP file will generate the PDF and save it to your server
                    // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    url: '{{route("sale.show",1)}}',
                    type: 'get',
                    cache: false,

                }).done(function () {

                    var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                    $('#factor-obj').html(s);


                    // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                })
                    .fail(function () {
                        console.log("error");
                    });

            });


        });


        var cust_rep = {!!customeReportNewData('sale_order_index')!!};
        // new vue for modal

        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                saleArealist: [],
                selectedArea: null,
                customer: [],
                selectedCustomer: null,
                classlist: [],
                selectedClass: null,
                customReportData:
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.SaleCode")', column_name: 'saleCode',checkedColumn:(cust_rep.saleCode)?'checked':'',column_percentage:(cust_rep.saleCode___percent)?cust_rep.saleCode___percent:''},
                 {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(cust_rep.customer)?'checked':'',column_percentage:(cust_rep.customer___percent)?cust_rep.customer___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.ItemName")', column_name: 'itemName',checkedColumn:(cust_rep.itemName)?'checked':'',column_percentage:(cust_rep.itemName___percent)?cust_rep.itemName___percent:''},
                 {Name: '@lang("layout.Inventory")', column_name: 'inventory',checkedColumn:(cust_rep.inventory)?'checked':'',column_percentage:(cust_rep.inventory___percent)?cust_rep.inventory___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(cust_rep.unit)?'checked':'',column_percentage:(cust_rep.unit___percent)?cust_rep.unit___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
                 {Name: '@lang("layout.TransferLeakage")', column_name: 'transferLeakage',checkedColumn:(cust_rep.transferLeakage)?'checked':'',column_percentage:(cust_rep.transferLeakage___percent)?cust_rep.transferLeakage___percent:''},
                 {Name: '@lang("layout.TransferOverLoad")', column_name: 'transferOverLoad',checkedColumn:(cust_rep.transferOverLoad)?'checked':'',column_percentage:(cust_rep.transferOverLoad___percent)?cust_rep.transferOverLoad___percent:''},
                 {Name: '@lang("layout.Delivered")', column_name: 'delivered',checkedColumn:(cust_rep.delivered)?'checked':'',column_percentage:(cust_rep.delivered___percent)?cust_rep.delivered___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_rep.price)?'checked':'',column_percentage:(cust_rep.price___percent)?cust_rep.price___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.TotalInHomeCurrency")', column_name: 'total_base',checkedColumn:(cust_rep.total_base)?'checked':'',column_percentage:(cust_rep.total_base___percent)?cust_rep.total_base___percent:''},
                 {Name: '@lang("layout.Forgivness")', column_name: 'forgivness',checkedColumn:(cust_rep.forgivness)?'checked':'',column_percentage:(cust_rep.forgivness___percent)?cust_rep.forgivness___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("layout.SaleArea")', column_name: 'saleArea',checkedColumn:(cust_rep.saleArea)?'checked':'',column_percentage:(cust_rep.saleArea___percent)?cust_rep.saleArea___percent:''},
                 {Name: '@lang("layout.Member")', column_name: 'member',checkedColumn:(cust_rep.member)?'checked':'',column_percentage:(cust_rep.member___percent)?cust_rep.member___percent:''},
                 {Name: '@lang("layout.Discount")', column_name: 'discount',checkedColumn:(cust_rep.discount)?'checked':'',column_percentage:(cust_rep.discount___percent)?cust_rep.discount___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'',column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
                 {Name: '@lang("layout.Remain")', column_name: 'remain',checkedColumn:(cust_rep.remain)?'checked':'',column_percentage:(cust_rep.remain___percent)?cust_rep.remain___percent:''},
                 {Name: '@lang("layout.Bundl")', column_name: 'bundle',checkedColumn:(cust_rep.bundle)?'checked':'',column_percentage:(cust_rep.bundle___percent)?cust_rep.bundle___percent:''},
                 {Name: '@lang("layout.RemainBundle")', column_name: 'remainBundle',checkedColumn:(cust_rep.remainBundle)?'checked':'',column_percentage:(cust_rep.remainBundle___percent)?cust_rep.remainBundle___percent:''},
                 {Name: '@lang("layout.OnHand")', column_name: 'onHand',checkedColumn:(cust_rep.onHand)?'checked':'',column_percentage:(cust_rep.onHand___percent)?cust_rep.onHand___percent:''},
                 {Name: '@lang("layout.FromPercentage")', column_name: 'fromPercentage',checkedColumn:(cust_rep.fromPercentage)?'checked':'',column_percentage:(cust_rep.fromPercentage___percent)?cust_rep.fromPercentage___percent:''},
                 {Name: '@lang("layout.ToPercentage")', column_name: 'toPercentage',checkedColumn:(cust_rep.toPercentage)?'checked':'',column_percentage:(cust_rep.toPercentage___percent)?cust_rep.toPercentage___percent:''},
                 {Name: '@lang("layout.PriceOfTon")', column_name: 'priceOfTon',checkedColumn:(cust_rep.priceOfTon)?'checked':'',column_percentage:(cust_rep.priceOfTon___percent)?cust_rep.priceOfTon___percent:''},
                 {Name: '@lang("layout.SaleNumber")', column_name: 'saleNumber',checkedColumn:(cust_rep.saleNumber)?'checked':'',column_percentage:(cust_rep.saleNumber___percent)?cust_rep.saleNumber___percent:''},
                 {Name: '@lang("layout.VendorName")', column_name: 'vendor_name',checkedColumn:(cust_rep.vendor_name)?'checked':'',column_percentage:(cust_rep.vendor_name___percent)?cust_rep.vendor_name___percent:''},
                ],
                cust_rep:cust_rep
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                onSaleAreaSearch(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'sale_areas',

                        }
                    })
                        .then(function (response) {
                            this.classlist = [];
                            if (response.data.length > 0) {
                                vm.saleArealist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },

                onMemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.customer = [];
                        if (response.data.length > 0) {
                            vm.customer = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })

                }, getDebounceTime()),

                //ajax call to get class
                searchClass(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'member_classes',

                        }
                    })
                        .then(function (response) {
                            vm.classlist = [];
                            if (response.data.length > 0) {
                                vm.classlist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },

                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        // /new vue for modal
        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#company_filter_data',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object')
                    {
                        data_table.clear();
                        data_table.ajax.reload()
                    }
                }
            }
        });

    </script>


@endpush
