@extends('layouts.app')
@section('content')
    @include('sales.modal')
    <!-- END PAGE HEADER-->
    <!-- BEGIN TAB PORTLET-->
	    <div id="app" v-cloak>
        {{Form::open(['route' => 'salesOrder.graphicalshow','method' => 'DELETE','class' => 'inline'])}}
        <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false" >
            <div slot="body">
                <div class="row">
                    <div class="form-group">

                        <div  class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch" :options="member">
                            </v-select>
                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>
						
                        <div  class="col-md-6">
                            <label class="control-label ">@lang('layout.Number') </label>
                            <input type="text" name="number" class="form-control"  autocomplete="off">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                   
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                                   
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h3> <label class="control-label"> @lang('layout.All') <input name="all" type="checkbox" value="true"> </label> </h3>
                             </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>

    <div id="app1" v-cloak>
        {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="graphicalshowSale"/>
        <button id="show-modal1" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false" >
            <div slot="body">
                <div class="row">
                    <div class="form-group">

                        <div  class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch" :options="member">
                            </v-select>
                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>
                        
                        <div  class="col-md-6">
                            <label class="control-label ">@lang('layout.Number') </label>
                            <input type="text" name="code" class="form-control"  autocomplete="off">
                        </div>

                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                   
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                                   
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>


	
    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.SalesOrderList')</span>
                </div>
                <div class="tools">
                </div>
                <div class="pull-right">
				<button type="button" class="btn btn-success" id="print_pdf_all"> <i class="fa fa-search"></i> @lang('layout.Search') </button>
                <button type="button" class="btn green hidden-print" id="print_pdf_all1"> <i class="fa fa-print"></i> @lang('layout.Print') </button>
                </div>
            </div>
            <div class="row">
                <?php foreach ($saleOrderAll as $so): ?> 
                <div class="col-md-6 col-sm-12">
                    <div class="portlet green-meadow box">
                        <div class="portlet-title">
                            <div class="caption">
                                <i class="icon-user"></i>&nbsp; {{$so['name']}}
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="row static-info">
                                <div class="value">
                                    <table class="table">
                                        <thead>
                                            <tr class="active" style="background-color: rgb(80, 129, 141) !important;">
                                                <td style="background-color: rgb(80, 129, 141) !important;color: white;">@lang('layout.Number')</td>
                                                <td style="background-color: rgb(80, 129, 141) !important;color: white;">@lang('layout.Date')</td>
                                                <td style="background-color: rgb(80, 129, 141) !important;color: white;">@lang('layout.Currency')</td>
                                                <td style="background-color: rgb(80, 129, 141) !important;color: white;">@lang('layout.Rate')</td>
                                                @if(systemConfig()[9] == 0 )
                                                @if(systemConfig()[4] == 1)
                                                <td style="background-color: rgb(80, 129, 141) !important;color: white;">@lang('layout.TotalQty')</td>
                                                <td style="background-color: rgb(80, 129, 141) !important;color: white;">@lang('layout.Total') @lang('layout.Bundl')</td>
                                                @endif
                                                @endif
                                                <td style="background-color: rgb(80, 129, 141) !important;color: white;">@lang('layout.Description')</td>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="active">
                                                <td>{{$so['number']}}</td>
                                                <td>{{convertDate($so['date'])}}</td>
                                                <td>{{$so['currency']}}</td>
                                                <td>{{$so['rate']}}</td>
                                                @if(systemConfig()[9] == 0 )
                                                @if(systemConfig()[4] == 1)
                                                <td>{{$so['total_quantity']}}</td>
                                                <td>{{$so['bundl']}}</td>
                                                @endif
                                                @endif
                                                <td>{{$so['description']}}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <div>
                                        <table class="table-bordered main-table" style="width: 100%;">
                                            <thead>
                                                <tr style="background-color: rgb(80, 129, 141) !important;">
                                                   <th class="text-center" style="color: white;">@lang('layout.ItemName')</th>
                                                   <th class="text-center" style="color: white;">@lang('layout.Inventory')</th>
                                                   @if(searchByCodeLocation()=="true")
                                                   <th class="text-center" style="color: white;">@lang('layout.Location')</th>
                                                   @endif
                                                   <th class="text-center" style="color: white;">@lang('layout.Quantity')</th>
                                                   <th class="text-center" style="color: white;">@lang('layout.Delivered')</th>
                                                   <th class="text-center" style="color: white;">@lang('layout.Remain')</th>
                                                   @if(systemConfig()[4] == 1)
                                                   <th class="text-center" style="color: white;">@lang('layout.Bundl')</th>
                                                   <th class="text-center" style="color: white;">@lang('layout.Remain') @lang('layout.Bundl') </th>
                                                    @endif
                                                   <th class="text-center" style="color: white;">@lang('layout.Measure')</th>
                                                   <th class="text-center" style="color: white;">@lang('layout.OnHand')</th>
                                                   <th class="text-center" style="color: white;">@lang('layout.Price')</th>
                                                   <th class="text-center" style="color: white;">@lang('layout.TotalPrice')</th>
                                                </tr>
                                            </thead> 
                                            <tbody>
                                                @if(isset($so['items']))
                                                <?php $totalSome = 0; ?>
                                                @foreach ($so['items'] as $item)
                                                <?php
                                                if(systemConfig()[30] == 1){
                                                    $totalSome += $item['qty']*$item['cost'] * $item['static_rate'] / $item['rate'];
                                                }else{
                                                    $totalSome += $item['qty']*$item['cost'] * $item['rate'];
                                                }
                                                ?>
                                                <tr>
                                                    <td class="text-center">{{$item['item']}}</td>
                                                    <td class="text-center">{{$item['site_name']}}</td>
                                                    @if(searchByCodeLocation()=="true")
                                                    <td class="text-center">{{$item['location']}}</td>
                                                    @endif
                                                    <td class="text-center">{{($item['item_quantity'] != 0)?myRound(($item['item_quantity']*$item['item_unit'])/$item['sale_order_unit']):0}}</td>
                                                    <td class="text-center">{{($item['item_quantity'] != 0)?($item['qut_out']*$item['item_unit'])/$item['sale_order_unit']:0}}</td>
                                                    <td class="text-center">@if($item['qty'] > 0)
                                                        {{($item['qty']*$item['item_unit'])/$item['sale_order_unit']}}
                                                        @endif
                                                    </td>
                                                    @if(systemConfig()[4] == 1)
                                                   <td class="text-center">{{$item['ordBundl']}}</td>
                                                   <td class="text-center">{{$item['bundl']}}</td>
                                                    @endif
                                                    <td class="text-center">{{$item['sale_order_measur']}}</td>
                                                    @if($item['type'] == 'material')
                                                    <td class="text-center">{{($item['item_unit'] > 0)?(inventoryItemRoll($item['inventory_id'], $item['site_id'])*($item['item_unit']/$item['sale_order_unit'])):0}}</td>
                                                    @else
                                                    <td class="text-center">{{($item['item_unit'] > 0)?(inventoryItem($item['inventory_id'], $item['site_id'])*($item['item_unit']/$item['sale_order_unit'])):0}}</td>
                                                    @endif
                                                    @if(systemConfig()[30] == 1)
                                                    <td class="text-center">{{$item['cost'] * $item['static_rate'] / $item['rate']}} </td>
                                                    @else 
                                                    <td class="text-center">{{$item['cost'] * $item['rate']}} </td>
                                                    @endif
                                                    @if(systemConfig()[30] == 1)
                                                    <td class="text-center">{{($item['qty'] != 0)?myRound(($item['qty']*$item['cost'] * $item['static_rate'] / $item['rate'] )):0}}  </td>
                                                    @else 
                                                    <td class="text-center">{{($item['qty'] != 0)?myRound(($item['qty']*$item['cost'] * $item['rate'])):0}}  </td>
                                                    @endif
                                                 </tr>
                                               @endforeach
                                               <tr>
                                                    <td class="text-center" colspan="10">@lang('layout.TotalPcs')</td>
                                                    <td class="text-center">{{$totalSome}}</td>
                                               </tr>
                                               @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach ?>
            </div>
            @if (isset($pageData))
            <div class="col-md-12 col-sm-12">
                <div class="row" style="border-radius: 5px;  padding-left: 20px; padding-right: 20px; margin-top: 20px;">
                    <div class="dataTables_paginate paging_full_numbers" id="saleOrder_paginate">
                        <ul class="pagination">
                            @if ($pageData->hasPages())
                            @if (!$pageData->onFirstPage())
                            <li class="paginate_button first" aria-controls="saleOrder" tabindex="0" id="saleOrder_first">
                                <a href="{{ $pageData->url($pageData->onFirstPage()) }}">
                                    <i class="fa fa-angle-double-right"></i>
                                </a>
                            </li>
                            @endif
                            @if ($pageData->onFirstPage())
                            @else
                            <li class="paginate_button previous" aria-controls="saleOrder" tabindex="0" id="saleOrder_previous">
                                <a href="{{ $pageData->previousPageUrl() }}">
                                    <i class="fa fa-angle-right"></i>
                                </a>
                            </li>
                            @endif
                            @for ($i= 1; $i <= $pageData->lastPage(); $i++)
                            @if ($i == $pageData->currentPage())
                            <li class="paginate_button active" aria-controls="saleOrder" tabindex="0">
                                <a href="{{ $pageData->url($i) }}">{{ $i }}</a>
                            </li>
                            @else
                            <li class="paginate_button" aria-controls="saleOrder" tabindex="0">
                                <a href="{{ $pageData->url($i) }}">{{ $i }}</a>
                            </li>
                            @endif
                            @endfor
                            @if ($pageData->hasMorePages())
                            <li class="paginate_button next" aria-controls="saleOrder" tabindex="0" id="saleOrder_next">
                            <a href="{{ $pageData->nextPageUrl() }}">
                                <i class="fa fa-angle-left"></i>
                            </a>
                            </li>
                            @endif
                            @if ($pageData->lastPage())
                            <li class="paginate_button last" aria-controls="saleOrder" tabindex="0" id="saleOrder_last">
                                <a href="{{ $pageData->url($pageData->lastPage()) }}">
                                    <i class="fa fa-angle-double-left"></i>
                                </a>
                            </li>
                            @endif
                            @endif
                        </ul>
                    </div>
                </div>
            </div>
            @endif
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>
    <!-- END CONTENT BODY -->
@stop
@push('scripts')
<script>

	    Vue.component('v-select', VueSelect.VueSelect);
    var Modal=Vue.component('modal', {
        template: '#modal-template',
        methods: {
            ok: function() {
                this.$emit('ok')
            }
        }
    });
    // start app
    var v_app = new Vue({
        el: '#app',
        data: {
            showModal: false,
            selectedMember:null,
            member:[],
        },
        methods:{
            ok:function(){
                // alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close:function(e)
            {
                this.showModal = !this.showModal;
            },
            editExample : function(){

                //Your other code that launches the modal
                this.showModal= true;
                this.$nextTick(function(){
                    $(document).ready(function(){
                    $(".date").persianDatepicker(modelDate());
                    });
                })
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        type: 'Customer'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        v_app.member = [];
                        v_app.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),
        },
    });

    var v_app1 = new Vue({
        el: '#app1',
        data: {
            showModal: false,
            selectedMember:null,
            member:[],
        },
        methods:{
            ok:function(){
                // alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close:function(e)
            {
                this.showModal = !this.showModal;
            },
            editExample : function(){

                //Your other code that launches the modal
                this.showModal= true;
                this.$nextTick(function(){
                    $(document).ready(function(){
                    $(".date").persianDatepicker(modelDate());
                    });
                })
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        type: 'Customer'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        v_app1.member = [];
                        v_app1.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),
        },
    });


    $('#print_pdf_all').on('click',function(e){
        $('#show-modal').click();
        e.preventDefault();
    });
        $('#print_pdf_all1').on('click',function(e){
        $('#show-modal1').click();
        e.preventDefault();
    });
	
	 
	</script>

@endpush
