@extends('layouts.report')
<?php 
$reportTitle = __('layout.PurchaseOrder');
?>
@section('content')
    <!-- END PAGE HEADER-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <h3 style="text-alin:center;">@lang('layout.SaleOrder')</h3>
            <div class="row">
                    <?php foreach ($data as $so): ?> 
                <div style=" margin-bottom: 15px; padding-left: 10px;" >
                    <div class="portlet green-meadow box" style=" border: 1px solid #2ae0bb;">
                        <div class="portlet-title" style=" background-color: #1BBC9B">
                            <div class="caption">
                                <i class="icon-user"></i> {{$so['name']}}
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="row static-info">
                                <div class="col-md-12 value">
                                      <table class="main-table">
                                        <thead>
                                            <tr class="active">
                                                <td class="text-center" style="text-align: center;">@lang('layout.Number')</td>
                                                <td class="text-center" style="text-align: center;">@lang('layout.Date')</td>
                                                <td class="text-center" style="text-align: center;">@lang('layout.Currency')</td>
                                                <td class="text-center" style="text-align: center;">@lang('layout.Rate')</td>
                                                @if(systemConfig()[9] == 0 )
                                                @if(systemConfig()[4] == 1)
                                                <td class="text-center" style="text-align: center;">@lang('layout.TotalQty')</td>
                                                <td class="text-center" style="text-align: center;">@lang('layout.Total') @lang('layout.Bundl')</td>
                                                @endif
                                                @endif
                                                <td class="text-center" style="text-align: center;">@lang('layout.Description')</td>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="active">
                                                <td class="text-center" style="text-align: center;">{{$so['number']}}</td>
                                                <td class="text-center" style="text-align: center;">{{convertDate($so['date'])}}</td>
                                                <td class="text-center" style="text-align: center;">{{$so['currency']}}</td>
                                                <td class="text-center" style="text-align: center;">{{$so['rate']}}</td>
                                                @if(systemConfig()[9] == 0 )
                                                @if(systemConfig()[4] == 1)
                                                <td class="text-center" style="text-align: center;">{{$so['total_quantity']}}</td>
                                                <td class="text-center" style="text-align: center;">{{$so['bundl']}}</td>
                                                @endif
                                                @endif
                                                <td class="text-center" style="text-align: center;">{{$so['description']}}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <br>
                                    <div >
                                        <table class="main-table" >
                                            <thead>
                                                <tr class="bg">
                                                   <th class="text-center" style="text-align: center;">#</th>
                                                   <th class="text-center" style="text-align: center;">@lang('layout.ItemName')</th>
                                                   <th class="text-center" style="text-align: center;">@lang('layout.Inventory')</th>
                                                   @if(searchByCodeLocation()=="true")
                                                   <th class="text-center" style="text-align: center;">@lang('layout.Location')</th>
                                                   @endif
                                                   <th class="text-center" style="text-align: center;">@lang('layout.Quantity')</th>
                                                   <th class="text-center" style="text-align: center;">@lang('layout.Delivered')</th>
                                                   <th class="text-center" style="text-align: center;">@lang('layout.Remain')</th>
                                                   @if(systemConfig()[4] == 1)
                                                   <th class="text-center" style="text-align: center;">@lang('layout.Bundl')</th>
                                                   <th class="text-center" style="text-align: center;">@lang('layout.Remain') @lang('layout.Bundl') </th>
                                                    @endif
                                                   <th class="text-center" style="text-align: center;">@lang('layout.Measure')</th>
                                                   <th class="text-center" style="text-align: center;">@lang('layout.OnHand')</th>
                                                   <th class="text-center" style="text-align: center;">@lang('layout.Price')</th>
                                                   <th class="text-center" style="text-align: center;">@lang('layout.TotalPrice')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $count = 1; ?>
                                                <?php $totalSome = 0; ?>
                                                @if(isset($so['items']))
                                                @foreach ($so['items'] as $item)
                                                <?php
                                                if(systemConfig()[30] == 1){
                                                    $totalSome += $item['qty']* $item['cost'] * $item['static_rate'] / $item['rate'];
                                                }else{
                                                    $totalSome += $item['qty']*$item['cost'] * $item['rate'];
                                                }
                                                ?>
                                                <tr>
                                                    <td class="text-center" style="text-align: center;">{{ $count++ }}</td>
                                                    <td class="text-center" style="text-align: center;">{{$item['item']}}</td>
                                                    <td class="text-center" style="text-align: center;">{{$item['site_name']}}</td>
                                                    @if(searchByCodeLocation()=="true")
                                                    <td class="text-center" style="text-align: center;">{{$item['location']}}</td>
                                                    @endif
                                                    <td class="text-center" style="text-align: center;">{{round(($item['quantity']*$item['item_unit'])/$item['sale_order_unit'],3)}}</td>
                                                    <td class="text-center" style="text-align: center;">{{($item['qut_out']*$item['item_unit'])/$item['sale_order_unit']}}</td>
                                                    <td class="text-center" style="text-align: center;">@if(($item['qty']*$item['item_unit'])/$item['sale_order_unit'] > 0)
                                                        {{($item['qty']*$item['item_unit'])/$item['sale_order_unit']}}
                                                        @endif
                                                    </td>
                                                    @if(systemConfig()[4] == 1)
                                                    <td class="text-center" style="text-align: center;">{{$item['ordBundl']}}</td>
                                                    <td class="text-center" style="text-align: center;">{{$item['bundl']}}</td>
                                                    @endif
                                                    <td class="text-center" style="text-align: center;">{{$item['sale_order_measur']}}</td>
                                                    @if($item['type'] == 'material')
                                                    <td class="text-center" style="text-align: center;">{{(inventoryItemRoll($item['inventory_id'], $item['site_id'])*$item['item_unit']/$item['sale_order_unit'])}}</td>
                                                    @else
                                                    <td class="text-center" style="text-align: center;">{{inventoryItem($item['inventory_id'], $item['site_id'])*$item['item_unit']/$item['sale_order_unit']}}</td>
                                                    @endif
                                                    @if(systemConfig()[30] == 1)
                                                    <td class="text-center" style="text-align: center;">{{$item['cost'] * $item['static_rate'] / $item['rate']}}</td>
                                                    @else 
                                                    <td class="text-center" style="text-align: center;">{{$item['cost'] * $item['rate']}}</td>
                                                    @endif
                                                    @if(systemConfig()[30] == 1)
                                                    <td class="text-center" style="text-align: center;">{{($item['qty'] != 0)?myRound(($item['qty']*$item['cost'] * $item['static_rate'] / $item['rate'])):0}}</td>
                                                    @else 
                                                    <td class="text-center" style="text-align: center;">{{($item['qty'] != 0)?myRound(($item['qty']*$item['cost'] * $item['rate'])):0}}</td>
                                                    @endif
                                                 </tr>
                                               @endforeach
                                               <tr>
                                                    <td class="text-center" style="text-align: center;" colspan="12">@lang('layout.TotalPcs')</td>
                                                    <td class="text-center" style="text-align: center;">{{$totalSome}}</td>
                                                </tr>
                                               @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                    <?php endforeach ?>
            </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>
    <!-- END CONTENT BODY -->
@stop

