@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>


    </style>
@stop
@section('content')
    @include("layouts.Cmodal")

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i> &nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditSaleOrders') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools"> 
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::model($saleOrder,['route' => ['salesOrderValue.update',$saleOrder->id],'method' => 'patch','class' => 'form-horizontal','id'=>'sales-form'])}}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                            <!-- begin inputs -->
                            <div class="row">


                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group"> 
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Customer')</label> 
                                            <v-select label="name" @input="memberChange()" :options="customer" @search="MemberSearch" v-model="selected_customer" disabled></v-select>
                                            <input type="hidden" name="customer"
                                                   :value="!selected_customer?null:selected_customer.id" required>
                                        </div>
                                    </div>
                                </div>
 
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group"> 
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Number')</label> 
                                            <input type="number" name="number" value="{{$saleOrder->number}}"
                                                   class="form-control">
                                        </div>
                                    </div>
                                </div> 

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.SaleCode')</label>
                                            <input type="text" name="sale_code" value="{{$saleOrder->sale_code}}" class="form-control">
                                        </div>
                                    </div>
                                </div>
 
                            </div>

                            <div class="row">
                                
                            

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.DeliveryDate')</label>

                                            <input type="text" name="delivery_date"
                                                   value="{{$saleOrder->delivery_date}}" class="form-control date"
                                                   autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>

                                            <textarea name="description" class="form-control" rows="1">{{$saleOrder->description}}</textarea>
                                        </div>
                                    </div>
                                </div> 

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>

                                            <input type="text" name="date" value="{{$saleOrder->date}}"
                                                   class="form-control date" autocomplete="off">
                                        </div>
                                    </div>
                                </div> 
                            </div>
  
                            <!--div class="row">

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Currency')</label>


                                            <v-select label="code" @input="selectedRate" :options="currency"
                                                      v-model="selected_currency"></v-select>
                                            <input type="hidden" name="currency" :value="selected_currency.code">

                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Rate')</label>

                                            <input type="number" name="currency_rate" name="rate"
                                                   v-model="!selected_currency?0:selected_currency.rate"
                                                   class="form-control" :class="{'has-error':rate<=0}">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Discount')</label>

                                            <div class="input-group">

                                                <input v-model="discountFiled" class="form-control"
                                                       type="number" min="0" max="100">
                                                <span v-if="discountIsAmount"
                                                      @click="discountIsAmount = !discountIsAmount"
                                                      class="input-group-addon">@{{selected_currency.symbol}}
                                              <input type="hidden" class="input-group-addon" name="discount_type"
                                                     value="currency">
                                          </span>
                                                <span v-else @click="discountIsAmount = !discountIsAmount"
                                                      class="input-group-addon">%
                                              <input type="hidden" name="discount_type" value="percent">
                                          </span>
                                                <input type="hidden" name="discountTotal" :value="discount">
                                                <input type="hidden" name="discount" :value="discountFiled">
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div -->

                            <!--div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.DeliveryDate')</label>

                                            <input type="text" name="delivery_date"
                                                   value="{{$saleOrder->delivery_date}}" class="form-control date"
                                                   autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>

                                            <textarea name="description" class="form-control" rows="1">
                                            {{$saleOrder->description}}
                                        </textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>

                                            <input type="text" name="date" value="{{$saleOrder->date}}"
                                                   class="form-control date" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                            </div -->

                            <!--div class="row">
                                 <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Category')</label>

                                            <select name="category" v-model="category" class="form-control">
                                                <option value="">@lang('layout.Select')</option>
                                                <option  value="saleOrder">@lang('layout.SaleOrder')</option>
                                                <option value="itemLend">@lang('layout.ItemLend')</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div -->
                            <!-- end inputs -->
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                            <!-- begin total -->
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') :</small>
                                        </td>
                                        <td class="text-right"><span data-counter="counterup"
                                                                     data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Discount'): (@{{
                                                Number.parseFloat(discount).toFixed(precision()) }}%)
                                            </small>
                                        </td>
                                        <td class="text-right">
                               <span class="text-right" data-counter="counterup"
                                     data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>

                                <!--      <tr>
                          <td>
                              <small>@lang('layout.Payment'):</small>
                          </td>
                          <td class="text-right">
                              <small class="font-green-sharp">
                                  <span class="text-right" data-counter="counterup"
                                  data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                  <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                              </small>
                          </td>
                      </tr>
 -->

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Sub-Total'):</small>
                                        </td>
                                        <td class="text-right">
                              <span class="text-right" data-counter="counterup"
                                    data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>


                                </table>

                            </div>

                            <!-- end total -->
                        </div>

                    </div>

                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th v-show="showWhat('sale_category')=='yes'"
                                    style="min-width: 130px">@lang('layout.Category') </th>
                                <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                @if(systemConfig()[4] == 1)
                                <th style="min-width: 100px">@lang('layout.Bundl') </th>
                                @endif
                                 <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 100px">@lang('layout.OMeasureValue') 1
                                </th>
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 100px">@lang('layout.OMeasureValue') 2
                                </th>
                                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                <th style="min-width: 100px">@lang('layout.NewCost') </th>
                                  <th v-show="showWhat('sale_discount')=='yes'"
                                                            style="min-width: 100px">@lang('layout.Discount') </th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                <td v-show="showWhat('sale_category')=='yes'">
                                    <v-select label="name" v-model="item.item_category" ></v-select>
                                    <input type="hidden" name="inventory_category_id[]"
                                           :value="(!item.item_category)?null:item.item_category.id">
                                </td>
                                <td class="highlight">
                                    <v-select label="name" v-model="item.item" ></v-select>
                                    <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                    <input type="hidden" name="saleOrderInfoId[]" :value="(!item.item)?null:item.item.saleOrderInfoId">
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item==null)?null:item.item.site" class="form-control" disabled>
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                  :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                    </select>

                                    <input type="hidden" name="inventory_site[]"
                                           :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                </td>
                                <td v-show="showWhat('sale_description')=='yes'">
                                    <input type="text" placeholder="@lang('layout.Description')"
                                           name="inventory_description[]" class="form-control">
                                </td>

                                <td>


                                    <input type="number" name="inventory_quantity[]"
                                           v-model.number="(item.item==null)?null:item.item.quantity"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.Quantity')">
                                </td>
                                @if(systemConfig()[4] == 1)
                                <td>
                                    <input type="number" name="bundl[]" v-model.number="(item.item==null)?null:item.item.bundl"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.Bundl')">
                                </td>
                                @endif
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" name="other_measure_amount[]"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.OMeasureValue') 1"
                                            v-model.number="(item.item==null)?null:item.item.other_measure">
                                </td>
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" name="other_measure_amount2[]"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.OMeasureValue') 2"
                                            v-model.number="(item.item==null)?null:item.item.other_measure2">
                                </td>

                                <td>
                                <!--    <input type="text" :value="(item.item==null)?null:saleItemQuantity(item.item,item.item.quantity)" class="form-control input-number" placeholder="@lang('layout.OnHand')"> -->
                                    @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)" disabled>
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                              <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span> 
                                    </select> 
                                    <input type="hidden" name="inventory_measure[]"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="inventory_price[]" placeholder="@lang('layout.Cost')"
                                               :value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)"
                                               ref="in" @input="setNewRate('inventory',index)" class="form-control">
                                        <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div> 
                                </td>
                                    <td v-show="showWhat('sale_discount')=='yes'">
                                    <div class="input-group">
                                        <input type="number" name="inventory_discount[]"
                                               placeholder="@lang('layout.Discount')"
                                               v-model.number="(item.item==null)?null:item.item.discount"
                                               class="form-control">
                                        <span class="input-group-addon" v-if="discountIsAmount">
                                      @{{selected_currency.symbol}}
                                    </span>
                                        <span class="input-group-addon"
                                              v-if="!discountIsAmount">
                                      %
                                    </span>

                                    </div>

                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control inner_input"
                                               :value="(item.item==null)?null:getItemTotal(item.item,selected_currency.rate, null, null, null, null, null, selected_currency.static_rate).result"
                                               placeholder="@lang('layout.Total')" disabled>
                                        <span class="input-group-addon">
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('inventory',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>

                        <hr>
                        <!-- begin service -->
                        <!--table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>

                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(service,index) in services">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="service.item" :options="(service.items)"
                                              @click.native="addNew('service',index)"
                                              @input="checkExistingService(index)">

                                    </v-select>
                                    <input type="hidden" name="service_id[]"
                                           :value="(service.item==null)?null:service.item.id">
                                </td>

                                <td>
                                    <input class="form-control" name="service_quantity[]"
                                           v-model.number="(!service.item)?null:service.item.quantity"
                                           placeholder="@lang('layout.Quantity')">
                                </td>
                                <td class="highlight">
                                    <select v-model="(service.item == null)?null:service.item.measure"
                                            class="form-control" @change="measureChangeservice(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(service.item ==null)?false:true">
                                              <option v-for="measure in (service.item==null)?null:service.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>

                                    </select>

                                    <input type="hidden" name="service_measure[]"
                                           :value="(service.item==null)?null:service.item.measure.measure_id">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="service_price[]" placeholder="@lang('layout.Cost')"
                                               :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate)"
                                               ref="ser" @input="setNewRate('service',index)" class="form-control">
                                        <span class="input-group-addon">
                                          @{{selected_currency.symbol}}
                                        </span>
                                    </div>

                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control inner_input"
                                               :value="(service.item==null)?null:getItemTotalService(service.item,selected_currency.rate)"
                                               placeholder="@lang('layout.Total')" disabled>
                                        <span class="input-group-addon">
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('service',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table -->
                        <!-- end service -->
                        <!-- begin payments -->
                        <!--table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(payment,index) in payments">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="payment.item" :options="(payment.items)"
                                              @click.native="addNew('payment',index)"
                                              @input="checkExistingPayment(index)">

                                    </v-select>
                                    <input type="hidden" v-if="payment.item !=null" name="payment_id[]"
                                           :value="(payment.item==null)?null:payment.item.id">
                                </td>

                                <td>
                                                 
                                                      <span v-if="payment.item !=null">
                                                        @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                                      </span>
                                </td>
                                <td>
                                    <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                           type="number" v-model.number="(payment.item==null)?null:payment.item.rate "
                                           class="form-control"
                                           placeholder="@lang('layout.Rate')"/>
                                    <input v-if="payment.item !=null" type="hidden" name="payment_rate[]"
                                           v-bind:value="payment.item.rate">
                                </td>
                                <td>
                                    <input type="text" name="payment_currency[]" class="form-control"
                                           v-model="(payment.item==null)?null:payment.item.code"
                                           placeholder="@lang('layout.Currency')" disabled reqiured/>

                                    <input v-if="payment.item !==null" type="hidden" name="payment_currency[]"
                                           v-bind:value="payment.item.code"/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               v-model.number="(payment.item==null)?null:payment.item.amount "
                                               placeholder="@lang('layout.PayAmount')"/>

                                        <input v-if="payment.item !=null" type="hidden" name="payment_amount[]"
                                               v-bind:value="payment.item.amount">

                                        <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate)"
                                               placeholder="@lang('layout.Total')" style="min-width: 100px"/>
                                        <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('payment',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>

                        </table -->
                        <!-- end payments -->

                    </div>


                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" v-if="!isError" @click="submitForm"
                            class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('inventorySite.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">

                </cmodal>
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    types: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectReceive: null,
                    classes: [],
                    selectedClass: null,
                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Customer") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if(this.receivables.length>0)
                        {
                            this.selectReceive=this.receivables[0];
                        }
                        if(this.payables.length>0)
                        {
                            this.selectPay=this.payables[0];
                        }

                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    v.showModal = false;
                    //this.member.type = this.member.type.id;
                    var datas = $("#modalForm").serializeArray();
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': this.code,
                            'email': datas[1]['value'],
                            'phone': datas[2]['value'],
                            'address1': datas[3]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        if (response) {
                            v.selected_customer = response.customer;
                        }
                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });


        var selectedCustomer ={!! $selectedCustomer !!};
        var currency ={!! $currency !!};
        var selectedCurrency = {!! $selectedCurrency !!};
        var banks = {!! $banks !!};
        var selectedBanks = {!! $selectedBanks !!};
        var all_services = {!! $all_services !!};
        var saleOrderSelectedItem = {!! $saleOrderSelectedItem !!};
        var saleOrderSelectedService = {!! $saleOrderSelectedService !!};
        var saleOrder = {!! $saleOrder !!};

        var inventoryCategory = {!! $inventoryCategory !!};
        var saleArea = {!! $saleArea !!};
        var memberClass = {!! $memberClass !!};

        var v = new Vue({
            el: '#app',
            data: {
                showModal: false,
                saleOrder: saleOrder,
                saleOrderSelectedItem: saleOrderSelectedItem,
                all_customer:[],
                customer: [],
                selected_customer: selectedCustomer,
                banks: banks,
                all_services: all_services,
                saleOrderSelectedService: saleOrderSelectedService,
                selected_banks: selectedBanks,
                currency: currency,
                selected_currency: {!!json_encode(getHomeCurrency()) !!},
                rate: 0,
                discountFiled: 0,
                discountIsAmount: false,
                temp_items: [],
                totalAmountes: [],
                newCost: [
                    null,
                    null,
                    null,
                    null],
                inventories: [],
                services: [],
                payments: [
                    {
                        items: all_services,
                        item: null,
                    }
                ],
                inventory_category: inventoryCategory,
                selected_index: 0,
                saleArea: saleArea,
                selected_area: null,
                category:'saleOrder',
                memberClass:memberClass,
                selected_class:null
            },
            computed: {
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {

                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                            }
                            else {
                                // sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                            }

                        }

                    }
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item && this.services[i].item != null) {

                            var rate = this.services[i]['item']['rate'];
                            var new_rate = this.services[i]['item']['new_rate'];
                            var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.services[i]['item']['measure_unit'];
                            var quantity = this.services[i]['item']['quantity'];
                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                            }
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else   
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
                            }

                        }
                    }
                    return sum;
                },

                // check payed amount
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                //
                                @if(systemConfig()[30] == 1)
                                sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                                @endif
                                
                            }
                        }
                    }
                    return sum;
                },
                
                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    
                    if (this.inventories.length == 0 || this.selected_customer == undefined || this.selected_customer == null) {
                        isError = true;
                    }
                    return isError;


                },
                // filter the banks according to selected currency
                approperiateBank: function () {
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },
            },
            mounted: function () {
                // initialize the selected item
                for (var i = 0; i < this.saleOrderSelectedItem.length; i++) {
                    this.inventories.push({
                        item: this.saleOrderSelectedItem[i],
                        item_category: this.saleOrderSelectedItem[i].item_category
                    });
                }
                
                // end item

                // begin payment initialization

                for (var t = 0; t < this.selected_banks.length; t++) {
                    var foundFlag = false;
                    var tempBank = null;
                    for (var y = 0; y < this.banks.length; y++) {
                        if (this.selected_banks[t].id == this.banks[y].id) {
                            foundFlag = true;
                            tempBank = this.banks[y];
                            tempBank.amount = this.selected_banks[t].balance;
                            tempBank.rate = this.selected_banks[t].rate;
                        }
                    }
                    if (foundFlag) {

                        this.payments.push({item: tempBank, items: this.banks});
                    }
                }
                // for(var w=1;w>this.selected_banks.length;w--)
                // {
                //    this.payments.push({item:null,items:banks});
                // }
                // end payment initialization


                // begin service

                for (var r = 0; r < this.saleOrderSelectedService.length; r++) {
                    var flag = false;
                    var tempService;
                    for (var h = 0; h < this.all_services.length; h++) {
                        if (this.all_services[h].id == this.saleOrderSelectedService[r].item_id) {
                            flag = true;
                            tempService = this.all_services[h];
                            tempService.quantity = this.saleOrderSelectedService[r].qty;
                            tempService.rate = this.saleOrderSelectedService[r].price;
                            tempService.new_rate = this.saleOrderSelectedService[r].price;
                        }
                    }
                    if (flag) {
                        this.services.push({item: tempService, items: this.all_services})
                    }
                }
                for (var w = 1; w > this.saleOrderSelectedService.length; w--) {
                    this.services.push({item: null, items: all_services});
                }
                // end service

                if (this.saleOrder) {
                    
                    this.selected_area = _.find(this.saleArea, (s) => s.id == this.saleOrder.sale_area_id);

                    this.selected_currency = _.find(this.currency, (s) => s.code == this.saleOrder.currency);
                    
                    this.selected_class = _.find(this.memberClass, (c) => c.id == this.saleOrder.class_id);
                    if(this.saleOrder.category)
                    {
                        this.category=this.saleOrder.category;
                    }
                    this.discountFiled = this.saleOrder.discount;
                    if (this.saleOrder.discount_type) {
                        if (this.saleOrder.discount_type == 'percent') {
                            this.discountIsAmount = false;
                        }
                        else {
                            this.discountIsAmount = true;
                        }
                    }
                }
            },
            methods:
                {
                    memberClassChange() {
                        if (v.selected_class) {
                            v.customer = [];
                            // v.selected_customer = null;
                            let class_id = v.selected_class.id;
                        
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchMember',
                                    class_id: class_id,
                                    type: 'Customer'
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    // console.log(response.data);
                                    v.customer = [];
                                    v.customer = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }
                    },
                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                class_id: class_id,
                                type: 'Customer'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.customer = [];
                                v.customer = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),
                    
                    setIndex(e) {
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {
                        v.setIndex(index);
                        let inventory_category_id = this.inventories[this.selected_index]['item_category'].id;
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSale',
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                    },

                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },

                    // calculate item price based on measure change
                    measureChangeservice(index) {

                        if (this.services[index].item != null) {
                            var item = this.services[index].item;
                            @if(systemConfig()[30] == 1)
                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                            @endif
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.services[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    // detect member change and searh
                    memberChange() {
                        if (this.selected_customer) {
                            // get member contract
                            this.contractSearch(this.selected_customer.id, this);
                        }
                    },
                    // set new price
                    setNewRate(type = null, index) {
                        if (type == 'inventory') {
                            if (this.inventories[index].item) {
                                @if(systemConfig()[30] == 1)
                                this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                                @endif
                            }
                        }
                        if (type == 'service') {
                            if (this.services[index].item) {
                                @if(systemConfig()[30] == 1)
                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                                @endif
                            }
                        }


                    },
                    // begin item search
                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSearchSale',
                                keyword: search,
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),


                    // end item search

                    // contract search


                    contractSearch(id, vm) {
                        vm.contract = [];
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'member_contract',
                                member_id: id
                            }
                        })
                            .then(function (response) {
                                if (response.data.length > 0) {
                                    vm.contract = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    },
                    // end contract search

                    // generic function for adding item to list
                    addNew(type = null, index) {

                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, item_category: null});
                                }
                            }
                            if (type == 'service') {
                                if (this.services[index + 1] == undefined) {
                                    this.checkExistingService(index, '');
                                    this.services.push({
                                        items: this.all_services,
                                        item: null,
                                    });
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },

                    // in here you can check and decide to allow duplicate service or not
                    checkExistingService(index = null, name = '') {
                        var service_temp = this.all_services.slice();
                        var service_temp1 = [];
                        for (var i = 0; i < this.services.length; i++) {
                            if (this.services[i].item != null) {
                                var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                                if (fined != -1) {
                                    var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                                }
                            }
                        }
                        this.services[index].items = service_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'service') {
                                this.services.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("sales-form").submit()

                            }
                            else {

                            }
                        });

                    },
                },
            created: function () {

            }

        });

    </script>


@endpush