@extends('layouts.factor-master')

@section('content')
<?php
// dd($info);
?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.SaleOrderDetails')</h3>
@if($info && $info !=[])
<table class="main-table">
 
  <tr class="bg"> 
    <td class="center">@lang('layout.Number')</td>
    <td class="center">@lang('layout.Member')</td>
    <td class="center">@lang('layout.Currency')</td>
    <td class="center">@lang('layout.Rate')</td>
    <td class="center">@lang('layout.Discount')</td>
    <td class="center">@lang('layout.TotalQuantity')</td>
    <td class="center">@lang('layout.Date')</td>
    <td class="center">@lang('layout.DeliveryDate')</td>
    <td class="center">@lang('layout.Description')</td>
  </tr>
  <tr>
    <td class="center">{{$info->number}}</td>
    <td class="center">{{$info->name}}</td>
    <td class="center">{{$info->currency}}</td>
    <td class="center">{{$info->rate}}</td>
    <td class="center">{{$info->discount}}</td>
    <td class="center">{{$info->quatity}}</td>
    <td class="center">{{convertDate($info->date)}}</td>
    <td class="center">{{convertDate($info->delivery_date)}}</td>
    <td class="center">

        @if(isset($report_format))
        {{$info->description}}
        @else
        {!! wordwrap($info->description,40,"<br/>\n",false) !!}
        @endif

  </td>
  </tr>


</table>
<br>
@endif




<table class="main-table">
 
  <tr class="bg"> 
  <td><div class="center"> @lang('layout.Record') </div></td>  
  <td class="center">@lang('layout.ItemName')</td>
  <td class="center">@lang('layout.Site')</td>
  @if(searchByCodeLocation()=="true")
  <td class="center">@lang('layout.Location')</td>
  @endif
  <td class="center">@lang('layout.MeasureUnit')</td>
  
  @if(systemConfig()[4] == 1)
  <td class="center">@lang('layout.Bundl')</td>
  @endif
  @if(getOtherMeasure()=="true")
  <th>@lang('layout.OMeasureValue1')</th>
  @endif
  @if(getOtherMeasure2()=="true")
  <th>@lang('layout.OMeasureValue2')</th>
  @endif
  <td class="center">@lang('layout.Quantity')</td>
  <td class="center">@lang('layout.Price')</td>
  <td class="center">@lang('layout.TotalAmount')</td>
</tr>
<?php
$count = 0;
?>
@foreach($data AS $record)
<tr>
<td class="center">{{++$count}}</td>
<td class="center">{{$record->item}}</td>
<td class="center">{{$record->site}}</td>
@if(searchByCodeLocation()=="true")
<td class="center">{{$record->location}}</td>
@endif
<td class="center">{{$record->measure_unit}}</td>
@if(systemConfig()[4] == 1)
<td class="center">{{$record->bundl}}</td>
  @endif
  @if(getOtherMeasure()=="true")
  <td class="center">{{$record->other_measure}}</td>
  @endif
  @if(getOtherMeasure2()=="true")
  <td class="center">{{$record->other_measure2}}</td>
  @endif
  <td class="center">{{$record->quatity}}</td>
  @if(systemConfig()[30] == 1)
  <td class="center">{{myRound(($record->cost*$info->static_rate / $info->rate))}}</td>
  <td class="center">{{myRound((($record->cost*$record->quatity)* $info->static_rate / $info->rate))}}</td>
  @else 
  <td class="center">{{myRound(($record->cost*$info->rate))}}</td>
  <td class="center">{{myRound((($record->cost*$record->quatity)*$info->rate))}}</td>
  @endif

</tr>
@endforeach

</table>

<?php
$count = 0;
?>

@if(count($saleOrderService)>0)
<br>
<table class="main-table">
  <tr class="bg">
    <th>@lang('layout.Record') </th>
    <th>@lang('layout.ServiceName')</th>
    <th>@lang('layout.MeasureUnit')</th>
    <th>@lang('layout.Quantity')</th>
    <th>@lang('layout.Price')</th>
    <th>@lang('layout.TotalAmount')</th>
  </tr>
  @foreach($saleOrderService AS $service)
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$service->item}}</td>
    <td class="center">{{$service->measure_unit}}</td>
    <td class="center">{{$service->qty}}</td>
    <td class="center">{{myRound($service->price)}}</td> 
    <td class="center">{{myRound((($service->price*$service->qty)*$info->rate))}}</td> 
  </tr>
  @endforeach
</table>
@endif
<br>
<table class="main-table">
<tr>
  <td class="center" colspan="2">@lang('layout.Total')</td>
  <td class="center" colspan="5">{{$total}}&nbsp;{{$info->currency}}</td>
</tr> 
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection