@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')
    <style> 
    </style>
@stop
@section('content')
    @include("layouts.Cmodal")

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateSalesOrder') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'salesOrder.store','method' => 'POST','class' => 'form-horizontal','id'=>'sales-form'])}}
                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                            <!-- begin inputs -->
                            <div class="row">
                                <div class="row" style="margin-right: 2px">

                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="form-group">

                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.SaleArea')</label>

                                                <v-select label="name" :options="saleArea"
                                                          v-model="selected_area"></v-select>
                                                <input type="hidden" name="sale_area_id"
                                                       :value="!selected_area?null:selected_area.id">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12"
                                         v-show="showWhat('member_class')=='yes'">
                                        <div class="form-group">

                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.MemberClass')</label>

                                                <v-select label="name" :options="memberClass"
                                                          v-model="selected_class"
                                                          @input="memberClassChange()"></v-select>
                                                <input type="hidden" name="class_id"
                                                       :value="!selected_class?null:selected_class.id">
                                            </div>
                                        </div>
                                    </div>

                                    @if(getShwoPriceLevel()=="general")
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <div class="form-group">

                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.PriceLevel') </label>

                                                <v-select label="name" :options="priceLevel" v-model="selected_priceLevel" @input="changePriceLevel()">
                                                </v-select>
                                                <input type="hidden" name="price_level_id" :value="!selected_priceLevel?null:selected_priceLevel.id">
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                    
                                    @if(getShwoPriceLevel()=="general_percent")
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <div class="form-group">

                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.PriceLevel') </label>
                                                <v-select label="name" :options="priceLevelGeneral" v-model="selected_priceLevelGeneral" @input="change_sale_rate_by_price_level_general()">
                                                </v-select>
                                                <input type="hidden" name="price_level_id" :value="!selected_priceLevelGeneral?null:selected_priceLevelGeneral.id">
                                            </div>
                                        </div>
                                    </div>
                                    @endif

                                </div>


                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Customer')</label>

                                            <div class="input-group">
                                                <v-select label="name" @input="memberChange()" :options="customer" @search="MemberSearch"  v-model="selected_customer"></v-select>
                                                <input type="hidden" name="customer" :value="!selected_customer?null:selected_customer.id" required>

                                                <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                    <i class="fa fa-plus" style="color: white"></i>
                                                </span> 
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Number')</label>
                                            <input type="number" name="number" value="{{$number}}" class="form-control">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.SaleCode')</label>
                                            <input type="text" name="sale_code" class="form-control">
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="row">

                                <div class="{{ auth()->user()->company()->first()->tag != 1 ?'col-lg-3 col-md-3':'col-lg-4 col-md-4' }} col-sm-12 col-xs-12">
                                    <div class="form-group"> 
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Currency')</label> 
                                            <v-select label="code" @input="selectedRate" :options="setRates"
                                                      v-model="selected_currency"></v-select>
                                            <input type="hidden" name="currency" :value="selected_currency.code"> 
                                        </div>
                                    </div>
                                </div>

                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-lg-3 col-md-3' : 'col-lg-4 col-md-4' }} col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Rate')</label>

                                            <input type="number" name="currency_rate" name="rate"
                                                   v-model="!selected_currency?0:selected_currency.rate"
                                                   class="form-control" :class="{'has-error':rate<=0}">
                                        </div>
                                    </div>
                                </div>

                                @if(auth()->user()->company()->first()->tag != 1)
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.ExchangeRateHQ')</label>

                                                <input type="number" name="currency_rate_hq"
                                                       v-model="!selected_currency?0:selected_currency.hq_rate"
                                                       class="form-control" :class="{'has-error':rate<=0}">
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-lg-3 col-md-3' : 'col-lg-4 col-md-4' }}  col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Discount')</label>

                                            <div class="input-group">

                                                <input v-model="discountFiled" class="form-control"
                                                       type="number" min="0" max="100">
                                                <span v-if="discountIsAmount"
                                                      @click="discountIsAmount = !discountIsAmount"
                                                      class="input-group-addon">@{{selected_currency.symbol}}
                                              <input type="hidden" class="input-group-addon" name="discount_type"
                                                     value="currency">
                                          </span>
                                                <span v-else @click="discountIsAmount = !discountIsAmount"
                                                      class="input-group-addon">%
                                              <input type="hidden" name="discount_type" value="percent">
                                          </span>
                                                <input type="hidden" name="discountTotal" :value="discount">
                                                <input type="hidden" name="discount" :value="discountFiled">
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                            <!--     <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Account')</label>
        
                                       <v-select  label="name"  :options="approperiateBank" v-model="selected_banks"></v-select>
                                       <input type="hidden" name="bank_account" :value="(this.selected_banks==null)?null:selected_banks.id">
                                  </div>
                              </div> 
                          </div> -->

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.DeliveryDate')</label>

                                            <input type="text" name="delivery_date" class="form-control date"
                                                   autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="description" class="form-control" rows="1"></textarea>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>

                                            <input type="text" name="date" class="form-control date" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                 <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Category')</label>

                                            <select name="category" class="form-control">
                                                <option value="">@lang('layout.Select')</option>
                                                <option selected value="saleOrder">@lang('layout.SaleOrder')</option>
                                                <option value="itemLend">@lang('layout.ItemLend')</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end inputs -->
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                            <!-- begin total -->
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') :</small>
                                        </td>
                                        <td class="text-right"><span data-counter="counterup"
                                                                     data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Discount'): (@{{
                                                Number.parseFloat(discount).toFixed(precision()) }}%)
                                            </small>
                                        </td>
                                        <td class="text-right">
                               <span class="text-right" data-counter="counterup"
                                     data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td>
                                            <small>@lang('layout.Sub-Total'):</small>
                                        </td>
                                        <td class="text-right">
                              <span class="text-right" data-counter="counterup"
                                    data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>@lang('layout.TotalQuantity'):</small>
                                        </td>
                                        <td class="text-right">
                                            <span class="text-right" data-counter="counterup" data-value="7800">@{{ subtotalQty }}</span>
                                            <small class="font-green-sharp">

                                            </small>
                                        </td>
                                    </tr>

                                </table>
                            </div>

                            <!-- end total -->
                        </div>

                    </div>

                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        @if(systemConfig()[23] == 1)
                        <table id="table_content" class="table table-bordered table-advance">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                @if(searchByCodeLocation()=="true")
                                <th style="min-width: 110px;">@lang('layout.Location')</th>
                                @endif
                                @if(getSerailNumber() =="true")
                                <th style="min-width: 100px">@lang('layout.SerialNum') </th>
                                @endif
                                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                <th style="min-width: 50px">@lang('layout.Quantity') </th>
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 50px">@lang('layout.OMeasureValue1')
                                </th>
                                <th v-show="showWhat('other_measure2')=='yes'"
                                    style="min-width: 50px">@lang('layout.OMeasureValue2')
                                </th>
                                @if(systemConfig()[4] == 1)
                                <th style="min-width: 50px">@lang('layout.Bundl') </th>
                                @endif
                                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                @if(systemConfig()[4] == 1)
                                <th style="min-width: 50px">@lang('layout.TotalCode') </th>
                                @endif
                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                <th style="min-width: 50px">@lang('layout.Cost') </th>
                                <th style="min-width: 50px">@lang('layout.SalePrice') </th>
                                <th v-show="showWhat('sale_discount')=='yes'"
                                                            style="min-width: 50px">@lang('layout.Discount') </th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                @if(auth()->user()->company()->first()->tag != 1)
                                    <th style="min-width: 100px">@lang('layout.TotalHQ') </th>
                                @endif
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                <td v-show="showWhat('sale_category')=='yes'">
                                    <v-select label="name" v-model="item.item_category" :options="inventory_category"
                                              @input="itemCategoryChange(index)"></v-select>
                                    <input type="hidden" name="inventory_category_id[]"
                                           :value="(!item.item_category)?null:item.item_category.id">
                                </td>
                                <td class="highlight">
                                    <v-select label="name" v-model="item.inventory" :options="temp_items"
                                    @input="(editKey)?onItemload(index):''"
											@keyup.native="editKey = true"
											  @click.native="editKey = true, addNew('inventory',index)"
											  @search="onItemSearch"></v-select>
                                    <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                </td>
                                @if(searchByCodeLocation()=="true")
                                <td class="highlight">
                                    <v-select label="name" @Click.native="setIndex(index)" @input="locationItemload(index)" v-model="item.location" :options="(item.item==null)?[]:item.item.locationList" @search="locationSearch" ></v-select>
                                    <input type="hidden" :name="'location['+index+']'" v-validate="''" data-vv-as="@lang('layout.Location')" :value="(!item.location)?null:item.location.name">
                                </td>
                                @endif
                                @if(getSerailNumber() =="true")
                                <td>
                                    @{{(!item.item)?null:item.item.number}}
                                </td>
                                @endif
                                <td class="highlight">
                                    <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                  :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                    </select>

                                    <input type="hidden" name="inventory_site[]"
                                           :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                </td>
                                <td v-show="showWhat('sale_description')=='yes'">
                                    <input type="text" placeholder="@lang('layout.Description')"
                                    oninput = "autowidths(event)"
                                           name="inventory_description[]" class="form-control chan_length">
                                </td>

                                <td>
                                    <input type="number" name="inventory_quantity[]"
                                           v-model.number="(item.item==null)?null:item.item.quantity"
                                           oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.Quantity')">
                                </td>

                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" name="other_measure_amount[]"
                                    oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.OMeasureValue1')">
                                </td>
                                <td v-show="showWhat('other_measure2')=='yes'">
                                    <input type="number" name="other_measure_amount2[]"
                                    oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.OMeasureValue2')">
                                </td>
                                @if(systemConfig()[4] == 1)
                                <td>
                                    <input type="number" name="bundl[]"
                                    oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.Bundl')">
                                </td>
                                @endif
                                <td>
                                <!--    <input type="text" :value="(item.item==null)?null:saleItemQuantity(item.item,item.item.quantity)" class="form-control input-number" placeholder="@lang('layout.OnHand')"> -->
                                    @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                </td>
                                @if(systemConfig()[4] == 1)
                                <td>
                                @{{(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qut_in)}}
                                </td>
                                @endif
                                <td class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                              <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>


                                    </select>

                                    <input type="hidden" name="inventory_measure[]"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
                                @if(systemConfig()[30] == 1)
                                <td>
                                    @{{(item.item==null)? 0:myRound((item.item.cost * item.item.measure.measure_unit / item.item.measure_unit) * selected_currency.static_rate / selected_currency.rate)}}
                                    @{{selected_currency.symbol}}
                                </td>
                                @else 
                                <td>
                                    @{{(item.item==null)? 0:myRound((item.item.cost * item.item.measure.measure_unit / item.item.measure_unit) *selected_currency.rate)}}
                                    @{{selected_currency.symbol}}
                                </td>
                                @endif

                                <td>
                                    <div class="input-group">
                                        <input type="number" name="inventory_price[]" placeholder="@lang('layout.SalePrice')"
                                               :value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)"
                                               oninput = "autowidths(event)"
                                               ref="in" @input="setNewRate('inventory',index)" class="form-control chan_length">
                                        <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>

                                </td>
                                <td v-show="showWhat('sale_discount')=='yes'">
                                    <div class="input-group">
                                        <input type="number" name="inventory_discount[]"
                                               placeholder="@lang('layout.Discount')"
                                               v-model.number="(item.item==null)?null:item.item.discount"
                                               oninput = "autowidths(event)"
                                               class="form-control chan_length">
                                        <span class="input-group-addon" v-if="discountIsAmount">
                                      @{{selected_currency.symbol}}
                                    </span>
                                        <span class="input-group-addon"
                                              v-if="!discountIsAmount">
                                      %
                                    </span>

                                    </div>

                                </td>
                                <td>

                                    @{{ (item.item==null)?null:getItemTotal(item.item,selected_currency.rate, null, null,  selected_currency.hq_rate, null, null, selected_currency.static_rate).result }}
                                    @{{selected_currency.symbol}}
                                </td>
                                @if(auth()->user()->company()->first()->tag != 1)
                                    <td>
                                        @{{ (item.item==null)?null:getItemTotal(item.item,selected_currency.rate, null, null,  selected_currency.hq_rate, null, null, selected_currency.static_rate).resultHQ }}
                                        @{{selected_currency.symbol}}
                                    </td>
                                @endif
                                <td>
                                    <span v-on:click="deleteItem('inventory',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        @endif

                        <hr>
                        @if(systemConfig()[26] == 1)
                        <!-- begin service -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>

                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                               @if(auth()->user()->company()->first()->tag != 1)
                                    <th class="text-center" style="min-width: 120px;">@lang('layout.TotalHQ')</th>
                               @endif
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(service,index) in services">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="service.item" :options="(service.items)"
                                              @click.native="addNew('service',index)"
                                              @input="checkExistingService(index)"> 
                                    </v-select>
                                    <input type="hidden" name="service_id[]"
                                           :value="(service.item==null)?null:service.item.id">
                                </td>

                                <td>
                                    <input class="form-control" name="service_quantity[]"
                                           v-model.number="(!service.item)?null:service.item.quantity"
                                           placeholder="@lang('layout.Quantity')">
                                </td>
                                <td class="highlight">
                                    <select v-model="(service.item == null)?null:service.item.measure"
                                            class="form-control" @change="measureChangeservice(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(service.item ==null)?false:true">
                                              <option v-for="measure in (service.item==null)?null:service.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>

                                    </select>

                                    <input type="hidden" name="service_measure[]"
                                           :value="(service.item==null)?null:service.item.measure.measure_id">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="service_price[]" placeholder="@lang('layout.Cost')"
                                               :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate, null, selected_currency.static_rate)"
                                               ref="ser" @input="setNewRate('service',index)" class="form-control">
                                        <span class="input-group-addon">
                                          @{{selected_currency.symbol}}
                                        </span>
                                    </div>

                                </td>
                                <td>
                                    @{{ (service.item==null)?null:getItemTotalService(service.item,selected_currency.rate,selected_currency.hq_rate, selected_currency.static_rate).result }}
                                    <b>@{{selected_currency.symbol}}</b>
                                </td>
                                @if(auth()->user()->company()->first()->tag != 1)
                                    <td>
                                        @{{ (service.item==null)?null:getItemTotalService(service.item,selected_currency.rate,selected_currency.hq_rate, selected_currency.static_rate).resultHQ }}
                                        <b>@{{selected_currency.symbol}}</b>
                                    </td>
                                @endif
                                <td>
                                    <span v-on:click="deleteItem('service',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <!-- end service -->
                        @endif

                        {{-- this is for the Sale Percentage................................................................... --}}
                        <hr>
                         <!-- begin service -->
                        <h3 style="margin-bottom: 20px;"> @lang('layout.PercentageList') </h3>
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.FromPercentage')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ToPercentage')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>
 
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(percentage,index) in percentages">
                                <td>@{{index+1}}</td>
                                <td>
                                    <input class="form-control" name="from_percentage[]"         
                                    placeholder="@lang('layout.FromPercentage')"
                                    @click="addNew('percentage',index)">
                                </td> 
                                <td>
                                    <input class="form-control" name="to_percentage[]" 
                                    placeholder="@lang('layout.ToPercentage')">
                                </td> 
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="amount_percentage[]" placeholder="@lang('layout.Amount')"
                                               ref="ser" class="form-control">
                                        <span class="input-group-addon">
                                          @{{selected_currency.symbol}}
                                        </span>
                                    </div>

                                </td>
                                <td>
                                    <span v-on:click="deleteItem('percentage',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                              
                            </tr>
                            </tbody>
                        </table>
                         {{-- End of This routes for Sale Percentage ............................................................. --}}

                         
                        <!-- begin payments -->
                        @permission('receive-create')
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                @if(auth()->user()->company()->first()->tag != 1)
                                    <th class="text-center" style="min-width: 120px;">@lang('layout.TotalHQ')</th>
                                @endif
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(payment,index) in payments">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="payment.item" :options="(payment.items)"
                                              @click.native="addNew('payment',index)"
                                              @input="checkExistingPayment(index)"
                                              >

                                    </v-select>
                                    <input type="hidden" v-if="payment.item !=null" name="payment_id[]"
                                           :value="(payment.item==null)?null:payment.item.id">
                                </td>

                                <td>
                                 
                                      <span v-if="payment.item !=null">
                                        @{{myRound(Number((payment.item==null)?null:payment.item.balance)+Number((payment.item==null)?null:payment.item.amount))}}
                                      </span>
                                </td>
                                <td>
                                    <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                           type="number" v-model.number="(payment.item==null)?null:payment.item.rate "
                                           class="form-control"
                                           placeholder="@lang('layout.Rate')"/>
                                    <input v-if="payment.item !=null" type="hidden" name="payment_rate[]"
                                           v-bind:value="payment.item.rate">
                                    <input v-if="payment.item !=null" type="hidden" name="payment_rate_hq[]"
                                           v-bind:value="payment.item.hq_rate">
                                </td>
                                <td>
                                    <input type="text" name="payment_currency[]" class="form-control"
                                           v-model="(payment.item==null)?null:payment.item.code"
                                           placeholder="@lang('layout.Currency')" disabled reqiured/>

                                    <input v-if="payment.item !==null" type="hidden" name="payment_currency[]"
                                           v-bind:value="payment.item.code"/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               v-model.number="(payment.item==null)?null:payment.item.amount "
                                               placeholder="@lang('layout.PayAmount')"/>

                                        <input v-if="payment.item !=null" type="hidden" name="payment_amount[]"
                                               v-bind:value="payment.item.amount">

                                        <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate, null, selected_currency.static_rate).result"
                                               placeholder="@lang('layout.Total')" style="min-width: 100px"/>
                                        <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                    </div>
                                </td>
                                @if(auth()->user()->company()->first()->tag != 1)
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate,selected_currency.hq_rate, selected_currency.static_rate).resultHQ"
                                               placeholder="@lang('layout.Total')" style="min-width: 100px"/>
                                        <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                    </div>
                                </td>
                                @endif
                                <td>
                                    <span v-on:click="deleteItem('payment',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>

                        </table>
                        @endpermission
                        <!-- end payments -->


                    </div>
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Memo')</label>
                                    <textarea name="memo" class="form-control" rows="2"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" v-if="!isError" @click="submitForm"class="btn green">@lang('layout.Submit')</button>
                    <button type="button" class="btn blue" @click="saveAndNew($event)" v-if="!isError" >@lang('layout.SaveAndNew')</button>
                    <a href="{{route('salesOrder.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">

                </cmodal>
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


<script type="text/javascript">
    @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);
        Vue.use(VueInputAutowidth);

        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    types: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectReceive: null,
                    classes: [],
                    selectedClass: null,
                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Customer") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if(this.receivables.length>0)
                        {
                            this.selectReceive=this.receivables[0];
                        }
                        if(this.payables.length>0)
                        {
                            this.selectPay=this.payables[0];
                        }

                    }).catch(error => console.log(error));
            },
            methods: {
              

                onSubmit() {

                    v.showModal = false;
                    var datas = $("#modalForm").serializeArray();

                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        if (response) {
                            v.selected_customer = response.customer;
                        }
                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });

        var currency ={!! $currency !!};
        var banks = {!! $banks !!};
        var all_services = {!! $all_services !!};
        var inventoryCategory = {!! $inventoryCategory !!};
        var saleArea = {!! $saleArea !!};

        var priceLevel = {!!$priceLevel!!};
        var priceLevelGeneral = {!!$priceLevelGeneral!!};

        let homeCurrency = {!! $home !!};
        let ratesFetched = {!! $rates !!};
        var memberClass= {!! $memberClass !!};

        var v = new Vue({
            el: '#app',
            data: {
                showModal: false,
                priceLevel: priceLevel,
                selected_priceLevel: null,
                priceLevelGeneral: priceLevelGeneral,
                selected_priceLevelGeneral: null,
                all_customer: [],
                customer: [],
                selected_customer: null,
                banks: banks,
                all_services: all_services,
                selected_banks: null,
                currency: currency,
                selected_currency: {!!json_encode(getHomeCurrency()) !!},
                rate: 0,
                discountFiled: 0,
                discountIsAmount: false,
                editKey: false,
                temp_items: [],
                totalAmountes: [],
                newCost: [
                    null,
                    null,
                    null,
                    null],
                inventories: [
                    {item: null, location: null, item_category: null},
                    {item: null, location: null, item_category: null},
                    {item: null, location: null, item_category: null},
                    {item: null, location: null, item_category: null},
                ],
                services: [
                    {
                        items: all_services,
                        item: null,
                    },
                    {
                        items: all_services,
                        item: null,
                    },
                ],
                payments: [
                    {
                        items: banks,
                        item: null,
                    }
                ],
                percentages: [
                    {
                        item: null
                    }
                ],

                inventory_category: inventoryCategory,
                selected_index: 0,
                saleArea: saleArea,
                selected_area: null,
                memberClass:memberClass,
                selected_class:null
            },
            computed: {
                setRates(){

                    let rates = [];
                    this.currency.forEach((b)=>{
                        ratesFetched.forEach((a)=>{

                            if(a.currency_id == b.id){
                                rates.push({
                                    name: a.name,
                                    code:a.code,
                                    symbol: a.symbol,
                                    static_rate: a.static_rate,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null? Number.parseFloat(a.hq_rate) : 1,
                                    currency:b.id,
                                    id: b.id
                                });
                            }
                        })
                    });

                    this.currency.forEach((a)=>{
                        let found = false;
                        rates.forEach((b)=>{
                            if(a.id == b.id){
                                found = true;
                                return;
                            }
                        });

                        if(!found){
                            rates.push({
                                name: a.name,
                                code:a.code,
                                symbol: a.symbol,
                                static_rate: a.static_rate,
                                rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency:a.id,
                                id: a.id
                            })
                        }
                    });
                    this.banks =[];

                    banks.forEach((a)=>{
                        rates.forEach((r)=>{
                            if(a.code == r.code){
                                this.banks.push({
                                    amount: a.amount,
                                    static_rate: a.static_rate,
                                    balance: a.balance,
                                    code: a.code,
                                    id: a.id,
                                    name: a.name,
                                    rate: r.rate,
                                    hq_rate: r.hq_rate
                                })
                            }
                        });
                    });

                    return rates;

                },
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                            }
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
                            }

                        }

                    }
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item && this.services[i].item != null) {
                            var rate = this.services[i]['item']['rate'];
                            var new_rate = this.services[i]['item']['new_rate'];
                            var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.services[i]['item']['measure_unit'];
                            var quantity = this.services[i]['item']['quantity'];
                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                            }
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
                            } 
                        }
                    }
                    return sum;
                },

                // check payed amount
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                //
                                @if(systemConfig()[30] == 1)
                                sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                                @endif
                            }
                        }
                    }
                    return sum;
                },
 

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    for (var i = 0; i < this.inventories.length; i++) {

                        if (this.inventories[i].item) {
                            flag = true;
                            if (((this.inventories[i]['item']['rate'] <= 0))) {
                                rate = this.inventories[i]['item']['rate'];
                                new_rate = this.inventories[i]['item']['new_rate'];
                                if (rate <= 0 && new_rate <= 0) {
                                    isError = true;
                                }

                            }
                        }
                    }
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item && this.services[i].item != null) {
                            flag = true;
                        }
                    }
                    if (this.inventories.length == 0 || this.selected_customer == undefined || this.selected_customer == null || flag == false) {
                        isError = true;
                    }
                    return isError;


                },
                // filter the banks according to selected currency
                approperiateBank: function () {
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },

                // calculate subtotalQty
                subtotalQty: function() {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item) {
                            if (this.inventories[i].item != null) {
                                var quantity = this.inventories[i]['item']['quantity'];
                                if (quantity > 0) {
                                    sum += Number.parseFloat(quantity);
                                }
                            }
                        }

                    }

                    return sum;
                },

            },
            methods:
                {
                
                    selectMemeber(id = null) {
                        if (id) {
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchMember',
                                    id: id,
                                    type: 'Customer'
                                }
                            })
                            .then(function(response) {
                                if (response.data) {
                                    // console.log(response.data);
                                    v.selected_customer = null;
                                    v.selected_customer = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }
                    },
                    memberClassChange() {
                        if (v.selected_class) {
                            v.customer = [];
                            // v.selected_customer = null;
                            let class_id = v.selected_class.id;
                        
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchMember',
                                    class_id: class_id,
                                    type: 'Customer'
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    // console.log(response.data);
                                    v.customer = [];
                                    v.customer = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }
                    },
                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                class_id: class_id,
                                type: 'Customer'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.customer = [];
                                v.customer = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    changePriceLevel() {
                        this.inventories = [];
                        this.inventories.push({
                            item: null,
                            location: null,
                            item_category: null
                        });
                    },

                    // Change Item Sale Rate According Item Price Level
                    change_sale_rate_by_price_level_general() {
                        
                        if (this.inventories != null && this.selected_priceLevelGeneral) {
                            var price_type = this.selected_priceLevelGeneral.price_type;
                            var percent = Number.parseFloat(this.selected_priceLevelGeneral.percent);

                            for (var i = 0; i < this.inventories.length; i++) {
                                if (this.inventories[i].item && this.inventories[i].item != null) {
                                        var rate = this.inventories[i]['item']['rate'];
                                        var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                                        var measure_unit = this.inventories[i]['item']['measure_unit'];
                                        var rate1 = (rate * smeasure_unit / measure_unit);
                                        rate1 = Number.parseFloat(rate1);

                                        if(price_type == 'up' && percent > 0 && rate1 > 0){
                                            var result = Number.parseFloat((rate1 * percent) / 100);
                                            this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                                        } else if(price_type == 'down' && percent > 0 && rate1 > 0){
                                            var result = Number.parseFloat((rate1 * percent) / 100);
                                            this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                                        }  
                                }
                            }
                        }
                    },

                    setIndex(e) {
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {
                        v.setIndex(index);
                        let inventory_category_id = this.inventories[this.selected_index]['item_category'].id;
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchNameBoot',
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                    },

                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },

                    // calculate item price based on measure change
                    measureChangeservice(index) {

                        if (this.services[index].item != null) {
                            var item = this.services[index].item;
                            @if(systemConfig()[30] == 1)
                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                            @endif
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.services[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    // detect member change and searh
                    memberChange() {
                        if (this.selected_customer) {
                            // get member contract
                            this.contractSearch(this.selected_customer.id, this);

                            @if(getShwoPriceLevel()=="general_percent")
                            var price_level_id = this.selected_customer.price_level_id;
                            // console.log(22,price_level_id);
                            if(price_level_id){
                                this.selected_priceLevelGeneral = _.find(this.priceLevelGeneral, (s) => s.id == price_level_id);
                            }else{
                                this.selected_priceLevelGeneral = null;
                            }
                            @endif

                        }
                    },
                    // set new price
                    setNewRate(type = null, index) {
                        if (type == 'inventory') {
                            if (this.inventories[index].item) {
                                @if(systemConfig()[30] == 1)
                                this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                                @endif
                            }
                        }
                        if (type == 'service') {
                            if (this.services[index].item) {
                                @if(systemConfig()[30] == 1)
                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                                @endif
                            }
                        }


                    },
                    // begin item search


                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSearchNameBoot',
                                keyword: search,
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),

                    // end item search
					
                    onItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].inventory != null) {
                            // console.log('klk',v.inventories[index].inventory,v.inventories);
                            var inventory_id = v.inventories[index].inventory.id;
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                            let price_level_id = (this.selected_priceLevel) ? this.selected_priceLevel.id : '';
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSaleBoot',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                    price_level_id: price_level_id,
                                }
                            })
                            .then(function (response) {
                                v.inventories[index].item = null;
                                if (response.data.length > 0) {
                                    v.inventories[index].item = response.data[0];
                                    v.inventories[index].location = null;
                                    @if(getShwoPriceLevel()=="general_percent")
                                    setTimeout((function () {
                                        v.change_sale_rate_by_price_level_general();
                                    }), 400);
                                    @endif

                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                        }
                    },

                    locationSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_id = (v.inventories[v.selected_index]['item'] != undefined) ? v.inventories[v.selected_index]['item'].id : '';
                        // console.log(3333, v.inventories, v.selected_index, inventory_id, search);
                        if (inventory_id) {
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemesSearchLocation',
                                    keyword: search,
                                    inventory_id: inventory_id
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    v.inventories[v.selected_index]['item']['locationList'] = response.data;
                                }
                                loading(false);
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        } else {
                            loading(false);
                        }
                    }, getDebounceTime()),

                    locationItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].item != null && v.inventories[index].location != null) {
                            var inventory_id = v.inventories[index].item.id;
                            var location = v.inventories[index].location.name;

                            axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        method_name: 'itemSiteByLocation',
                                        inventory_id: inventory_id,
                                        location: location
                                    }
                                })
                                .then(function(response) {
                                    // console.log(4444, response.data);
                                    if (response.data.item.length > 0) {
                                        v.inventories[index].item.site_list = response.data.item;
                                        v.inventories[index].item.site = response.data.selectItem;
                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                })
                        }
                    },

                    // contract search
                    contractSearch(id, vm) {
                        vm.contract = [];
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'member_contract',
                                member_id: id
                            }
                        })
                            .then(function (response) {
                                if (response.data.length > 0) {
                                    vm.contract = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    },
                    // end contract search

                    // generic function for adding item to list
                    addNew(type = null, index) {

                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, location: null, item_category: null});
                                }
                            }
                            if (type == 'service') {
                                if (this.services[index + 1] == undefined) {
                                    this.checkExistingService(index, '');
                                    this.services.push({
                                        items: this.all_services,
                                        item: null,
                                    });
                                }
                            }
                            
                            // if (type == 'percentages') {
                            //     if (this.inventories[index + 1] == undefined) {
                            //         this.temp_items = [];
                            //         this.inventories.push({item: null, location: null, item_category: null});
                            //     }
                            // }

                            if (type == 'percentage') {
                                if (this.percentages[index + 1] == undefined) {
                                    this.percentages.push({item: null});
                                }
                            }


                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;

                    },

                    // in here you can check and decide to allow duplicate service or not
                    checkExistingService(index = null, name = '') {
                        var service_temp = this.all_services.slice();
                        var service_temp1 = [];
                        for (var i = 0; i < this.services.length; i++) {
                            if (this.services[i].item != null) {
                                var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                                if (fined != -1) {
                                    var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                                }
                            }
                        }
                        this.services[index].items = service_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp; 
                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'service') {
                                this.services.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                            if (type == 'percentage') {
                                this.percentages.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("sales-form").submit()

                            }
                            else {

                            }
                        });

                    },

                    saveAndNew()
                    {
                        this.$validator.validate()
                        .then(valid =>{
                            if(valid)
                            {
                                
                                var url="{{route('salesOrder.store')}}";
                                form_id='sales-form';
                                var data= $('#'+form_id).serialize();
                                // console.log(444, data);
                                toggleBlock(true);
                                axios.post(url,data)
                                .then(function(response){
                                        toggleBlock(0);
                                        if(response.data.result==1)
                                        {
                                            $('#'+form_id).trigger('reset');
                                            
                                            toastr.success('',response.data.message); 
                                            location.reload();
                                        
                                        }
                                        else
                                        {
                                            var message="{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('',message);
                                        }
                                })
                                .catch(function(error){
                                toggleBlock(0);
                                    console.log(error);
                                    var message="{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('',message);
                                });
                            
                            }
                        })
                    },

                },
            created: function () {

            }

        });

    </script>


@endpush