@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.Details') @lang('layout.Gift')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>
                            <i class="fa  fa-bars"></i> @lang('layout.Number')
                        </th>

                        <th>
                            <i class="fa fa-code"></i> @lang('layout.ItemName')
                        </th>
                        <th>
                            <i class="fa fa-file-excel-o"></i> @lang('layout.Gift')
                        </th>
                        <th>
                            <i class="fa  fa-bars"></i> @lang('layout.Date')
                        </th>

                        <th>
                            <i class="fa fa-code"></i> @lang('layout.Description')
                        </th>
                        <th>
                            <i class="fa fa-file-excel-o"></i> @lang('layout.User')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>  {{$salesGift->number}} </td>
                        <td> {{$salesGift->name}}  </td>
                        <td>  {{$salesGift->item_gift}} </td>
                        <td>  {{convertDate($salesGift->date)}} </td>
                        <td> {{$salesGift->description}}  </td>
                        <td>  {{$salesGift->user_name}} </td>

                    </tr>
                   
                    </tbody>
                </table>
            </div>
        </div>
       
    </div>
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.Details') </span>
                    </div>
                    <div class="tools"></div>

                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="salesGiftDetails">
                        <thead>
                        <tr> 
                            <th>@lang('layout.From')</th>
                            <th>@lang('layout.To')</th>
                            <th>@lang('layout.Quantity') @lang('layout.Gift')</th>
                        </tr>
                        </thead>
                    </table> 
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
@push('scripts') 
    <script>
        $(document).ready(function () { 
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#salesGiftDetails').DataTable({
                ajax: '{{route("salesGift.show",$salesGift->id)}}',
                period: 'CustomDates',
                scrollCollapse: true,
                is_show: false,
                serverSide: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                pageLength: '{{getPageRows()}}',


                columns: [
                    {data: 'from_count', name: 'from_count'},
                    {data: 'to_count', name: 'to_count'},
                    {data: 'quantity', name: 'quantity'}
                ]  
            });
        });
    </script> 

@endpush
