@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.SalesGifCreate')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;" v-cloak>
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'SaleGiftDetails.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-10 col-md-10 col-sm-12 col-xs-12">
                            {{-- <p style="color:red">@lang('layout.Note'): @lang('layout.SaleGiftDetailsNote')</p> --}}

                            <div class="col-md-3"> 
                                <label class="control-label">@lang('layout.Number'):</label>
                                <input type="text" name="number" value="{{$number}}" class="form-control" autocomplete="off">
                            </div>

                            <div class="col-md-3">
                                <label for=""> @lang('layout.Date') </label>
                                <input type="text" value="@if(autoSelectDate()=='true'){!! getDropdownDate('invoice', 'date') !!}@endif" @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif
                                name="date" class="form-control date now" autocomplete="off">
                            </div>
    
                            <div class="col-md-3">
                                  <label class="control-label"> @lang('layout.ItemName')</label>
                                    <v-select label="name" v-model="selected_item" :options="items" @search="onItemSearch"></v-select>
                                    <input type="hidden" name="item" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(!selected_item)?null:selected_item.id">
                                  <span class="required">@{{ errors.first('item') }}</span>
                              </div>
 
                            <div class="col-md-3">
                                  <label class="control-label"> @lang('layout.ItemGift')</label>
                                    <v-select label="name" v-model="selected_item_gift" :options="itemsGift" @search="onItemSearchGift"></v-select>
                                    <input type="hidden" name="item_gift_id" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(!selected_item_gift)?null:selected_item_gift.id">
                                  <span class="required">@{{ errors.first('item') }}</span>
                              </div>
 
                              

                            <div class="col-md-12" style="margin-bottom: 20px;">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Description')</label>
                                    <textarea name="description" class="form-control" rows="3"></textarea>
                                </div>
                            </div>
                        </div>
                        
                            <div style="margin-top: 50px !important">
                                <table id="table_content" class="table table-bordered">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th >@lang('layout.From') </th>
                                        <th >@lang('layout.To') </th>
                                        <th >@lang('layout.Quantity') </th>
                                        <th></th>

                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for="(item,index) in SaleGiftDetails">
                                        <td @click="addNew(index)">@{{index+1}}</td>
                                        <td @click="addNew(index)" class="highlight">
                                            <input type="number" 
                                                   name="from_quantity[]" class="form-control">
                                        </td>
                                        <td @click="addNew(index)" class="highlight">
                                            <input type="number" 
                                                   name="to_quantity[]" class="form-control">
                                        </td> 
                                         <td @click="addNew(index)" class="highlight">
                                            <input type="number" 
                                                   name="quantity[]" class="form-control">
                                        </td>  
                                        <td>
                                            <span v-on:click="deleteItem('index')"><i
                                             class="paddint-both glyphicon glyphicon-trash"></i></span>
                                        </td>

                                    </tr>
                                    </tbody>
                                </table> 
                                <button v-if="SaleGiftDetails.length<1" class="btn btn-info" @click="addNew(0)">+</button>
                            </div>
                        


                    </div>
                </div>
                <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button type="button" 
                        @click="handleSubmit($event)"
                        class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('salesGift.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
    <script type="text/javascript">

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);
  

        let v = new Vue({
            el: '#app',
            data: {
                items: [],
                selected_item: null,
                itemsGift: [],
                selected_item_gift: null,
                
                SaleGiftDetails:
                [
                    {from_amount: null, to_amount: null,tax:null,extra_amount:null},
                    {from_amount: null, to_amount: null,tax:null,extra_amount:null},

                ]
            },
            methods: {

                
                onItemSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                    method_name: 'itemesSearchSale',
                    'search_column': 'name',
                    'table_name': 'items',
                    keyword: search,
                    'formula': 'formula',
                    'limit_type': 'item'
                    }
                })
                .then(function(response) {
                    v.items = [];
                    if (response.data.length > 0) {
                    v.items = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    console.log(error);
                })
            }, getDebounceTime()),
 


                onItemSearchGift: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                    method_name: 'itemesSearchSale',
                    'search_column': 'name',
                    'table_name': 'items',
                    keyword: search,
                    'formula': 'formula',
                    'limit_type': 'item'
                    }
                })
                .then(function(response) {
                    v.items = [];
                    if (response.data.length > 0) {
                    v.itemsGift = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    console.log(error);
                })
            }, getDebounceTime()),






                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            v.submitForm(e.target.form);
                        }
                    });
                },
                 submitForm(form) {

                        
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                form.submit()

                            }
                            else {

                            }
                        });

                    },
                addNew(index) {
                    if (this.SaleGiftDetails[index + 1] == undefined) {
                        this.SaleGiftDetails.push({from_amount: null, to_amount: null,tax:null,extra_amount:null});
                    }

                },

                deleteItem(index) {
                    this.SaleGiftDetails.splice(index, 1);
                },
            }
        })
    </script>

@endpush
 