@extends('layouts.app')

@section('content')

 <div id="print-modal">

    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
        v-if="is_show" 
        :value-type="'Sale_Details'"
        @closed="closeModal">
        <div slot="body">
             <input type="hidden" name="id" value="{{$sale->sale_id}}"/>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                         <div class="tabbable tabbable-tabdrop">
                            <ul class="nav nav-tabs">
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                </li>
                                @if(systemConfig()[2] != 0 )
                                        @permission(['customreport-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                                @endpermission
                                @endif
                            </ul>
                            <div class="tab-content">
                                 <div class="tab-pane active" id="tab1"> 
                                        <div class="portlet light bordered">   
                                        </div>
                                </div>  
                                <div class="tab-pane" id="tab2"> 
                                   <div class="portlet light bordered">
                                        <div class="portlet-body">
                                            <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                @csrf
                                                <input type="hidden" name="part_name" value="sale_show">
                                                <div class="col-md-12 col-sm-12 col-xs-12">
                                                    <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                        <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                :checked="row.checkedColumn" >
                                                                                <span class="slider round"></span>
                                                                            </label>
                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                                <option value="10">10 %</option>
                                                                                <option value="15">15 %</option>
                                                                                <option value="20">20 %</option>
                                                                                <option value="25">25 %</option>
                                                                                <option value="30">30 %</option>
                                                                                <option value="40">40 %</option>
                                                                                <option value="50">50 %</option>
                                                                                <option value="60">60 %</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                             <!-- <label> @{{ row.Name }}</label>

                                                              <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                             <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                  <span class="slider round"></span>
                                                            </label> -->

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="margiv-top-10">
                                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                    <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                </div>
                                        </form>
                                        </div>
                                </div>
                        </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->

        </div>
    </report-modal>
</div>


    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.SalesInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th> 
                            <i class="fa  fa-bars"></i>@lang('layout.SalesNumber') 
                        </th>   
                        <th>
                            <i class="fa  fa-bars"></i>@lang('layout.ReferenceNumber') 
                        </th>
                        <th class="">
                            <i class="fa fa-text-width"></i>@lang('layout.Type')
                        </th>
                        <th class="">
                            <i class="fa fa-user"></i>  @lang('layout.Customer')
                        </th>
                        <th>
                            <i class="fa fa-file-excel-o"></i> @lang('layout.Account')
                        </th>
                         <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th>
                        <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Hour')
                        </th> 
                        <th>
                            <i class="fa  "></i> @lang('layout.Rate')
                        </th>
                          <th> 
                            <i class="fa "></i>@lang('layout.Amount') 
                        </th>
                         <th> 
                            <i class="fa "></i>@lang('layout.Discount') 
                        </th>
                        <th>
                            <i class="fa  "></i>@lang('layout.Currency') 
                        </th>
                        <th>
                            <i class="fa  "></i>@lang('layout.PaymentType') 
                        </th>
                    </tr> 
                    </thead>
                    <tbody>
                        <tr>  
                            <td class=""> {{ $sale->number}}  </td>
                            <td class=""> {{ $sale->ref_Number}}  </td>
                            <td class=""> {{ $sale->type }}  </td>
                            <td class=""> {{ $sale->member_name }}  </td>
                            <td class=""> {{ $sale->account_name}}  </td>
                            <td class=""> {{ convertDate($sale->date) }}  </td>
                            <td class=""> {{ $sale->hour}} </td>
                            <td class=""> {{ $sale->rate }}  </td>
                            <td class=""> {{ myRound($sale->amount) }}  </td>
                            <td class=""> {{ $sale->discount }}  </td>
                            <td class=""> {{ $sale->currency }}  </td>
                            @if($sale->payment_type == 'On')
                            <td class=""> @lang('layout.Paid')  </td>
                            @else
                            <td class=""> @lang('layout.NoPaid')  </td>
                            @endif
                        </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th width="">
                                <i class=" fa fa-text-width"></i> @lang('layout.OldCounter')
                            </th>
                            <th width="">
                                <i class=" fa fa-text-width"></i> @lang('layout.NewCounter')
                            </th>
                            <th width="">
                                <i class=" fa fa-text-width"></i> @lang('layout.Description')
                            </th>
                            <th width="">
                                <i class=" fa fa-text-width"></i> @lang('layout.Memo')
                            </th>
                            @if(showVendorInFactor() == 'true') 
                            <th>
                                <i class="fa  "></i> @lang('layout.VendorName')
                            </th>
                            @endif
                            @if($seeCost==true)
                            <th>
                                <i class="fa  fa-money"></i> @lang('layout.GrossProfit')
                            </th>
                            @endif
                            <th>
                                <i class="fa  "></i> @lang('layout.CustomerCheck')
                            </th>
                            @if(getSaleCommission()=="true")
                            <th>
                                <i class="fa  "></i> @lang('layout.Commission') @lang('layout.Percentage')%
                            </th>
                            @endif
                            
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class=" "> {{ $sale->old_oil_counter}}  </td>
                            <td class=" "> {{ $sale->new_oil_counter}}  </td>
                            <td class=" "> {{ $sale->description}}  </td>
                            <td class=" "> {{ $sale->memo}}  </td>
                            @if(showVendorInFactor() == 'true') 
                            <td class=" "> {{ $sale->vendor_name}}  </td>
                            @endif
                            @if($seeCost==true)
                            @if(systemConfig()[30] == 1)
                            <td class=""> {{ $grossProfit *$sale->static_rate / $sale->rate}}  </td>
                            @else 
                            <td class=""> {{ $sale->rate*$grossProfit }}  </td>
                            @endif
                            @endif
                            @if($sale->customer_status)
                            <td class=""> @lang('layout.checked') </td>
                            @else 
                            <td class=""> </td>
                            @endif
                            @if(getSaleCommission()=="true")
                            <td class=""> {{$sale->commission_percent}}  </td>
                            @endif
    
                           
                        </tr>
                    </tbody>
                </table>
            </div>
            @if(getDriverInfo() == "true")
            <div class="table-scrollable">
                <h4>@lang('layout.DriverInfo')</h4>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th class="">
                            <i class="fa fa-bars"></i> @lang('layout.TransferCode')
                        </th>
                        <th class="">
                            <i class="fa fa-user"></i> @lang('layout.Transporter_name')
                        </th>
                        <th>
                            <i class="fa fa-file-excel-o"></i> @lang('layout.Transporter_phone')
                        </th>
                        <th>
                            <i class="fa fa-text-width"></i> @lang('layout.PlaceOfWeight')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.SourcePlace')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.PlateNumber')
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.WayBillNumber')
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.TotalWeight')
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.EmptyCarWeight')
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.TotalBori')
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.Description')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                        <td class=""> {{$sale->transferCode }}  </td>
                        <td class=""> {{$sale->driver}}  </td>
                        <td class=""> {{$sale->driverPhone}}  </td>
                        <td class=""> {{$sale->PlaceOfWeight}}  </td>
                        <td class=""> {{$sale->sourcePlace }}  </td>
                        <td class=""> {{$sale->plateNumber }}  </td>
                        <td class=""> {{$sale->wayBillNumber }}  </td>
                        <td class=""> {{$sale->totalWeight }}  </td>
                        <td class=""> {{$sale->emptyCarWeight }}  </td>
                        <td class=""> {{$sale->bori }}  </td>
                        <td class=""> {{$sale->trDesription }}  </td>
                        @if($sale->customer_status)
                        <td class=""> @lang('layout.checked') </td>
                        @else 
                        <td class=""> </td>
                        @endif
                        </tr>
                    </tbody>
                </table>
            </div>
            @endif  
        </div>
    </div>

    <div class="row">

<div class="tabbable tabbable-tabdrop">
    <ul class="nav nav-tabs">
        <li class="active">
            <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.SaleDetails')</a>
        </li>
        <li class="">
            <a href="#tab3" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
        </li>
        <li class="">
            <a href="#tab5" data-toggle="tab" id="tab_grn">@lang('layout.GRN')</a>
        </li>
    </ul>
    <div class="tab-content">
        <div class="tab-pane active" id="tab1">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.SaleDetails')</span>
                    </div>
                    <div class="tools"></div>
                    <div class="actions">
                        <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                        </span>
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="sales">
                        <thead>
                            <tr>
                                @if(getSerailNumber() =="true")
                                <th>@lang('layout.SerialNum')</th>
                                @endif
                                <th>@lang('layout.ItemName')</th>
                                <th>@lang('layout.Site')</th>
                                @if(searchByCodeLocation()=="true")
                                <th>@lang('layout.Location')</th>
                                @endif
                                @if(getSaleDescription()=="true") 
                                <th>@lang('layout.Model')</th>
                                <th>@lang('layout.Color')</th>
                                @endif
                                <th>@lang('layout.Unit/M')</th>
                                <th>@lang('layout.PurchaseDate')</th>
                                <th>@lang('layout.SleepStaff')</th>
                                @if(getOtherMeasure()=="true")
                                <th>@lang('layout.OMeasureValue1')</th>
                                @endif
                                @if(getOtherMeasure2()=="true")
                                <th>@lang('layout.OMeasureValue2')</th>
                                @endif
                                <th>@lang('layout.Quantity')</th>
                                <th>@lang('layout.Price')</th>
                                <th>@lang('layout.Discount')</th> 
                                @if(getSaleCommission()=="true")
                                <th>@lang('layout.Commission') @lang('layout.Percentage')%</th>
                                <th>@lang('layout.Commission') @lang('layout.Amount')</th>
                                @endif 
                                @if($seeCost==true)
                                <th>@lang('layout.Cost')</th>
                                <th>@lang('layout.GrossProfit')</th>
                                @endif
                                <th>@lang('layout.Total')</th>
                                <th>@lang('layout.GRN')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
        <div class="tab-pane" id="tab5">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.GRN')</span>
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="grn">
                        <thead>
                            <tr>
                                <th>@lang('layout.Name')</th>
                                <th>@lang('layout.Number')</th>
                                <th>@lang('layout.Action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div> 
    '
    <div class="tab-pane" id="tab3">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="portlet light bordered">
                    <div class="portlet-body">

                        <form role="form" action="{{route('attachment.store')}}" method="post"
                              enctype="multipart/form-data">

                            @csrf
                            <input type="hidden" name="redirect_route" value="sale.show">
                            <input type="hidden" name="foreign_data_id" value="{{$sale->sale_id}}">
                            <input type="hidden" name="path" value="uploads/Invoice">
                            <input type="hidden" name="table_name" value="sales">

                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                        <input type="text" name="title" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        <textarea name="description" class="form-control"></textarea>
                                    </div>
                                </div>
                                <div class="col-md-7">
                                    <div class="form-group">
                                        <div class="fileinput fileinput-new" data-provides="fileinput">
                                            <div class="fileinput-new thumbnail"
                                                 style="width: 200px; height: 150px;">
                                                <img src="" alt=""></div>
                                            <div class="fileinput-preview fileinput-exists thumbnail"
                                                 style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                            <div>
                                                        <span class="btn default btn-file">
                                                            <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                            <input type="hidden" value="" name=""><input
                                                                    type="file" name="photo"> </span>

                                                <a href="javascript:;" class="btn default fileinput-exists"
                                                   data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="margiv-top-10">
                                <button type="button" onclick="regForm(this)"
                                        class="btn green"> @lang('layout.Submit') </button>
                                <a href="{{route('dailyExpense.index')}}"
                                   class="btn default">@lang('layout.Cancel')</a>
                            </div>
                        </form>
                    </div>
                </div>
                <table class="table table-striped table-bordered table-hover" id="attachment">
                    <thead>
                    <tr>
                        <th>@lang('layout.AttachmentTitle')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Action')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>   
</div>
</div>
</div>
@endsection
@include('print.modal')
 @push('scripts')
<script>
    function grnPrintAll(id, item_id = null) {
    var invoice_id = {{$sale->sale_id}}
    var a = document.createElement('a');
    a.href = "{{url('grnPrintAll')}}/" + id+"/"+invoice_id+"/"+item_id;
    a.target = "_blank";
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
    } 
    var cust_rep = {!!customeReportNewData('sale_show')!!};
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#sales').DataTable({
            ajax: {
                url: '{{route("sale.show",$sale->sale_id)}}',
                data: {type: 'sale'}
            },
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [
				@if(getSerailNumber() =="true"){ data: 'number', name: 'number', orderable:false,searchable:false },@endif
				{ data: 'name', name: 'name', orderable:false,searchable:false },
				{ data: 'siteName', name: 'siteName', orderable:false,searchable:false },
                @if(searchByCodeLocation()=="true")
                {data: 'location', name: 'location', orderable: false, searchable: false},
                @endif
                @if(getSaleDescription()=="true") 
                { data: 'model',      name: 'model',searchable:false },
                { data: 'color',      name: 'color',searchable:false },
                @endif
                { data: 'symbol', name: 'symbol', orderable:false,searchable:false },
                { data: 'stocks_date', name: 'stocks_date', orderable:false,searchable:false },
                { data: 'sleepDate', name: 'sleepDate', orderable:false,searchable:false },
                @if(getOtherMeasure()=="true")
                { data: 'other_measure', name: 'other_measure', orderable: false, searchable: false },
                @endif
                @if(getOtherMeasure2()=="true")
                { data: 'other_measure2', name: 'other_measure2', orderable: false, searchable: false},
                @endif
                { data: 'qty', name: 'qty', orderable:false,searchable:false },
                { data: 'price', name: 'price', orderable:false,searchable:false},
                { data: 'discount', name: 'discount', orderable:false,searchable:false },

                @if(getSaleCommission()=="true")
                { data: 'row_commission_percent', name: 'row_commission_percent', orderable:false,searchable:false },
                { data: 'total_commission', name: 'total_commission', orderable:false,searchable:false },
                @endif

                @if($seeCost==true)
                { data: 'avgCost', name: 'avgCost', orderable:false,searchable:false},
                { data: 'income', name: 'income', orderable:false,searchable:false},
                @endif
                { data: 'total', name: 'total', orderable:false,searchable:false},
                { data: 'actions', name: 'actions', orderable:false,searchable:false},
        ]
        });



        $('#attachment').DataTable({
                ajax: {
                    url: '{{route("invoice.show",$sale->sale_id)}}',
                    data: {type: 'attachment'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'title', name: 'attachments.title'},
                    {data: 'description', name: 'attachments.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });     

        $('#grn').DataTable({
                ajax: {
                    url: '{{route("invoice.show",$sale->sale_id)}}',
                    data: {type: 'grn'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'site_name', name: 'site_name'},
                    {data: 'site_number', name: 'site_number'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},

            


                ]
            });  

    });


        var vm =new Vue({ 
            el: '#print-modal',
            data:{
                is_show: false,
                pdfRoute: '{!!route('export.PDFAny') !!}',
                excelRoute: '{!! route('export.exportCsv') !!}',
                customReportData:
                [ 
                 {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_rep.item_name)?'checked':'',column_percentage:(cust_rep.item_name___percent)?cust_rep.item_name___percent:''},
                 {Name: '@lang("layout.PurchaseDate")', column_name: 'purchase_date',checkedColumn:(cust_rep.purchase_date)?'checked':'',column_percentage:(cust_rep.purchase_date___percent)?cust_rep.purchase_date___percent:''},
                 {Name: '@lang("layout.SleepStaff")', column_name: 'sleep_day',checkedColumn:(cust_rep.sleep_day)?'checked':'',column_percentage:(cust_rep.sleep_day___percent)?cust_rep.sleep_day___percent:''},
                 {Name: '@lang("layout.Symbol")', column_name: 'symbol',checkedColumn:(cust_rep.symbol)?'checked':'',column_percentage:(cust_rep.symbol___percent)?cust_rep.symbol___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
                 {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_rep.price)?'checked':'',column_percentage:(cust_rep.price___percent)?cust_rep.price___percent:''},
                 {Name: '@lang("layout.Cost")', column_name: 'purchase_rate',checkedColumn:(cust_rep.purchase_rate)?'checked':'',column_percentage:(cust_rep.purchase_rate___percent)?cust_rep.purchase_rate___percent:''},
                 {Name: '@lang("layout.GrossProfit")', column_name: 'income',checkedColumn:(cust_rep.income)?'checked':'',column_percentage:(cust_rep.income___percent)?cust_rep.income___percent:''},
               
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.TotalGrossProfit")', column_name: 'total_gross_profit',checkedColumn:(cust_rep.total_gross_profit)?'checked':'',column_percentage:(cust_rep.total_gross_profit___percent)?cust_rep.total_gross_profit___percent:''},
                 @if(showLocation()=="true")
                 {Name: '@lang("layout.Location")', column_name: 'location',checkedColumn:(cust_rep.location)?'checked':'',column_percentage:(cust_rep.location___percent)?cust_rep.location___percent:''},
                 @endif
                 @if(getSaleDescription()=="true")
                 {Name: '@lang("layout.Model")', column_name: 'model',checkedColumn:(cust_rep.model)?'checked':'',column_percentage:(cust_rep.model___percent)?cust_rep.model___percent:''},
                 {Name: '@lang("layout.Color")', column_name: 'color',checkedColumn:(cust_rep.color)?'checked':'',column_percentage:(cust_rep.color___percent)?cust_rep.color___percent:''},
                 @endif  
                 @if(getSaleCommission()=="true")   
                 {Name: '@lang("layout.Commission")  @lang("layout.Percentage")', column_name: 'commission_percentage',checkedColumn:(cust_rep.commission_percentage)?'checked':'',column_percentage:(cust_rep.commission_percentage___percent)?cust_rep.commission_percentage___percent:''},
                 {Name: '@lang("layout.Commission")  @lang("layout.Amount")', column_name: 'commission_amount',checkedColumn:(cust_rep.commission_amount)?'checked':'',column_percentage:(cust_rep.commission_amount___percent)?cust_rep.commission_amount___percent:''},
                 @endif
                ], 
                  cust_rep:cust_rep
            },
    
            methods:{
                closeModal: function(){
                    this.is_show = !this.is_show;
                }
            }
        });

    new Vue({
        el:'#anchore-modal',
        methods:{
            showModal:function(){
                console.log('trr')
                vm.$data.is_show = true;
            }
        }
    });

</script>


@endpush 