@extends('layouts.app')
@section('style')
<style type="text/css">
    body, html{
        height: 100%;
    }
    .background{
        position: relative;
        width: 100%;
        height: 100vh;
        background-image: url('{{asset('menu_img/SaleImages/Capture6.PNG')}}');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        overflow-y: auto;
    }
    .overlay{
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100vh;
        background-color: rgba(0, 0, 0, 0.651);
        display: flex;
        justify-content: center;
        align-items: flex-start;
        padding-top: 20px;
    }
    .cards{
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        width: 100%;
        max-width: 1600px;
        padding: 10px;
        box-sizing: border-box;
        gap: 10px;
    }
    .allCards{ 
        width: 19%;
        /* height: 80px; */
        min-height: 90px;
        background-color: white;
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(235, 232, 232, 0.877);
        transition: .5s;
    }
    .allMainCard{ 
        width: 19%;
        /* height: 80px; */
        min-height: 100px;
        border-radius: 10px;
        transition: .5s;
    }
    .allMainCard:hover{
        text-decoration: none;
    }
    .allCards:hover{
        background-color: rgba(255, 255, 255, 0.787);
        transition: .5s;
    }
    .allCards:hover a{
        text-decoration: none;
    }
    @media(max-width: 1024px){
        .allCards{
            width: 22%;
        }
        .allMainCard{
            width: 22%;
        }
    }
    @media(max-width: 768px){
        .allCards{
            width: 45%;
        }
        .allMainCard{
            width: 45%;
        }
    }
    @media(max-width: 480px){
        .allCards{
            width: 90%;
        }
        .allMainCard{
            width: 90%;
        }
    }
    .caret{
        transition: transform 0.3s ease;
    }
    .caret.open{
        transform: rotate(90deg);
    }
</style>
@stop
@section('content')
<div class="background">
    <div class="overlay">
        <div class="cards">
            <div class="mainHeader" style="display: flex; justify-content: space-between;width: 100%;flex-wrap: wrap;">
                <h3 style="color: white;">@lang('layout.Sales')</h3>
                <div>
                    <div class="btn-group">
                        @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                        @permission('sales-create')
                        <a href="{{route('sale.create')}}" type="button" class="btn topBtn" style="background-color: #50818d;color: white;">@lang('layout.AddNew')</a>
                        <button type="button" class="btn topBtn dropdown-toggle btn-success" data-toggle="dropdown" id="dropdownButton">
                            <span class="caret"></span>
                        </button>
                        @endpermission
                        @endif
                        <ul class="dropdown-menu dropdown-menu-right" role="menu">
                            @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                            @permission('sales-create')
                            <li>
                                <a href="{{route('sale.create')}}">@lang('menu.SaleReceipt')</a>
                            </li>
                            @endpermission
                            @endif
    
                            @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                            @permission('invoice-create')
                            <li>
                                <a href="{{route('invoice.create')}}">@lang('menu.Invoice')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                            @if(systemConfig()[23] == 1) 
                            @if(systemConfig()[4] != 0 )
                            @permission('invoiceRoll-create')
                            <li>
                                <a href="{{route('invoice_roll.create')}}">@lang('menu.InvoiceRoll')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                            @if(systemConfig()[23] == 1) 
                            @if(systemConfig()[20] == 1)
                            @permission('ProjectInvoice-create')
                            <li>
                                <a href="{{route('projectInvoice.create')}}">@lang('menu.ProjectInvoice')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                            @if(systemConfig()[23] == 1)
                            @permission('saleByType-create')
                            <li>
                                <a href="{{route('saleByType.create')}}">@lang('menu.SaleByType')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                            @permission('salesOrder-create')
                            <li>
                                <a href="{{route('salesOrder.create')}}">@lang('menu.SalesOrder')</a>
                            </li>
                            @endpermission
                            @endif
    
                            @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                            @if(systemConfig()[23] == 1) 
                            @permission('saleGift-create')
                            <li>
                                <a href="{{route('saleGift.create')}}"> @lang('menu.SaleGift')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                            @if(systemConfig()[23] == 1) 
                            @permission('saleArea-create')
                            <li>
                                <a href="{{route('saleArea.create')}}"> @lang('menu.SaleArea')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                            @if(systemConfig()[23] == 1) 
                            @permission('refund-create')
                            <li>
                                <a href="{{route('simpleRefundInvoice.create')}}"> @lang('menu.Refund')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                            @if(systemConfig()[23] == 1) 
                            @if(systemConfig()[4] != 0 )
                            @permission('refund-create')
                            <li>
                                <a href="{{route('refundRoll.create')}}"> @lang('menu.ReturnRoll')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                            @if(systemConfig()[23] == 1)
                            @permission('estimate-create')
                            <li>
                                <a href="{{route('estimate.create')}}"> @lang('menu.Estimates')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                            @if(systemConfig()[23] == 1)
                            @permission('taxation-create')
                            <li>
                                <a href="{{route('taxation.create')}}"> @lang('menu.Taxation')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                            @if(systemConfig()[23] == 1)
                            @permission('Commission-create')
                            <li>
                                <a href="{{route('commission.create')}}"> @lang('layout.Commission')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                            @if(systemConfig()[23] == 1)
                            @if(systemConfig()[27] == 1)
                            @permission('GasStation-create')
                            <li>
                                <a href="{{route('oilPart.create')}}"> @lang('menu.GasStation')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                            @if(systemConfig()[23] == 1)
                            @if(systemConfig()[27] == 1)
                            @permission('OilPartCounter-create')
                            <li>
                                <a href="{{route('oilPartCounter.create')}}"> @lang('menu.GasStationCounter')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                            @if(systemConfig()[23] == 1)
                            @permission('discountDate-create')
                            <li>
                                <a href="{{route('saleDiscountDate.create')}}"> @lang('menu.DiscountDate')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
                        </ul>
                    </div>
                    <a href="#" class="btn btn-danger">@lang('layout.Back') <i class="fa fa-reply"></i></a>
                </div>
            </div>
            <div class="cards">
                @permission('sales-list')
                <a href="{{route('sale.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.SalesReceiptes')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #7ccc04;" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($total_SalesReceipt)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('invoice-list')
                <a href="{{route('invoice.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.Invoice')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #b6babf;" class="fa fa-credit-card"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($total_Invoice)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @if(systemConfig()[23] == 1 || systemConfig()[26] == 1)
                @if(systemConfig()[23] == 1) 
                @if(systemConfig()[4] != 0 )
                @permission('invoiceRoll-create')
                <a href="{{route('invoice_roll.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.InvoiceRoll')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #fb8001;" class="fa fa-qrcode"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($total_InvoiceRoll)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @endif
                @endif
                @permission('saleByType-list')
                <a href="{{route('saleByType.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.SaleByType')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #0175c0;" class="fa fa-align-justify"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($total_saleByType)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('salesOrder-list')
                <a href="{{route('salesOrder.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 0px !important; margin:5px 0px !important;font-weight: bold;">@lang('menu.SalesOrder')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #259ce0;" class="fa fa-credit-card"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$sale_order_count}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @if(systemConfig()[23] == 1) 
                @if(systemConfig()[20] == 1)
                @permission('ProjectInvoice-list')
                <a href="{{route('projectInvoice.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ProjectInvoice')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #1fa7f2;" class="fa fa-credit-card"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($invoiceContract){{myround($invoiceContract)}} {{getHomeCurrency()['code']}} @else 0 @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @endif
                @permission('saleGift-list')
                <a href="{{route('saleGift.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.SaleGift')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgb(193, 179, 22);" class="fa fa-credit-card"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($saleGift){{myround($saleGift)}} @else 0 @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('saleArea-list')
                <a href="{{route('saleArea.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.SaleArea')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(163, 209, 118, 1);" class="fa fa-area-chart"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($saleGift){{myround($saleArea)}} @else 0 @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('refund-list')
                <a href="{{route('refund.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Refund')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 131, 128, 1);" class="fa fa-mail-forward"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">(@lang('layout.ReturnInvoice')) @if($refundInvoice){{myround($refundInvoice)}} {{getHomeCurrency()['code']}} @else 0 @endif</p>
                            <p style="padding: 0px !important; margin: 0px !important;">(@lang('layout.ReturnSales')) @if($refundSales){{myround($refundSales)}} {{getHomeCurrency()['code']}} @else 0 @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @if(systemConfig()[4] != 0 )
                @permission('refund-list')
                <a href="{{route('refundRoll.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ReturnRoll')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 166, 164, 1);" class="fa fa-mail-forward"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($refundInvoiceRoll){{myround($refundInvoiceRoll)}} {{getHomeCurrency()['code']}} @else 0 @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[23] == 1)
                @permission('estimate-list')
                <a href="{{route('estimate.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Estimates')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 193, 191, 1);" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @permission('taxation-list')
                <a href="{{route('taxation.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Taxation')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color:  rgba(77, 94, 137, 1);" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('Commission-list')
                <a href="{{route('commission.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.Commission')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(32, 57, 87, 1);" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                        </div>
                    </div>
                </a>
                @endpermission
                @if(systemConfig()[27] == 1)
                @permission('GasStation-list')
                <a href="{{route('oilPart.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.GasStation')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(110, 140, 168, 1);" class="fa fa-home"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($oilPart){{$oilPart}} @else 0 @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[27] == 1)
                @permission('OilPartCounter-list')
                <a href="{{route('oilPartCounter.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.GasStationCounter')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(247, 111, 0, 1);" class="fa fa-sort-numeric-asc"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($gasStationCounter){{$gasStationCounter}} @else 0 @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[23] == 1)
                @permission('discountDate-list')
                <a href="{{route('saleDiscountDate.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.DiscountDate')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(44, 160, 28, 1);" class="fa fa-percent"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    const dropdownButton = document.getElementById('dropdownButton');
    const caret = dropdownButton.querySelector('.caret');
    dropdownButton.addEventListener('click', ()=>{
        caret.classList.toggle('open');
    });
    function toggleContent(){
        var content = document.querySelector('.content');
        var icon = document.getElementById('icon');
        if(content.classList.contains('collapsed')){
            content.classList.remove('collapsed');
            content.classList.add('expanded');
            icon.classList.remove('fa-chevron-down');
            icon.classList.add('fa-chevron-up');
        }else{
            content.classList.remove('expanded');
            content.classList.add('collapsed');
            icon.classList.remove('fa-chevron-up');
            icon.classList.add('fa-chevron-down');
        }
    }
</script>
<script type="text/javascript">
    new Vue({
        el: "#system_setting",
        data: {
            settings: settingAll,
            measures: measures,
            sites: sites,
            enable_notify: false
        },
        mounted() {
        },
        methods: {
        }
    });
</script>
@endpush