@extends('layouts.app')
@section('style')
    <style>
        .hide_btn{
            display: none; 
        }
    </style>
@endsection
@section('content')
    <!-- BEGIN CONTENT -->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'SaleList'" @closed="closeModal"> 
            <div slot="body">
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
            <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 ) 
                            @permission(['customreport-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1"> 
                                    <div class="portlet light bordered">
                                    <div class="row">
                                        <div class="form-group"> 
                                            <div class="col-md-6">
                                                <label class="control-label ">@lang('layout.SelectMember') </label>
                                                <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                                        :options="memberlist">
                                                </v-select>
                                                <input type="hidden" name="member_id"
                                                    v-model.number="(!selectedMember)?null:selectedMember.id">
                                            </div>
                                            <div class="col-md-6">
                                                <label class="control-label ">@lang('layout.MemberClass') </label>
                                                <v-select class="vue-select2" v-model="selectedClass" label="name" @search="onClassSearch"
                                                        :options="classlist">
                                                </v-select>
                                                <input type="hidden" name="class_id"
                                                    v-model.number="(!selectedClass)?null:selectedClass.id">
                                            </div>
                                            <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.SaleArea') </label>
                                                <v-select class="vue-select2" v-model="selectedArea" label="name" @search="onSaleAreaSearch" :options="saleArealist">
                                                </v-select>
                                                <input type="hidden" name="sale_area_id" v-model.number="(!selectedArea)?null:selectedArea.id">
                                            </div> 
                                            <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.SelectSite') </label>
                                                <v-select class="vue-select2" v-model="selectedInventorySite" label="name" :options="InventorySite">
                                                </v-select>
                                                <input type="hidden" name="inventory_id" v-model.number="(!selectedInventorySite)?null:selectedInventorySite.id">
                                            </div>
                                            @if(getFactorPending() == 'true')
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label" >@lang('layout.Factor') @lang('layout.Pending')</label>
                                                        <input type="checkbox" name="pending" value="on"  class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            @endif
                                            <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.ReferenceNumber') </label>
                                                <input type="text" name="ref_no" class="form-control" >
                                            </div>
                                            @if(getActiveSale() == 'true')
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label" >@lang('layout.ActiveSale')</label>
                                                        <input type="checkbox" name="sale_status" value="on" checked class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label ">@lang('layout.Date')</label>
                                                    <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                    <option value="CustomDates">@lang('type.CustomDates')</option>
                                                    <option value="Today">@lang('type.Today')</option>
                                                    <option value="Yesterday">@lang('type.Yesterday')</option>
                                                    <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                    <option value="LastWeek">@lang('type.LastWeek')</option>
                                                    <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                    <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                    <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                    <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                    <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                    <option value="ThisYear">@lang('type.ThisYear')</option>
                                                    <option value="YearToDate">@lang('type.YearToDate')</option>
                                                </select>
                                            </div>
                                            <div class="col-md-12" v-show="period == 'CustomDates'">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                    <div class="input-group">
                                                        <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                        <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    </div>
                            </div> 

                            <div class="tab-pane" id="tab2"> 
                                <div class="portlet light bordered">
                                        <div class="portlet-body">

                                            <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                @csrf
                                                <input type="hidden" name="part_name" value="sale_index">


                                                <div class="col-md-12 col-sm-12 col-xs-12">

                                                    <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                        <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                                        <tr>
                                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td style="text-align: center;">
                                                                                <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                                <label class="switch">
                                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                    :checked="row.checkedColumn" >
                                                                                    <span class="slider round"></span>
                                                                                </label>
                                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="2">2 %</option>
                                                                                    <option value="6">6 %</option>
                                                                                    <option value="10">10 %</option>
                                                                                    <option value="15">15 %</option>
                                                                                    <option value="20">20 %</option>
                                                                                    <option value="25">25 %</option>
                                                                                    <option value="30">30 %</option>
                                                                                    <option value="40">40 %</option>
                                                                                    <option value="50">50 %</option>
                                                                                    <option value="60">60 %</option>
                                                                                </select>
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                            <!-- <label> @{{ row.Name }}</label>

                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                            <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                <span class="slider round"></span>
                                                            </label> -->

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="margiv-top-10">
                                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                    <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                </div>
                                        </form>
                                        </div>
                                </div>
                            </div>
                    </div>
                </div>
            </div>
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->

            </div>
        </report-modal>
    </div>
    {{-- custom part start  --}}
    <div id="settingModal" v-cloak>
        <setting-modal :pdf-route="route" v-if="is_show" :value-type="'sale'" @closed="closeModal">
            <div slot="header" class="text-center">
                <h4 style="font-weight: bold;">@lang('layout.CustomForms')</h4>
            </div>
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <div class="mt-checkbox-inline col-md-2" style="padding: 0px;margin-bottom: 10px;" v-for="(row,itemIndex) in customReportData">
                            <div class="form-group">
                                <table class="table table-striped table-bordered table-advance">
                                    <tr style="background-color: rgba(227, 227, 227, 0.757)">
                                        <th style="text-align: center;">@{{ row.Name }}</th>
                                    </tr>
                                    <tr>
                                        <td style="text-align: center;">
                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                            <label class="switch">
                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                :checked="row.checkedColumn" >
                                                <span class="slider round"></span>
                                            </label>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            </div>
        </setting-modal>
    </div>
    {{-- custom part end  --}}
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="col-md-2 col-sm-2">
                <span class="caption-subject bold uppercase" style="font-size: 20px;">@lang('layout.SalesList')</span>
            </div>
            <div class="col-md-5 col-sm-6" id="date_part">
                <div class="form-group">
                    <div class="col-md-3 col-sm-3">
                        <input name="ref_no" class="form-control" ref="ref_no" placeholder="@lang('layout.ReferenceNumber')" autocomplete="off" />
                    </div>
                    <div class="input-group col-md-9 col-sm-9">
                        <input name="from_date" class="form-control date" ref="from_date" placeholder="@lang('layout.FromDate')" autocomplete="off" />
                        <span class="input-group-addon"> @lang('layout.To') </span>
                        <input name="to_date" class="form-control date" ref="to_date" placeholder="@lang('layout.ToDate')" autocomplete="off" />
                        <span class="input-group-addon btn"  @Click="getData()" > @lang('layout.Search') </span>
                    </div>
                </div>
            </div>
            <div class="col-md-2 col-sm-4" id="date_parttwo">
                <div class="form-group">
                {{Form::open(['route' => 'sales.changeFactor','method' => 'POST','class' => 'form-horizontal', 'id'=>'sales-form'])}}
                {{ csrf_field() }}
                    <div class="form-group  hidden-print">
                        <div class="input-group"> 
                            <input name="part_number" class="form-control" ref="part_number" placeholder="@lang('layout.DeActiveOldsFactor')"  type="number" />
                            <span class="input-group-addon btn" style="padding: 0px;" > <button type="button" @click="submitFormDatePart($event)" style="padding: 0px 8px; color:red;" > @lang('layout.Disable') </button> </span>
                        </div>
                    </div>
                {!! Form::close() !!}
                </div>
            </div> 
            <div class="portlet-title">
                <div class="caption font-dark">
                    <!-- <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.SalesList')</span> -->
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    <span id="setting-modal">
                        <button type="submit" @click.prevent="showModal" class="btn" style="background-color: rgb(80, 129, 141);color: white;">
                            <i class="fa fa-wrench"></i>
                        </button>
                    </span>
                    @if(getNegativeSale() == 'true')
					<a href="{{route('sale.index_nagative')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.ShowNegativeSale')
                            @if ($nagativeInvoice > 0)
                            <span class="badge badge-default" style="color: #ffffff; background-color: #f90000; font-size: 15px !important;"> {{$nagativeInvoice}} </span>
                            @endif
                        </button>
                    </a>
					@endif
                    @if(getFactorPending() == 'true')
					<a href="{{route('sale.index_pending')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.Factor') @lang('layout.Pending')
                        </button>
                    </a>
					@endif
                    @if(getActiveSale() == 'true')
					<a href="{{route('sale.index_all')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.All') @lang('layout.Sale')
                            <!-- <span class="badge badge-default" style="color: #ffffff; background-color: #f90000; font-size: 15px !important;"> 0 </span> -->        
                        </button>
                    </a>
					@endif
                    @permission('sales-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                    </span>
                    @endpermission
                    @permission('sales-create')
                    <a href="{{route('sale.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    <!-- <button class="btn btn-success" id="addNewRefundd">
                                <i class="icon-action-redo"></i> @lang('menu.Refund')
                        </button> -->
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered " cellspacing="0" id="sale">
                    <thead>
                        <tr>
                            <th>@lang('layout.SalesNumber')</th>
                            @if(getCustomeForm('sale','referenceNumber'))
                            <th>@lang('layout.ReferenceNumber')</th>
                            @endif
                            <th>@lang('layout.CustomerName')</th>
                            <th>@lang('layout.SalesType')</th>
                            <th>@lang('layout.Account')</th>
                            @if(getCustomeForm('sale','date'))
                            <th>@lang('layout.Date')</th>
                            @endif
                            @if(getCustomeForm('sale','hour'))
                            <th>@lang('layout.Hour')</th>
                            @endif
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Discount')</th>
                            @if(getCustomeForm('sale','status'))
                            @if(getFactorPending() == 'true')
                            <th>@lang('layout.Status')</th>
                            @endif
                            @endif
                            @if(getCustomeForm('sale','pumpNumber'))
                            @if(systemConfig()[27] == 1)
                            <th>@lang('layout.PumpNumber')</th>
                            @endif
                            @endif
                            @if(getCustomeForm('sale','category'))
                            @if(getActiveSale()=="true")
                            <th>@lang('layout.Category')</th>
                            @endif
                            @endif
                            @if(getCustomeForm('sale','user'))
                            <th>@lang('layout.User')</th>
                            @endif
                            @if(getCustomeForm('sale','description'))
                            <th>@lang('layout.Description')</th>
                            @endif
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- for factor begin -->
    <div id="factor-obj"></div>
    <iframe id="saleFrames" style="display: none;"></iframe>
    <!-- end for factor -->
@stop
@include('print.modal')
@include('layouts.setting_model')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        var cust_rep = {!!customeReportNewData('sale_index')!!};
        @if(Session('sale_id') && getFactorPrint()== "automatic")
        factorPrint("{{Session('sale_id')}}", "{{Session('whatsapp')}}")
        @endif
        @if(Session('sale_id') && Session('category') == "Restaurant")
        factorPrint("{{Session('sale_id')}}", "{{Session('whatsapp')}}")
        @endif
         //GRN Print
        // grnPrint("{{Session('sale_id')}}")
        Vue.component('v-select', VueSelect.VueSelect)
        function factorPrint(id,sendWhatsapp = null,type = null) {
            if (sendWhatsapp == null || sendWhatsapp == '') {
                sendWhatsapp = 'not';
            }
            if (type == null || type == '') {
                type = 1;
            }
            var a = document.createElement('a');
            a.href = "{{url('invoiceFactorPrint')}}/" + id + "/" + sendWhatsapp + "/" + type;
            a.target = "_self";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
        function sendVoucherToWhatsapp(id,sendWhatsapp) {
            if (id && sendWhatsapp) {
                axios.get("{{url('invoiceFactorPrint')}}/" + id + "/1", {
                    // params: {
                        // method_name: 'SearchMember',
                        // class_id: class_id
                    // }
                })
                .then(function(response) {
                    // console.log(response);
                    if (response.data) {
                        if (sendWhatsapp == 1) {
                            var a = document.createElement('a');
                            a.href = "https://wa.me/?text=" + response.data;
                            a.target = "_blank";
                            document.body.appendChild(a);
                            a.click();
                            document.body.removeChild(a);
                        }
                        if (sendWhatsapp == 2) {
                            var a = document.createElement('a');
                            a.href = "https://telegram.me/share/url?url=Hi&text=" + response.data;
                            a.target = "_blank";
                            document.body.appendChild(a);
                            a.click();
                            document.body.removeChild(a);
                        }
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
            }
        }        
        function grnPrint(id) {
            var a = document.createElement('a');
            a.href = "{{url('grnFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);

                    // $.ajax({
                    //         // This PHP file will generate the PDF and save it to your server
                    //         // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    //         url: "{{url('/')}}/invoiceFactorPrint/"+id,
                    //         type: 'get',
                    //         cache: false,

                    //     }).done(function () {

                    //         var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                    //         $('#factor-obj').html(s);
                       

                    //         // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                    //     })
                    //         .fail(function () {
                    //             console.log("error");
                    //         });
        }
        let data_table;
        function getRecord() {
            // console.log(234, vtr.from_date, vtr.to_date);
            data_table = $('#sale').DataTable({
                ajax: {
                    ajax: '{{route("sale.index")}}',
                    data: {
                        ref_no: vtr.ref_no,
                        from_date: vtr.from_date,
                        to_date: vtr.to_date
                    }
                },
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:5}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                destroy: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [

                    {data: 'number', name: 'sales.number'},
                    @if(getCustomeForm('sale','referenceNumber'))
                    {data: 'ref_no', name: 'sales.ref_no'},
                    @endif
                    {data: 'member_name', name: 'member_name'},
                    {data: 'type', name: 'type', orderable: false, searchable: false},
                    {data: 'account_name', name: 'accounts.name'},
                    @if(getCustomeForm('sale','date'))
                    {data: 'date', name: 'sales.date', searchable: false},
                    @endif
                    @if(getCustomeForm('sale','hour'))
                    {data: 'hour', name: 'sales.hour', searchable: false},
                    @endif
                    {data: 'currency', name: 'transactions.unit'},
                    {data: 'amount', name: 'transactions.amount' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'discount', name: 'discount', orderable: false, searchable: false},
                    @if(getCustomeForm('sale','status'))
                    @if(getFactorPending() == 'true')
                    {data: 'status', name: 'status', orderable: false, searchable: false},
                    @endif
                    @endif
                    @if(getCustomeForm('sale','pumpNumber'))
                    @if(systemConfig()[27] == 1)
                    {data: 'pump_number', name: 'oil_parts.number'},
                    @endif
                    @endif
                    @if(getCustomeForm('sale','category'))
                    @if(getActiveSale()=="true")
                    {data: 'category', name: 'sales.category'},
                    @endif
                    @endif
                    @if(getCustomeForm('sale','user'))
                    {data: 'username', name: 'users.name'},
                    @endif
                    @if(getCustomeForm('sale','description'))
                    {data: 'description', name: 'description' @if(getGeneralSearch()) , searchable: false @endif},
                    @endif
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });
        }
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            getRecord();
        });
        $(document).ready(function () {
            $('#btnPrint').click(function () {
                $.ajax({
                    // This PHP file will generate the PDF and save it to your server
                    // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    url: '{{route("sale.show",1)}}',
                    type: 'get',
                    cache: false,

                }).done(function () {

                    var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                    $('#factor-obj').html(s);


                    // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                })
                    .fail(function () {
                        console.log("error");
                    });

                // window.print();
                // window.open("data:application/pdf," + escape(data=""));
                $.ajax({
                    // This PHP file will generate the PDF and save it to your server
                    // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    url: '{{route("sale.show",1)}}',
                    type: 'get',
                    cache: false,

                }).done(function () {

                    var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                    $('#factor-obj').html(s);


                    // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                })
                    .fail(function () {
                        console.log("error");
                    });

            });


        });        
        var v = new Vue({
            el: '#date_parttwo',
            methods: {
                // submit the form
              
                submitFormDatePart(e) {
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                        text: "",
                        icon: "info",
                        InfoMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("sales-form").submit()
                        } else {
                            
                        }
                    });
                },
                // submit the form
            }
        });
        var inventorySite = {!! $inventorySite !!};
        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                selectedMember: null,
                memberlist: [],
                classlist: [],
                selectedClass: null,
                saleArealist: [],
                selectedInventorySite: null,
                InventorySite: inventorySite,
                selectedArea: null,
                customReportData:
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(cust_rep.reference_number)?'checked':'',column_percentage:(cust_rep.reference_number___percent)?cust_rep.reference_number___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_rep.hour)?'checked':'',column_percentage:(cust_rep.hour___percent)?cust_rep.hour___percent:''},
                 {Name: '@lang("layout.SaleNumber")', column_name: 'sale_number',checkedColumn:(cust_rep.sale_number)?'checked':'',column_percentage:(cust_rep.sale_number___percent)?cust_rep.sale_number___percent:''},
                 {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(cust_rep.customer)?'checked':'',column_percentage:(cust_rep.customer___percent)?cust_rep.customer___percent:''},
                 {Name: '@lang("layout.AccountName")', column_name: 'account_name',checkedColumn:(cust_rep.account_name)?'checked':'',column_percentage:(cust_rep.account_name___percent)?cust_rep.account_name___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'',column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(cust_rep.unit)?'checked':'',column_percentage:(cust_rep.unit___percent)?cust_rep.unit___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.DiscountType")', column_name: 'discount_type',checkedColumn:(cust_rep.discount_type)?'checked':'',column_percentage:(cust_rep.discount_type___percent)?cust_rep.discount_type___percent:''},
                 {Name: '@lang("layout.Discount")', column_name: 'discount',checkedColumn:(cust_rep.discount)?'checked':'',column_percentage:(cust_rep.discount___percent)?cust_rep.discount___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.Code")', column_name: 'code',checkedColumn:(cust_rep.code)?'checked':'',column_percentage:(cust_rep.code___percent)?cust_rep.code___percent:''},
                 @if(systemConfig()[27] == 1)
                 {Name: '@lang("layout.OldCounter")', column_name: 'old_counter',checkedColumn:(cust_rep.old_counter)?'checked':'',column_percentage:(cust_rep.old_counter___percent)?cust_rep.old_counter___percent:''},
                 {Name: '@lang("layout.NewCounter")', column_name: 'new_counter',checkedColumn:(cust_rep.new_counter)?'checked':'',column_percentage:(cust_rep.new_counter___percent)?cust_rep.new_counter___percent:''},
                 @endif
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                ],
                  cust_rep:cust_rep
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                onClassSearch(search, loading) {
                    loading(true);
                    this.searchClass(search, loading, this);
                },
                onSaleAreaSearch(search, loading) {
                    loading(true);
                    this.searchSaleArea(search, loading, this);
                },
                //ajax call to get class
                searchClass(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'member_classes',

                        }
                    })
                        .then(function (response) {
                            this.classlist = [];
                            if (response.data.length > 0) {
                                vm.classlist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                searchSaleArea(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'sale_areas',

                        }
                    })
                        .then(function (response) {
                            this.classlist = [];
                            if (response.data.length > 0) {
                                vm.saleArealist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                //ajax call to get items
                onMemberSearch: _.debounce((search, loading) => {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })

                }, getDebounceTime()),

                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },

            }
        });
        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });
        var vtr = new Vue({
            el: '#date_part',
            data: {
                ref_no: null,
                from_date: null,
                to_date: null,
            },
            methods: {
                getData() {
                    this.ref_no = this.$refs.ref_no.value;
                    this.from_date = this.$refs.from_date.value;
                    this.to_date = this.$refs.to_date.value;
                    // console.log(234, this.from_date, this.to_date,this.$refs.from_date.value);
                    getRecord();
                }
            }
        });
        // custom part start 
        var cust_form = {!!customeForm('sale')!!};
        var sm = new Vue({
            el: '#settingModal',
            data: {
                is_show: false,
                route: '{!!route("customForm.store") !!}',
                customReportData:
                [    
                    {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_form.description)?'checked':''},
                    {Name: '@lang("layout.Telegram")', column_name: 'telegram',checkedColumn:(cust_form.telegram)?'checked':''},
                    {Name: '@lang("layout.Whatsapp")', column_name: 'whatsapp',checkedColumn:(cust_form.whatsapp)?'checked':''},
                    @if(getShwoPriceLevel()=="general")
                    {Name: '@lang("layout.PriceLevel")', column_name: 'priceLevel',checkedColumn:(cust_form.priceLevel)?'checked':''},  
                    @endif      
                    {Name: '@lang("layout.ReferenceNumber")', column_name: 'referenceNumber',checkedColumn:(cust_form.referenceNumber)?'checked':''},   
                    {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_form.date)?'checked':''},   
                    {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_form.hour)?'checked':''},   
                    {Name: '@lang("layout.Contract")', column_name: 'contract',checkedColumn:(cust_form.contract)?'checked':''},   
                    {Name: '@lang("layout.Factor") @lang("layout.Pending")', column_name: 'factorPending',checkedColumn:(cust_form.factorPending)?'checked':''}, 
                    @if(oilSale() == 'true')  
                    {Name: '@lang("layout.Oil")', column_name: 'oil',checkedColumn:(cust_form.oil)?'checked':''},   
                    @endif
                    @if(getActiveSale()=="true")
                    {Name: '@lang("layout.FreeCardTimes")', column_name: 'freeCardTimes',checkedColumn:(cust_form.freeCardTimes)?'checked':''},
                    @endif   
                    @if(getNegativeSale() == 'true')
                    {Name: '@lang("layout.NegativeSale")', column_name: 'negativeSale',checkedColumn:(cust_form.negativeSale)?'checked':''},
                    @endif
                    {Name: '@lang("layout.CheckGift")', column_name: 'checkGift',checkedColumn:(cust_form.checkGift)?'checked':''},
                    @if(systemConfig()[27] == 1)
                    {Name: '@lang("menu.GasStation")', column_name: 'gasStation',checkedColumn:(cust_form.gasStation)?'checked':''},
                    @endif
                    @if(getActiveSale()=="true")
                    {Name: '@lang("layout.Category")', column_name: 'category',checkedColumn:(cust_form.category)?'checked':''},
                    @endif
                    {Name: '@lang("layout.ReceivedAmount")', column_name: 'receivedAmount',checkedColumn:(cust_form.receivedAmount)?'checked':''},
                    @if(getSaleCommission()=="true")
                    {Name: '@lang("layout.Commission")', column_name: 'commission',checkedColumn:(cust_form.commission)?'checked':''},
                    @endif
                    @if(getFactorPending() == 'true')
                    {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_form.status)?'checked':''},
                    @endif
                    @if(systemConfig()[27] == 1)
                    {Name: '@lang("layout.PumpNumber")', column_name: 'pumpNumber',checkedColumn:(cust_form.pumpNumber)?'checked':''},
                    @endif
                    {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_form.user)?'checked':''},
                ],
                cust_form:cust_form
            },
            watch: {
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });
        new Vue({
            el: '#setting-modal',
            methods: {
                showModal: function () {
                    // console.log('trr')
                    sm.$data.is_show = true
                }
            }
        });
        // custom part end 
    </script>
@endpush
