@extends('layouts.factor-master')

@section('content')
<?php

$report = customeReportNew('GeneralSaleReportCustomer_index');
$_record = !in_array('record', $report);
$_sale_number = !in_array('sale_number', $report);
$_date = !in_array('date', $report);
$_reference_number = !in_array('reference_number', $report);
$_description = !in_array('description', $report);
$_pump_number = !in_array('pump_number', $report);
$_class = !in_array('class', $report);
$_sale_area = !in_array('sale_area', $report);
$_customer = !in_array('customer', $report);
$_code = !in_array('code', $report);
$_site = !in_array('site', $report);
$_item_name = !in_array('item_name', $report);
$_quantity = !in_array('quantity', $report);
$_unit = !in_array('unit', $report);
$_unit_price = !in_array('unit_price', $report);
$_total_amount = !in_array('total_amount', $report);
$_total_cost_of_sale = !in_array('total_cost_of_sale', $report);
$_gross_profit_or_lost = !in_array('gross_profit_or_lost', $report);
$_rate = !in_array('rate', $report);
$_old_counter = !in_array('old_counter', $report);
$_new_counter = !in_array('new_counter', $report);


// dd($_record);

$report_percent = customeReportNewPercent('GeneralSaleReportCustomer_index');
    $_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
    $_sale_number_percent= (array_key_exists('sale_number___percent', $report_percent))?$report_percent['sale_number___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_reference_number_percent= (array_key_exists('reference_number___percent', $report_percent))?$report_percent['reference_number___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_pump_number_percent= (array_key_exists('pump_number___percent', $report_percent))?$report_percent['pump_number___percent']:null;
    $_class_percent= (array_key_exists('class___percent', $report_percent))?$report_percent['class___percent']:null;
    $_sale_area_percent= (array_key_exists('sale_area___percent', $report_percent))?$report_percent['sale_area___percent']:null;
    $_customer_percent= (array_key_exists('customer___percent', $report_percent))?$report_percent['customer___percent']:null;
    $_code_percent= (array_key_exists('code___percent', $report_percent))?$report_percent['code___percent']:null;
    $_site_account_percent= (array_key_exists('site___percent', $report_percent))?$report_percent['site___percent']:null;
    $_item_name_percent= (array_key_exists('item_name___percent', $report_percent))?$report_percent['item_name___percent']:null;
    $_quantity_percent= (array_key_exists('quantity___percent', $report_percent))?$report_percent['quantity___percent']:null;
    $_unit_percent= (array_key_exists('unit___percent', $report_percent))?$report_percent['unit___percent']:null;
    $_unit_price_percent= (array_key_exists('unit_price___percent', $report_percent))?$report_percent['unit_price___percent']:null;
    $_total_amount_percent= (array_key_exists('total_amount___percent', $report_percent))?$report_percent['total_amount___percent']:null;
    $_total_cost_of_sale_percent= (array_key_exists('total_cost_of_sale___percent', $report_percent))?$report_percent['total_cost_of_sale___percent']:null;
    $_gross_profit_or_lost_percent= (array_key_exists('gross_profit_or_lost___percent', $report_percent))?$report_percent['gross_profit_or_lost___percent']:null;
    $_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
    $_old_counter_percent= (array_key_exists('old_counter___percent', $report_percent))?$report_percent['old_counter___percent']:null;
    $_new_counter_percent= (array_key_exists('new_counter___percent', $report_percent))?$report_percent['new_counter___percent']:null;
    
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.GeneralSaleReportCustomer')</h3>

<table>
@if($from_date || $to_date)
<tr>
  @if($from_date)
  <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
@endif
</table>
<table class="main-table" style="margin: 6px 0px;" >
@if($ClassName)
<tr>
  <td>
    <span>@lang('menu.FinancialClass')</span>: {{$ClassName}}
  </td>
</tr>
@endif
</table>

@if($inventory_site_name || $area_name || $member_class_name || $member_name)
<table class="main-table" style="margin: 6px 0px;" >
   
    <tr>
      @if($inventory_site_name)
      <td>
        <span>@lang('layout.SiteName')</span>: {{$inventory_site_name}}
      </td>
      @endif
      @if($area_name)
      <td>
        <span>@lang('layout.SaleArea')</span>: {{$area_name}}
      </td>
      @endif
      @if($member_class_name)
      <td>
        <span>@lang('layout.MemberClass')</span>: {{$member_class_name}}
      </td>
      @endif
   
      @if($member_name)
      <td>
        <span>@lang('layout.Member')</span>: {{$member_name}}
      </td>
      @endif
      
    </tr>
   
</table>
@endif


<table class="main-table">

  <thead>
    <tr class="bg">
      @if($_record)
      <td class="center" @if($_record_percent) width="{{$_record_percent}}%" @endif >
        <div> @lang('layout.Record') </div>
      </td> @endif
      @if($_sale_number)
      <td class="center" @if($_sale_number_percent) width="{{$_sale_number_percent}}%" @endif >
        <div> @lang('layout.SaleNumber') </div>
      </td> @endif
      @if($_date)
      <td class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif >
        <div> @lang('layout.Date')</div>
      </td> @endif
     
      @if($_reference_number)
      <td class="center" @if($_reference_number_percent) width="{{$_reference_number_percent}}%" @endif >
        <div> @lang('layout.ReferenceNumber') </div>
      </td> @endif
      @if($_description)
      <td class="center" @if($_description_percent) width="{{$_description_percent}}%" @endif >
        <div> @lang('layout.Description') </div>
      </td> @endif
      @if(systemConfig()[27] == 1)
      @if($_pump_number)
      <td class="center" @if($_pump_number_percent) width="{{$_pump_number_percent}}%" @endif >
        <div> @lang('layout.PumpNumber') </div>
      </td> @endif
      @endif
      @if(!$member_class_name)
      @if($_class)
      <td class="center" @if($_class_percent) width="{{$_class_percent}}%" @endif >
        <div> @lang('layout.Class')</div>
      </td> @endif
      @endif
      @if(getSaleArea()=="true")
      @if(!$area_name)
      @if($_sale_area)
      <td class="center" @if($_sale_area_percent) width="{{$_sale_area_percent}}%" @endif >
        <div> @lang('layout.SaleArea')</div>
      </td> @endif
      @endif
      @endif
      @if(!$member_name)
      @if($_customer)
      <td class="center" @if($_customer_percent) width="{{$_customer_percent}}%" @endif >
        <div> @lang('layout.Customer')</div>
      </td> 
      @endif
      @if($_code)
      <td class="center" @if($_code_percent) width="{{$_code_percent}}%" @endif >
        <div> @lang('layout.Code')</div>
      </td> 
      @endif
      @endif
      
      @if(!$inventory_site_name)
      @if($_site)
      <td class="center" @if($_site_account_percent) width="{{$_site_account_percent}}%" @endif >
        <div> @lang('layout.Site')</div>
      </td> @endif
      @endif
      @if($_item_name)
      <td class="center" @if($_item_name_percent) width="{{$_item_name_percent}}%" @endif >
        <div> @lang('layout.ItemName')</div>
      </td> @endif
   
      @if(systemConfig()[27] == 1)
      @if($_old_counter)<td  @if($_old_counter_percent) width="{{$_old_counter_percent}}%" @endif><div class="center"> @lang('layout.OldCounter') </div></td>@endif
      @if($_new_counter)<td  @if($_new_counter_percent) width="{{$_new_counter_percent}}%" @endif><div class="center"> @lang('layout.NewCounter') </div></td>@endif
      @endif
      
      @if($_quantity)
      <td class="center" @if($_quantity_percent) width="{{$_quantity_percent}}%" @endif >
        <div> @lang('layout.Quantity')</div>
      </td> @endif

      @if($_unit)
      <td class="center" @if($_unit_percent) width="{{$_unit_percent}}%" @endif >
        <div> @lang('layout.Unit')</div>
      </td> @endif
      @if($_unit_price)
      <td class="center" @if($_unit_price_percent) width="{{$_unit_price_percent}}%" @endif >
        <div> @lang('layout.UnitPrice')</div>
      </td> @endif
      @if($_total_amount)
      <td class="center" @if($_total_amount_percent) width="{{$_total_amount_percent}}%" @endif >
        <div> @lang('layout.Amount')</div>
      </td> @endif
      <td class="center" >
        <div> @lang('layout.DiscountAmount')</div>
      </td>
      @if($_total_amount)
      <td class="center" @if($_total_amount_percent) width="{{$_total_amount_percent}}%" @endif >
        <div> @lang('layout.TotalAmount')</div>
      </td> @endif
      @if($_total_cost_of_sale)
      <th class="center" @if($_total_cost_of_sale_percent) width="{{$_total_cost_of_sale_percent}}%" @endif ><div> @lang('layout.TotalCostOfSale')</div></th> @endif
      @if($_gross_profit_or_lost)
      <th class="center" @if($_gross_profit_or_lost_percent) width="{{$_gross_profit_or_lost_percent}}%" @endif ><div> @lang('layout.GrossProfitORLost')</div></th> @endif
      @if($_unit)
      <td class="center" @if($_unit_percent) width="{{$_unit_percent}}%" @endif >
        <div> @lang('layout.Unit')</div>
      </td> @endif
      @if($_rate)
      <td class="center" @if($_rate_percent) width="{{$_rate_percent}}%" @endif >
        <div> @lang('layout.Rate')</div>
      </td> @endif
 
    </tr>
  </thead>
  <?php
  $count = 0;
  $total_home_currency = 0;
  $total_discount = 0;
  $total_assetAmount = 0;
  $currencies = [];
  $all_items = [];
  $all_zero_items = [];
  $total_by_class_name = [];
  ?>
  @foreach($data AS $record)

  <tr>
    <?php
    $total_home_currency += ($record->Amount / $record->rate);
    $total_discount += ($record->discountAmount / $record->rate);
    $total_assetAmount += ($record->assetAmount / $record->rate);

    if (array_key_exists($record->Currency, $currencies)) {
      $currencies[$record->Currency] = $currencies[$record->Currency] + $record->Amount;
    } else {

      $currencies[$record->Currency] = $record->Amount;
    }

    if (($record->Amount - $record->discountAmount) > 0) {
      if (array_key_exists($record->item_name, $all_items)) {
        $all_items[$record->item_name]['quantityOut'] = $all_items[$record->item_name]['quantityOut'] + $record->quantityOut;
        $all_items[$record->item_name]['Amount'] = $all_items[$record->item_name]['Amount'] + ($record->Amount / $record->rate);
        $all_items[$record->item_name]['discountAmount'] = $all_items[$record->item_name]['discountAmount'] + ($record->discountAmount / $record->rate);
        $all_items[$record->item_name]['assetAmount'] = $all_items[$record->item_name]['assetAmount'] + ($record->assetAmount / $record->rate);
      } else {
        $all_items[$record->item_name]['code'] = $record->code;
        $all_items[$record->item_name]['um'] = $record->um;
        $all_items[$record->item_name]['quantityOut'] = $record->quantityOut;
        $all_items[$record->item_name]['Amount'] = ($record->Amount / $record->rate);
        $all_items[$record->item_name]['discountAmount'] = ($record->discountAmount / $record->rate);
        $all_items[$record->item_name]['assetAmount'] = ($record->assetAmount / $record->rate);
      }
    } else {
      if (array_key_exists($record->item_name, $all_zero_items)) {
        $all_zero_items[$record->item_name]['quantityOut'] = $all_zero_items[$record->item_name]['quantityOut'] + $record->quantityOut;
        $all_zero_items[$record->item_name]['Amount'] = $all_zero_items[$record->item_name]['Amount'] + ($record->Amount / $record->rate);
        $all_zero_items[$record->item_name]['discountAmount'] = $all_zero_items[$record->item_name]['discountAmount'] + ($record->discountAmount / $record->rate);
        $all_zero_items[$record->item_name]['assetAmount'] = $all_zero_items[$record->item_name]['assetAmount'] + ($record->assetAmount / $record->rate);
      } else {
        $all_zero_items[$record->item_name]['code'] = $record->code;
        $all_zero_items[$record->item_name]['um'] = $record->um;
        $all_zero_items[$record->item_name]['quantityOut'] = $record->quantityOut;
        $all_zero_items[$record->item_name]['Amount'] = ($record->Amount / $record->rate);
        $all_zero_items[$record->item_name]['discountAmount'] = ($record->discountAmount / $record->rate);
        $all_zero_items[$record->item_name]['assetAmount'] = ($record->assetAmount / $record->rate);
      }
    }
    
    if (array_key_exists($record->className, $total_by_class_name)) {
      $total_by_class_name[$record->className] = $total_by_class_name[$record->className] + $record->exchanged_amount;
    } else {

      $total_by_class_name[$record->className] = $record->exchanged_amount;
    }
    ?>
    
    
    @if($_record)
    <td class="center">{{++$count}}</td>@endif
    @if($_sale_number)
    <td class="center">{{$record->Number}}</td>@endif
    @if($_date)

    <td class="center">{{convertDate($record->Date)}}</td>@endif
    @if($_reference_number)
    <td class="center">{{$record->refNo}}</td>@endif
    @if($_description)
    <td class="center">{{$record->description}}</td>@endif
    @if(systemConfig()[27] == 1)
    @if($_pump_number)
    <td class="center">{{$record->pump_number}}</td>@endif
    @endif
    @if(!$member_class_name)
    @if($_class)
    <td class="center">{{$record->className}}</td>@endif
    @endif
    @if(getSaleArea()=="true")
    @if(!$area_name)
    @if($_sale_area)
    <td class="center">{{$record->areaName}}</td>@endif
    @endif
    @endif
    @if(!$member_name)
    @if($_customer)
    <td class="center">{{$record->Name}}</td>@endif
    @if($_code)
    <td class="center">{{$record->code}}</td>
    @endif
    @endif
    @if(!$inventory_site_name)
    @if($_site)
    <td class="center">{{$record->site_name}}</td>@endif
    @endif
   
    @if($_item_name)
    <td class="center">{{$record->item_name}}</td>@endif

   
    @if(systemConfig()[27] == 1)
  @if($_old_counter)<td  class="center">{{$record->old_oil_counter}}</td>@endif
  @if($_new_counter)<td  class="center">{{$record->new_oil_counter}}</td>@endif
  @endif
    
  @if($_quantity)
  <td class="center">{{$record->quantityOut}}</td>@endif
  
    @if($_unit)
    <td class="center">{{$record->um}}</td>@endif
    @if($_unit_price)
    <td class="center">{{myRound($record->PerAmount)}}</td>@endif
    @if($_total_amount)
    <td class="center">{{myRound($record->Amount)}}</td>@endif
    <td class="center">{{myRound($record->discountAmount)}}</td>
    @if($_total_amount)
    <td class="center">{{myRound($record->Amount - $record->discountAmount)}}</td>@endif
    @if($_total_cost_of_sale)
    <td  class="center">{{myRound($record->assetAmount)}}</td>@endif
    @if($_gross_profit_or_lost)
    <td  class="center">{{myRound($record->Amount - $record->discountAmount - $record->assetAmount)}}</td>@endif
    @if($_unit)
    <td class="center">{{$record->Unit}}</td>@endif
    @if($_rate)
    <td class="center">{{myRound($record->rate)}}</td>@endif



  </tr>
  @endforeach
</table>

@if (count($all_items) > 0)
<h3 class="table-caption" style="text-align: center;">@lang('layout.TotalSale')</h3>

<table class="main-table">

  <thead>
    <tr class="bg">
      <td>
        <div class="center"> @lang('layout.Record') </div>
      </td>
      <td>
        <div class="center"> @lang('layout.Code')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.ItemName')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Unit')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Quantity')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Amount') {{getHomeCurrency()[getCurrencyType()]}}</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Total') @lang('layout.Discount') {{getHomeCurrency()[getCurrencyType()]}}</div>
      </td>
      <th><div class="center"> @lang('layout.TotalCostOfSale') {{getHomeCurrency()[getCurrencyType()]}}</div></th>
      <th><div class="center"> @lang('layout.GrossProfitORLost') {{getHomeCurrency()[getCurrencyType()]}}</div></th>

    </tr>
  </thead>
  <?php
  $count = 0;
  ?>
  @foreach($all_items AS $key => $record)
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record['code']}}</td>
    <td class="center">{{$key}}</td>
    <td class="center">{{$record['um']}}</td>
    <td class="center">{{myRound($record['quantityOut'])}}</td>
    <td class="center">{{myRound($record['Amount'])}}</td>
    <td class="center">{{myRound($record['discountAmount'])}}</td>
    <td class="center">{{myRound($record['assetAmount'])}}</td>
    <td class="center">{{myRound($record['Amount'] - $record['discountAmount'] - $record['assetAmount'])}}</td>

  </tr>
  @endforeach
</table>
@endif

@if (count($all_zero_items) > 0)
<h3 class="table-caption" style="text-align: center;">@lang('layout.TotalSaleByAllDiscount')</h3>

<table class="main-table">

  <thead>
    <tr class="bg">
      <td>
        <div class="center"> @lang('layout.Record') </div>
      </td>
      <td>
        <div class="center"> @lang('layout.Code')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.ItemName')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Unit')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Quantity')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Amount') {{getHomeCurrency()[getCurrencyType()]}}</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Total') @lang('layout.Discount') {{getHomeCurrency()[getCurrencyType()]}}</div>
      </td>
      <th><div class="center"> @lang('layout.TotalCostOfSale') {{getHomeCurrency()[getCurrencyType()]}}</div></th>
      <th><div class="center"> @lang('layout.GrossProfitORLost') {{getHomeCurrency()[getCurrencyType()]}}</div></th>

    </tr>
  </thead>
  <?php
  $count = 0;
  ?>
  @foreach($all_zero_items AS $key1 => $record1)
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record1['code']}}</td>
    <td class="center">{{$key1}}</td>
    <td class="center">{{$record1['um']}}</td>
    <td class="center">{{myRound($record1['quantityOut'])}}</td>
    <td class="center">{{myRound($record1['Amount'])}}</td>
    <td class="center">{{myRound($record1['discountAmount'])}}</td>
    <td class="center">{{myRound($record1['assetAmount'])}}</td>
    <td class="center">{{myRound($record1['Amount'] - $record1['discountAmount'] - $record1['assetAmount'])}}</td>

  </tr>
  @endforeach
</table>
@endif

<?php
$total_refund_amount = 0;
$total_refund_assat = 0;
?>
@if($summaryRefund)
@if(count($summaryRefund)>0)
<h3 style="text-align: center;">@lang('layout.Total') @lang('layout.Refund')</h3>

<table class="main-table">

  <thead>
    <tr class="bg">
      <td>
        <div class="center"> @lang('layout.Record') </div>
      </td>
      <td>
        <div class="center"> @lang('layout.Date')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.ItemName')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Quantity')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Unit')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Amount') {{getHomeCurrency()[getCurrencyType()]}}</div>
      </td>
      <td>
        <div class="center"> @lang('layout.UnitCost') {{getHomeCurrency()[getCurrencyType()]}}</div>
      </td>

    </tr>
  </thead>
  <?php
  $count = 0;
  $total_refund_amount = 0;
  $total_refund_assat = 0;
  ?>
  @foreach($summaryRefund AS $record)

  <?php
  $total_refund_amount += $record->Amount;
  $total_refund_assat += $record->total_asset;
  ?>

  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{convertDate($record->Date)}}</td>
    <td class="center">{{$record->item_name}}</td>
    <td class="center">{{$record->quantityIn}}</td>
    <td class="center">{{$record->um}}</td>
    <td class="center">{{myRound($record->Amount)}}</td>
    <td class="center">{{myRound($record->total_asset)}}</td>

  </tr>
  @endforeach
</table>
@endif
@endif


<h3 style="text-align: center;">@lang('layout.Total')</h3>

<table class="main-table">

  <tr class="bg">
    <td>
      <div class="center">@lang('layout.TotalAmount')</div>
    </td>
    <td>
      <div class="center">@lang('layout.Total') @lang('layout.Discount')</div>
    </td>
    <td>
      <div class="center">@lang('layout.Total') @lang('layout.Refund')</div>
    </td>
    <td>
      <div class="center">@lang('layout.TotalCostOfSale')</div>
    </td>
    <td>
      <div class="center">@lang('layout.GrossProfitORLost')</div>
    </td>
  </tr>
  <tr>
    <td>
      <div class="center">{{myRound($total_home_currency)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
    </td>
    <td>
      <div class="center">{{myRound($total_discount)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
    </td>
    <td>
      <div class="center">{{myRound($total_refund_amount - $total_refund_assat)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
    </td>
    <td>
      <div class="center">{{myRound($total_assetAmount)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
    </td>
    <td>
      <div class="center">{{myRound($total_home_currency - $total_refund_amount - $total_refund_assat - $total_discount - $total_assetAmount)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
    </td>
  </tr>
</table>


<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection