@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('sales');
$_date=in_array('date', $report);
$sale_number=in_array('sale_number', $report);
$_customer=in_array('customer', $report);
$_account_name=in_array('account_name', $report);
$_amount=in_array('amount', $report);
$_unit=in_array('unit', $report);
$_rate=in_array('rate', $report);
$_discount_type=in_array('discount_type', $report);
$_discount=in_array('discount', $report);
$_description=in_array('description', $report);


?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.SaleReport')</h3>

<table>
@if($from_date || $to_date)
<tr>
  <td><span>@lang('layout.FromDate'):</span>{{convertDate($from_date)}}</td>
  <td><span>@lang('layout.ToDate'):</span>{{convertDate($to_date)}}</td>
</tr>
@endif
</table>
<table class="main-table" style="margin: 6px 0px;" >
@if($ClassName)
<tr>
  <td>
    <span>@lang('menu.FinancialClass')</span>: {{$ClassName}}
  </td>
</tr>
@endif
</table>

<table class="main-table">
<thead>
  <tr class="bg" >
   <th style="height: 55px" rowspan="2"><div class="center" ><b> @lang('layout.SNo')</b> </div></th>
   <th style="height: 55px" rowspan="2"><div class="center" ><b> @lang('layout.Customer')</b> </div></th>
   <th style="height: 55px" rowspan="2"><div class="center" ><b> @lang('layout.Phone')</b> </div></th>
   <th style="height: 55px" rowspan="2"><div class="center" ><b> @lang('layout.Location')</b> </div></th>
   <th style="height: 55px" rowspan="2"><div class="center" ><b> @lang('layout.Address')</b> </div></th>
   <th style="height: 55px" rowspan="2"><div class="center" ><b> @lang('layout.ChannelType')</b> </div></th>
   @if(getSaleArea()=="true")
   <th style="height: 55px" rowspan="2"><div class="center" ><b> @lang('layout.SaleArea')</b> </div></th>
   @endif
   <th style="height: 55px" colspan="4"><div class="center" ><b> @lang('layout.Item')</b></div></th>
   <th style="height: 55px" colspan="3"><div class="center" ><b> @lang('layout.InvoiceCurrency')</b></div></th>
   <th style="height: 55px" colspan="3"><div class="center" ><b>{{homeCurrency()['code']}} @lang('layout.Amount')</b> </div></th>
   </tr>  
   <tr>
     <th style="height: 55px"><div class="center" ><b> @lang('layout.ItemName')</b></div></th>
     <th style="height: 55px"><div class="center" ><b> @lang('layout.Quantity')/Base</b></div></th>
       
     <th style="height: 55px"><div class="center" ><b> @lang('layout.Total')/{{($measure2)?$measure2->name:0}}</b></div></th>
     <th style="height: 55px"><div class="center" ><b> @lang('layout.Total')/{{($measure3)?$measure3->name:0}}</b></div></th>

     <th style="height: 55px"><div class="center" ><b> @lang('layout.TotalAmount')</b></div></th>
     <th style="height: 55px"><div class="center" ><b> @lang('layout.TotalReceivedAmount')</b></div></th>
     <th style="height: 55px"><div class="center" ><b> @lang('layout.LoanAmount')</b></div></th>

     <th style="height: 55px"><div class="center" ><b> @lang('layout.TotalAmount')</b></div></th>
     <th style="height: 55px"><div class="center" ><b> @lang('layout.TotalReceivedAmount')</b></div></th>
     <th style="height: 55px"><div class="center" ><b> @lang('layout.LoanAmount')</b></div></th>

   </tr>

</thead>
<?php
$count = 0;
$total_home_currency=0;
$currencies=[];

$totalItem=0;
$totalAmountCurrencyAll=0;
$totalReceivesInCurrency=0;
$totalAmountAll=0;
$totalReceivesInHomeCurrency=0;
$totalAmountReceptAll=0;
?>
@foreach($data AS $record)
    <?php
    $allSaleDetails = $record['Item'];
    $saleInfo       = $record['saleInfo'];
    $saleReceive    = $record['saleReceive'];
    $saleRecepts    = $record['saleRecepts'];
    $totalAmount = 0;
    $totalAmountCurrency=0;
    $totalReceived=0;

    $totalReceivesInCurrency+=$record['receivesInCurrency'];
    $totalReceivesInHomeCurrency+=$record['receivesInHomeCurrency'];

    // $totalAmountReceptAll+=$saleRecepts['amount']/$saleRecepts['rate'];


    ?>
<tr >


 <td class="center">{{$record['Number']}}</td>
 <td class="center">{{$record['Name']}}</td>
 <td class="center">{{$record['Phone']}}</td>
 <td class="center">{{$record['City']}}</td>
 <td class="center">{{$record['Address']}}</td>
 <td class="center">{{$record['className']}}</td>
 @if(getSaleArea()=="true")
 <td class="center">{{$record['areaName']}}</td>
 @endif

    <td  colspan="4">
      <table  style="width:100%">
   
    
    @foreach($allSaleDetails AS $row)
        <?php
        $totalAmount+=$row['qty']*$row['price'];
        $totalAmountAll+=$row['qty']*$row['price'];
        $totalItem+=$row['qty'];



        
        ?>
      <tr>
        <td class="center" style="border: none;">{{$row['name']}}</td>
        <td class="center"style="border: none;">{{myRound($row['qty'])}}</td>

        <td  class="center"style="border: none;">{{($measure1 && $measure2)?myRound(($row['qty']*$measure1->unit)/$measure2->unit):0}}</td> 

        <td  class="center"style="border: none;">{{($measure1 && $measure3)?myRound(($row['qty']*$measure1->unit)/$measure3->unit):0}}</td>
      </tr>
      @endforeach  
      </table>
    </td>

<!--------------------------------Sale Owne Currency  ------------------------------------------->
        @foreach($saleInfo as $info)   
          <?php
          $totalAmountCurrency+=($info['qty']*$info['price']);
          $totalAmountCurrencyAll+=($info['qty']*$info['price']);
          ?>
          @endforeach

        <td  colspan="3">
          <table  style="width:100%">
        
        

        <tr>
          <td class="center"  style="border: none;">{{myRound($totalAmountCurrency)}}</td>
          @if($record['Type'] == "Invoice")
          <td class="center" style="border: none;">{{myRound($record['receivesInCurrency'])}}</td>
          <td class="center" style="border: none;">{{myRound($totalAmountCurrency-$record['receivesInCurrency'])}}</td>
          @else
          <td class="center" style="border: none;">{{myRound($totalAmountCurrency)}}</td>
          <td class="center" style="border: none;">0</td>
          @endif
        </tr>
        </table>
        </td>
<!--------------------------------End Sale Owne Currency  ------------------------------------------->

<!----------------------------------- - ------------------------------------------------------------->
<!--------------------------------Sale Home Currency  ----------------------------------------------->
    <td  colspan="3">
      <table class="main-table" style="width:100%">
     
    

    <tr>
      <td class="center" >{{myRound($totalAmount)}}</td>
<!--------------------------------Sale Receives  ----------------------------------------------->
        @if($record['Type'] == "Invoice")
            <td width="60%">
              <table class="main-table" style="width:100%">
                <tr class="bg">
                  <td width="50%"><div class="center"> @lang('layout.Currency') </div></td>
                  <td width="50%"><div class="center"> @lang('layout.Rate') </div></td>
                  <td width="50%"><div class="center"> @lang('layout.Amount') </div></td>
                </tr>
         
          @foreach($saleReceive AS $recive)
            <?php
              
            ?>
            <tr>
              <td class="center">{{$recive['unit']}}</td>
              <td class="center">{{$recive['rate']}}</td>
              <td class="center">{{$recive['balance']}}</td>
            </tr>
             @endforeach
            <tr>
              <td class="center">@lang('layout.Total')</td>
              <td class="center">{{myRound($record['receivesInHomeCurrency'])}}</td>
            </tr>
            </table>
            </td>
          <td class="center">{{myRound($totalAmount-$record['receivesInHomeCurrency'])}}</td>
          @else
 
            <?php

            $totalAmountRecept=($saleRecepts['amount']/$saleRecepts['rate']);
            $totalAmountReceptAll+=($saleRecepts['amount']/$saleRecepts['rate']);

            ?>

          <td class="center">{{myRound($totalAmountRecept)}}</td>
          <td class="center">0</td>
          @endif
       
<!--------------------------------Sale Receives  ------------------------------------------------------>
    </tr>
    <tr></tr>
    </table>
    </td> 
<!----------------------------------- - ----------------------------------------------------------------->
<!--------------------------------End Sale Home Currency  ----------------------------------------------->

</tr>
@endforeach 
<!----------------------------------- - ---------------------------------------------------------------->
<!--------------------------------Begin Totals In Buttom  -----------------------------------------------> 
<tr >
  <td style="height: 40px" colspan="7"><b>@lang('layout.Total')</b></td>
  <td style="height: 40px">{{$totalItem}}</td>
  <td style="height: 40px">{{($measure1 && $measure2)?myRound(($totalItem*$measure1->unit)/$measure2->unit):0}}</td>
  <td style="height: 40px">{{($measure1 && $measure3)?myRound(($totalItem*$measure1->unit)/$measure3->unit):0}}</td>

<!--
  <td style="height: 40px">{{$totalAmountCurrencyAll}}</td>
  <td style="height: 40px">{{$totalReceivesInCurrency}}</td>
  <td style="height: 40px">{{$totalAmountCurrencyAll-$totalReceivesInCurrency}}</td>
-->
<td style="height: 40px" colspan="3"></td>

  <td style="height: 40px">{{$totalAmountAll}}</td>
  <td style="height: 40px">{{$totalReceivesInHomeCurrency+$totalAmountReceptAll}}</td>
  <td style="height: 40px">{{$totalAmountAll-($totalReceivesInHomeCurrency+$totalAmountReceptAll)}}</td>
</tr>
<!----------------------------------- - -------------------------------------------------------------->
<!--------------------------------End Totals In Buttom  ----------------------------------------------->  
</table>

<!--
<h3 class="table-caption" style="text-align: center;">@lang('layout.TotalSale')</h3>



<table class="main-table">

<thead>
  <tr class="bg">
 <td><div class="center"> #</div></td>
   @if($_date)<td><div class="center"> @lang('layout.Date')</div></td>@endif
 <td ><div class="center"> @lang('layout.ItemName')</div></td>
 <td ><div class="center"> @lang('layout.Quantity')</div></td>
 <td ><div class="center"> @lang('layout.Unit')</div></td>
   @if($_amount)<td><div class="center"> @lang('layout.Amount')</div></td>@endif
   @if($_unit)<td><div class="center"> @lang('layout.Unit')</div></td>@endif

 </tr>
</thead>
<?php
$count = 0;
?>
@foreach($summary AS $record)
<tr>
<td class="center">{{++$count}}</td>
 @if($_date)<td  class="center">{{convertDate($record->Date)}}</td>@endif
<td  class="center">{{$record->item_name}}</td>
<td  class="center">{{$record->quantityOut}}</td>
<td  class="center">{{$record->um}}</td>
 @if($_amount)<td class="center">{{round($record->Amount,2)}}</td>@endif
 @if($_unit)<td  class="center">{{getHomeCurrency()[getCurrencyType()]}}</td>@endif

</tr>
@endforeach   
</table>










<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center"> #</div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>
<tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{round($total_home_currency,2)}} {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>

</table>-->
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection