@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReportNew('sale_show');

$_item_name= !in_array('item_name', $report);
$_symbol= !in_array('symbol', $report);
$_purchase_date= !in_array('purchase_date', $report);
$_sleep_day= !in_array('sleep_day', $report);
$_quantity= !in_array('quantity', $report);
$_price= !in_array('price', $report);
$_purchase_rate= !in_array('purchase_rate', $report);
$_income= !in_array('income', $report);
$_total= !in_array('total', $report);
$_total_gross_profit= !in_array('total_gross_profit', $report);
$_model= !in_array('model', $report); 
$_color= !in_array('color', $report); 
$_location= !in_array('location', $report); 
$_commission_percentage= !in_array('commission_percentage', $report); 
$_commission_amount= !in_array('commission_amount', $report); 


$report_percent = customeReportNewPercent('sale_show');
    $_item_name_percent= (array_key_exists('item_name___percent', $report_percent))?$report_percent['item_name___percent']:null;
    $_symbol_percent= (array_key_exists('symbol___percent', $report_percent))?$report_percent['symbol___percent']:null;
    $_purchase_date_percent= (array_key_exists('purchase_date___percent', $report_percent))?$report_percent['purchase_date___percent']:null;
    $_sleep_day_percent= (array_key_exists('sleep_day___percent', $report_percent))?$report_percent['sleep_day___percent']:null;
    $_quantity_percent= (array_key_exists('quantity___percent', $report_percent))?$report_percent['quantity___percent']:null;
    $_price_percent= (array_key_exists('price___percent', $report_percent))?$report_percent['price___percent']:null;
    $_purchase_rate_percent= (array_key_exists('purchase_rate___percent', $report_percent))?$report_percent['purchase_rate___percent']:null;
    $_income_percent= (array_key_exists('income_costOfGood_sold___percent', $report_percent))?$report_percent['income_costOfGood_sold___percent']:null;
    $_total_percent= (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
    $_total_gross_profit_percent= (array_key_exists('total_gross_profit___percent', $report_percent))?$report_percent['total_gross_profit___percent']:null;
    $_model_percent= (array_key_exists('model__percent', $report_percent))?$report_percent['model__percent']:null; 
    $_color_percent= (array_key_exists('color___percent', $report_percent))?$report_percent['color___percent']:null; 
    $_location_percent= (array_key_exists('location___percent', $report_percent))?$report_percent['location___percent']:null; 
    $_commission_percentage_percent= (array_key_exists('commission_percentage___percent', $report_percent))?$report_percent['commission_percentage___percent']:null; 
    $_commission_amount_percent= (array_key_exists('commission_amount___percent', $report_percent))?$report_percent['commission_amount___percent']:null; 

    // dd($_item_name_percent);

$seePrice = \Entrust::can('price-create');
$seeCost = \Entrust::can('cost-create');


?>
<table  class="main-table">
 @if($info && $info !=[])

 <tr>
  <td>
    <span>@lang('layout.Number')</span>:
    <span>{{$info->number}}</span>
  </td>
   <td>
    <span>@lang('layout.ReferenceNumber')</span>:
    <span>{{$info->ref_Number}}</span>
  </td>
  <td>
    <span>@lang('layout.Customer')</span> :
    <span>{{$info->member_name}}</span>
  </td>
  <td>
    <span>@lang('layout.Account')</span>:
    <span>{{$info->account_name}}</span>
  </td>
  <td>
    <span>@lang('layout.Amount')</span>:
    <span>{{$info->amount}}</span>
  </td>
</tr>
<tr>

 <td>
  <span>@lang('layout.Currency')</span>:
  <span>{{$info->currency}}</span>
</td>
<td>
  <span>@lang('layout.Rate')</span>:
  <span>{{$info->rate}}</span>
</td>
<td>
  <span>@lang('layout.Discount')</span>:
  <span>{{$info->discount}}</span>
</td>

</tr>
@endif 
</table> 
    @if(getDriverInfo() == "true")
     @if($info)
      @if($info->transferCode!=null 
      || $info->driver!=null 
      || $info->sourcePlace!=null
      || $info->plateNumber!=null
      || $info->totalWeight!=null
      || $info->trDesription!=null
      ) 
        <h4>@lang('layout.DriverInfo')</h4>
        <table class="main-table"> 
            <tr>
                <th class="hidden-xs">
                    @lang('layout.TransferCode')
                </th>
                <th class="hidden-xs">
                    @lang('layout.Transporter_name')
                </th>
                <th>
                    @lang('layout.Transporter_phone')
                </th>
                <th>
                    @lang('layout.PlaceOfWeight')
                </th>
                <th>
                    @lang('layout.SourcePlace')
                </th>
            </tr>
            <tr>
                <td> {{$info->transferCode }}  </td>
                <td> {{$info->driver}}  </td>
                <td> {{$info->driverPhone}}  </td>
                <td> {{$info->PlaceOfWeight}}  </td>
                <td> {{$info->sourcePlace }}  </td>
            </tr>

        </table>
        <br>
        <table class="main-table">
            <tr>
                <th>
                    @lang('layout.PlateNumber')
                </th>
                <th>
                    @lang('layout.WayBillNumber')
                </th>
                <th>
                    @lang('layout.TotalWeight')
                </th>
                <th>
                    @lang('layout.EmptyCarWeight')
                </th>
                <th>
                    @lang('layout.TotalBori')
                </th>
                <th>
                    @lang('layout.Description')
                </th>
            </tr>
            <tr>
                <td> {{$info->plateNumber }}  </td>
                <td> {{$info->wayBillNumber }}  </td>
                <td> {{$info->totalWeight }}  </td>
                <td> {{$info->emptyCarWeight }}  </td>
                <td> {{$info->bori }}  </td>
                <td> {{$info->trDesription }}  </td>
            </tr>
        </table>
    @endif
    @endif
    @endif


<h3 class="table-caption" style="text-align: center;">@lang('layout.SaleseReport')</h3>
<table class="main-table">

<thead>
  <tr class="bg">
 <td class="center" ><div > @lang('layout.Record') </div></td>

  @if($_item_name)<th  @if($_item_name_percent) width="{{$_item_name_percent}}%" @endif>@lang('layout.ItemName')</th>@endif
  @if($_item_name)<th >@lang('layout.Site')</th>@endif
  @if(searchByCodeLocation()=="true")
    <th>@lang('layout.Location')</th>
  @endif
  @if(getSaleDescription()=="true") 
  @if($_model)
  <th  @if($_model_percent) width="{{$_model_percent}}%" @endif>@lang('layout.Model')</th>
   @endif 
   @if($_color)
   <th  @if($_color_percent) width="{{$_color_percent}}%" @endif>@lang('layout.Color')</th>
   @endif
   @endif 
  @if($_symbol) <th @if($_symbol_percent) width="{{$_symbol_percent}}%" @endif>@lang('layout.Symbol')</th>@endif
  @if($_purchase_date) <th @if($_purchase_date_percent) width="{{$_purchase_date_percent}}%" @endif>@lang('layout.PurchaseDate')</th>@endif
  @if($_sleep_day) <th @if($_sleep_day_percent) width="{{$_sleep_day_percent}}%" @endif>@lang('layout.SleepStaff')</th>@endif
  @if(getOtherMeasure()=="true")
    <th>@lang('layout.OMeasureValue1')</th>
    @endif
    @if(getOtherMeasure2()=="true")
    <th>@lang('layout.OMeasureValue2')</th>
    @endif
  @if($_quantity)<th @if($_quantity_percent) width="{{$_quantity_percent}}%" @endif>@lang('layout.Quantity')</th>@endif
  
  @if(getSaleCommission()=="true")
  @if($_commission_percentage)<th @if($_commission_percentage_percent) width="{{$_commission_percentage_percent}}%" @endif>@lang('layout.Commission') @lang('layout.Percentage')%</th>@endif
  @if($_commission_amount)<th @if($_commission_amount_percent) width="{{$_commission_amount_percent}}%" @endif>@lang('layout.Commission') @lang('layout.Amount')</th>@endif
  @endif

  @if($_price)<th @if($_price_percent) width="{{$_price_percent}}%" @endif>@lang('layout.Price')</th>@endif
  @if($seeCost==true)
    @if($_purchase_rate)<th @if($_purchase_rate_percent) width="{{$_purchase_rate_percent}}%" @endif>@lang('layout.Cost')</th>@endif
    @if($_income)<th @if($_income_percent) width="{{$_income_percent}}%" @endif>@lang('layout.Income')</th>@endif
  @endif
  @if($_total)<th @if($_total_percent) width="{{$_total_percent}}%" @endif>@lang('layout.Total')</th>@endif

</tr>
</thead>
<?php
$count = 0;
$total_profit=0;
?>
@foreach($data AS $record) 
            <?php
               if(systemConfig()[30] == 1){
                   $total_profit += $record->income*$record->static_rate / $record->sale_rate;
                }else{
                    $total_profit +=$record->income*$record->sale_rate;
               }

            ?>
<tr>
<td  class="center">{{++$count}}</td>


@if($_item_name)<td class="center">{{$record->name}}</td>@endif
@if($_item_name)<td class="center">{{$record->siteName}}</td>@endif
@if(searchByCodeLocation()=="true")<td  class="center"> {{$record->location}}</td>@endif
@if(getSaleDescription()=="true") 
@if($_model)
<td  class="center">{{$record->model}}</td>
@endif 
@if($_color)
<td  class="center">{{$record->color}}</td>
@endif
@endif  
@if($_symbol)<td  class="center">{{$record->symbol}}</td>@endif
@if($_purchase_date)<td class="center">{{$record->stocks_date}}</td>@endif
@if($_sleep_day)<td  class="center">{{$record->sleepDate}}</td>@endif
@if(getOtherMeasure()=="true")
<td  class="center">{{$record->other_measure}}</td>
@endif
@if(getOtherMeasure2()=="true")
<td  class="center">{{$record->other_measure2}}</td>
@endif
@if($_quantity)<td  class="center">{{$record->qty}}</td>@endif
@if(getSaleCommission()=="true")
@if($_commission_percentage)<td  class="center">{{$record->row_commission_percent}}   </td>@endif
 
@if(systemConfig()[30] == 1)
@if($record->row_commission_percent)
@if($_commission_amount)<td  class="center">{{ myRound(($record->qty * $record->price * $record->static_rate / $record->sale_rate) * $record->row_commission_percent / 100) }}   </td>@endif
@else 
<td></td>
@endif 
@else 
@if($record->row_commission_percent)
@if($_commission_amount)<td  class="center">{{ myRound(($record->qty * $record->price * $record->sale_rate) * ($record->row_commission_percent) / 100)  }}   </td>@endif
@else 
<td></td>
@endif 
@endif
@endif  

@if(systemConfig()[30] == 1)
@if($_price)<td  class="center">{{myRound($record->price*$record->static_rate / $record->sale_rate)}}</td>@endif
@else 
@if($_price)<td  class="center">{{myRound($record->price*$record->sale_rate)}}</td>@endif
@endif
@if($seeCost==true)
@if(systemConfig()[30] == 1)
    @if($_purchase_rate)<td  class="center">{{myRound(($record->avgCost*$record->saleUnit)/$record->itemUnit*$record->static_rate / $record->sale_rate)}}</td>@endif
@else 
    @if($_purchase_rate)<td  class="center">{{myRound(($record->avgCost*$record->saleUnit)/$record->itemUnit*$record->sale_rate)}}</td>@endif
@endif
    @if(systemConfig()[30] == 1)
    @if($_income)<td  class="center">{{myRound($record->income*$record->static_rate / $record->sale_rate)}}</td>@endif
    @else 
    @if($_income)<td  class="center">{{myRound($record->income*$record->sale_rate)}}</td>@endif
    @endif 
@endif
@if(systemConfig()[30] == 1)
@if($_total)<td  class="center">{{myRound($record->qty*$record->price*$record->static_rate / $record->sale_rate)}}</td>@endif
@else 
@if($_total)<td  class="center">{{myRound($record->qty*$record->price*$record->sale_rate)}}</td>@endif
@endif

</tr>
@endforeach   
</table>



<br>
@if($seeCost==true)
    @if($info && $info !=[])
    @if($_total_gross_profit )
        <table class="main-table" style="width: 30%">
            <tr class="bg">
                <td colspan="2"><b>@lang('layout.TotalGrossProfit')</b></td>
                
            </tr>
            <tr>
                <td >{{myRound($total_profit)}}</td>
                <td >{{$info->currency}}</td>
            </tr>
        </table>
        @endif
        @endif
@endif




 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection