@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>
    .dstyle {
        /* background-color: rgb(84, 199, 211); */
        text-align: center;
        /* color: white */
    }
    .v-select.searchable .dropdown-toggle .form-control {
        width: 100% !important;
    }
</style>
@stop
@section('content')
@include("layouts.Cmodal")
<div class="row">
    <div class="portlet light bordered">
        <!-- BEGIN TAB PORTLET-->
        <div class="portlet light bordered sale">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.SalesReceiptes')</span>
                </div>
                <div class="actions">
                </div>
            </div>
            <div id="app" class="portlet-body">

                <div class="tabbable tabbable-tabdrop">
                    <div>
                        {{Form::model($sale,['route' => ['sale.add_store',$sale->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'sales-form'])}}
                        {{ csrf_field() }}
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                    <!-- BEGIN FORM-->


                                    <div class="form-body">
                                        <div class="row">
                                            <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                                                <div class="row">
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" style="padding-right: 3px !important; padding-left: 3px !important;" >
                                                        <table>
                                                            <tr>
                                                                <td class="dstyle" width="30%" >@lang('layout.Customer')</td>
                                                                <td class="highlight">
                                                                    <!-- <div class="input-group"> -->
                                                                        <v-select label="name" @input="memberChange()" :options="customer" @search="MemberSearch" v-model="selected_customer" disabled></v-select>
                                                                        <input type="hidden" name="customer" :value="!selected_customer?null:selected_customer.id" required>
                                                                        <!-- <span class="btn btn-success input-group-addon " @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                                            <i class="fa fa-plus" style="color: white"></i>
                                                                        </span>
                                                                    </div> -->
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="dstyle" width="30%" >@lang('layout.Currency')</td>
                                                                <td class="highlight">
                                                                    <v-select label="code" @input="selectedRate" :options="currency" v-model="selected_currency" disabled></v-select>
                                                                    <input type="hidden" name="currency" :value="selected_currency.code">
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="dstyle" width="30%" >@lang('layout.Rate')</td>
                                                                <td class="highlight">
                                                                    <input type="number" name="currency_rate" name="rate" v-model="!selected_currency?0:selected_currency.rate" readonly class="form-control" :class="{'has-error':rate<=0}">

                                                                    @if(getCompanyTag() != 1)
                                                                    <input type="hidden" name="currency_rate_hq" v-model="!selected_currency?0:selected_currency.hq_rate">
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="dstyle" width="30%" >@lang('layout.Discount')</td>
                                                                <td class="highlight">
                                                                    <div class="input-group">

                                                                        <input v-model="discountFiled" class="form-control" type="number" min="0" max="100" readonly>
                                                                        <span v-if="discountIsAmount" @click="discountIsAmount = !discountIsAmount"  class="input-group-addon">@{{selected_currency.symbol}}
                                                                            <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                                                        </span>
                                                                        <span v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon">%
                                                                            <input type="hidden" name="discount_type" value="percent">
                                                                        </span>
                                                                        <input type="hidden" name="discountTotal" :value="discount">
                                                                        <input type="hidden" name="discount" :value="discountFiled">
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" style="padding-right: 3px !important; padding-left: 3px !important;" >
                                                        <table>
                                                            <tr v-show="showWhat('descriptionASMemberName')=='yes'">
                                                                <td class="dstyle" width="30%" >@lang('layout.OtherMemberName')</td>
                                                                <td class="highlight">
                                                                    <input type="text" name="other_member_name" value="{{$sale->other_member_name}}" class="form-control">
                                                                </td>
                                                            </tr>
                                                            @if(getShwoPriceLevel()=="general")

                                                            <tr>
                                                                <td class="dstyle" width="30%" >@lang('layout.PriceLevel')</td>
                                                                <td class="highlight">
                                                                    <v-select label="name" :options="priceLevel" v-model="selected_priceLevel">
                                                                    </v-select>
                                                                    <input type="hidden" name="price_level_id" :value="!selected_priceLevel?null:selected_priceLevel.id">
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            @if(getShwoPriceLevel()=="general_percent")
                                                            <tr>
                                                                <td class="dstyle" width="30%" >@lang('layout.PriceLevel')</td>
                                                                <td class="highlight">
                                                                    <v-select label="name" :options="priceLevelGeneral" v-model="selected_priceLevelGeneral">
                                                                    </v-select>
                                                                    <input type="hidden" name="price_level_id" :value="!selected_priceLevelGeneral?null:selected_priceLevelGeneral.id">
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            <tr>
                                                                <td class="dstyle" width="30%" >@lang('layout.Description')</td>
                                                                <td class="highlight">
                                                                    <textarea name="description" class="form-control" rows="2">{{$sale->description}}</textarea>
                                                                </td>
                                                            </tr>
                                                            @if(systemConfig()[20] == 1)
                                                            <tr>
                                                                <td class="dstyle" width="30%" >@lang('layout.Contract')</td>
                                                                <td class="highlight">
                                                                    <div class="form-control">
                                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                                            <input type="checkbox" name="contract_check" v-model="contract_check">
                                                                            <span></span>
                                                                        </label>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            @if(getFactorPending()=="true")
                                                            <!-- <tr>
                                                                <td class="dstyle">@lang('layout.Factor') @lang('layout.Pending')</td>
                                                                <td class="highlight">
                                                                <div class="form-control">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="pending" value="on" <?php if($sale->pending == 'on'){ echo "checked"; } ?> >
                                                                    <span></span>
                                                                </label>
                                                                </div>
                                                                </td>
                                                            </tr> -->
                                                            @endif
                                                        </table>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" style="padding-right: 3px !important; padding-left: 3px !important;" >
                                                        <table>
                                                            <tr>
                                                                <td class="dstyle" width="30%" >@lang('layout.InvoiceNumber')</td>
                                                                <td class="highlight">
                                                                    <input type="number" name="number" value="{{$sale->number}}" readonly class="form-control">
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="dstyle" width="30%" >@lang('layout.ReferenceNumber')</td>
                                                                <td class="highlight">
                                                                    <input type="text" name="ref_no" v-model="ref_no" class="form-control" readonly @input="checkRefNo()">
                                                                    <span v-if="isError1 ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="dstyle" width="30%" >@lang('layout.Account')</td>
                                                                <td class="highlight">
                                                                    <v-select label="name" :options="approperiateBank" disabled v-model="selected_banks"></v-select>
                                                                    <input type="hidden" name="bank_account" :value="(this.selected_banks==null)?null:selected_banks.id">
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="dstyle" width="30%" >@lang('layout.Date')</td>
                                                                <td class="highlight">

                                                                    <input type="text" name="date" value="{{$sale->date}}" class="form-control date" autocomplete="off">
                                                                </td>
                                                            </tr>
                                                            @if(getActiveSale()=="true")
                                                            <tr>
                                                                <td class="dstyle">@lang('layout.Category')</td>
                                                                <td class="highlight">
                                                                    <select name="category" v-model="category" readonly class="form-control" >
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="Sauna">@lang('layout.Sauna')</option>
                                                                        <option value="Restaurant">@lang('layout.Restaurant')</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                            @endif
                                                        </table>
                                                    </div>
                                                    
                                                </div>
                                            </div>
                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" v-show="seePrice == true">
                                            
                                            <!-- begin total -->
                                            <div class="dashboard-stat2 ">
                                                <table class="dashboard-tabel" width="100%">
                                                    <tr>
                                                        <td>
                                                            <small>@lang('layout.Total') :</small>
                                                        </td>
                                                        <td class="text-right"><span data-counter="counterup" data-value="7800">@{{ Number.parseFloat((subtotal - (discount*(subtotal - discountFiledRow)/100) - discountFiledRow)-payeds).toFixed(precision())}}</span>
                                                            <small class="font-green-sharp">
                                                                @{{selected_currency.symbol}}
                                                            </small>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td>
                                                            <small>@lang('layout.Discount'): (@{{
                                                                        Number.parseFloat(discount).toFixed(precision())
                                                                        }}%)
                                                            </small>
                                                        </td>
                                                        <td class="text-right">
                                                            <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number.parseFloat(discount*(subtotal - discountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}</span>
                                                            <small class="font-green-sharp">
                                                                @{{selected_currency.symbol}}
                                                            </small>
                                                        </td>
                                                    </tr>

                                                    <!--      <tr>
                                              <td>
                                                  <small>@lang('layout.Payment'):</small>
                                              </td>
                                              <td class="text-right">
                                                  <small class="font-green-sharp">
                                                      <span class="text-right" data-counter="counterup"
                                                      data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                      <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                                  </small>
                                              </td>
                                          </tr>
                                      -->

                                                    <tr>
                                                        <td>
                                                            <small>@lang('layout.Sub-Total'):</small>
                                                        </td>
                                                        <td class="text-right">
                                                            <span class="text-right" data-counter="counterup" data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                                            <small class="font-green-sharp">
                                                                @{{selected_currency.symbol}}
                                                            </small>
                                                        </td>
                                                    </tr>


                                                </table>

                                            </div>

                                            <!-- end total -->
                                        </div>

                                    </div>
                                    <br/>
                                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                                        <table id="table_content" class="table table-bordered table-advance table-hover">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                                    <th v-show="showWhat('inventory_brand')=='yes'" style="min-width: 130px">@lang('layout.Brand') </th>
                                                    @if(getSerailNumber() =="true")
                                                    <th style="min-width: 80px">@lang('layout.SerialNum') </th>
                                                    @endif
                                                    <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                                                    @if(searchByCodeLocation()=="true")
                                                    <th style="min-width: 110px;">@lang('layout.Location')</th>
                                                    @endif
                                                    <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                                    <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                                    <th v-show="showWhat('sale_description2')=='yes'">@lang('layout.Description')
                                                        :2
                                                    </th>
                                                    <th style="min-width: 50px">@lang('layout.Quantity') </th>
                                                    <th style="min-width: 100px">@lang('layout.OnHand') </th>

                                                    <th v-show="showWhat('other_measure')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue1')
                                                    </th>
                                                    <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue2')
                                                    </th>
                                                    <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                    <th v-show="seeCost == true" style="min-width: 30px">@lang('layout.CostInInventory') </th>

                                                    @if(getShwoPriceLevel()=="per_item")
                                                    <th style="min-width: 100px">@lang('layout.PriceLevel') </th>
                                                    @endif
                                                    @if(getShwoPriceLevel()=="general_percent_per_item")
                                                    <th style="min-width: 100px">@lang('layout.PriceLevel') </th>
                                                    @endif
                                                    <th v-show="seePrice == true" style="min-width: 50px">@lang('layout.NewPrice') </th>
                                                    @if(getM2()!="")
                                                    @if(getFactorMeasure2()=="true")
                                                    <th style="min-width: 100px">@lang('layout.Measure2') </th>
                                                    @endif
                                                    @endif
                                                    @if(getSubMeasure()=="true")
                                                    <th style="min-width: 100px">@lang('layout.EquivalentTo') </th>
                                                    @endif
                                                    @if(getM3()!="" && getSubMeasure()!="true")
                                                    @if(getFactorMeasure3()=="true")
                                                    <th style="min-width: 100px">@lang('layout.Measure3') </th>
                                                    @endif
                                                    @endif
                                                    @if(getM4()!="")
                                                    @if(getFactorMeasure4()=="true")
                                                    <th style="min-width: 100px">@lang('layout.Measure4') </th>
                                                    @endif
                                                    @endif

                                                    <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 50px">@lang('layout.Discount') </th>
                                                    <th v-show="seePrice == true" style="min-width: 100px">@lang('layout.Total') </th>
                                                    <th></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr v-for="(item,index) in inventories">
                                                    <td>@{{index+1}}</td>
                                                    <td v-show="showWhat('sale_category')=='yes'">
                                                        <v-select label="name" v-model="item.item_category" :options="inventory_category" @Click.native="itemCategoryChange(index)" @keyup.native="itemCategoryChange(index)"></v-select>
                                                        <input type="hidden" name="inventory_category_id[]" :value="(!item.item_category)?null:item.item_category.id">
                                                    </td>
                                                    <td v-show="showWhat('inventory_brand')=='yes'">
                                                        <v-select label="name" v-model="item.item_brand" :options="brandItem" @Click.native="itemBrandChange(index)" @keyup.native="itemBrandChange(index)"></v-select>
                                                        <input type="hidden" name="inventory_brand_id[]" :value="(!item.item_brand)?null:item.item_brand.id">
                                                    </td>
                                                    @if(getSerailNumber() =="true")
                                                    <td>
                                                        @{{(!item.item)?null:item.item.number}}
                                                    </td>
                                                    @endif
                                                    <td class="highlight">
                                                        <v-select label="name" @keyup.native="onItemload(index)" @click.native="onItemload(index)" v-model="item.inventory" :options="temp_items" @search="onItemSearch"></v-select>
                                                        <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                                    </td>
                                                    @if(searchByCodeLocation()=="true")
                                                    <td class="highlight">
                                                        <v-select label="name" @Click.native="setIndex(index)" @input="locationItemload(index)" v-model="item.location" :options="(item.item==null)?[]:item.item.locationList" @search="locationSearch" ></v-select>
                                                        <input type="hidden" :name="'location['+index+']'" v-validate="''" data-vv-as="@lang('layout.Location')" :value="(!item.location)?null:item.location.name">
                                                    </td>
                                                    @endif
                                                    <td class="highlight">
                                                        <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                                            <option value="null">@lang('layout.Select')</option>
                                                            <span v-if="(item.item != null)">
                                                                <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                    @{{site.site_name}}
                                                                </option>
                                                            </span>
                                                        </select>

                                                        <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                    </td>
                                                    <td v-show="showWhat('sale_description')=='yes'">
                                                        <input type="text" placeholder="@lang('layout.Description')" name="inventory_description[]" v-model="(item.item==null)?null:item.item.description" oninput = "autowidths(event)" class="form-control chan_length">
                                                    </td>
                                                    <td v-show="showWhat('sale_description2')=='yes'">
                                                        <input type="text" placeholder="@lang('layout.Description')" name="description2[]" v-model="(item.item==null)?null:item.item.description2" oninput = "autowidths(event)" class="form-control chan_length">
                                                    </td>

                                                    <td>


                                                        <input type="number" name="inventory_quantity[]" v-model.number="(item.item==null)?null:item.item.quantity" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Quantity')">
                                                    </td>

                                                    <td>
                                                        @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity,0))}}
                                                    </td>
                                                    <td v-show="showWhat('other_measure')=='yes'">
                                                        <div class="input-group">
                                                            <input type="number" name="other_measure_amount[]" v-model.number="(item.item==null)?null:item.item.other_measure" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue1')">
                                                            @if(getCalQuantityOfOtherMeasure() == 'avgMethod')
                                                            <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty) > 0">
                                                                @{{myRound((item.item==null)?null:((item.item.site==null)?null:(item.item.site.OnHand / item.item.site.per_qty)))}}
                                                            </span>
                                                            @elseif(getCalQuantityOfOtherMeasure() == 'simpleMethod')
                                                            <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:true)">
                                                                @{{myRound((item.item==null)?null:((item.item.site==null)?null:item.item.site.other_measure))}}
                                                            </span>
                                                            @else
                                                            <span class="input-group-addon">
                                                                @{{(item.item==null)?null:item.item.o_measure_v}}
                                                            </span>
                                                            @endif
                                                        </div>
                                                    </td>
                                                    <td v-show="showWhat('other_measure2')=='yes'">
                                                        <div class="input-group">
                                                            <input type="number" name="other_measure_amount2[]" v-model.number="(item.item==null)?null:item.item.other_measure2" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')">
                                                            @if(getCalQuantityOfOtherMeasure() == 'avgMethod')
                                                            <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty2) > 0">
                                                                @{{myRound((item.item==null)?null:((item.item.site==null)?null:(item.item.site.OnHand / item.item.site.per_qty2)))}}
                                                            </span>
                                                            @elseif(getCalQuantityOfOtherMeasure() == 'simpleMethod')
                                                            <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:true)">
                                                                @{{myRound((item.item==null)?null:((item.item.site==null)?null:item.item.site.other_measure2))}}
                                                            </span>
                                                            @else
                                                            <span class="input-group-addon">
                                                                @{{(item.item==null)?null:item.item.o_measure_v1}}
                                                            </span>
                                                            @endif
                                                        </div>
                                                    </td>
                                                    <td class="highlight">
                                                        <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                                            <option value="null">@lang('layout.Select')</option>
                                                            <span v-if="(item.item ==null)?false:true">
                                                                <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                    @{{measure.measure_name}}
                                                                </option>
                                                            </span>


                                                        </select>

                                                        <input type="hidden" name="inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                    </td>
                                                    <td v-show="seeCost==true">
                                                        @{{(item.item==null)? 0:myRound((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) *selected_currency.rate)}}
                                                        @{{selected_currency.symbol}}
                                                    </td>
                                                    @if(getShwoPriceLevel()=="per_item")
                                                    <td>
                                                        <select v-model="(item.item == null)?null:item.price_level" class="form-control" @change="change_sale_rate_by_price_level(index)">
                                                            <option value="null">@lang('layout.Select')</option>
                                                            <span v-if="(item.item ==null)?false:true">
                                                                <option v-for="price_level in (item.item==null)?null:item.item.item_price_level" :value="price_level">
                                                                    @{{price_level.name}}
                                                                </option>
                                                            </span>
                                                        </select>

                                                        <input type="hidden" name="item_price_level_id[]" :value="(item.price_level == null)?null:item.price_level.id">
                                                    </td>
                                                    @endif
                                                    @if(getShwoPriceLevel()=="general_percent_per_item")
                                                    <td>
                                                        <select v-model="(item.item == null)?null:item.price_level" class="form-control" @change="change_sale_rate_by_price_level_general_per_item(index)">
                                                            <option value="null">@lang('layout.Select')</option>
                                                            <span v-if="(item.item ==null)?false:true">
                                                                <option v-for="price_level in (item.item==null)?null:priceLevelGeneral" :value="price_level">
                                                                    @{{price_level.name}}
                                                                </option>
                                                            </span>
                                                        </select>

                                                        <input type="hidden" name="item_price_level_id[]" :value="(item.price_level == null)?null:item.price_level.id">
                                                    </td>
                                                    @endif


                                                    <td v-show="seePrice == true">
                                                        <div class="input-group">
                                                            <input type="number" name="inventory_price[]" placeholder="@lang('layout.Price')" :value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate)" ref="in" @input="setNewRate('inventory',index)" oninput = "autowidths(event)" class="form-control chan_length">
                                                            <span class="input-group-addon">
                                                                @{{selected_currency.symbol}}
                                                            </span>
                                                        </div>
                                                    </td>

                                                    @if(getM2()!="" && getSubMeasure()!="true")
                                                    @if(getFactorMeasure2()=="true")
                                                    <td>
                                                        <div class="input-group">
                                                            <select name="measure1[]" class="form-control" v-model="(item.item==null)?null:item.item.measure1.measure_id">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                            @if(getSaleAmountSecondMeasure()=="true")
                                                            <span class="input-group-addon">
                                                                @{{myRound((item.item==null)?null:secoundMeasurQuantity(item.item,item.item.quantity))}}
                                                            </span>
                                                            @endif
                                                        </div>
                                                    </td>
                                                    @endif
                                                    @endif
                                                    @if(getM3()!="")
                                                    @if(getFactorMeasure3()=="true")
                                                    <td>
                                                        <select name="measure2[]" class="form-control" v-model="(item.item==null)?null:item.item.measure2.measure_id">
                                                            <option value="null">@lang('layout.Select')</option>
                                                            <span v-if="(item.item ==null)?false:true">
                                                                <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                    @{{measure.measure_name}}
                                                                </option>
                                                            </span>
                                                        </select>
                                                    </td>
                                                    @endif
                                                    @endif
                                                    @if(getSubMeasure() =="true")
                                                    <td>
                                                        @{{myRound((item.item==null)?null:subMQuantity(item.item,item.item.quantity))}}
                                                    </td>
                                                    @endif
                                                    @if(getM4()!="")
                                                    @if(getFactorMeasure4()=="true")
                                                    <td>
                                                        <select name="measure3[]" class="form-control" v-model="(item.item==null)?null:item.item.measure3.measure_id">
                                                            <option value="null">@lang('layout.Select')</option>
                                                            <span v-if="(item.item ==null)?false:true">
                                                                <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                    @{{measure.measure_name}}
                                                                </option>
                                                            </span>
                                                        </select>
                                                    </td>
                                                    @endif
                                                    @endif


                                                    <td v-show="showWhat('sale_discount')=='yes'">
                                                        <div class="input-group">
                                                            <input type="number" name="inventory_discount[]" placeholder="@lang('layout.Discount')" v-model.number="(item.item==null)?null:item.item.discount" oninput = "autowidths(event)" class="form-control chan_length">
                                                            <span class="input-group-addon" v-if="discountIsAmount">
                                                                @{{selected_currency.symbol}}
                                                            </span>
                                                            <span class="input-group-addon" v-if="!discountIsAmount">
                                                                %
                                                            </span>

                                                        </div>

                                                    </td>
                                                    <td v-show="seePrice == true">
                                                        <div class="input-group">
                                                            <input type="number" class="form-control inner_input chan_length" :value="(item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount).result" oninput = "autowidths(event)" placeholder="@lang('layout.Total')" disabled>
                                                            <span class="input-group-addon">
                                                                <b>@{{selected_currency.symbol}}</b>
                                                            </span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                    </td>
                                                </tr>
                                                <tr style="background-color: #ffffff;">

                                                    <td></td>
                                                    <td>
                                                        <center>
                                                            <button type="button" @click="addNew('inventory',1000)" class="btn btn-success"><i class="fa fa-plus"></i></button>
                                                        </center>
                                                    </td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                </tr>
                                            </tbody>
                                        </table>

                                        <hr>
                                        <!-- begin service -->
                                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="min-width: 8px;"> #</th>
                                                    <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                                    <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                                    <th v-show="showWhat('sale_description2')=='yes'">@lang('layout.Description') :2 </th>
                                                    <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                                    <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                                    <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>
                                                    <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                    <th></th>

                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr v-for="(service,index) in services">
                                                    <td>@{{index+1}}</td>
                                                    <td class="highlight">
                                                        <v-select label="name" v-model="service.item" :options="(service.items)" @click.native="addNew('service',index)" @input="checkExistingService(index)">

                                                        </v-select>
                                                        <input type="hidden" name="service_id[]" :value="(service.item==null)?null:service.item.id">
                                                    </td>
                                                    <td v-show="showWhat('sale_description')=='yes'">
                                                        <input type="text" placeholder="@lang('layout.Description')" name="service_description[]" v-model="(service.item==null)?null:service.item.description" class="form-control">
                                                    </td>
                                                    <td v-show="showWhat('sale_description2')=='yes'">
                                                        <input type="text" placeholder="@lang('layout.Description')" name="service_description2[]" v-model="(service.item==null)?null:service.item.description2" class="form-control">
                                                    </td>
                                                    <td>
                                                        <input class="form-control" name="service_quantity[]" v-model.number="(!service.item)?null:service.item.quantity" placeholder="@lang('layout.Quantity')">
                                                    </td>
                                                    <td class="highlight">
                                                        <select v-model="(service.item == null)?null:service.item.measure" class="form-control" @change="measureChangeservice(index)">
                                                            <option value="null">@lang('layout.Select')</option>
                                                            <span v-if="(service.item ==null)?false:true">
                                                                <option v-for="measure in (service.item==null)?null:service.item.measure_list" :value="measure">
                                                                    @{{measure.measure_name}}
                                                                </option>
                                                            </span>

                                                        </select>

                                                        <input type="hidden" name="service_measure[]" :value="(service.item==null)?null:service.item.measure.measure_id">
                                                    </td>
                                                    <td>
                                                        <div class="input-group">
                                                            <input type="number" name="service_price[]" placeholder="@lang('layout.Cost')" :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate)" ref="ser" @input="setNewRate('service',index)" class="form-control">
                                                            <span class="input-group-addon">
                                                                @{{selected_currency.symbol}}
                                                            </span>
                                                        </div>

                                                    </td>
                                                    <td>
                                                        <div class="input-group">
                                                            <input type="number" class="form-control inner_input" :value="(service.item==null)?null:getItemTotalService(service.item,selected_currency.rate).result" placeholder="@lang('layout.Total')" disabled>
                                                            <span class="input-group-addon">
                                                                <b>@{{selected_currency.symbol}}</b>
                                                            </span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span v-on:click="deleteItem('service',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <!-- end service -->


                                    </div>


                                    <!--Begin Draiver-->

                                    @if(getDriverInfo()=="true")
                                    <br>
                                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="min-width: 8px;"> @lang('layout.DriverInfo') </th>

                                            </tr>
                                        </thead>
                                    </table>

                                    <div class="row">
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                            <!-- begin inputs -->
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.TransferCode')</label>
                                                        {{Form::text('transfer_code',$sale->transferCode,['class' => 'form-control','placeholder' => __('layout.TransferCode')])}}

                                                    </div>
                                                </div>

                                                <div class="col-md-3">

                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Transporter_name')</label>
                                                        <input type="test" name="transporter_name" value="{{$sale->driver}}" class="form-control">

                                                    </div>
                                                </div>
                                                <div class="col-md-3">

                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Transporter_phone')</label>
                                                        <input type="test" name="transporter_phone" value="{{$sale->driverPhone}}" class="form-control">

                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.PlaceOfWeight')</label>
                                                        {{Form::text('palce_of_weight',$sale->PlaceOfWeight,['class' => 'form-control','placeholder' => __('layout.PlaceOfWeight')])}}
                                                    </div>
                                                </div>


                                            </div>
                                            <div class="row">

                                                <div class="col-md-3">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.SourcePlace')</label>
                                                        {{Form::text('source_place',$sale->sourcePlace,['class' => 'form-control','placeholder' => __('layout.SourcePlace')])}}
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.PlateNumber')</label>
                                                        <input type="text" name="plate_number" value="{{$sale->plateNumber}}" placeholder="@lang('layout.PlateNumber')" class="form-control">

                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.WayBillNumber')</label>
                                                        <input type="text" name="way_bill_number" value="{{$sale->wayBillNumber}}" placeholder="@lang('layout.WayBillNumber')" class="form-control">

                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.TotalWeight')</label>
                                                        <input type="text" name="total_weight" value="{{$sale->totalWeight}}" placeholder="@lang('layout.TotalWeight')" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.EmptyCarWeight')</label>
                                                        <input type="text" name="empty_car_weight" value="{{$sale->emptyCarWeight}}" placeholder="@lang('layout.EmptyCarWeight')" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.TotalBori')</label>
                                                        <input type="text" name="total_bori" placeholder="@lang('layout.TotalBori')" value="{{$sale->bori}}" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.Rent')</label>
                                                        <input type="number" name="rent" placeholder="@lang('layout.Rent')" class="form-control" value="{{$sale->rent}}">
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.Description')</label>
                                                        {{Form::textarea('transfer_description',$sale->trDesription,['class' => 'form-control','rows' => '3','placeholder' => __('layout.Description')])}}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    @endif
                                    <!--End Draiver-->

                                    <!-- begin total -->
                                    @if(getInvoiceTotal() == 'true')

                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" v-show="seePrice == true">
                                        <div class="dashboard-stat2 ">
                                            <table class="dashboard-tabel" width="100%">
                                                <tr>

                                                    <td>
                                                        <small>@lang('layout.Sub-Total'):</small>
                                                    </td>
                                                    <td class="text-right">
                                                        <span class="text-right" data-counter="counterup" data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                                        <small class="font-green-sharp">
                                                            @{{selected_currency.symbol}}
                                                        </small>
                                                    </td>

                                                    <td>
                                                        <small>@lang('layout.Discount'): (@{{
                                                                        Number.parseFloat(discount).toFixed(precision())
                                                                        }}%)
                                                        </small>
                                                    </td>
                                                    <td class="text-right">
                                                        <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number.parseFloat(discount*(subtotal - discountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}</span>
                                                        <small class="font-green-sharp">
                                                            @{{selected_currency.symbol}}
                                                        </small>
                                                    </td>

                                                    <td>
                                                        <small>@lang('layout.Total') :</small>
                                                    </td>
                                                    <td class="text-right"><span data-counter="counterup" data-value="7800">@{{ Number.parseFloat((subtotal - (discount*(subtotal - discountFiledRow)/100) - discountFiledRow)-payeds).toFixed(precision())}}</span>
                                                        <small class="font-green-sharp">
                                                            @{{selected_currency.symbol}}
                                                        </small>
                                                    </td>


                                                </tr>


                                            </table>

                                        </div>
                                    </div>
                                    @endif
                                    <!-- end total -->

                                    @if(getPrintDescription()=="true")
                                    <div class="row">
                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <label class="control-label">@lang('layout.PrintDescription')</label>
                                                    <textarea name="print_description" class="form-control" rows="2">{{$sale->print_description}}</textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endif

                                    <div class="row">
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <label class="control-label">@lang('layout.Memo')</label>
                                                    <textarea name="memo" class="form-control" rows="2">{{$sale->memo}}</textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                    <button type="button" v-if="isError1 ==false" v-if="!isError" @click="submitForm" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
                                    <button type="button" v-if="isError1 ==false" v-if="!isError" :disabled="disabled" class="btn blue" @click="saveAndPrint($event)">@lang('layout.SaveAndPrint')</button>
                                    <a href="{{route('sale.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                </div>

                                <cmodal :show='showModal' @close="showModal=false">

                                </cmodal>
                            </div>

                        </div>


                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
            <p> &nbsp; </p>
            <p> &nbsp; </p>
        </div>
    </div>
    <!-- END TAB PORTLET-->
</div>
</div>
@endsection
@push('scripts')


<script type="text/javascript">


//Add to auto print preview
function factorPrint(id,sendWhatsapp = null,type = null) {
    if (sendWhatsapp == null || sendWhatsapp == '') {
        sendWhatsapp = 'not';
    }
    if (type == null || type == '') {
        type = 1;
    }
    var a = document.createElement('a');
    a.href = "{{url('invoiceFactorPrint')}}/" + id + "/" + sendWhatsapp + "/" + type;
    a.target = "_blank";
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
}

document.onkeydown = function (e) {
        // save invoice by f8
        if (e.which == 119) {
            v.saveAndPrint();
        }
    }


    Vue.use(VueInputAutowidth);

    Vue.component('v-select', VueSelect.VueSelect);
    Vue.component("cmodal", {
        template: '#cmodal-template',

        props: ['show'],
        data() {
            return {
                types: [],
                receivables: [],
                payables: [],
                code: null,
                selectType: null,
                selectPay: null,
                selectReceive: null,
                classes: [],
                selectedClass: null,
            }
        },
        created() {

            axios.get('{{route("customer.create")}}').then(
                response => {
                    this.types = response.data.types;
                    if (this.types) {
                        for (var i = 0; i < this.types.length; i++) {
                            if (this.types[i].type == "Customer") {
                                this.selectType = this.types[i];
                            }
                        }
                    }
                    this.receivables = response.data.receivable;
                    this.payables = response.data.payable;
                    this.code = response.data.code;
                    this.classes = response.data.member_class;
                    if (this.receivables.length > 0) {
                        this.selectReceive = this.receivables[0];
                    }
                    if (this.payables.length > 0) {
                        this.selectPay = this.payables[0];
                    }

                }).catch(error => console.log(error));
        },
        methods: {
            onSubmit() {

                v.showModal = false;
                var datas = $("#modalForm").serializeArray();

                console.log('Lala', datas)
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    url: '{{route("customer.store")}}',
                    method: 'post',
                    data: {
                        "name": datas[0]['value'],
                        'code': datas[1]['value'],
                        'email': datas[2]['value'],
                        'phone': datas[3]['value'],
                        'address1': datas[4]['value'],
                        'type': this.selectType.id,
                        'receivable': this.selectReceive.id,
                        'payable': this.selectPay.id,
                        'class': (this.selectedClass) ? this.selectedClass.id : null
                    },
                    dataType: 'json',

                }).done(function(response) {
                    if (response) {
                        v.selected_customer = response.customer;
                    }
                }).fail(function(error) {
                    console.log('error', error);
                });

            }
        }
    });

    var seePrice ={!! $seePrice !!};
    var seeCost ={!! $seeCost !!};
    var currency ={!! $currency !!};
    var selectedCurrency = {!! $selectedCurrency !!};
    var banks = {!! $banks !!};
    var all_services = {!! $all_services !!};
    var selectedService = {!! $selectedService !!};
    var selectedItem = {!! $selectedItem !!};
    var sale = {!! $sale !!};
    var inventory_category = {!! $inventory_category !!};
    var memberClass = {!! $memberClass !!};
    var saleArea = {!! $saleArea !!};
    var priceLevel = {!!$priceLevel!!};
    var priceLevelGeneral = {!!$priceLevelGeneral!!};
    var selected_priceLevel = {!!$selected_priceLevel!!};
    var inventoryBrand =  {!!$inventoryBrand!!}; 

    var v = new Vue({
        el: '#app',
        data: {
            showModal: false,
            sale: sale,
            customer: [],
            all_customer: [],
            seePrice: seePrice,
            seeCost: seeCost,
            selected_customer: {!!$selectedCustomer!!},
            selected_item: selectedItem,
            banks: banks,
            selected_banks: null,
            all_services: all_services,
            selected_service: selectedService,
            currency: currency,
            selected_currency: selectedCurrency,
            rate: 0,
            discountFiled: 0,
            discountFiledRow: 0,
            discountIsAmount: false,
            disabled: false,
            brandItem: inventoryBrand,
            selected_iventory_brand: null,
            temp_items: [],
            totalAmountes: [],
            inventory_category: inventory_category,
            category:null,
            selected_index: 0,
            newCost: [
                null,
                null,
                null,
                null
            ],
            inventories: [],
            services: [],
            payments: [],
            memberClass: memberClass,
            selected_class: null,
            saleArea: saleArea,
            selected_area: null,
            ref_no: "{{$sale->ref_Number}}",
            contract_check: "{{$sale->contract_check}}",
            msg: '',
            isError1: false,

            priceLevel: priceLevel,
            selected_priceLevel: null,
            priceLevelGeneral: priceLevelGeneral,
            selected_priceLevelGeneral: null
        },
        computed: {
            selectedRate() {
                this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
            },
            discount() {
                if (this.discountIsAmount) {

                    if (this.subtotal > 0 && this.discountFiled) {
                        return (parseFloat(this.discountFiled) * 100) / (this.subtotal - this.discountFiledRow);
                    } else {
                        return 0;
                    }
                } else {

                    return this.discountFiled
                }
            },

            // calculate subtotal
            subtotal: function() {
                var sum = 0;
                var sum_discount = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item != null) {
                        var quantity = this.inventories[i]['item']['quantity'];
                        var rate = this.inventories[i]['item']['rate'];
                        var new_rate = this.inventories[i]['item']['new_rate'];
                        var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit = this.inventories[i]['item']['measure_unit'];
                        var discount = this.inventories[i]['item']['discount'];
                        if (new_rate && quantity > 0) {
                            sum += new_rate * quantity * this.selected_currency.rate;
                            if (this.discountIsAmount) {
                                if (discount > 0) {
                                    sum_discount += (discount * quantity);
                                }
                            } else {

                                if (discount > 0) {
                                    sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                }
                            }
                        } else {
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            if (this.discountIsAmount) {
                                if (discount > 0) {
                                    sum_discount += (discount * quantity);
                                }
                            } else {

                                if (discount > 0) {
                                    sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
                                }
                            }
                        }

                    }

                }
                this.discountFiledRow = sum_discount;

                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item && this.services[i].item != null) {

                        var rate = this.services[i]['item']['rate'];
                        var new_rate = this.services[i]['item']['new_rate'];
                        var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                        var measure_unit = this.services[i]['item']['measure_unit'];
                        var quantity = this.services[i]['item']['quantity'];
                        if (new_rate != rate && quantity > 0) {
                            sum += new_rate * quantity * this.selected_currency.rate;
                        } else {
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                        }

                    }
                }
                return sum;
            },

            // check payed amount
            payeds: function() {
                var sum = 0;
                for (var i = 0; i < this.payments.length; i++) {

                    if (this.payments[i].item != null && this.payments[i].item) {
                        if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                            //
                            sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                        }
                    }
                }
                return sum;
            },

            // check data validation
            isError: function() {
                var isError = false;
                var flag = false;
                for (var i = 0; i < this.inventories.length; i++) {

                    if (this.inventories[i].item) {
                        flag = true;
                        if (((this.inventories[i]['item']['rate'] <= 0))) {
                            rate = this.inventories[i]['item']['rate'];
                            new_rate = this.inventories[i]['item']['new_rate'];
                            if (rate <= 0 && new_rate <= 0) {
                                isError = true;
                            }

                        }
                    }
                }
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item && this.services[i].item != null) {
                        flag = true;
                    }
                }
                if (this.selected_customer == undefined || this.selected_customer == null || flag == false) {
                    isError = true;
                }
                return isError;

            },
            // filter the banks according to selected currency
            approperiateBank: function() {
                var bankCopy = this.banks.slice();
                var tempBank = bankCopy.filter((account) => {
                    return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                });
                if (tempBank.length > 0) {
                    this.selected_banks = tempBank[0];
                }
                return tempBank;
            },
        },
        mounted: function() {

            @if(getShwoPriceLevel() == "general")
            this.selected_priceLevel = selected_priceLevel;
            @endif

            @if(getShwoPriceLevel() == "general_percent")
            this.selected_priceLevelGeneral = selected_priceLevel;
            @endif

            // initialize the selected item
            // for (var i = 0; i < this.selected_item.length; i++) {

            //     var price_level = this.selected_item[i].price_level;
            //     @if(getShwoPriceLevel() == "general_percent_per_item")
            //     if (this.selected_item[i].price_level_id) {
            //         price_level = _.find(this.priceLevelGeneral, (s) => s.id == this.selected_item[i].price_level_id);

            //     }
            //     @endif

            //     this.inventories.push({
            //         inventory: this.selected_item[i],
            //         item: this.selected_item[i],
            //         item_category: this.selected_item[i].item_category,
            //         item_brand: this.selected_item[i].inventory_brand,
            //         price_level: price_level
            //     });
            // }
            for (var m = 2; m > 0; m--) {
                this.inventories.push({
                    inventory: null,
                    item: null,
                    location: null,
                    item_category: null,
                    item_brand: null,
                    price_level: null
                });
            }
            // end item

            // initialize payments

            for (var j = 0; j < this.banks.length; j++) {
                if (this.banks[j].id == this.sale.account_id) {
                    this.selected_banks = this.banks[j];
                }
            }

            // end payment

            // begin service

            // for (var r = 0; r < this.selected_service.length; r++) {
            //     var flag = false;
            //     var tempService;
            //     for (var h = 0; h < this.all_services.length; h++) {
            //         if (this.all_services[h].id == this.selected_service[r].item_id) {
            //             flag = true;
            //             tempService = this.all_services[h];
            //             tempService.quantity = this.selected_service[r].qty;
            //             tempService.rate = this.selected_service[r].sales_price;
            //             tempService.new_rate = this.selected_service[r].sales_price;
            //             tempService.description = this.selected_service[r].description;
            //             tempService.description2 = this.selected_service[r].description2;
            //         }
            //     }
            //     if (flag) {
            //         this.services.push({
            //             item: tempService,
            //             items: this.all_services
            //         })
            //     }
            // }
            for (var w = 2; w > 0; w--) {
                this.services.push({
                    item: null,
                    items: all_services
                });
            }
            // end service

            if (this.sale) {
                this.selected_class = _.find(this.memberClass, (c) => c.id == this.sale.class_id);
                this.selected_area = _.find(this.saleArea, (c) => c.id == this.sale.sale_area_id);
                this.discountFiled = this.sale.discount;
                if (this.sale.discount_type) {
                    if (this.sale.discount_type == 'percent') {
                        this.discountIsAmount = false;
                    } else {
                        this.discountIsAmount = true;
                    }
                }

                if (this.sale.category) {
                    this.category = this.sale.category;
                }
            }
        },
        methods: {

            checkRefNo() {

                //console.log(vm.ref_no)

                var chack = 'false';
                var ref_no = v.ref_no;
                if (ref_no != null) {


                    axios.get("{{route('callMethod.search')}}", {

                            params: {
                                ref_no: v.ref_no,
                                method_name: 'Search_ref_no',
                                table_name: 'sales'
                            },
                        })
                        .then(function(response) {
                            // console.log(response.data.result);
                            if (response.data.result != null) {
                                console.log(response.data.result);
                                // v.temp_items=response.data;
                                v.msg = "@lang('layout.DuplicateData')";
                                v.isError1 = true;
                            } else {
                                v.msg = 'no';
                                v.isError1 = false;

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });

                }
            },

            memberClassChange() {
                        if (v.selected_class) {
                            v.customer = [];
                            // v.selected_customer = null;
                            let class_id = v.selected_class.id;
                        
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchMember',
                                    class_id: class_id,
                                    type: 'Customer'
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    // console.log(response.data);
                                    v.customer = [];
                                    v.customer = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }
                    },
                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                class_id: class_id,
                                type: 'Customer'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.customer = [];
                                v.customer = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

            subMQuantity(item = null, quantity = null) {
                if (item != null) {
                    var result = 0;
                    if (item.site) {
                        // console.log(38383,item.measureListAll.length);

                        for (var i = 0; i < item.measureListAll.length; i++) {
                            // console.log(3838,item.measureListAll[i]);
                            if (item.measureListAll[i].measure_id == item.measure2.measure_id) {
                                result = (quantity * item.measure.measure_unit) / (item.measure_unit);
                                result = (result * item.measure_unit) / (item.measureListAll[i].measure_unit);
                            }
                        }


                    }
                    return result;
                }
            },
            secoundMeasurQuantity(item = null, quantity = null) {
                if (item != null) {
                    var result = 0;
                    if (item.site) {
                        // console.log(38383,item.measureListAll.length);
                        if (item.measureListAll) {
                            for (var i = 0; i < item.measureListAll.length; i++) {
                                // console.log(3838,item.measureListAll[i],item.measure_unit,item.measure.measure_unit);
                                if (item.measureListAll[i].measure_id == item.measure1.measure_id) {
                                    result = (quantity * item.measure.measure_unit) / (item.measure_unit);
                                    result = (result * item.measure_unit) / (item.measureListAll[i].measure_unit);
                                }
                            }
                        }
                    }
                    return result;
                }
            },

            // calculate item price based on measure change
            measureChange(index) {

                if (this.inventories[index].item != null) {
                    var item = this.inventories[index].item;

                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                    result = Number.parseFloat(temp).toFixed(precision());

                    this.inventories[index].item.new_rate = result;

                    // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                }
            },

            // Change Item Sale Rate According Item Price Level
            change_sale_rate_by_price_level(index) {

                if (this.inventories[index].item != null) {

                    var item = this.inventories[index].item;
                    var item_price_level = this.inventories[index].item.item_price_level;


                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                    result = Number.parseFloat(temp).toFixed(precision());
                    this.inventories[index].item.new_rate = result;

                    var myDataArray = this.inventories[index].item.item_price_level;
                    if (this.inventories[index].price_level != undefined) {
                        var item = this.inventories[index].item;
                        for (var i = 0; i < myDataArray.length; i++) {
                            if (myDataArray[i]['id'] == this.inventories[index].price_level.id) {
                                var temp = ((myDataArray[i]['rate'] * item.measure.measure_unit / item.measure_unit));
                                result = Number.parseFloat(temp).toFixed(precision());

                                // if(this.selected_currency.rate > 0){
                                //     item.new_rate = myRound((result)/this.selected_currency.rate);
                                // }else{
                                item.new_rate = myRound(result);
                                // }
                            }

                        }
                    }
                }
            },


            // calculate item price based on measure change
            measureChangeservice(index) {

                if (this.services[index].item != null) {
                    var item = this.services[index].item;

                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                    result = Number.parseFloat(temp).toFixed(precision());

                    this.services[index].item.new_rate = result;

                    // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                }
            },
            // detect member change and searh
            memberChange() {
                if (this.selected_customer) {
                    // get member contract
                    this.contractSearch(this.selected_customer.id, this);
                }
            },
            // set new price
            setNewRate(type = null, index) {
                if (type == 'inventory') {
                    if (this.inventories[index].item) {
                        this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                    }
                }
                if (type == 'service') {
                    if (this.services[index].item) {

                        this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                    }
                }


            },
            // begin item search

            onItemSearch: _.debounce((search, loading) => {

                loading(true);
                let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                let inventory_brand_id = (v.inventories[v.selected_index]['item_brand'] != undefined) ? v.inventories[v.selected_index]['item_brand'].id : '';

                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            member_id: v.member_id,
                            method_name: 'itemesSearchSale',
                            keyword: search,
                            inventory_category_id: inventory_category_id,
                            inventory_brand_id: inventory_brand_id,
                        }
                    })
                    .then(function(response) {
                        v.temp_items = [];
                        if (response.data.length > 0) {
                            v.temp_items = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            }, getDebounceTime()),


            onItemload(index) {
                v.selected_index = index;
                if (v.inventories[index].inventory != null) {
                    // console.log('klk',v.inventories[index].inventory,v.inventories);
                    var inventory_id = v.inventories[index].inventory.id;
                    let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                    let inventory_brand_id = (v.inventories[index]['item_brand'] != undefined) ? v.inventories[index]['item_brand'].id : '';
                    let price_level_id = (this.selected_priceLevel) ? this.selected_priceLevel.id : '';
                    var contract_check = 'no_contract';
                    if (v.contract_check) {
                        contract_check = 'yes_contract'
                    }
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSale',
                                inventory_id: inventory_id,
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id,
                                price_level_id: price_level_id,
                                contract_check: contract_check
                            }
                        })
                        .then(function(response) {
                            v.inventories[index].item = null;
                            v.inventories[index].location = null;
                            if (response.data.length > 0) {
                                v.inventories[index].item = response.data[0];
                                @if(getShwoPriceLevel() == "general_percent")
                                setTimeout((function() {
                                    v.change_sale_rate_by_price_level_general(index);
                                }), 400);
                                @endif
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            locationSearch: _.debounce((search, loading) => {
                loading(true);
                let inventory_id = (v.inventories[v.selected_index]['item'] != undefined) ? v.inventories[v.selected_index]['item'].id : '';
                // console.log(3333, v.inventories, v.selected_index, inventory_id, search);
                if (inventory_id) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            member_id: v.member_id,
                            method_name: 'itemesSearchLocation',
                            keyword: search,
                            inventory_id: inventory_id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            v.inventories[v.selected_index]['item']['locationList'] = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                } else {
                    loading(false);
                }
            }, getDebounceTime()),

            locationItemload(index) {
                v.selected_index = index;
                if (v.inventories[index].item != null && v.inventories[index].location != null) {
                    var inventory_id = v.inventories[index].item.id;
                    var location = v.inventories[index].location.name;

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSiteByLocation',
                                inventory_id: inventory_id,
                                location: location
                            }
                        })
                        .then(function(response) {
                            // console.log(4444, response.data);
                            if (response.data.item.length > 0) {
                                v.inventories[index].item.site_list = response.data.item;
                                v.inventories[index].item.site = response.data.selectItem;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            // Change Item Sale Rate According Item Price Level
            change_sale_rate_by_price_level_general(i) {

                if (this.inventories != null && this.selected_priceLevelGeneral) {
                    var price_type = this.selected_priceLevelGeneral.price_type;
                    var percent = Number.parseFloat(this.selected_priceLevelGeneral.percent);

                    if (this.inventories[i].item && this.inventories[i].item != null) {
                        var rate = this.inventories[i]['item']['rate'];
                        var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit = this.inventories[i]['item']['measure_unit'];
                        var rate1 = (rate * smeasure_unit / measure_unit);
                        rate1 = Number.parseFloat(rate1);

                        if (price_type == 'up' && percent > 0 && rate1 > 0) {
                            var result = Number.parseFloat((rate1 * percent) / 100);
                            this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                        } else if (price_type == 'down' && percent > 0 && rate1 > 0) {
                            var result = Number.parseFloat((rate1 * percent) / 100);
                            this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                        }
                    }
                }
            },

            // Change Item Sale Rate According Item Price Level
            change_sale_rate_by_price_level_general_per_item(index) {

                if (this.inventories != null) {
                    if (this.inventories[index].item != null) {
                        var item = this.inventories[index].item;
                        var item_price_level = this.inventories[index].price_level;
                        var price_type = item_price_level.price_type;
                        var percent = Number.parseFloat(item_price_level.percent);

                        var rate = this.inventories[index]['item']['rate'];
                        var smeasure_unit = this.inventories[index]['item']['measure']['measure_unit'];
                        var measure_unit = this.inventories[index]['item']['measure_unit'];
                        var rate1 = (rate * smeasure_unit / measure_unit);
                        rate1 = Number.parseFloat(rate1);

                        if (price_type == 'up' && percent > 0 && rate1 > 0) {
                            var result = Number.parseFloat((rate1 * percent) / 100);
                            this.inventories[index]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                        } else if (price_type == 'down' && percent > 0 && rate1 > 0) {
                            var result = Number.parseFloat((rate1 * percent) / 100);
                            this.inventories[index]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                        }
                    }
                }
            },


            //ajax call to get items
            setIndex(e) {
                // v.temp_items=[];
                this.selected_index = e;
            },
            itemCategoryChange(index) {
                v.setIndex(index);
                let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                let inventory_brand_id = (v.inventories[v.selected_index]['item_brand'] != undefined) ? v.inventories[v.selected_index]['item_brand'].id : '';
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            member_id: v.member_id,
                            method_name: 'itemesSearchSale',
                            inventory_category_id: inventory_category_id,
                            inventory_brand_id: inventory_brand_id
                        }
                    })
                    .then(function(response) {
                        // v.inventories[v.selected_index]['item'] = null;
                        // v.inventories[v.selected_index]['inventory'] = null;
                        v.temp_items = [];
                        if (response.data.length > 0) {
                            v.temp_items = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    });

            },
            itemBrandChange(index) {
                v.setIndex(index);

                v.selected_iventory_brand = this.inventories[index]['item_brand'];
                if (this.inventories[index]['item_brand'] != null) {
                    let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                    let inventory_brand_id = this.inventories[index]['item_brand'].id;

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id
                            }
                        })
                        .then(function(response) {
                            // v.inventories[index]['item'] = null;
                            // v.inventories[index]['inventory'] = null;
                            v.temp_items = [];
                            if (response.data.length > 0) {
                                v.temp_items = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }

            },

            // end item search

            // contract search


            contractSearch(id, vm) {
                vm.contract = [];
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member_contract',
                            member_id: id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            vm.contract = response.data;
                        }
                        // loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            },
            // end contract search

            // generic function for adding item to list
            addNew(type = null, index) {
                v.selected_index = index;
                this.temp_items = [];
                if (type != null) {
                    if (type == 'inventory') {
                        if (this.inventories[index + 1] == undefined) {
                            this.temp_items = [];
                            this.inventories.push({
                                inventory: null,
                                item: null,
                                location: null,
                                item_category: null,
                                item_brand: null,
                                price_level: null
                            });
                        }
                    }
                    if (type == 'service') {
                        if (this.services[index + 1] == undefined) {
                            this.checkExistingService(index, '');
                            this.services.push({
                                items: this.all_services,
                                item: null,
                            });
                        }
                    }
                    if (type == 'payment') {
                        if (this.payments[index + 1] == undefined) {
                            this.checkExistingPayment(index, '');
                            this.payments.push({
                                items: this.banks,
                                item: null,
                            });
                        }
                    }
                }

            },

            // in here you can check and decide to allow duplicate bank for payment or not
            checkExistingPayment(index = null, name = '') {
                var bank_temp = this.banks.slice();
                var bank_temp1 = [];
                for (var i = 0; i < this.payments.length; i++) {
                    if (this.payments[i].item != null) {
                        var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                        if (fined != -1) {
                            var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                        }
                    }
                }
                this.payments[index].items = bank_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;


            },

            // in here you can check and decide to allow duplicate service or not
            checkExistingService(index = null, name = '') {
                var service_temp = this.all_services.slice();
                var service_temp1 = [];
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item != null) {
                        var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                        if (fined != -1) {
                            var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                        }
                    }
                }
                this.services[index].items = service_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;


            },
            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    console.log(type);
                    if (type == 'inventory') {
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                this.inventories.splice(index, 1);
                            } else {

                            }
                        });
                    }
                    if (type == 'service') {
                        if (type == 'service') {
                            swal({
                                title: "@lang('layout.AreYouSure?')",
                                buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                                text: "",
                                icon: "info",
                                dangerMode: true,
                            }).then((willDelete) => {
                                if (willDelete) {
                                    this.services.splice(index, 1);
                                } else {

                                }
                            });
                        }
                    }
                    if (type == 'payment') {
                        this.payments.splice(index, 1);
                    }
                }

            },
            // submit the form
            submitForm() {

                if (this.isError == true) {
                    alert('there is no item');
                    return false;
                }
                v.disabled = true;
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("sales-form").submit()
                    } else {
                        v.disabled = false;
                    }
                });

            },           
            // submit the form and print
            // submitFormAndPrint() {

            //     if (this.isError == true) {
            //         alert('there is no item');
            //         return false;
            //     }
            //     v.disabled = true;
            //     swal({
            //         title: "@lang('layout.AreYouSure?')",
            //         buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
            //         text: "",
            //         icon: "info",
            //         dangerMode: true,
            //     }).then((willDelete) => {
            //         if (willDelete) {
            //             document.getElementById("sales-form").submit()
            //         } else {
            //             v.disabled = false;
            //         }
            //     });

            // }

            saveAndPrint() {
                v.disabled = true;
                var url = "{{url('sale')}}/"+v.sale.id+"/add_store";
                form_id = 'sales-form';
                var data = $('#' + form_id).serialize();
                toggleBlock(true);
                axios.post(url, data)
                    .then(function(response) {
                        toggleBlock(0);
                        if (response.data.result == 1) {
                            $('#' + form_id).trigger('reset');
                            factorPrint(response.data.sale_id)
                            //redirect after print to sale index
                            var redirect_route = "{{url('sale')}}";
                            window.location.href = redirect_route


                        } else {
                            var message = "{{__('message.Warning')}}";
                            v.disabled = false;
                            //$('#error-sound')[0].play();
                            toastr.warning('', message);
                        }
                    })
                    .catch(function(error) {
                        toggleBlock(0);
                        v.disabled = false;
                        console.log(error);
                        var message = "{{__('message.Warning')}}";
                        //$('#error-sound')[0].play();
                        toastr.warning('', message);
                    });
            },

            
        },


    });
</script>


@endpush