@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('style')
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
<style>
    .required {
        padding-left: 0px !important;
        color: red;
    }
    .dstyle {
        /* background-color: rgb(84, 199, 211); */
        text-align: center;
        /* color: white */
    }
    .v-select.searchable .dropdown-toggle .form-control {
        width: 100% !important;
    }
    .t_head {
        background-color: #eceef1 !important;
        /* padding: 7px !important; */
    }
    .t_body {
        background-color: #eceef1 !important;
        /* padding: 7px !important; */
    }
</style>
@stop
@section('content')
@include("layouts.Cmodal")
@include("invoices.modal")
<div class="row">
    <div class="portlet light bordered">
        <!-- BEGIN TAB PORTLET-->
        <div class="portlet light bordered sale">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.SalesReceiptes')</span>
                </div>
                <div class="actions"></div>
            </div>
            <div id="app" class="portlet-body" v-cloak>
                <div id="measure">
                    <modal v-if="showInfoModal" @close="showInfoModal = false">
                        <div slot="body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="row col-md-12">
                                        <h4 class="col-md-3">
                                            @lang('menu.InventoryBrand') :</h4>
                                        <h4 class="col-md-8">
                                            @{{ brand }}
                                        </h4>
                                    </div>
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-3">
                                            @lang('layout.Location') :</h4>
                                        <h4 class="col-md-8">
                                            @{{ location }}
                                        </h4>
                                    </div>
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-4">
                                            @lang('layout.ByAdvancePricing') :</h4>
                                        <h4 class="col-md-7">
                                            @{{ AdvancePrice }}
                                        </h4>
                                    </div>
                                    @if(getShowMakeCartan()=="true")
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-4">
                                            @lang('layout.Width') :</h4>
                                        <h4 class="col-md-7">
                                            @{{ width }}
                                        </h4>
                                    </div>
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-4">
                                            @lang('layout.Height') :</h4>
                                        <h4 class="col-md-7">
                                            @{{ height }}
                                        </h4>
                                    </div>
                                    @endif
                                </div>
                                <div class="col-md-6">
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-3">
                                            @lang('layout.Cost') :</h4>
                                        <h4 class="col-md-8">
                                            @{{ cost }}
                                        </h4>
                                    </div>
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-3">
                                            @lang('layout.SerialNum') :</h4>
                                        <h4 class="col-md-8">
                                            @{{ SNumber }}
                                        </h4>
                                    </div>
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-4">
                                            @lang('layout.OnHand') :</h4>
                                        <h4 class="col-md-7">
                                            @{{ on_hand }} @{{ measure_name }}
                                        </h4>
                                    </div>
                                    @if(getShowMakeCartan()=="true")
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-4">
                                            @lang('layout.Length') :</h4>
                                        <h4 class="col-md-7">
                                            @{{ length }}
                                        </h4>
                                    </div>
                                    @endif
                                </div>
                            </div>
                            @if(ShowLastSale()=="true")
                            <div class="row" v-if="last_item_sale != null && last_item_sale != ''">
                                <div class="col-md-12">
                                    <h3> @lang('layout.ShowLastSales') </h3>
                                    <table class="table table-striped table-bordered table-hover">
                                        <thead>
                                            <tr>
                                                <th>@lang('layout.CustomerName')</th>
                                                <th>@lang('layout.Measure')</th>
                                                <th>@lang('layout.Price')</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="(last_it,index) in last_item_sale">
                                                <td>@{{last_it.member}}</td>
                                                <td>@{{last_it.Measure}}</td>
                                                <td>@{{last_it.price}} @{{last_it.currency}}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            @endif

                        </div>
                        <h3 slot="header">
                            <div class="col-md-4">
                                <h3>
                                    @lang('layout.OtherInformations') @lang('layout.Item')
                                </h3>
                            </div>
                        </h3>
                        <div slot="footer">
                            <button type=button class="modal-default-button" v-on:click="showInfoModal = false ,measure = null , type=null">
                                @lang('layout.Cancel')
                            </button>
                        </div>
                    </modal>
                </div>
                <div class="tabbable tabbable-tabdrop">
                    <div>
                        {{Form::open(['route' => 'sale.store','method' => 'POST','class' => 'form-horizontal','id'=>'sales-form'])}}
                        {{ csrf_field() }}
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                    <!-- BEGIN FORM-->
                                    <div class="form-body" >
                                        <div class="row">
                                            <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                                                <!-- begin inputs -->
                                                <div class="row">
                                                    <!--<div v-show="showWhat('sale_area')=='yes'"
                                                            class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.SaleArea')</label>
                                                                <v-select label="name" :options="saleArea" v-model="selected_area"></v-select>
                                                                <input type="hidden" name="sale_area_id" :value="!selected_area?null:selected_area.id">
                                                            </div>
                                                        </div>
                                                    </div> -->
                                                    <!-- <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-show="showWhat('member_class')=='yes'">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.MemberClass')</label>
                                                                <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                                                <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                                            </div>
                                                        </div>
                                                    </div> -->
                                                </div>
                                                <div class="row">
                                                    <!-- <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Customer')</label>
                                                                <v-select label="name" @input="memberChange()" :options="customer" v-model="selected_customer"></v-select>
                                                                <input type="hidden" name="customer" v-validate="'required'" data-vv-as="@lang('layout.Customer')" :value="!selected_customer?null:selected_customer.id" required>
                                                                <span class="required">@{{ errors.first('customer') }}</span>
                                                            </div>
                                                        </div>
                                                    </div> -->
                                                    <!--<div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label col-md-12"><br></label>
                                                                    <button type="button" class="btn blue btn-block" @click="showModal = true">@lang('layout.NewCustomer')</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div v-show="showWhat('descriptionASMemberName')=='yes'" class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                            <div class="col-md-12 form-group">
                                                                <label class=" control-label">@lang('layout.OtherMemberName')</label>
                                                                <div>
                                                                    <input type="text" name="other_member_name"   class="form-control">
                                                                </div>
                                                            </div>
                                                    </div> -->
                                                    <!--<div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.InvoiceNumber')</label>
                                                                <input type="number" name="number" v-validate="'required|numeric'" data-vv-as="@lang('layout.InvoiceNumber')" v-model="number" class="form-control">
                                                                <span class="required">@{{ errors.first('number') }}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                                <input type="text" name="ref_no" v-model="ref_no" class="form-control" @input="checkRefNo()">
                                                                <span v-if="isError1 ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                                            </div>
                                                        </div>
                                                    </div> -->
                                                </div>
                                                <!-------------------------------------------------------
                                                -----------------------------------------------------
                                                ----------------------------------------------------->
                                                <div class="row">
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" style="padding-right: 3px !important; padding-left: 3px !important;" >
                                                        <table class="mainTableContent">
                                                            <tr v-show="showWhat('sale_area')=='yes'">
                                                                <td class="dstyle">@lang('layout.SaleArea')</td>
                                                                <td class="highlight">
                                                                    <v-select label="name" :options="saleArea" v-model="selected_area"></v-select>
                                                                    <input type="hidden" name="sale_area_id" :value="!selected_area?null:selected_area.id">
                                                                </td>
                                                            </tr>
                                                            <tr v-show="showWhat('member_class')=='yes'">
                                                                <td class="dstyle">@lang('layout.MemberClass')</td>
                                                                <td class="highlight">
                                                                    <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                                                    <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                                                </td>
                                                            </tr>
                                                            <tr class="CustomerTrIcon">
                                                                <td class="dstyle">@lang('layout.Customer')</td>
                                                                <td class="highlight">
                                                                    <div class="input-group">
                                                                        <v-select label="name" @input="memberChange()" :options="customer" @search="MemberSearch" v-model="selected_customer"></v-select>
                                                                        <input type="hidden" name="customer" v-validate="'required'" data-vv-as="@lang('layout.Customer')" :value="!selected_customer?null:selected_customer.id" required>
                                                                        <span class="btn btn-success input-group-addon " @click="showModal = true" style="background-color:  rgb(80, 129, 141)">
                                                                            <i class="fa fa-plus" style="color: white"></i>
                                                                        </span> 
                                                                    </div>
                                                                    <span class="required">@{{ errors.first('customer') }}</span>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="dstyle">@lang('layout.Currency')</td>
                                                                <td class="highlight">
                                                                    <v-select label="code" @input="selectedRate" @keyup.native="changeStaticRate()" @Click.native="changeStaticRate()" :options="setRates" v-model="selected_currency"></v-select>
                                                                    <input type="hidden" name="currency" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
                                                                    <span class="required">@{{ errors.first('currency') }}</span>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="dstyle">@lang('layout.Rate')</td>
                                                                <td class="highlight">
                                                                    <input type="number" name="currency_rate" v-validate="'required'" data-vv-as="@lang('layout.Rate')" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                                                    <span class="required">@{{ errors.first('currency_rate') }}</span>
                                                                    <input type="hidden" name="currency_rate_hq" v-model="!selected_currency?0:selected_currency.hq_rate" class="form-control">
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="dstyle">@lang('layout.Discount')</td>
                                                                <td class="highlight">
                                                                    <div class="input-group" style="color: black !important">
                                                                        <input v-model="discountFiled" class="form-control" type="number" min="0" max="100">
                                                                        <span v-if="discountIsAmount" @click="discountIsAmount = !discountIsAmount" style="background-color: rgb(80, 129, 141)" class="input-group-addon">@{{selected_currency.symbol}}
                                                                            <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                                                        </span>
                                                                        <span v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon" style="background-color: rgb(80, 129, 141);">%
                                                                            <input type="hidden" name="discount_type" value="percent">
                                                                        </span>
                                                                        <input type="hidden" name="discountTotal" :value="discount">
                                                                        <input type="hidden" name="discount" :value="discountFiled">
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                            <tr class="@if(!getCustomeForm('sale','description')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.Description')</td>
                                                                <td class="highlight">
                                                                    <textarea name="description" class="form-control" rows="2"></textarea>
                                                                </td>
                                                            </tr>    
                                                            @if(getTelegramBot()=="true")
                                                            <tr class="@if(!getCustomeForm('sale','telegram')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.Telegram')</td>
                                                                <td class="highlight">
                                                                    <div style="display: flex; justify-content: center; align-content: center; align-items: center;margin: 1px;border: 1px solid rgb(215, 215, 215);padding: 10px;border-radius: 5px;">
                                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                                            <i class="fa fa-telegram" style="color:rgb(14 177 177); font-size:20px; margin-top: 5px;"></i>
                                                                            <input type="checkbox" name="telegram" value="ok">
                                                                            <span></span>
                                                                        </label>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            @if(getWhatsApp() =='true' && getWhatsAppType() == 'direct')
                                                            <tr class="@if(!getCustomeForm('sale','whatsapp')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.Whatsapp')</td>
                                                                <td class="highlight">
                                                                    <div style="display: flex; justify-content: center; align-content: center; align-items: center;margin: 1px;border: 1px solid rgb(215, 215, 215);padding: 10px;border-radius: 5px;">
                                                                        <label class="mt-checkbox mt-checkbox-outline" style="color: green;">
                                                                            <i class="fa fa-whatsapp" style="color:green; font-size:20px; margin-top: 5px;"></i>
                                                                            <input type="checkbox"  name="whatsapp" value="5" />
                                                                            <span></span>
                                                                        </label>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                            @endif
                                                        </table>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" style="padding-right: 3px !important; padding-left: 3px !important;" >
                                                        <table>
                                                            <tr v-show="showWhat('descriptionASMemberName')=='yes'">
                                                                <td class="dstyle">@lang('layout.OtherMemberName')</td>
                                                                <td class="highlight">
                                                                    <input type="text" name="other_member_name" class="form-control">
                                                                </td>
                                                            </tr>
                                                            @if(getShwoPriceLevel()=="general")
                                                            <tr class="@if(!getCustomeForm('sale','priceLevel')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.PriceLevel')</td>
                                                                <td class="highlight">
                                                                    <v-select label="name" :options="priceLevel" v-model="selected_priceLevel" @input="changePriceLevel()">
                                                                    </v-select>
                                                                    <input type="hidden" name="price_level_id" :value="!selected_priceLevel?null:selected_priceLevel.id">
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            @if(getShwoPriceLevel()=="general_percent")
                                                            <tr class="@if(!getCustomeForm('sale','priceLevel')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.PriceLevel')</td>
                                                                <td class="highlight">
                                                                    <v-select label="name" :options="priceLevelGeneral" v-model="selected_priceLevelGeneral" @input="change_sale_rate_by_price_level_general()">
                                                                    </v-select>
                                                                    <input type="hidden" name="price_level_id" :value="!selected_priceLevelGeneral?null:selected_priceLevelGeneral.id">
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            <tr>
                                                                <td class="dstyle">@lang('layout.InvoiceNumber')</td>
                                                                <td class="highlight">
                                                                    <input type="number" name="number" v-validate="'required|numeric'" @input="checkNo()" data-vv-as="@lang('layout.InvoiceNumber')" v-model="number" class="form-control">
                                                                    <span class="required">@{{ errors.first('number') }}</span>
                                                                    <span v-if="number_Error ==true" class="input-has-error" style="color: red">@{{number_msg}}</span>
                                                                </td>
                                                            </tr>
                                                            <tr class="@if(!getCustomeForm('sale','referenceNumber')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.ReferenceNumber')</td>
                                                                <td class="highlight">
                                                                    <input type="text" name="ref_no" v-model="ref_no" class="form-control" @input="checkRefNo()">
                                                                    <span v-if="isError1 ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                                                </td>
                                                            </tr> 
                                                            <tr class="@if(!getCustomeForm('sale','date')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.Date')</td>
                                                                <td class="highlight">
                                                                    <input type="text" value="@if(autoSelectDate()=='true'){!! getDropdownDate('invoice', 'date') !!}@endif" @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif
                                                                     name="date" class="form-control date now" autocomplete="off">
                                                                     <span class="required">@{{ errors.first('date') }}</span>
                                                                </td>
                                                            </tr>
                                                            <tr class="@if(!getCustomeForm('sale','hour')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.Hour')</td>
                                                                <td class="highlight">
                                                                    <div class="input-group" @click="stopDynamicTime" @mousemove="changeTime"> 
                                                                        @if(getHourType() == 24)
                                                                        <input type="text" class="form-control timepicker timepicker-24" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                                                        @else
                                                                        <input type="text" class="form-control timepicker timepicker-no-seconds" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                                                        @endif
                                                                        <span class="input-group-btn">
                                                                            <button class="btn default" type="button">
                                                                                <i class="fa fa-clock-o"></i>
                                                                            </button>
                                                                        </span>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                            @if(systemConfig()[20] == 1)
                                                            <tr class="@if(!getCustomeForm('sale','contract')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.Contract')</td>
                                                                <td class="highlight">
                                                                <div class="form-control">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="contract_check" v-model="contract_check">
                                                                    <span></span>
                                                                </label>
                                                                </div>
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            @if(getFactorPending()=="true")
                                                            <tr class="@if(!getCustomeForm('sale','factorPending')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.Factor') @lang('layout.Pending')</td>
                                                                <td class="highlight">
                                                                <div class="form-control">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="pending" value="on">
                                                                    <span></span>
                                                                </label>
                                                                </div>
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            @if(oilSale() == 'true')
                                                            <tr class="@if(!getCustomeForm('sale','oil')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.Oil')</td>
                                                                <td class="highlight">
                                                                <div class="form-control">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" @click="ChangeOil" name="oil_sale" @if(systemConfig()[27] == 1 && oilSale() == 'true' && getActiveStatusOilSale() != 'false') checked @endif value="ok">
                                                                    <span></span>
                                                                </label>
                                                                </div>
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            @if(getActiveSale()=="true")
                                                            <tr v-if="selected_customer" class="@if(!getCustomeForm('sale','freeCardTimes')) displayNone @endif">
                                                                <td class="dstyle" colspan="2" :style="(Number(provided_card) >= Number(selected_customer.free_card_times))?'color: red;':''" >@lang('layout.FreeCardTimes') : @{{selected_customer.free_card_times}}  &nbsp;&nbsp;&nbsp;&nbsp; @lang('layout.Provided') : @{{provided_card}} </td>
                                                            </tr>
                                                            @endif
                                                            @if(getNegativeSale() == 'true')
                                                            <tr class="@if(!getCustomeForm('sale','negativeSale')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.NegativeSale')</td>
                                                                <td class="highlight">
                                                                <div class="form-control">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="negative_sale" value="ok">
                                                                    <span></span>
                                                                </label>
                                                                </div>
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            @if(checkGift() == 'true') 
                                                            <tr class="@if(!getCustomeForm('sale','checkGift')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.CheckGift')</td>
                                                                <td class="highlight">
                                                                    <input type="checkbox" name="check_gift" style="cursor: pointer" class="form-control" autocomplete="off"> 
                                                                </td>
                                                            </tr>
                                                            @endif
                                                        </table>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" style="padding-right: 3px !important; padding-left: 3px !important;" >
                                                        <table>
                                                            <tr>
                                                                <td class="dstyle">@lang('layout.Account')</td>
                                                                <td class="highlight">
                                                                    <v-select label="name" :options="approperiateBank" v-model="selected_banks"></v-select>
                                                                    <input type="hidden" name="bank_account" v-validate="'required'" data-vv-as="@lang('layout.Account')" :value="(this.selected_banks==null)?null:selected_banks.id">
                                                                    <span class="required">@{{ errors.first('bank_account') }}</span>
                                                                </td>
                                                            </tr>
                                                            @if(systemConfig()[27] == 1)
                                                            <tr class="@if(!getCustomeForm('sale','gasStation')) displayNone @endif">
                                                                <td class="dstyle">@lang('menu.GasStation')</td>
                                                                <td class="highlight">
                                                                    <v-select class="vue-select2" label="name" :options="oilPart" v-model="selectedOilPart" @input="setSaleNumber()">
                                                                    </v-select>
                                                                    <input type="hidden" name="oil_part_id" v-model.number="(!selectedOilPart)?null:selectedOilPart.id">
                                                                </td>
                                                            </tr>
                                                            <tr class="@if(!getCustomeForm('sale','gasStation')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.OldCounter')</td>
                                                                <td class="highlight">
                                                                    <input type="number" v-model="old_oil_counter" name="old_oils_counter" class="form-control"  readonly>
                                                                </td>
                                                            </tr> 
                                                            <tr class="@if(!getCustomeForm('sale','gasStation')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.NewCounter')</td>
                                                                <td class="highlight">
                                                                    <input type="number" name="new_counter" class="form-control" v-model="NewCounter" @input="NewCounters()"> 
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            @if(getActiveSale()=="true")
                                                            <tr class="@if(!getCustomeForm('sale','category')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.Category')</td>
                                                                <td class="highlight">
                                                                    <select name="category" v-model="category" @input="checkRefNo()" class="form-control" >
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="Sauna">@lang('layout.Sauna')</option>
                                                                        <option value="Restaurant">@lang('layout.Restaurant')</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                            @endif
                                                            <tr class="@if(!getCustomeForm('sale','receivedAmount')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.ReceivedAmount')</td>
                                                                <td class="highlight">
                                                                    <input type="number" v-model="receivedAmount" class="form-control " autocomplete="off">
                                                                </td>
                                                            </tr> 
                                                            @if(getSaleCommission()=="true")
                                                            <tr class="@if(!getCustomeForm('sale','commission')) displayNone @endif">
                                                                <td class="dstyle">@lang('layout.Commission')</td>
                                                                <td class="highlight">
                                                                    <v-select v-model="selected_commission" label="name" :options="commission">
                                                                    </v-select>
                                                                    <input type="hidden" name="commission_id" :value="!selected_commission?null:selected_commission.id" />
                                                                    <input type="hidden" name="commission_vendor_id" :value="!selected_commission?null:selected_commission.member_id" />
                                                                    <input type="hidden" name="commission_expense_id" :value="!selected_commission?null:selected_commission.expense_id" />
                                                                    <input type="hidden" name="commission_value" :value="subTotalCommi" readonly />
                                                                </td>
                                                            </tr>   
                                                            <tr class="@if(!getCustomeForm('sale','commission')) displayNone @endif">  
                                                                <td class="dstyle" v-if="commissionIsAmount">@lang('layout.Amount')</td>
                                                                <td class="dstyle" v-else="!commissionIsAmount">@lang('layout.Percentage')</td>
                                                                <td class="highlight">
                                                                    <div class="input-group" style="color: black !important">
                                                                        <input class="form-control" type="number" min="0" max="100" name="camission_amount"  v-model="!selected_commission?null:selected_commission.percent">
                                                                        <span v-if="commissionIsAmount" @click="commissionIsAmount = !commissionIsAmount" style="background-color: rgb(80, 129, 141)" class="input-group-addon">@{{selected_currency.symbol}}
                                                                            <input type="hidden" class="input-group-addon" name="commission_type" value="currency">
                                                                        </span>
                                                                        <span v-else @click="commissionIsAmount = !commissionIsAmount" class="input-group-addon" style="background-color: rgb(80, 129, 141);">%
                                                                            <input type="hidden" name="commission_type" value="percent">
                                                                        </span>
                                                                        <input type="hidden" name="commissionTotal" :value="commission">
                                                                        <input type="hidden" name="commission" :value="commissionFiled">
                                                                    </div>
                                                                </td>
                                                            </tr> 
                                                            @endif
                                                        </table>
                                                    </div>
                                                </div>
                                                @if(TabIndexInItemName() =="true")
                                                <!--Begin search Item-->
                                                <div class="row col-lg-12 col-md-12 col-sm-12 col-xs-12" style="background-color: #eceef1">
                                                    <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                                        {{-- <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <label class="control-label">@lang('layout.SerialNum')</label>
                                                                <input type="text" v-model="selected_inventory1" ref="barcode_search1" class="form-control" @input="callOnItemloadGeneral(), editKey = false" >
                                                                <span v-if="item_not_found" class="required">@lang('layout.ItemNotFound')</span>
                                                            </div>
                                                        </div> --}}
                                                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.SerialNum')</label>
                                                            <div class="input-group">
                                                                <input type="text" v-model="selected_inventory1"  ref="barcode_search1" class="form-control" @input="(!check_with_key)?callOnItemloadGeneral():''" >
                                                                {{-- <input type="number" v-model="exchange_amount" @input="set_rate(), getTranslateToWordExchange()" class="form-control" min="0" step="any"> --}}
                                                                <span class="input-group-addon">
                                                                    <input type="checkbox" v-model="check_with_key" title="{{ __('layout.SearchItemsWithSpecificKey') }}">
                                                                    <span></span>
                                                                </span>
                                                            </div>
                                                            <span v-if="item_not_found" class="required">@lang('layout.ItemNotFound')</span>
                                                        </div> 
                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" v-show="showWhat('sale_category')=='yes'">
                                                            <div class="form-group">
                                                                <label class="control-label">@lang('layout.Category')</label>
                                                                <v-select label="name" v-model="selected_iventory_category" :options="inventory_category"></v-select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" >
                                                            <div class="form-group">
                                                                <label class="control-label">@lang('layout.Site')</label>
                                                                <v-select label="name" v-model="selected_iventory_site" :options="inventory_sites"></v-select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                                        <div class="form-group">
                                                            <label class="control-label">@lang('layout.Quantity')</label>
                                                            <input type="number" v-model.number="selected_quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                                        <div class="form-group">
                                                            <label class="control-label col-md-12" style="color: white;">.</label>
                                                            <button type="button" v-if="((!isError) && (number_Error == false) && (isError1 == false))" @click="handleSubmit($event)" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--END search Item-->
                                                @endif
                                                <!-------------------------------------------------------
                                                -----------------------------------------------------
                                                ----------------------------------------------------->
                                                <!--<div class="row">
                                                        <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-lg-3 col-md-3':'col-lg-4 col-md-4' }} col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Currency')</label>


                                                                    <v-select label="code" @input="selectedRate"
                                                                              :options="setRates"
                                                                              v-model="selected_currency"></v-select>

                                                                    <input type="hidden" name="currency"
                                                                           v-validate="'required'"
                                                                           data-vv-as="@lang('layout.Currency')"
                                                                           :value="selected_currency.code">
                                                                    <span class="required">@{{ errors.first('currency') }}</span>

                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Rate') </label>

                                                                    <input type="number" name="currency_rate"
                                                                           v-validate="'required'"
                                                                           data-vv-as="@lang('layout.Rate')"
                                                                           v-model="!selected_currency?0:selected_currency.rate"
                                                                           class="form-control"
                                                                           :class="{'has-error':rate<=0}">

                                                                    <span class="required">@{{ errors.first('currency_rate') }}</span>
                                                                    <input type="hidden" name="currency_rate_hq"
                                                                           v-model="!selected_currency?0:selected_currency.hq_rate"
                                                                           class="form-control">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4  col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Discount')</label>

                                                                    <div class="input-group">

                                                                        <input v-model="discountFiled"
                                                                               class="form-control"
                                                                               type="number" min="0" max="100">
                                                                        <span v-if="discountIsAmount"
                                                                              @click="discountIsAmount = !discountIsAmount"
                                                                              class="input-group-addon">@{{selected_currency.symbol}}
                                                                  <input type="hidden" class="input-group-addon"
                                                                         name="discount_type" value="currency">
                                                              </span>
                                                                        <span v-else
                                                                              @click="discountIsAmount = !discountIsAmount"
                                                                              class="input-group-addon">%
                                                                  <input type="hidden" name="discount_type"
                                                                         value="percent">
                                                              </span>
                                                                        <input type="hidden" name="discountTotal"
                                                                               :value="discount">
                                                                        <input type="hidden" name="discount"
                                                                               :value="discountFiled">
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Account')</label>

                                                                    <v-select label="name" :options="approperiateBank"
                                                                              v-model="selected_banks"></v-select>
                                                                    <input type="hidden" name="bank_account"
                                                                           v-validate="'required'"
                                                                           data-vv-as="@lang('layout.Account')"
                                                                           :value="(this.selected_banks==null)?null:selected_banks.id">
                                                                    <span class="required">@{{ errors.first('bank_account') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Description')</label>

                                                                    <textarea name="description" class="form-control"
                                                                              rows="1"></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Date')</label>

                                                                    <input type="text" name="date"
                                                                           class="form-control date now"
                                                                           autocomplete="off">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div> -->
                                                <!-- end inputs -->
                                                <!--Begin search Item-->
                                                <br/>
                                                @if(systemConfig()[23] == 1)
                                                <div class="row col-lg-12 col-md-12 col-sm-12 col-xs-12" style="background-color: #eceef1">
                                                    <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12" style="padding: 0px !important;" >
                                                        <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12" >
                                                            <div class="form-group" >
                                                                <!-- <div class="col-md-12"> -->
                                                                    <!-- <label class="control-label">@lang('layout.ItemName')</label> -->
                                                                    <v-select label="name" ref="barcode_search" @input="loadItemGeneral(), editKey = false"  
                                                                    v-model="selected_inventory" :options="temp_items" @search="onItemSearch" 
                                                                    placeholder="@lang('layout.ItemName')" ></v-select>
                                                                <!-- </div> -->
                                                            </div>
                                                            <p v-if="selected_item">
                                                                @lang('layout.OnHand'):@{{(selected_item)?(Number.parseFloat(selected_item.on_hand * selected_item.measure_unit / selected_item.measure.measure_unit).toFixed(2)):''}} @{{(selected_item)?selected_item.measure.measure_name:''}}
                                                            </p>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12"  >
                                                            <div class="form-group">
                                                                <!-- <label class="control-label">@lang('layout.Site')</label> -->
                                                                <v-select label="name" v-model="selected_iventory_site" :options="inventory_sites1" placeholder="@lang('layout.Site')"></v-select>
                                                            </div>
                                                            <p v-if="selected_item && selected_iventory_site" >
                                                                @{{(selected_item && selected_iventory_site)?(Number.parseFloat(selected_iventory_site.OnHand * selected_item.measure_unit / selected_item.measure.measure_unit).toFixed(2)):''}} @{{(selected_item)?selected_item.measure.measure_name:''}}
                                                            </p>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12" style="padding: 0px !important;" >
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12"  >
                                                            <div class="form-group">
                                                                <!-- <div class="col-md-12"> -->
                                                                    <!-- <label class="control-label">@lang('layout.Quantity')</label> -->
                                                                    <input type="number" v-model.number="selected_quantity" ref="selected_quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                                                    <span class="required" v-if="selected_quantity_error" >@lang('layout.Quantity')</span>
                                                                <!-- </div> -->
                                                            </div>
                                                            <p v-if="AdvancePrice" >
                                                            @lang('layout.ByAdvancePricing') : @{{ AdvancePrice }}
                                                            </p>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12"  >
                                                            <div class="form-group">
                                                                <!-- <div class="col-md-12"> -->
                                                                    <!-- <label class="control-label">@lang('layout.Quantity')</label> -->
                                                                    <select v-model="(selected_item == null)?null:selected_item.measure" @input="changeMesurss()" class="form-control" >
                                                                        <option value="null">@lang('layout.Select')</option>
                                                                        <span v-if="(selected_item ==null)?false:true">
                                                                            <option v-for="measure in (selected_item==null)?null:selected_item.measure_list" :value="measure">
                                                                                @{{measure.measure_name}}
                                                                            </option>
                                                                        </span>
                                                                    </select>
                                                                <!-- </div> -->
                                                            </div>
                                                            @if(systemConfig()[30] == 1)
                                                            <p v-if="AdvancePrice_cost && AdvancePrice" >
                                                            @lang('layout.Price') : @{{(selected_item==null)?null:Number.parseFloat((AdvancePrice_cost * selected_item.measure.measure_unit / selected_item.measure_unit) * selected_currency.static_rate / selected_currency.rate).toFixed(3)}} @{{selected_currency.symbol}}
                                                            </p>
                                                            @else 
                                                            <p v-if="AdvancePrice_cost && AdvancePrice" >
                                                            @lang('layout.Price') : @{{(selected_item==null)?null:Number.parseFloat((AdvancePrice_cost * selected_item.measure.measure_unit / selected_item.measure_unit) * selected_currency.rate).toFixed(3)}} @{{selected_currency.symbol}}
                                                            </p>
                                                            @endif

                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-show="seePrice==true" >
                                                            <div class="form-group"> 
                                                                    <input type="number" v-model.number="selected_price" class="form-control input-style input-number" placeholder="@lang('layout.Price')">
                                                            </div>
                                                            @if(systemConfig()[30] == 1)
                                                            <p v-if="selected_item && seeCost==true" >
                                                            @lang('layout.CostInInventory'): @{{(selected_item==null)?null:Number.parseFloat((selected_item.LasCost * selected_item.measure.measure_unit / selected_item.measure_unit) * selected_currency.static_rate / selected_currency.rate).toFixed(3)}} @{{selected_currency.symbol}}
                                                            </p>
                                                            @else  
                                                            <p v-if="selected_item && seeCost==true" >
                                                            @lang('layout.CostInInventory'): @{{(selected_item==null)?null:Number.parseFloat((selected_item.LasCost * selected_item.measure.measure_unit / selected_item.measure_unit) * selected_currency.rate).toFixed(3)}} @{{selected_currency.symbol}}
                                                            </p>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12" style="padding: 0px !important;" >
                                                        @lang('layout.Total'): @{{(selected_item==null)?null:Number.parseFloat(selected_quantity * selected_price).toFixed(precision())}} @{{selected_currency.symbol}}
                                                    </div>
                                                    <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12" style="padding: 0px !important;" >
                                                        <button type="button" @click="addData()" class="btn btn-success" style="background-color: rgb(80, 129, 141);"><i class="fa fa-plus"></i></button>
                                                        <button type="button" @click="resetData()" class="btn btn-danger"><i class="fa fa-times"></i></button>
                                                    </div>
                                                </div>
                                                @endif
                                                <!--END search Item-->
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" v-show="seePrice == true">
                                                <!-- begin total -->
                                                <div class="well " style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                    <table class="dashboard-tabel" width="100%">
                                                        <tr>
                                                            <td>
                                                                <small style="font-weight: bolder;font-size:20px">@lang('layout.Total') :</small>
                                                            </td>
                                                            <td class="text-right"><span data-counter="counterup" data-value="7800" style="font-weight: bolder;font-size:20px">@{{ format_number(Number.parseFloat((subtotal - (discount*(subtotal - discountFiledRow)/100) - discountFiledRow)-Number.parseFloat(receivedAmount)))}}</span>
                                                                <small class="font-green-sharp" style="font-weight: bolder;font-size:20px">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Discount'): 
                                                                    (@{{ Number.parseFloat(discount).toFixed(precision()) }}%)
                                                                </small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number.parseFloat(discount*(subtotal - discountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}</span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Payment'): </small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number.parseFloat(receivedAmount)) }}</span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Total') @lang('layout.Commission'):</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">
                                                                    @{{ myRound(Number.parseFloat(totalCommi) + Number.parseFloat(sum_commission))}}
                                                                </span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Sub-Total'):</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number.parseFloat(subtotal))}}</span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                                <!-- end total -->
                                                @if(getSubMeasure()=="true")
                                                <div class="well" style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                    <table class="dashboard-tabel table-bordered" width="100%">
                                                        <tbody>
                                                            <span>
                                                                <tr>
                                                                    <td class="highlight">
                                                                        @lang('layout.Total')
                                                                    </td>
                                                                    <td>
                                                                        @{{format_number(this.total_qty_amount)}}
                                                                    </td>
                                                                </tr>
                                                            </span>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                @endif
                                                @if(ShowLastSale()=="true")
                                                <div class="well" v-if="last_item_sale != null && last_item_sale != ''" style="overflow-x: scroll; height:130px; padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                    <table class="dashboard-tabel table-bordered" width="100%">
                                                        <tr>
                                                            <td style="text-align: center">@lang('layout.CustomerName')</td>
                                                            <td style="text-align: center">@lang('layout.Measure')</td>
                                                            <td style="text-align: center">@lang('layout.SalePrice')</td>
                                                        </tr>
                                                        <tr v-for="(last_it,index) in last_item_sale">
                                                            <td style="text-align: center">@{{last_it.member}}</td>
                                                            <td style="text-align: center">@{{last_it.Measure}}</td>
                                                            <td style="text-align: center">@{{myRound(last_it.price)}} @{{last_it.currency}}</td>
                                                        </tr>
                                                    </table>
                                                </div>
                                                <div class="well" v-if="last_item_purchase != null && last_item_purchase != ''" style="overflow-x: scroll; height:110px; padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                    <table class="dashboard-tabel table-bordered" width="100%">
                                                        <tr>
                                                            <td style="text-align: center">@lang('layout.Vendor')</td>
                                                            <td style="text-align: center">@lang('layout.Measure')</td>
                                                            <td style="text-align: center">@lang('layout.Cost')</td>
                                                        </tr>
                                                        <tr v-for="(last_it,index) in last_item_purchase">
                                                            <td style="text-align: center">@{{last_it.member}}</td>
                                                            <td style="text-align: center">@{{last_it.Measure}}</td>
                                                            <td style="text-align: center">@{{myRound(last_it.cost)}} @{{last_it.currency}}</td>
                                                        </tr>
                                                    </table>
                                                </div>
                                                @endif
                                            </div>
                                        </div>
                                        <br/>
                                        <div class="row" style="overflow-x: scroll;">
                                            @if(systemConfig()[23] == 1)
                                            <table id="table_content" class="table table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                                        <th v-show="showWhat('inventory_brand')=='yes'" style="min-width: 130px">@lang('layout.Brand') </th>
                                                        <th v-show="showWhat('item_by_site_in_sale')=='yes'" style="min-width: 130px">@lang('layout.Site') </th>
                                                        @if(getSaleCommission()=="true")
                                                        <th>@lang('layout.Commission')</th>
                                                        @endif 
                                                        <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                                                        @if(searchByCodeLocation()=="true")
                                                        <th style="min-width: 110px;">@lang('layout.Location')</th>
                                                        @endif
                                                        @if(getSerailNumber() =="true")
                                                        <th style="min-width: 100px">@lang('layout.SerialNum') </th>
                                                        @endif
                                                        <th style="min-width: 100px" v-show="showWhat('item_by_site_in_sale')!='yes'">@lang('layout.SiteName') </th>
                                                        <th v-show="showWhat('sale_description')=='yes'" style="min-width: 100px">@lang('layout.Description1') </th>
                                                        <th v-show="showWhat('sale_description2')=='yes'" style="min-width: 100px">@lang('layout.Description') :2 </th>
                                                        <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                        <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                                        <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                        <th v-show="showWhat('other_measure')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue1')
                                                        </th>
                                                        <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue2')
                                                        </th>
                                                        <th v-show="seeCost == true" style="min-width: 100px">@lang('layout.CostInInventory') ({{getHomeCurrency()['code']}})</th>
                                                        <th v-show="seeCost == true" style="min-width: 100px">@lang('layout.CostInInventory') </th>
                                                        <th v-if="oil_sale == true && seeCost==true" style="min-width: 60px">@lang('layout.OilCostInInventory')</th>
                                                        <th v-if="oil_sale == true" style="min-width: 100px">@lang('layout.Density') </th>
                                                        <th v-if="oil_sale == true" style="min-width: 100px">@lang('layout.OilQuantity') </th>
                                                        <th v-if="oil_sale == true" style="min-width: 100px">@lang('layout.Measure') </th>
                                                        @if(getShwoPriceLevel()=="per_item")
                                                        <th style="min-width: 100px">@lang('layout.PriceLevel') </th>
                                                        @endif
                                                        @if(getShwoPriceLevel()=="general_percent_per_item")
                                                        <th style="min-width: 100px">@lang('layout.PriceLevel') </th>
                                                        @endif
                                                        <th v-show="seePrice == true" style="min-width: 100px">@lang('layout.NewPrice') </th>

                                                        @if(getM2()!="")
                                                        @if(getFactorMeasure2()=="true")
                                                        <th style="min-width: 100px">@lang('layout.Measure2') </th>
                                                        @endif
                                                        @endif
                                                        @if(getSubMeasure()=="true")
                                                        <th style="min-width: 100px">@lang('layout.EquivalentTo') </th>
                                                        @endif
                                                        @if(getM3()!="" && getSubMeasure()!="true")
                                                        @if(getFactorMeasure3()=="true")
                                                        <th style="min-width: 100px">@lang('layout.Measure3') </th>
                                                        @endif
                                                        @endif
                                                        @if(getM4()!="")
                                                        @if(getFactorMeasure4()=="true")
                                                        <th v-if="oil_sale == false" style="min-width: 100px">@lang('layout.Measure4') </th>
                                                        @endif
                                                        @endif

                                                        @if(getSaleCommission()=="true")
                                                        <th style="min-width: 100px" v-if="commissionIsAmount">@lang('layout.Commission') @lang('layout.Amount')</th>
                                                        <th style="min-width: 100px" v-else="!commissionIsAmount">@lang('layout.Commission') @lang('layout.Percentage')%</th>
                                                        @endif  

                                                        <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th>
                                                        <th v-show="seePrice == true" style="min-width: 150px">@lang('layout.Total') </th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(item,index) in inventories">
                                                        <td>@{{index+1}}</td>
                                                        <td v-show="showWhat('sale_category')=='yes'">
                                                            <v-select label="name" v-model="item.item_category" :options="inventory_category" @input="itemCategoryChange(index)" @Click.native="itemCategoryChange(index)"></v-select>
                                                            <input type="hidden" name="inventory_category_id[]" :value="(!item.item_category)?null:item.item_category.id">
                                                        </td>
                                                        <td v-show="showWhat('inventory_brand')=='yes'">
                                                            <v-select label="name" v-model="item.item_brand" :options="brandItem" @Click.native="itemBrandChange(index)" @input="itemBrandChange(index)"></v-select>
                                                            <input type="hidden" name="inventory_brand_id[]" :value="(!item.item_brand)?null:item.item_brand.id">
                                                        </td>
                                                        <td v-if="showWhat('item_by_site_in_sale')=='yes'">
                                                            <v-select label="name" v-model="item.inventory_site" :options="inventory_sites" @input="inventorySiteChange(index), changeDensity(index)" @Click.native="inventorySiteChange(index)"></v-select>
                                                            <input type="hidden" name="inventory_site_id[]" :value="(!item.inventory_site)?null:item.inventory_site.id">
                                                        </td>

                                                        @if(getSaleCommission() =="true") 
                                                        <td> 
                                                            <div class="mt-checkbox" style="padding-left: 0px;"> 
                                                                <label class="mt-checkbox mt-checkbox-outline"> 
                                                                    <input type="checkbox" :name="'row_commission_stat['+index+']'" v-model="item.commission" checked /> 
                                                                    <span></span> 
                                                                </label> 
                                                            </div> 
                                                        </td>
                                                        @endif  

                                                        <td class="highlight">
                                                            <div class="input-group">
                                                                <v-select label="name" @input="(editKey)?onItemload(index):''" @keyup.native="editKey = true" @Click.native="addNew('inventory',index), editKey = true" v-model="item.inventory" :options="temp_items" @search="onItemSearch" @if(TabIndexInItemName() =="true") tabindex="1" @endif ></v-select>
                                                                <input type="hidden" :name="'inventory_id['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
                                                                <span class="btn btn-success input-group-addon" @click="showInfo(index)">
                                                                    <i class="fa fa-info"></i></span>
                                                                <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                                            </div>
                                                        </td>
                                                        @if(searchByCodeLocation()=="true")
                                                        <td class="highlight">
                                                            <v-select label="name" @Click.native="addNew('inventory',index)" @input="locationItemload(index)" v-model="item.location" :options="(item.item==null)?[]:item.item.locationList" @search="locationSearch" ></v-select>
                                                            <input type="hidden" :name="'location['+index+']'" v-validate="''" data-vv-as="@lang('layout.Location')" :value="(!item.location)?null:item.location.name">
                                                        </td>
                                                        @endif
                                                        @if(getSerailNumber() =="true")
                                                        <td>
                                                            @{{(!item.item)?null:item.item.number}}
                                                        </td>
                                                        @endif
                                                        <td class="highlight" v-show="showWhat('item_by_site_in_sale')!='yes'">
                                                            <select v-model="(item.item==null)?null:item.item.site" @click="changeDensity(index)" @input="changeCostBylLocation(index)" class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item != null)">
                                                                    <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                        @{{site.site_name}}
                                                                    </option>
                                                                </span>
                                                            </select>

                                                            <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                        </td>
                                                        <td v-show="showWhat('sale_description')=='yes'">
                                                            {{-- <input type="text" placeholder="@lang('layout.Description1')" oninput = "autowidths(event)" name="inventory_description[]" v-model="(item.item==null)?null:item.item.description" class="form-control chan_length"> --}}
                                                            <input type="text" placeholder="@lang('layout.Description1')" @input="updateChange(event)" name="inventory_description[]" v-model="(item.item==null)?null:item.item.description" class="form-control chan_length">
                                                        </td>
                                                        <td v-show="showWhat('sale_description2')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')" @input="updateChange(event)" name="description2[]" v-model="(item.item==null)?null:item.item.description2" class="form-control chan_length">
                                                        </td>
                                                        <td>
                                                            <input type="number" :name="'inventory_quantity['+index+']'" v-validate="(item.item==null)?'':'required'" data-vv-as="@lang('layout.Quantity')" v-model.number="(item.item==null)?null:item.item.quantity" @input="change_oil_qty(index), setNewRate('inventory',index)" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Quantity')">
                                                            <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                            <span v-show=" myRound((item.item==null)?0:saleItemQuantity(item.item,item.item.quantity)) < 0" class="required">@lang('layout.LowOnHand')</span>
                                                        </td>

                                                        <td>
                                                            @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                                        </td>

                                                        <td class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>

                                                            </select>

                                                            <input type="hidden" name="inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>
                                                        <td v-show="showWhat('other_measure')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="other_measure_amount[]" v-model="(item.item == null)?null:item.item.other_measure_amount" class="form-control input-style input-number chan_length" oninput = "autowidths(event)" placeholder="@lang('layout.OMeasureValue1')">
                                                                @if(getCalQuantityOfOtherMeasure() == 'avgMethod')
                                                                <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty) > 0">
                                                                    @{{myRound((item.item==null)?null:((item.item.site==null)?null:(item.item.site.OnHand / item.item.site.per_qty)))}}
                                                                </span>
                                                                @elseif(getCalQuantityOfOtherMeasure() == 'simpleMethod')
                                                                <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:true)">
                                                                    @{{myRound((item.item==null)?null:((item.item.site==null)?null:item.item.site.other_measure))}}
                                                                </span>
                                                                @else
                                                                <span class="input-group-addon">
                                                                    @{{(item.item==null)?null:item.item.o_measure_v}}
                                                                </span>
                                                                @endif
                                                            </div>
                                                        </td>
                                                        <td v-show="showWhat('other_measure2')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="other_measure_amount2[]" v-model="(item.item == null)?null:item.item.other_measure_amount2" class="form-control input-style input-number chan_length" oninput = "autowidths(event)" placeholder="@lang('layout.OMeasureValue2')">
                                                                @if(getCalQuantityOfOtherMeasure() == 'avgMethod')
                                                                <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty2) > 0">
                                                                    @{{myRound((item.item==null)?null:((item.item.site==null)?null:(item.item.site.OnHand / item.item.site.per_qty2)))}}
                                                                </span>
                                                                @elseif(getCalQuantityOfOtherMeasure() == 'simpleMethod')
                                                                <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:true)">
                                                                    @{{myRound((item.item==null)?null:((item.item.site==null)?null:item.item.site.other_measure2))}}
                                                                </span>
                                                                @else
                                                                <span class="input-group-addon">
                                                                    @{{(item.item==null)?null:item.item.o_measure_v1}}
                                                                </span>
                                                                @endif
                                                            </div>
                                                        </td>
                                                        <td v-show="seeCost==true">
                                                            @{{(item.item==null)?null:myRound((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit))}}
                                                        </td>
                                                        @if(systemConfig()[30] == 1)
                                                        <td v-show="seeCost==true">
                                                            @{{(item.item==null)? 0:myRound((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) *selected_currency.static_rate / selected_currency.rate)}}
                                                            @{{selected_currency.symbol}}
                                                        </td>
                                                        @else 
                                                        <td v-show="seeCost==true">
                                                            @{{(item.item==null)? 0:myRound((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) *selected_currency.rate)}}
                                                            @{{selected_currency.symbol}}
                                                        </td>
                                                        @endif
                                                        @if(systemConfig()[30] == 1)
                                                        <td v-if="oil_sale == true && seeCost==true" >
                                                            @{{(item.item==null)?null:((item.item.density)?myRound(((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) * item.item.density) * selected_currency.static_rate / selected_currency.rate):null)}}
                                                        </td>
                                                        @else 
                                                        <td v-if="oil_sale == true && seeCost==true" >
                                                            @{{(item.item==null)?null:((item.item.density)?myRound(((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) * item.item.density) * selected_currency.rate):null)}}
                                                        </td>
                                                        @endif
                                                        <td v-if="oil_sale == true">
                                                            <input type="number" name="density[]" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Density')" @input="change_oil_qty(index)" v-model.number="(item.item==null)?null:item.item.density" oninput = "autowidths(event)" />
                                                        </td>
                                                        <td v-if="oil_sale == true">
                                                            <input type="number" name="oil_qty[]" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OilQuantity')" @input="change_qty_by_oil(index)" v-model.number="(item.item==null)?null:item.item.oil_qty" oninput = "autowidths(event)" />
                                                        </td>
                                                        <td v-if="oil_sale == true">
                                                            <select name="measure3[]" class="form-control" v-model="(item.item==null)?null:item.item.measure3.measure_id">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measureListAll" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                        </td>
                                                        @if(getShwoPriceLevel()=="per_item")
                                                        <td>
                                                            <select  v-model="(item.item == null)?null:item.price_level" 
                                                                    class="form-control" @change="change_sale_rate_by_price_level(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="price_level in (item.item==null)?null:item.item.item_price_level"
                                                                            :value="price_level">
                                                                    @{{price_level.name}}
                                                                    </option>
                                                                </span>
                                                            </select>

                                                            <input type="hidden" name="item_price_level_id[]" :value="(item.price_level == null)?null:item.price_level.id">
                                                        </td>
                                                        @endif
                                                        @if(getShwoPriceLevel()=="general_percent_per_item")
                                                        <td>
                                                            <select v-model="(item.item == null)?null:item.price_level" class="form-control" @change="change_sale_rate_by_price_level_general_per_item(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="price_level in (item.item==null)?null:priceLevelGeneral" :value="price_level">
                                                                        @{{price_level.name}}
                                                                    </option>
                                                                </span>
                                                            </select>

                                                            <input type="hidden" name="item_price_level_id[]" :value="(item.price_level == null)?null:item.price_level.id">
                                                        </td>
                                                        @endif

                                                        <td v-show="seePrice == true">
                                                            <vue-numeric v-if="item.item"
                                                                class="form-control chan_length"
                                                                oninput = "autowidths(event)"
                                                                v-model="item.item.cost"
                                                                :max="99999999999999"
                                                                currency=""
                                                                :precision="((p_total)?7:precision())"
                                                                @input="setNewRate('inventory',index)"
                                                                >
                                                            </vue-numeric>
                                                            <input type="hidden" :name="'inventory_price['+index+']'" placeholder="@lang('layout.Price')" :value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate, ((p_total)?7:precision()), selected_currency.static_rate)" >
                                                            <span v-show="((item.item==null)?null:checkCheap(item.item,selected_currency.rate, selected_currency.static_rate))==true" class="required">@lang('layout.SalesToTheDetriment')</span>
                                                        </td>

                                                        @if(getM2()!="" && getSubMeasure()!="true")
                                                        @if(getFactorMeasure2()=="true")
                                                        <td>
                                                            <div class="input-group">
                                                            <select name="measure1[]" class="form-control" v-model="(item.item==null)?null:item.item.measure1.measure_id">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                            @if(getSaleAmountSecondMeasure()=="true")	
                                                            <span class="input-group-addon">
                                                                @{{myRound((item.item==null)?null:secoundMeasurQuantity(item.item,item.item.quantity))}}
                                                            </span>
                                                            @endif
                                                        </div>
                                                        </td>
                                                        @endif
                                                        @endif
                                                        @if(getM3()!="")
                                                        @if(getFactorMeasure3()=="true")
                                                        <td>
                                                            <select name="measure2[]" class="form-control" v-model="(item.item==null)?null:item.item.measure2.measure_id">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                        </td>
                                                        @endif
                                                        @endif
                                                        @if(getSubMeasure() =="true")
                                                        <td>
                                                            @{{myRound((item.item==null)?null:subMQuantity(item.item,item.item.quantity))}}
                                                        </td>
                                                        @endif
                                                        @if(getM4()!="")
                                                        @if(getFactorMeasure4()=="true")
                                                        <td v-if="oil_sale == false">
                                                            <select name="measure3[]" class="form-control" v-model="(item.item==null)?null:item.item.measure3.measure_id">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                        </td>
                                                        @endif 
                                                        @endif  
                              
 

                                                        @if(getSaleCommission()=="true")
                                                        <td>
                                                            <div class="input-group" v-show="!item.commission"> 
                                                                <input type="number" class="form-control chan_length" :name="'row_percent_commission['+index+']'" oninput = "autowidths(event)" v-model="item.row_commission_percent" />
                                                                <span class="input-group-addon" v-if="commissionIsAmount">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                                <span class="input-group-addon" v-if="!commissionIsAmount">
                                                                    %
                                                                </span>
                                                            <input type="hidden" :name="'row_commission_amount['+index+']'" :value="item.row_commission_amount" />
                                                        </div>
                                                        </td>
                                                        @endif  
                                                        

 
                                                        <td v-show="showWhat('sale_discount')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="inventory_discount[]" placeholder="@lang('layout.Discount')" v-model.number="(item.item==null)?null:item.item.discount" oninput = "autowidths(event)" class="form-control chan_length">
                                                                <span class="input-group-addon" v-if="discountIsAmount">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                                <span class="input-group-addon" v-if="!discountIsAmount">
                                                                    %
                                                                </span>
                                                            </div>
                                                        </td>
                                                        <td v-if="oil_sale == false" v-show="seePrice==true">
                                                            <input type="number" :value="(item.item==null)? 0:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate, null, null, selected_currency.static_rate).result" ref="total" @input="setQuantityByTotal(index)"  class="form-control">
                                                            {{-- @{{(item.item==null)? 0:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate).result}}
                                                            @{{selected_currency.symbol}} --}}
                                                        </td>
                                                        <td v-if="oil_sale == true" v-show="seePrice==true">
                                                            <input type="number" :value="(item.item==null)? 0:getItemTotalOil(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate, null, selected_currency.static_rate).result" ref="total" @input="setQuantityByTotal(index)"  class="form-control">
                                                            {{-- @{{(item.item==null)? 0:getItemTotalOil(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate).result}}
                                                            @{{selected_currency.symbol}} --}}
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                            <!--span  @click="addNew('inventory',index)"><i class="paddint-both glyphicon glyphicon-plus"></i></span -->
                                                        </td>
                                                    </tr>
                                                    <tr style="background-color: #ffffff;">
                                                        <td></td>
                                                        <td>
                                                            <center>
                                                                <button type="button" @click="addNew('inventory',1000)" class="btn btn-success"><i class="fa fa-plus"></i></button>
                                                            </center>
                                                        </td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            @endif
                                            <hr>
                                            @if(systemConfig()[26] == 1)
                                            <!-- begin service -->
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                                        <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                                        <th v-show="showWhat('sale_description2')=='yes'">@lang('layout.Description') :2 </th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>
                                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(service,index) in services">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="service.item" :options="(service.items)" @click.native="addNew('service',index)" @input="checkExistingService(index)">
                                                            </v-select>
                                                            <input type="hidden" name="service_id[]" :value="(service.item==null)?null:service.item.id">
                                                        </td>
                                                        <td v-show="showWhat('sale_description')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')" name="service_description[]" v-model="(service.item==null)?null:service.item.description" class="form-control">
                                                        </td>
                                                        <td v-show="showWhat('sale_description2')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')" name="service_description2[]" v-model="(service.item==null)?null:service.item.description2" class="form-control">
                                                        </td>
                                                        <td>
                                                            <input class="form-control" name="service_quantity[]" v-model.number="(!service.item)?null:service.item.quantity" placeholder="@lang('layout.Quantity')">
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(service.item == null)?null:service.item.measure" class="form-control" @change="measureChangeservice(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(service.item ==null)?false:true">
                                                                    <option v-for="measure in (service.item==null)?null:service.item.measure_list" :value="measure">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                            <input type="hidden" name="service_measure[]" :value="(service.item==null)?null:service.item.measure.measure_id">
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" name="service_price[]" placeholder="@lang('layout.Cost')" :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate, null, selected_currency.static_rate)" ref="ser" @input="setNewRate('service',index)" class="form-control">
                                                                <span class="input-group-addon">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                @{{
                                                                (service.item==null)?null:getItemTotalService(service.item,selected_currency.rate,selected_currency.hq_rate, selected_currency.static_rate).result
                                                                }}
                                                                @{{selected_currency.symbol}}
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('service',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <!-- end service -->
                                            @endif
                                        </div>
                                        <!--Begin Draiver-->
                                        @if(getDriverInfo()=="true")
                                        <br>
                                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="min-width: 8px;"> @lang('layout.DriverInfo') </th>

                                                </tr>
                                            </thead>
                                        </table>


                                        <div class="row">
                                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                <!-- begin inputs -->
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.TransferCode')</label>
                                                            {{Form::text('transfer_code',null,['class' => 'form-control','placeholder' => __('layout.TransferCode')])}}

                                                        </div>
                                                    </div>

                                                    <div class="col-md-3">

                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Transporter_name')</label>
                                                            <input type="test" name="transporter_name" class="form-control">

                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">

                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Transporter_phone')</label>
                                                            <input type="test" name="transporter_phone" class="form-control">

                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.PlaceOfWeight')</label>
                                                            {{Form::text('palce_of_weight',null,['class' => 'form-control','placeholder' => __('layout.PlaceOfWeight')])}}
                                                        </div>
                                                    </div>


                                                </div>
                                                <div class="row">

                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.SourcePlace')</label>
                                                            {{Form::text('source_place',null,['class' => 'form-control','placeholder' => __('layout.SourcePlace')])}}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.PlateNumber')</label>
                                                            <input type="text" name="plate_number" placeholder="@lang('layout.PlateNumber')" class="form-control">

                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.WayBillNumber')</label>
                                                            <input type="text" name="way_bill_number" placeholder="@lang('layout.WayBillNumber')" class="form-control">

                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.TotalWeight')</label>
                                                            <input type="text" name="total_weight" placeholder="@lang('layout.TotalWeight')" class="form-control">
                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.EmptyCarWeight')</label>
                                                            <input type="text" name="empty_car_weight" placeholder="@lang('layout.EmptyCarWeight')" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.TotalBori')</label>
                                                            <input type="text" name="total_bori" placeholder="@lang('layout.TotalBori')" class="form-control">
                                                        </div>
                                                    </div>

                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.Rent')</label>
                                                            <input type="number" name="rent" placeholder="@lang('layout.Rent')" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.Description')</label>
                                                            {{Form::textarea('transfer_description',null,['class' => 'form-control','rows' => '3','placeholder' => __('layout.Description')])}}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        @endif
                                        <!--End Draiver-->


                                        <!-- begin total -->
                                        @if(getInvoiceTotal() == 'true')

                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" v-show="seePrice == true">
                                            <div class="dashboard-stat2 ">
                                                <table class="dashboard-tabel" width="100%">
                                                    <tr>

                                                        <td>
                                                            <small>@lang('layout.Sub-Total'):</small>
                                                        </td>
                                                        <td class="text-right">
                                                            <span class="text-right" data-counter="counterup" data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                                            <small class="font-green-sharp">
                                                                @{{selected_currency.symbol}}
                                                            </small>
                                                        </td>

                                                        <td>
                                                            <small>@lang('layout.Discount'): (@{{ Number.parseFloat(discount).toFixed(precision()) }}%)
                                                            </small>
                                                        </td>

                                                        <td class="text-right">
                                                            <span class="text-right" data-counter="counterup" data-value="7800">
                                                                @{{ format_number(Number.parseFloat(discount*(subtotal - discountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}</span>
                                                            <small class="font-green-sharp">
                                                                @{{selected_currency.symbol}}
                                                            </small>
                                                        </td>
 
                                                        <td>
                                                            <small>@lang('layout.Total') :</small>
                                                        </td>
                                                        
                                                        <td class="text-right"><span data-counter="counterup" data-value="7800">
                                                            @{{ Number.parseFloat((subtotal - (discount*(subtotal - discountFiledRow)/100) - discountFiledRow)-payeds).toFixed(precision())}}</span>
                                                            <small class="font-green-sharp">
                                                                @{{selected_currency.symbol}}
                                                            </small>
                                                        </td>


                                                    </tr>


                                                </table>

                                            </div>
                                        </div>
                                        @endif
                                        <!-- end total -->
                                        <div class="row">
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <table class="table table-striped table-bordered table-advance ">
                                                    <tr>
                                                        <td class="t_body">
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">@lang('layout.NotShowingDiscount')
                                                                    <input type="checkbox" name="show_discount" value="ok">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <table class="table table-striped table-bordered table-advance ">
                                                    <tr>
                                                        <td class="t_body">
                                                            <div>
                                                                <label class="">@lang('layout.PrintFactor') </label>
                                                                    <select name="print_factor_type" id="" class="form-control">
                                                                        <option value=""> @lang('layout.Select') </option>
                                                                        <option value="A4">A4</option>
                                                                        <option value="A5">A5</option>
                                                                    </select>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                        <div class="row">
                                            @if(searchByCodeLocation()=="true")
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <table class="table table-striped table-bordered table-advance ">
                                                    <tr>
                                                        <td class="t_body">
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">@lang('layout.PersianDescription')
                                                                    <input type="checkbox" name="show_persian_desc" value="ok">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                            @endif

                                            

                                            
                                        </div>
                                        <div class="row">
                                            {{-- @if(getWhatsApp() =='true')                  
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                                                            <label class="mt-checkbox mt-checkbox-outline">
                                                                <input type="checkbox"  name="whatsapp" value="2" />
                                                                <span></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif --}}
                                            @if(getPrintDescription()=="true")
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.PrintDescription')</label>
                                                        <textarea name="print_description" class="form-control" rows="2"></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Memo')</label>
                                                        <textarea name="memo" class="form-control" rows="2"></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php
                                        $print_session = session()->get('print');

                                        $current_sale_id = "invoiceFactorPrint/".$print_session
                                        ?>
                                        @if($print_session)
                                        <div class="row">
                                            <iframe src="{{$current_sale_id}}" height="400" width="500"></iframe>
                                        </div>
                                        <?php
                                            session()->forget('print');
                                        ?>
                                        @endif
                                    </div>
                                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                        <button type="button" v-if="((!isError) && (number_Error == false) && (isError1 == false))" @click="handleSubmit($event)" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
                                        <button type="button" v-if="((!isError) && (number_Error == false) && (isError1 == false))" :disabled="disabled" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                                        <a href="{{route('sale.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                    </div>
                                    <cmodal :show='showModal' @close="showModal=false">
                                    </cmodal>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
                <p> &nbsp; </p>
                <p> &nbsp; </p>
            </div>
        </div>
        <!-- END TAB PORTLET-->
    </div>
</div>
@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>

<script type="text/javascript">

//Add to auto print preview
function factorPrint(id,sendWhatsapp = null,type = null) {
    if (sendWhatsapp == null || sendWhatsapp == '') {
        sendWhatsapp = 'not';
    }
    if (type == null || type == '') {
        type = 1;
    }
    var a = document.createElement('a');
    a.href = "{{url('invoiceFactorPrint')}}/" + id + "/" + sendWhatsapp + "/" + type;
    a.target = "_blank";
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
}



    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.use(VueInputAutowidth);
    Vue.use(VueNumeric.default);

    Vue.component("modal", {
        template: "#modal-template",
        props: ['show'],

    });

    Vue.component('v-select', VueSelect.VueSelect);

    document.onkeydown = function (e) {
        // save invoice by f9
        if (e.which == 120) {
            v.autoSubmit();
        }        

        // save invoice by shif && enter
        if (e.shiftKey && e.which == 13) {
            v.autoSubmit();
        }

        // save invoice by f8
        if (e.which == 119) {
            v.saveAndNew();
        }

        // save invoice by shif && enter
         if (e.ctrlKey && e.which == 13) {
         v.callOnItemloadGeneral();
        }
        
    }

    Vue.component("cmodal", {
        template: '#cmodal-template',

        props: ['show'],
        data() {
            return {
                types: [],
                receivables: [],
                payables: [],
                code: null,
                selectType: null,
                selectPay: null,
                selectReceive: null,
                classes: [],
                selectedClass: null,

            }
        },
        mounted() {
            setTimeout(() => {
                this.getMemberCode();
            }, 500);
        },
        methods: {
            onSubmit() {

                v.showModal = false;
                var datas = $("#modalForm").serializeArray();
                let vmc = this;
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    url: '{{route("customer.store")}}',
                    method: 'post',
                    data: {
                        "name": datas[0]['value'],
                        'code': datas[1]['value'],
                        'email': datas[2]['value'],
                        'phone': datas[3]['value'],
                        'address1': datas[4]['value'],
                        'type': this.selectType.id,
                        'receivable': this.selectReceive.id,
                        'payable': this.selectPay.id,
                        'class': (this.selectedClass) ? this.selectedClass.id : null

                    },
                    dataType: 'json',

                }).done(function(response) {
                    if (response) {
                        v.selected_customer = response.customer;
                        vmc.getMemberCode();
                    }
                }).fail(function(error) {
                    console.log('error', error);
                });

            },
            getMemberCode() {
                let vmc = this;
                axios.get('{{route("customer.create")}}').then(
                response => {
                    vmc.types = response.data.types;
                    if (vmc.types) {
                        for (var i = 0; i < vmc.types.length; i++) {
                            if (vmc.types[i].type == "Customer") {
                                vmc.selectType = vmc.types[i];
                            }
                        }
                    }
                    vmc.receivables = response.data.receivable;
                    vmc.payables = response.data.payable;
                    vmc.code = response.data.code;
                    vmc.classes = response.data.member_class;
                    if(vmc.receivables.length>0)
                    {
                        vmc.selectReceive=vmc.receivables[0];
                    }
                    if(vmc.payables.length>0)
                    {
                        vmc.selectPay=vmc.payables[0];
                    }

                }).catch(error => console.log(error));
            }
        }
    });

    var seePrice ={!! $seePrice !!};
    var seeCost ={!! $seeCost !!};
    var currency ={!! $currency !!};
    var banks = {!! $banks !!};
    var all_services = {!! $all_services !!};
    var inventory_category = {!! $inventory_category !!};
    var memberClass = {!! $memberClass !!};
    var saleArea = {!! $saleArea !!};
    let homeCurrency = {!! json_encode(getHomeCurrency()) !!};
    let ratesFetched = {!! $rates !!};
    let mainHomeCurrency = {!! $mainHomeCurrency !!};
    var inventory_sites = {!!$inventory_sites!!};
    var priceLevel = {!!$priceLevel!!};
    var priceLevelGeneral = {!!$priceLevelGeneral!!};
    var inventoryBrand =  {!!$inventoryBrand!!}; 
    var oilPart =  {!!$oilPart!!}; 
    var commission =  {!!$commission!!}; 

    var v = new Vue({
        el: '#app',
        data: {
            dynamic_time:'',
            time_interval:0,
            number: "{{$number}}",
            old_number: "{{$number}}",
            number_msg: '',
            commission: commission,
            selected_commission: null,
            check_with_key: false,
            number_Error: false,
            showModal: false,
            showInfoModal: false,
            disabled: false,
            cheap: false,
            contract_check: false,
            oil_sale: false,
            editKey: false,
            subTotalCommi:0,
            totalCommi:0,
            brand: null,
            location: null,
            cost: null,
            SNumber: null,
            // selectDate: '',
            on_hand: null,
            measure_name: null,
            AdvancePrice: null,
            AdvancePrice_cost: null,
            customer: [],
            all_customer: [],
            selectedOilPart: null,
            oilPart: oilPart,
            seePrice: seePrice,
            seeCost: seeCost,
            selected_customer: null,
            member_id: null,
            provided_card: 0,
            receivedAmount: 0,
            banks: banks,
            all_services: all_services,
            selected_banks: null,
            defuilt_banks: null,
            currency: currency,
            selected_currency: {!!json_encode(getHomeCurrency()) !!},
            rate: 0,
            discountFiled: 0,
            commissionFiled: 0,
            discountFiledRow: 0,
            commisisonFiledRow: 0,
            discountIsAmount: false,
            commissionIsAmount: false,
            brandItem: inventoryBrand,
            selected_iventory_brand: null,
            temp_items: [],
            totalAmountes: [],
            inventory_category: inventory_category,
            selected_iventory_category: null,
            inventory_sites: inventory_sites,
            selected_iventory_site: null,
            selected_index: 0,
            category: null,
            newCost: [
                null,
                null,
                null,
                null
            ],
            inventories: [],
            services: [{
                    items: all_services,
                    item: null,
                },
                {
                    items: all_services,
                    item: null,
                },
            ],
            payments: [{
                items: all_services,
                item: null,
            }],
            memberClass: memberClass,
            selected_class: null,
            saleArea: saleArea,
            selected_area: null,
            ref_no: '',
            msg: '',
            isError1: false,
            p_total: false,
            number_msg: '',
            sum_commission:0,
            number_Error: false,
            total_qty_amount: 0,
            counter_check: 0,
            counter_check1: 1,
            counter_check2: -1,
            priceLevel: priceLevel,
            selected_priceLevel: null,
            priceLevelGeneral: priceLevelGeneral,
            selected_priceLevelGeneral: null,
            selected_inventory: null,
            selected_inventory1: null,
            inventory_sites1: inventory_sites,
            selected_iventory_site: null,
            selected_item: null,
            selected_quantity: null,
            selected_quantity_error: false,
            selected_price: null,
            item_not_found: false,
            last_item_sale: null,
            last_item_purchase: null,
            width:null,
            length:null,
            height:null,     
            old_oil_counter: 0,
            NewCounter: 0     
        },
        computed: {
            setRates() {

                let rates = [];
                this.currency.forEach((b) => {
                    ratesFetched.forEach((a) => {

                        if (a.currency_id == b.id) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                static_rate: a.static_rate,
                                rate: Number.parseFloat(a.rate),
                                exchange_rate: Number.parseFloat(a.rate),
                                hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 0,
                                currency: b.id,
                                id: b.id
                            });
                        }
                    })
                });

                this.currency.forEach((a) => {
                    let found = false;
                    rates.forEach((b) => {
                        if (a.id == b.id) {
                            found = true;
                            return;
                        }
                    });

                    if (!found) {
                        rates.push({
                            name: a.name,
                            code: a.code,
                            static_rate: a.static_rate,
                            symbol: a.symbol,
                            rate: 0,
                            exchange_rate: 0,
                            hq_rate: 0,
                            currency: a.id,
                            id: a.id
                        })
                    }
                });
                // console.log('rates', rates);
                return rates;

            },
            selectedRate() {
                if (this.selected_currency) {
                    var newrate = (this.selected_currency) ? this.selected_currency.rate : 0; 
                    if (this.discountIsAmount && this.discountFiled && this.rate > 0 && newrate > 0 && this.rate != newrate) {
                        this.discountFiled = (Number.parseFloat(this.discountFiled / this.rate) * newrate);
                    } 
                    
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0; 

                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                            if (this.inventories[i].item.new_rate) {

                                @if(salePriceCalculate() == "static_item_price")
                                if(this.inventories[i].item.static_item_prices && this.inventories[i].item.static_item_prices.length>0){
                                    this.changeStaticRate();

                                }else {
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                                    @else 
                                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.rate;
                                    @endif
                                }
                                @else
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                                    @else 
                                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.rate;
                                    @endif
                                @endif

                            }
                        }
                    }
                }
            },

            discount() {
                console.log("Discount");
                if (this.discountIsAmount) { 
                    if (this.subtotal > 0 && this.discountFiled) {
                        return (Number.parseFloat(this.discountFiled) * 100) / (this.subtotal - this.discountFiledRow);
                    } else {
                        return 0;
                    }
                } else { 
                    return this.discountFiled
                }

            }, 
            
            
            subtotal: function() {
                var sum = 0;
                var sum_discount = 0;
                var total_qty = 0;
                var sum_commission = 0;
 
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item != null) {

                        //Total Qty all Invoic 
                        var row_amount = this.subMQuantity(this.inventories[i]['item'], this.inventories[i]['item']['quantity'])
                        total_qty += row_amount;

                        if (this.oil_sale == true) {
                            var quantity = this.inventories[i]['item']['oil_qty'];
                        } else {
                            var quantity = this.inventories[i]['item']['quantity'];
                        }
                        
                        var rate = this.inventories[i]['item']['rate'];
                        var new_rate = this.inventories[i]['item']['new_rate'];
                        var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit = this.inventories[i]['item']['measure_unit'];
                        var discount = this.inventories[i]['item']['discount'];
                        var selected_row_commission = this.inventories[i]['row_commission_percent'];

                        if (new_rate != rate && quantity > 0) {
                            
                            @if(systemConfig()[30] == 1)
                            sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                            @else 
                            sum += new_rate * quantity * this.selected_currency.rate;
                            @endif
                            if (this.discountIsAmount) {
                                if (discount > 0) {
                                    sum_discount += (discount * quantity);
                                }
                            } else { 
                                if (discount > 0) {
                                    @if(systemConfig()[30] == 1)
                                    sum_discount += (Number.parseFloat(discount) * (new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate)) / 100;
                                    @else 
                                    sum_discount += (Number.parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                    @endif 
                                }
                            }
 
                            if (this.commissionIsAmount) {
                                if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                                    sum_commission += (quantity * selected_row_commission);
                                    this.inventories[i]['row_commission_amount'] = (quantity * selected_row_commission);
                                }
                            } else{
                                if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                                    @if(systemConfig()[30] == 1)
                                    sum_commission += ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_row_commission) / 100;
                                    this.inventories[i]['row_commission_amount'] = ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_row_commission) / 100;
                                    @else 
                                    sum_commission += ((new_rate * quantity * this.selected_currency.rate) * selected_row_commission) / 100;
                                    this.inventories[i]['row_commission_amount'] = ((new_rate * quantity * this.selected_currency.rate) * selected_row_commission) / 100;
                                    @endif
                                }
                            } 
  
                        } else {
                            @if(systemConfig()[30] == 1)
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            @endif

                            if (this.discountIsAmount) {
                                if (discount > 0) {
                                    sum_discount += (discount * quantity);
                                }
                            } else {

                                if (discount > 0) {
                                    @if(systemConfig()[30] == 1)
                                    sum_discount += (Number.parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate))) / 100;
                                    @else 
                                    sum_discount += (Number.parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
                                    @endif
                                }
                            }

 

                            if (this.commissionIsAmount) {
                                if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                                    sum_commission += (quantity * selected_row_commission);
                                    this.inventories[i]['row_commission_amount'] = (quantity * selected_row_commission);
                                }
                            } else{
                            if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                                @if(systemConfig()[30] == 1)
                                sum_commission += ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_row_commission) / 100;
                                this.inventories[i]['row_commission_amount'] = ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_row_commission) / 100;
                                @else 
                                sum_commission += ((new_rate * quantity * this.selected_currency.rate) * selected_row_commission) / 100;
                                this.inventories[i]['row_commission_amount'] = ((new_rate * quantity * this.selected_currency.rate) * selected_row_commission) / 100;
                                @endif
                            }
                            }

                        }

                    }

                }

                
                this.discountFiledRow = sum_discount; 
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item && this.services[i].item != null) { 
                        var rate = this.services[i]['item']['rate'];
                        var new_rate = this.services[i]['item']['new_rate'];
                        var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                        var measure_unit = this.services[i]['item']['measure_unit'];
                        var quantity = this.services[i]['item']['quantity'];
                        if (new_rate != rate && quantity > 0) {
                            @if(systemConfig()[30] == 1)
                            sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                            @else 
                            sum += new_rate * quantity * this.selected_currency.rate;
                            @endif
                        } else {
                            @if(systemConfig()[30] == 1)
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            @endif
                        } 
                    }
                }
 
                

                if (this.selected_commission) {
                    var percent = this.selected_commission.percent;
                    if (this.commissionIsAmount) {
                        this.totalCommi = percent;
                        this.subTotalCommi = percent;
                    } else {
                        this.totalCommi = ((sum * percent) / 100);
                        this.subTotalCommi = ((sum * percent) / 100);
                    }
                }else{
                    this.totalCommi = 0;
                    this.subTotalCommi = 0;
                }
                // console.log(3444, this.totalCommi, this.subTotalCommi);
                
                if (this.selected_commission) {
                    var commi = this.totalCommi;
                    @if(getSaleCommissionMarketer() !="true")
                    sum = commi + sum;
                    @endif
                } 
                
                this.total_qty_amount = total_qty;

                this.sum_commission = sum_commission; 

                return sum;
            },



            // check payed amount
            payeds: function() {
                var sum = 0;
                for (var i = 0; i < this.payments.length; i++) {

                    if (this.payments[i].item != null && this.payments[i].item) {
                        if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                            //
                            @if(systemConfig()[30] == 1)
                            sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                            @endif
                        }
                    }
                }
                return sum;
            },

            // check data validation
            isError: function() {
                var isError = false;
                var flag = false;
                /**for (var i = 0; i < this.inventories.length; i++)
                     {
                    
                    if (this.inventories[i].item)
                    {
                      flag=true;
                      if(((this.inventories[i]['item']['rate'] <=0) ))
                      {
                        rate=this.inventories[i]['item']['rate'];
                        new_rate=this.inventories[i]['item']['new_rate'];
                        if(rate <=0 && new_rate <=0)
                        {
                             isError = true;
                        }
                       
                      }
                    } 
                 } **/
                if (this.selected_customer == undefined || this.selected_customer == null || !this.selected_banks || this.selected_banks == null) {
                    isError = true;
                }
                return isError;


            },
            // filter the banks according to selected currency
            approperiateBank: function() {
                var bankCopy = this.banks.slice();
                var tempBank = bankCopy.filter((account) => {
                    return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                });
                if (tempBank.length > 0) {
                    if (this.defuilt_banks) {
                        this.selected_banks = this.defuilt_banks;
                        this.defuilt_banks = null;
                    }else{
                        this.selected_banks = tempBank[0];
                    }
                } else {
                    this.selected_banks = null;
                }
                return tempBank;
            },

        },
        mounted: function () {
            this.dynamicTime()
            @if(autoSelectCustomer()!='false')
            this.selectMemeber({!! getDropdown('sale', 'customer') !!});
            @endif


            // @if(autoSelectCustomer()!='false')
            // this.selectDate = "{!! getDropdownDate('sale', 'date') !!}";
            // @endif
            
            // console.log(this.selectDate);

                var selected_site = null;
                if(showWhat('item_by_site_in_sale')=='yes'){
                    selected_site=_.find(this.inventory_sites,(v)=>v.id=={!! getDropdown('sale', 'site') !!});
                    this.selected_iventory_site = selected_site;
                } 
                
                this.inventories.push({
                    inventory: null,
                    item: null,
                    item_category: null,
                    item_brand: null,
                    location: null,
                    description2: null,
                    commission: 'on',
                    other_measure_amount: null,
                    other_measure_amount2: null,
                    inventory_site: selected_site,
                    price_level:null
                });

                var selected_banks=_.find(this.banks,(v)=>v.id=={!! getDropdown('sale', 'account') !!});
                if(selected_banks){
                    var selected_currency=_.find(this.setRates,(v)=>v.code==selected_banks.code);
                    // currency
                    this.selected_currency = selected_currency;
                    this.defuilt_banks = selected_banks;
                }
                // console.log(123, selected_banks, selected_currency, this.inventory_sites);

                @if(systemConfig()[27] == 1 && oilSale() == 'true' && getActiveStatusOilSale() != 'false')
                    this.oil_sale = true;
                @endif

                @if(TabIndexInItemName() =="true")
                    this.$refs.barcode_search1.focus();
                @endif
            },
        methods: {

            changeStaticRate(){
                if (this.selected_currency) {
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                            if (this.inventories[i].item.new_rate) {
                                //Begin static_item_prices
                                @if(salePriceCalculate() == "static_item_price")
                                    @if(systemConfig()[30] == 1)
                                    var changed_rate_by_static_item_price = this.inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                                    @else 
                                    var changed_rate_by_static_item_price = this.inventories[i].item.new_rate * this.selected_currency.rate;
                                    @endif 
                                    if(this.inventories[i].item.static_item_prices && this.inventories[i].item.static_item_prices.length>0){
                                        for (var j = 0; j < this.inventories[i].item.static_item_prices.length; j++) {
                                            if (this.inventories[i].item.static_item_prices[j].currency == this.selected_currency.code) {
                                                changed_rate_by_static_item_price = this.inventories[i].item.static_item_prices[j].amount;
                                            }
                                        }
                                        
                                        this.inventories[i].item.cost = changed_rate_by_static_item_price;
                                        @if(systemConfig()[30] == 1)
                                        this.inventories[i].item.new_rate = changed_rate_by_static_item_price / this.selected_currency.static_rate * this.selected_currency.rate;
                                        @else 
                                        this.inventories[i].item.new_rate = changed_rate_by_static_item_price / this.selected_currency.rate;
                                        @endif
                                    }
                                @endif
                            }
                        }
                    }
                }
            },

            //BEGIN - Used for dynamic input time
            dynamicTime()
                {
                    this.time_interval = setInterval(() => {
                        const now = new Date()
                        @if(getHourType() == 24)
                            const hours = now.getHours().toString().padStart(2,'0')
                            const minutes = now.getMinutes().toString().padStart(2,'0') 
                            // const seconds = now.getSeconds().toString().padStart(2,'0')
                            this.dynamic_time = `${hours}:${minutes}`
                        @else
                            const timeString = now.toLocaleTimeString('en-US',{hour:'numeric',minute:'numeric',hour12:true});
                            this.dynamic_time = `${timeString}`
                        @endif
                        
                    },1000);
                },
                stopDynamicTime()
                {
                    clearInterval(v.time_interval)
                },
                changeTime()
                {
                    v.dynamic_time = v.$refs.time_input.value
                },
                //END - Used for dynamic input time

            updateChange(event) {
                const value = event.target.value;
                const leng = value.length;
                event.target.style.width = ((leng*7)+26)+"px";
                },
            checkRefNo() {
                setTimeout(() => {
                    var chack = 'false';
                    var ref_no = v.ref_no;
                    var category = v.category;
                    if (ref_no != null) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                ref_no: v.ref_no,
                                method_name: 'Search_ref_no',
                                category: v.category,
                                table_name: 'sales'
                            },
                        })
                            .then(function(response) {
                                // console.log(response.data.result);
                                if (response.data.result != null) {
                                    console.log(response.data.result);
                                    // v.temp_items=response.data;
                                    v.msg = "@lang('layout.DuplicateData')";
                                    v.isError1 = true;
                                } else {
                                    v.msg = 'no';
                                    v.isError1 = false;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            });

                    } 
                }, 400);
            },
            checkNo() {
                var chack = 'false';
                var number = v.number;
                if (number != null && !v.selectedOilPart) {
                    axios.get("{{route('callMethod.search')}}", {

                            params: {
                                number: v.number,
                                method_name: 'Search_number',
                                table_name: 'sales'
                            },
                        })
                        .then(function(response) {
                            // console.log(response.data.result);
                            if (response.data.result != null) {
                                // console.log(response.data.result);
                                // v.temp_items=response.data;
                                v.number_msg = "@lang('layout.DuplicateData')";
                                v.number_Error = true;
                            } else {
                                v.number_msg = 'no';
                                v.number_Error = false;

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });

                } else {
                    v.number_msg = 'no';
                    v.number_Error = false;
                }
            },
            
            selectMemeber(id = null) {
                if (id) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            id: id,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data) {
                            // console.log(response.data);
                            v.selected_customer = null;
                            v.selected_customer = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }
            },



            memberClassChange() {
                if (v.selected_class) {
                    v.customer = [];
                    // v.selected_customer = null;
                    let class_id = v.selected_class.id;
                
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            class_id: class_id,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            v.customer = [];
                            v.customer = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id,
                        type: 'Customer'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        v.customer = [];
                        v.customer = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

            subMQuantity(item = null, quantity = null) {
                if (item != null) {
                    var result = 0;
                    if (item.site) {
                        // console.log(38383,item.measureListAll.length);

                        for (var i = 0; i < item.measureListAll.length; i++) {
                            // console.log(3838,item.measureListAll[i]);
                            if (item.measureListAll[i].measure_id == item.measure2.measure_id) {
                                result = (quantity * item.measure.measure_unit) / (item.measure_unit);
                                result = (result * item.measure_unit) / (item.measureListAll[i].measure_unit);
                            }
                        }


                    }
                    return result;
                }
            },

            secoundMeasurQuantity(item = null, quantity = null) {
                if (item != null) {
                    var result = 0;
                    if (item.site) {
                        // console.log(38383,item.measureListAll.length);
                        if(item.measureListAll){
                            for (var i = 0; i < item.measureListAll.length; i++) {
                        // console.log(3838,item.measureListAll[i],item.measure_unit,item.measure.measure_unit);
                            if (item.measureListAll[i].measure_id == item.measure1.measure_id) {
                                result = (quantity * item.measure.measure_unit) / (item.measure_unit);
                                result = (result * item.measure_unit) / (item.measureListAll[i].measure_unit);
                            }
                        }
                        }
                    }
                    return result;
                }
            },

            showInfo(index) {
                if (v.inventories[index].item != null) {
                    v.showInfoModal = true;
                    v.brand = v.inventories[index]['item']['brand'];
                    v.location = v.inventories[index]['item']['location'];
                    v.SNumber = v.inventories[index]['item']['number'];
                    v.AdvancePrice = v.inventories[index]['item']['advance_price'];
                    v.on_hand = v.inventories[index]['item']['on_hand'];
                    v.measure_name = v.inventories[index]['item']['measure']['measure_name'];
                    v.last_item_sale = v.inventories[index]['item']['last_item_sale'];
                    v.width = v.inventories[index]['item']['width'];
                    v.length = v.inventories[index]['item']['length'];
                    v.height = v.inventories[index]['item']['height'];
                    // console.log('ffff',v.inventories[index]);
                    // if(v.seeCost==true){
                    @if(systemConfig()[30] == 1)
                    v.cost = (v.inventories[index]['item']['LasCost'] * v.selected_currency.static_rate / v.selected_currency.rate);
                    @else 
                    v.cost = (v.inventories[index]['item']['LasCost'] * v.selected_currency.rate);
                    @endif
                    // }
                }
            },

            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        v.disabled = true;
                        v.submitForm(e.target);
                    }
                });
            },

            autoSubmit() {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        document.getElementById("sales-form").submit();
                    }
                });
            },

            // calculate item price based on measure change
            measureChange(index) {

                if (this.inventories[index].item != null) {
                    var item = this.inventories[index].item;

                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                    result = Number.parseFloat(temp).toFixed(precision());
                    @if(systemConfig()[30] == 1)
                    this.inventories[index].item.cost = result * this.selected_currency.static_rate / this.selected_currency.rate;
                    @else 
                    this.inventories[index].item.cost = result * this.selected_currency.rate;
                    @endif

                    //Begin static_item_prices
                    @if(salePriceCalculate() == "static_item_price")
                        var changed_rate_by_static_item_price = 0;
                        if(this.inventories[index].item.static_item_prices && this.inventories[index].item.static_item_prices.length>0 && this.selected_currency){
                            for (var j = 0; j < this.inventories[index].item.static_item_prices.length; j++) {
                                if (this.inventories[index].item.static_item_prices[j].currency == this.selected_currency.code && this.inventories[index].item.static_item_prices[j].amount1) {
                                    changed_rate_by_static_item_price = this.inventories[index].item.static_item_prices[j].amount1;
                                    var temp = ((changed_rate_by_static_item_price * item.measure.measure_unit / item.measure_unit));
                                    result = Number.parseFloat(temp).toFixed(precision());

                                    this.inventories[index].item.static_item_prices[j].amount = result

                                    this.inventories[index].item.cost = result;
                                    @if(systemConfig()[30] == 1)
                                    result = result / this.selected_currency.static_rate * this.selected_currency.rate;
                                    @else 
                                    result = result / this.selected_currency.rate;
                                    @endif
                                    
                                }
                            }
                        }
                    @endif

                    this.inventories[index].item.new_rate = result;
                
                }
            },
             // Change Item Sale Rate According Item Price Level
             change_sale_rate_by_price_level(index){

                if (this.inventories[index].item != null) {

                    var item = this.inventories[index].item;
                    var item_price_level = this.inventories[index].item.item_price_level;


                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                    result = Number.parseFloat(temp).toFixed(precision());
                    this.inventories[index].item.new_rate = result;
                    @if(systemConfig()[30] == 1)
                    this.inventories[index].item.cost = result * this.selected_currency.static_rate / this.selected_currency.rate;
                    @else 
                    this.inventories[index].item.cost = result * this.selected_currency.rate;
                    @endif

                    var myDataArray=  this.inventories[index].item.item_price_level;
                        if(this.inventories[index].price_level!=undefined){
                            var item = this.inventories[index].item;
                            for(var i=0;i<myDataArray.length;i++)
                            {
                                if (myDataArray[i]['id'] == this.inventories[index].price_level.id) { 
                                    var temp = ((myDataArray[i]['rate'] * item.measure.measure_unit / item.measure_unit));
                                    result = Number.parseFloat(temp).toFixed(precision());

                                    // if(this.selected_currency.rate > 0){
                                    //     item.new_rate = myRound((result)/this.selected_currency.rate);
                                    // }else{
                                        item.new_rate = myRound(result);
                                        @if(systemConfig()[30] == 1)
                                        item.cost = myRound(result * this.selected_currency.static_rate / this.selected_currency.rate);
                                        @else 
                                        item.cost = myRound(result * this.selected_currency.rate);
                                        @endif
                                    // }
                                }
                            
                            }
                        }
                }
            },

                // Change Item Sale Rate According Item Price Level
            change_sale_rate_by_price_level_general() {
                
                if (this.inventories != null && this.selected_priceLevelGeneral) {
                    var price_type = this.selected_priceLevelGeneral.price_type;
                    var percent = Number.parseFloat(this.selected_priceLevelGeneral.percent);

                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                                var rate = this.inventories[i]['item']['rate'];
                                var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                                var measure_unit = this.inventories[i]['item']['measure_unit'];
                                var rate1 = (rate * smeasure_unit / measure_unit);
                                rate1 = Number.parseFloat(rate1);

                                if(price_type == 'up' && percent > 0 && rate1 > 0){
                                    var result = Number.parseFloat((rate1 * percent) / 100);
                                    this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                                } else if(price_type == 'down' && percent > 0 && rate1 > 0){
                                    var result = Number.parseFloat((rate1 * percent) / 100);
                                    this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                                }  
                        }
                    }
                }
            },

            // Change Item Sale Rate According Item Price Level
            change_sale_rate_by_price_level_general_per_item(index) {
                
                if (this.inventories != null) {
                    if (this.inventories[index].item != null) {
                        var item = this.inventories[index].item;
                        var item_price_level = this.inventories[index].price_level;
                        var price_type = item_price_level.price_type;
                        var percent = Number.parseFloat(item_price_level.percent);
                        
                        var rate = this.inventories[index]['item']['rate'];
                        var smeasure_unit = this.inventories[index]['item']['measure']['measure_unit'];
                        var measure_unit = this.inventories[index]['item']['measure_unit'];
                        var rate1 = (rate * smeasure_unit / measure_unit);
                        rate1 = Number.parseFloat(rate1);

                        if(price_type == 'up' && percent > 0 && rate1 > 0){
                            var result = Number.parseFloat((rate1 * percent) / 100);
                            this.inventories[index]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                        } else if(price_type == 'down' && percent > 0 && rate1 > 0){
                            var result = Number.parseFloat((rate1 * percent) / 100);
                            this.inventories[index]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                        } 
                    }
                }
            },

            // calculate item price based on measure change
            measureChangeservice(index) {

                if (this.services[index].item != null) {
                    var item = this.services[index].item;
                    @if(systemConfig()[30] == 1)
                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                    @else 
                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                    @endif


                    result = Number.parseFloat(temp).toFixed(precision());

                    this.services[index].item.new_rate = result;

                    // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                }
            },
            // detect member change and searh
            memberChange() {
                if (this.selected_customer) {
                    v.member_id = this.selected_customer.id;
                    // get member contract
                    this.contractSearch(this.selected_customer.id, this);
                    this.get_provided(this.selected_customer.id, this);

                    @if(getShwoPriceLevel()=="general_percent")
                    var price_level_id = this.selected_customer.price_level_id;
                    if(price_level_id){
                        this.selected_priceLevelGeneral = _.find(this.priceLevelGeneral, (s) => s.id == price_level_id);
                    }else{
                        this.selected_priceLevelGeneral = null;
                    }
                    @endif 

                }
            },

            // detect setSaleNumber and searh
            setSaleNumber() {
                if (this.selectedOilPart) {
                    
                    
                    axios.get("{{route('callMethod.search')}}", { 
                        params: {
                            method_name: 'itemesSearchCounter',
                            oilPartId: v.selectedOilPart.id
                        }
                    })
                    .then(function(response) {
                        if (response.data > 0) {
                            v.old_oil_counter = response.data;
                            v.NewCounters();
                        }else{
                            v.old_oil_counter = v.selectedOilPart.counter;
                            v.NewCounters();
                        }
                    });
                    

                    if (this.selectedOilPart.sale_number) {
                        this.number = this.selectedOilPart.sale_number;
                        var counter = this.selectedOilPart.counter;
                        // if(this.old_oil_counter == 0){
                        //     this.old_oil_counter = this.selectedOilPart.counter;
                        //     console.log(this.old_oil_counter);
                        // }

                    }

                    v.inventories = [];
                    this.inventories.push({
                        inventory: null,
                        item: null,
                        item_category: null,
                        item_brand: null,
                        location: null,
                        commission: 'on',
                        description2: null,
                        other_measure_amount: null,
                        other_measure_amount2: null,
                        inventory_site: this.selected_iventory_site,
                        price_level:null
                    });
                }
            },

            NewCounters(){ 
                var count = this.old_oil_counter;
                var newCounter = this.NewCounter;
                if(count && newCounter){
                    this.selected_quantity = newCounter - count;
                }
                // console.log(total);
            },



            changePriceLevel() {
                this.inventories = [];
                this.inventories.push({
                    inventory: null,
                    item: null,
                    location: null,
                    description2: null,
                    commission: 'on',
                    other_measure_amount: null,
                    other_measure_amount2: null,
                    item_category: this.selected_iventory_category,
                    item_brand: this.selected_iventory_brand,
                    inventory_site: this.selected_iventory_site,
                    price_level:null
                });


            },

            // set new price

            setNewRate(type = null, index) {
                if (type == 'inventory') {
                    if (this.inventories[index].item) {
                        @if(systemConfig()[30] == 1)
                        this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.static_rate * this.selected_currency.rate;
                        @else 
                        this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.rate;
                        @endif
                        // this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                        @if(systemConfig()[30] == 1)
                        if (((this.inventories[index].item.LasCost * this.inventories[index].item.measure.measure_unit / this.inventories[index].item.measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate) > (this.inventories[index].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate)) {
                            this.cheap = true;
                        } else {
                            this.cheap = false;
                        }
                        @else 
                        if (((this.inventories[index].item.LasCost * this.inventories[index].item.measure.measure_unit / this.inventories[index].item.measure_unit) * this.selected_currency.rate) > (this.inventories[index].item.new_rate * this.selected_currency.rate)) {
                            this.cheap = true;
                        } else {
                            this.cheap = false;
                        }
                        @endif
                    }
                }
                if (type == 'service') {
                    if (this.services[index].item) {
                        @if(systemConfig()[30] == 1)
                        this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                        @else 
                        this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                        @endif 
                    }
                }
            },

            setQuantityByTotal(index) {
                if (v.counter_check == 0) {
                    v.counter_check = 1;
                    setTimeout((function () {
                        v.counter_check1 = v.$refs.total[index].value;
                        v.setQuantityByT(index);
                    }), 2e2)
                }  
            },
            setQuantityByT(index) {
                setTimeout((function () {
                    v.counter_check2 = v.$refs.total[index].value;
                    v.setQuantityByTotals(index);
                }), 2e3)
            },
            setQuantityByTotals(index) {
                if (v.counter_check1 != v.counter_check2) {
                    v.counter_check1 = v.$refs.total[index].value;
                    v.setQuantityByT(index);
                }else{
                    v.p_total = true;
                    if (v.$refs.total[index].value) {
                        if (v.inventories[index].item) {
                            if (v.oil_sale == true) {
                                if (v.inventories[index]['item']['cost']) {
                                    var cost = v.inventories[index]['item']['cost'];
                                    v.inventories[index].item.oil_qty = Number.parseFloat(v.$refs.total[index].value / cost).toFixed(7);
                                    v.change_qty_by_oil(index);
                                }
                            } else {
                                if (v.inventories[index]['item']['cost']) {
                                    var cost = v.inventories[index]['item']['cost'];
                                    v.inventories[index].item.quantity = Number.parseFloat(v.$refs.total[index].value / cost).toFixed(7);
                                }
                            }
                        }
                    }
                    v.counter_check = 0; 
                }
            },

            // begin item search

            onItemSearch: _.debounce((search, loading) => {

                loading(true);
                let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                let inventory_site_id = (v.inventories[v.selected_index]['inventory_site'] != undefined) ? v.inventories[v.selected_index]['inventory_site'].id : '';
                let inventory_brand_id = (v.inventories[v.selected_index]['item_brand'] != undefined) ? v.inventories[v.selected_index]['item_brand'].id : '';
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            member_id: v.member_id,
                            method_name: 'itemesSearchSale',
                            keyword: search,
                            inventory_category_id: inventory_category_id,
                            inventory_brand_id: inventory_brand_id,
                            inventory_site_id: inventory_site_id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            v.temp_items = [];
                            v.temp_items = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            }, getDebounceTime()),

            locationSearch: _.debounce((search, loading) => {

                loading(true);
                let inventory_id = (v.inventories[v.selected_index]['item'] != undefined) ? v.inventories[v.selected_index]['item'].id : '';
                if (inventory_id) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            member_id: v.member_id,
                            method_name: 'itemesSearchLocation',
                            keyword: search,
                            inventory_id: inventory_id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            v.inventories[v.selected_index]['item']['locationList'] = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                } else {
                    loading(false);
                }
            }, getDebounceTime()),

            onItemload(index) {
                v.selected_index = index;
                if (v.inventories[index].inventory != null) {
                    // console.log('klk',v.inventories[index].inventory,v.inventories);
                    var inventory_id = v.inventories[index].inventory.id;
                    let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                    let inventory_site_id = (v.inventories[v.selected_index]['inventory_site'] != undefined) ? v.inventories[v.selected_index]['inventory_site'].id : '';
                    let price_level_id = (this.selected_priceLevel) ? this.selected_priceLevel.id : '';
                    let inventory_brand_id = (v.inventories[v.selected_index]['item_brand'] != undefined) ? v.inventories[v.selected_index]['item_brand'].id : '';

                    var contract_check = 'no_contract';
                    if (v.contract_check) {
                        contract_check = 'yes_contract'
                    }

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSale',
                                inventory_id: inventory_id,
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id,
                                inventory_site_id: inventory_site_id,
                                price_level_id: price_level_id,
                                contract_check: contract_check
                            }
                        })
                        .then(function(response) {
                            v.inventories[index].item = null;
                            if (response.data.length > 0) {
                                console.log(123123, response.data);
                                var checkD = true;
                                
                                @if(NotDuplicateItem() =="true")
                                if (v.inventories != null && response.data[0].id) {
                                    for (var i = 0; i < v.inventories.length; i++) {
                                        if (v.inventories[i].item && v.inventories[i].item != null) {
                                            if (v.inventories[i].item.id == response.data[0].id) {
                                                checkD = false;
                                            }
                                        }
                                    }
                                }
                                @endif

                                var site_id = null;
                                if (v.selectedOilPart) {
                                    if (v.selectedOilPart.site_id) {
                                        site_id = v.selectedOilPart.site_id;
                                    }
                                }
                                if (!site_id) {
                                    @if(getDefaultSite() > 0)
                                        site_id = {{getDefaultSite()}};
                                    @else
                                        site_id = {{getDropdown('invoice', 'site')}};
                                    @endif
                                }
                                
                                if (checkD) {
                                    v.inventories[index].item = response.data[0];
                                    v.inventories[index].location = null;
                                    // console.log('888888',response.data[0]);
                                    if(showWhat('item_by_site_in_sale')!='yes'){
                                        if(site_id){
                                            for (var i = 0; i < v.inventories[index].item.site_list.length; i++) {
                                                if (v.inventories[index].item.site_list[i].site_id == site_id) {
                                                    v.inventories[index].item.site = v.inventories[index].item.site_list[i];
                                                    v.changeDensity(index);
                                                }
                                            }
                                        }
                                    }

                                    @if(salePriceCalculate() == "static_item_price")
                                        for (var i = 0; i < v.inventories[index].item.static_item_prices.length; i++) {
                                            if (v.inventories[index].item.static_item_prices[i].currency == v.selected_currency.code && v.inventories[index].item.static_item_prices[i].amount) {
                                                @if(systemConfig()[30] == 1)
                                                v.inventories[index].item.new_rate = v.inventories[index].item.static_item_prices[i].amount / v.selected_currency.static_rate * v.selected_currency.rate;
                                                @else 
                                                v.inventories[index].item.new_rate = v.inventories[index].item.static_item_prices[i].amount / v.selected_currency.rate;
                                                @endif
                                            }
                                        }
                                    @endif

                                    
                                    v.temp_items = [];
                                    @if(getShwoPriceLevel()=="general_percent")
                                    setTimeout((function () {
                                        v.change_sale_rate_by_price_level_general();
                                    }), 400);
                                    @endif
                                } else {
                                    v.inventories[index].item = null;
                                    v.inventories[index].inventory = null;
                                    v.inventories[index].location = null;
                                }

                                // setTimeout((function () {
                                
                                // }), 400);

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            locationItemload(index) {
                v.selected_index = index;
                if (v.inventories[index].item != null && v.inventories[index].location != null) {
                    var inventory_id = v.inventories[index].item.id;
                    var location = v.inventories[index].location.name;

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSiteByLocation',
                                inventory_id: inventory_id,
                                location: location
                            }
                        })
                        .then(function(response) {
                            if (response.data.item.length > 0) {
                                v.inventories[index].item.site_list = response.data.item;
                                v.inventories[index].item.site = response.data.selectItem;
                                @if(costByLocation()=="true")
                                if (response.data.selectItem) {
                                    v.inventories[index].item.LasCost = response.data.selectItem.cost;
                                    v.inventories[index].item.description = response.data.selectItem.description;
                                }
                                @endif
                            } else {
                                v.inventories[index].item.site_list = [];
                                v.inventories[index].item.site = null;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            onItemSearchGeneral(){

                let inventory_category_id = 0;
                let inventory_site_id = 0;
                let inventory_brand_id = 0;
                let keyword = v.selected_inventory1;
                    
                // console.log(32,keyword);

                if (keyword && keyword != 1) {
                    inventory_category_id = (v.selected_iventory_category != undefined)?v.selected_iventory_category.id:inventory_category_id;
                    // inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.id:inventory_site_id;
                    
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'itemesSearchByCode', 
                            keyword: keyword,
                            inventory_category_id: inventory_category_id,
                            inventory_brand_id: inventory_brand_id,
                            inventory_site_id: inventory_site_id,
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            v.temp_items = [];
                            v.temp_items = response.data;
                            v.onItemloadGeneral(v.temp_items[0].id);
                        }else{
                            v.item_not_found = true;
                            setTimeout((function () {
                                v.item_not_found = false;
                                v.selected_inventory = null;
                                v.selected_inventory1 = null;
                                v.$refs.barcode_search1.focus();
                                // console.log(12);
                            }), 3e3)
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }

            },

            loadItemGeneral() {
                if (v.selected_inventory != undefined) {
                    var inventory_id = v.selected_inventory.id;
                   
                    // console.log(888, number);
                    let inventory_category_id = (v.selected_iventory_category != undefined)?v.selected_iventory_category.id:'';
                    let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.site_id:'';

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSale',
                                inventory_id: inventory_id,
                                inventory_category_id: inventory_category_id,
                                // inventory_brand_id: inventory_brand_id,
                                inventory_site_id: inventory_site_id,
                                // number: number,
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                var checkD = true;
                                @if(NotDuplicateItem() =="true")
                                if (v.inventories != null && response.data[0].id) {
                                    for (var i = 0; i < v.inventories.length; i++) {
                                        if (v.inventories[i].item && v.inventories[i].item != null) {
                                            if (v.inventories[i].item.id == response.data[0].id) {
                                                checkD = false;
                                            }
                                        }
                                    }
                                }
                                @endif

                                var rate = 0;
                                var static_rate = 0;
                                if (v.selected_currency.rate > 0) {
                                    rate = v.selected_currency.rate;
                                    static_rate = v.selected_currency.static_rate;
                                }

                                if (checkD) {
                                    v.selected_item = null;
                                    v.selected_iventory_site = null;
                                    v.selected_item = response.data[0];
                                    @if(systemConfig()[30] == 1)
                                    v.selected_price = (Number.parseFloat(response.data[0].rate) * static_rate /  Number.parseFloat(rate)).toFixed(precision());
                                    @else 
                                    v.selected_price = (Number.parseFloat(response.data[0].rate) * Number.parseFloat(rate)).toFixed(precision());
                                    @endif
                                    v.inventory_sites1 = response.data[0].site_list;  
                                    v.last_item_sale = response.data[0].last_item_sale; 
                                    v.last_item_purchase = response.data[0].last_item_purchase; 
                                    v.AdvancePrice = response.data[0].advance_price; 
                                    v.AdvancePrice_cost = response.data[0].advance_price_cost; 
                                    // console.log(123, response.data[0]);
                                }else{
                                    v.selected_inventory = null;
                                    v.selected_inventory1 = null;
                                    v.counter_check = 0;
                                    v.temp_items = [];
                                    v.selected_item = null;
                                    v.selected_price = 0;
                                    v.selected_quantity = 0;
                                    v.$refs.barcode_search.$refs.search.focus();
                                }
                            }else{
                                // $('#success-sound')[0].play();
                                // $('#error-sound')[0].play();
                                v.item_not_found = true;
                                setTimeout((function () {
                                    v.item_not_found = false;
                                    v.$refs.barcode_search.$refs.search.focus();
                                }), 2e3)
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })

                }
            },

            changeMesurss() {
                setTimeout(() => {
                    if (v.selected_item) {
                        if (v.selected_item.measure && v.selected_item.measure_unit && v.selected_currency) {
                            var rate = v.selected_currency.rate;
                            var static_rate = v.selected_currency.static_rate;
                            @if(systemConfig()[30] == 1)
                            v.selected_price = (((Number.parseFloat(v.selected_item.rate) / Number.parseFloat(v.selected_item.measure_unit)) * Number.parseFloat(v.selected_item.measure.measure_unit)) * static_rate / Number.parseFloat(rate)).toFixed(precision());
                            @else 
                            v.selected_price = (((Number.parseFloat(v.selected_item.rate) / Number.parseFloat(v.selected_item.measure_unit)) * Number.parseFloat(v.selected_item.measure.measure_unit)) * Number.parseFloat(rate)).toFixed(precision());
                            @endif
                        }
                    } 
                }, 300);
            },

            ChangeOil() {
                if (v.oil_sale == false) {
                    v.oil_sale = true;
                } else {
                    v.oil_sale = false;
                }
                // console.log(v.oil_sale);
            },
            change_oil_qty(index) {
                if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {

                    var quantity = this.inventories[index]['item']['quantity'];
                    var density = this.inventories[index]['item']['density'];
                    if (quantity > 0 && density > 0) {
                        this.inventories[index]['item']['oil_qty'] = Number.parseFloat(quantity / density).toFixed(7);
                    }
                    // var oil_qty = this.inventories[index]['item']['oil_qty'];
                }
            },
            change_qty_by_oil(index) {
                if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {

                    var oil_qty = this.inventories[index]['item']['oil_qty'];
                    var density = this.inventories[index]['item']['density'];
                    if (oil_qty > 0 && density > 0) {
                        this.inventories[index]['item']['quantity'] = Number.parseFloat(oil_qty * density).toFixed(7);
                    }
                    // var oil_qty = this.inventories[index]['item']['oil_qty'];
                }
            },

            changeDensity(index) {
                if (v.inventories[0]['item'] != null || v.inventories[0]['inventory_site'] != null) {
                    @if(systemConfig()[27] == 1)
                    if (v.inventories[index]['item']['site'] && v.oil_sale) {
                        if (v.inventories[index].item.site.per_qty) {
                            v.inventories[index].item.density = v.inventories[index].item.site.per_qty;
                            v.change_qty_by_oil(index);
                        }
                    }
                    @endif
                }
            },

            changeCostBylLocation(index) {
                @if(costByLocation()=="true")
                setTimeout(() => {
                    if (v.inventories[index]['item'] != null) {
                        if (v.inventories[index]['item']['site']) {
                            if (v.inventories[index].item.site.cost) {
                                v.inventories[index].item.LasCost = v.inventories[index].item.site.cost;
                            }
                        }
                    } 
                }, 200);
                @endif
            },

            addData() {
                if (v.selected_item && v.selected_quantity > 0) {
                    v.selected_quantity_error = false;
                    v.AdvancePrice = null;
                    v.AdvancePrice_cost = null;
                    var che = null;
                    for (var i = 0; i < v.inventories.length; i++) {
                        if (v.inventories[i].item && v.inventories[i].item != null) {
                            che = 'ok';
                        } else {
                            v.inventories.splice(i, 1);
                        }
                    }
                    if(!che){
                        v.inventories = [];
                    }

                    let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.site_id:'';
                    if (inventory_site_id) {
                        for (var i = 0; i < v.selected_item.site_list.length; i++) {
                            if (v.selected_item.site_list[i].site_id == inventory_site_id) {
                                v.selected_item.site = v.selected_item.site_list[i];
                            }
                        }
                    }

                    var rate = 0;
                    var static_rate = 0;
                    if (v.selected_currency.rate > 0) {
                        rate = v.selected_currency.rate;
                        static_rate = v.selected_currency.static_rate;
                    }

                    v.selected_item.quantity = (v.selected_quantity > 0)?v.selected_quantity:1;
                    @if(systemConfig()[30] == 1)
                    v.selected_item.new_rate = (v.selected_price > 0)?(Number.parseFloat(v.selected_price) / static_rate * Number.parseFloat(rate)):1;
                    @else 
                    v.selected_item.new_rate = (v.selected_price > 0)?(Number.parseFloat(v.selected_price) / Number.parseFloat(rate)):1;
                    @endif
                    v.inventories.unshift({
                        inventory: v.selected_item,
                        item: v.selected_item,
                        location: null,
                        selected_taxation: null,
                        tax: v.selected_item.row_tax_stat,
                        sub_total: v.selected_item.sub_total_stat,
                        item_category: v.selected_item.item_category,
                        item_brand: v.selected_item.inventory_brand,
                        price_level:null
                    });

                    v.selected_inventory = null;
                    v.selected_inventory1 = null;
                    v.counter_check = 0;
                    // v.temp_items = [];
                    // v.selectSaleNumber(0);
                    @if(getShwoPriceLevel()=="general_percent")
                    setTimeout((function () {
                        v.change_sale_rate_by_price_level_general();
                    }), 400);
                    @endif

                    // const inp = v.$refs.barcode_search.$refs.search;
                    // console.log(v.$refs.barcode_search.$refs.search.value);
                    v.$refs.barcode_search.$refs.search.focus();
                    // v.$refs.barcode_search.$refs.search = null;
                    // v.$refs.barcode_search.focus();

                    v.selected_item = null;
                    v.selected_price = 0;
                    v.selected_quantity = 0;
                    
                }else{
                    v.$refs.selected_quantity.focus();
                    v.selected_quantity_error = true;
                }

                this.NewCounters();

            },
            
            resetData() {
                v.AdvancePrice = null;
                v.AdvancePrice_cost = null;
                v.selected_inventory = null;
                v.selected_item = null;
                v.selected_iventory_site = null;
                v.temp_items = [];
                v.selected_price = 0;
                v.selected_quantity = 0;
                v.$refs.barcode_search.$refs.search.focus();
            },

            callOnItemloadGeneral() {
                v.editKey = false;
                if (v.counter_check == 0) {
                    v.counter_check = 1;
                    @if(getBarcodeType()=="true")
                    setTimeout((function () {
                        v.counter_check1 = v.selected_inventory1;
                        v.call2();
                        // console.log(12);
                    }), 1e1)
                    @else
                    setTimeout((function () {
                        v.counter_check1 = v.selected_inventory1;
                        v.call2();
                        // console.log(12);
                    }), 2e2)
                    @endif
                }
            },
            call2() {
                @if(getBarcodeType()=="true")
                setTimeout((function () {
                    v.counter_check2 = v.selected_inventory1;
                    v.onItemloadGeneral();
                    // console.log(13);
                }), 1e1)
                @else
                setTimeout((function () {
                    v.counter_check2 = v.selected_inventory1;
                    v.onItemloadGeneral();
                    // console.log(13);
                }), 2e2)
                @endif
            },

            onItemloadGeneral(id = null) {
                if (v.counter_check1 != v.counter_check2) {
                    v.counter_check1 = v.selected_inventory1;
                    v.call2();
                }else{
                    if (v.selected_inventory != undefined || id || v.selected_inventory1) {

                        var inventory_id = id;
                        if (v.selected_inventory != undefined) {
                            inventory_id = v.selected_inventory.id;
                        }

                        let inventory_category_id = (v.selected_iventory_category != undefined)?v.selected_iventory_category.id:'';
                        let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.id:'';

                        let number = v.selected_inventory1;

                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSale',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                    // inventory_brand_id: inventory_brand_id,
                                    inventory_site_id: inventory_site_id,
                                    // price_level_id: price_level_id,
                                    number: number,
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    var che = null;
                                    var checkD = true;

                                    @if(NotDuplicateItem() =="true")
                                    if (v.inventories != null && response.data[0].id) {
                                        for (var i = 0; i < v.inventories.length; i++) {
                                            if (v.inventories[i].item && v.inventories[i].item != null) {
                                                if (v.inventories[i].item.id == response.data[0].id) {
                                                    v.inventories[i].item.quantity = ( Number.parseFloat(v.inventories[i].item.quantity) + 1);
                                                    checkD = false;
                                                }
                                            }
                                        }
                                    }
                                    @endif

                                    if (checkD) {
                                        for (var i = 0; i < v.inventories.length; i++) {
                                            if (v.inventories[i].item && v.inventories[i].item != null) {
                                                che = 'ok';
                                            } else {
                                                v.inventories.splice(i, 1);
                                            }
                                        }
                                        if(!che){
                                            v.inventories = [];
                                        }
                                        // console.log(response.data[0]);
                                        if (inventory_site_id) {
                                            for (var i = 0; i < response.data[0].site_list.length; i++) {
                                                if (response.data[0].site_list[i].site_id == inventory_site_id) {
                                                    response.data[0].site = response.data[0].site_list[i];
                                                }
                                            }
                                        }
                                        response.data[0].quantity = (v.selected_quantity > 0)?v.selected_quantity:1;

                                        v.inventories.unshift({
                                            inventory: response.data[0],
                                            item: response.data[0],
                                            location: null,
                                            selected_taxation: null,
                                            tax: response.data[0].row_tax_stat,
                                            sub_total: response.data[0].sub_total_stat,
                                            item_category: response.data[0].item_category,
                                            item_brand: response.data[0].inventory_brand,
                                            price_level:null
                                        });

                                        v.temp_items = [];
                                        v.selected_inventory = null;
                                        v.selected_inventory1 = null;
                                        v.counter_check = 0;

                                        @if(getShwoPriceLevel()=="general_percent")
                                        setTimeout((function () {
                                            v.change_sale_rate_by_price_level_general();
                                        }), 400);
                                        @endif

                                        // const inp = v.$refs.barcode_search.$refs.search;
                                        // console.log(v.$refs.barcode_search.$refs.search.value);
                                        // v.$refs.barcode_search.$refs.search.focus();
                                        // v.$refs.barcode_search.$refs.search = null;
                                        v.$refs.barcode_search1.focus();
                                        
                                    }else{
                                        setTimeout((function () {
                                            v.selected_inventory = null;
                                            v.selected_inventory1 = null;
                                            v.counter_check = 0;
                                            v.$refs.barcode_search1.focus();
                                        }), 2e2)
                                    }
                                }else{
                                    v.item_not_found = true;
                                    setTimeout((function () {
                                        v.item_not_found = false;
                                        v.selected_inventory = null;
                                        v.selected_inventory1 = null;
                                        v.counter_check = 0;
                                        v.$refs.barcode_search1.focus();
                                        // console.log(12);
                                    }), 2e3)
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })

                    }
                }
            },

            //ajax call to get items
            setIndex(e) {
                //v.temp_items=[];
                this.selected_index = e;
            },
            inventorySiteChange(index) {
                v.setIndex(index);

                v.selected_iventory_site = this.inventories[this.selected_index]['inventory_site'];
                if (this.inventories[this.selected_index]['inventory_site'] != null) {
                    let inventory_site_id = this.inventories[this.selected_index]['inventory_site'].id;
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                inventory_site_id: inventory_site_id
                            }
                        })
                        .then(function(response) {
                            if (v.purchase_orders) {} else {
                                v.inventories[v.selected_index]['item'] = null;
                                v.inventories[v.selected_index]['inventory'] = null;
                            }
                            v.temp_items = [];
                            if (response.data.length > 0) {
                                v.temp_items = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }

            },
            itemCategoryChange(index) {
                v.setIndex(index);
                v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                if (this.inventories[this.selected_index]['item_category'] != null) {
                    let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                    let inventory_brand_id = (v.inventories[v.selected_index]['item_brand'] != undefined) ? v.inventories[v.selected_index]['item_brand'].id : '';

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id
                            }
                        })
                        .then(function(response) {
                            v.inventories[v.selected_index]['item'] = null;
                            v.inventories[v.selected_index]['inventory'] = null;
                            v.temp_items = [];
                            if (response.data.length > 0) {
                                v.temp_items = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }

            },

            itemBrandChange(index) {
                v.setIndex(index);

                v.selected_iventory_brand = this.inventories[index]['item_brand'];
                if (this.inventories[index]['item_brand'] != null) {
                    let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                    let inventory_brand_id = this.inventories[index]['item_brand'].id;
                    
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id
                            }
                        })
                        .then(function(response) {
                            v.inventories[index]['item'] = null;
                            v.inventories[index]['inventory'] = null;
                            v.temp_items = [];
                            if (response.data.length > 0) {
                                v.temp_items = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }
            },

            // end item search

            // contract search
            contractSearch(id, vm) {
                vm.contract = [];
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member_contract',
                            member_id: id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            vm.contract = response.data;
                        }
                        // loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            },
            // end contract search

            // get provided search
            get_provided(id, vm) {
                vm.provided_card = 0;
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'count_member_factor',
                        member_id: id
                    }
                })
                .then(function(response) {
                    if (response.data) {
                        vm.provided_card = response.data;
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
            },
            // end get provided search

            // generic function for adding item to list
            addNew(type = null, index) {
                v.selected_index = index;
                if (v.inventories[index] != undefined) {
                v.selected_iventory_category = this.inventories[index]['item_category'];
                v.selected_iventory_site = this.inventories[index]['inventory_site'];
                v.selected_iventory_brand = this.inventories[index]['item_brand'];
                    @if(getShwoPriceLevel()=="general_percent")
                    this.change_sale_rate_by_price_level_general();
                    @endif
                }
                // this.temp_items = [];
                if (type != null) {
                    if (type == 'inventory') {
                        if (this.inventories[index + 1] == undefined) {
                            this.temp_items = [];
                            this.inventories.push({
                                inventory: null,
                                item: null,
                                location: null,
                                description2: null,
                                other_measure_amount: null,
                                other_measure_amount2: null,
                                commission: 'on',
                                item_category: this.selected_iventory_category,
                                item_brand: this.selected_iventory_brand,
                                inventory_site: this.selected_iventory_site,
                                price_level:null
                            });
                        }
                    }
                    if (type == 'service') {
                        if (this.services[index + 1] == undefined) {
                            this.checkExistingService(index, '');
                            this.services.push({
                                items: this.all_services,
                                item: null,
                            });
                        }
                    }
                    if (type == 'payment') {
                        if (this.payments[index + 1] == undefined) {
                            this.checkExistingPayment(index, '');
                            this.payments.push({
                                items: this.banks,
                                item: null,
                            });
                        }
                    }
                }

            },

            // in here you can check and decide to allow duplicate bank for payment or not
            checkExistingPayment(index = null, name = '') {
                var bank_temp = this.banks.slice();
                var bank_temp1 = [];
                for (var i = 0; i < this.payments.length; i++) {
                    if (this.payments[i].item != null) {
                        var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                        if (fined != -1) {
                            var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                        }
                    }
                }
                this.payments[index].items = bank_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;


            },

            // in here you can check and decide to allow duplicate service or not
            checkExistingService(index = null, name = '') {
                var service_temp = this.all_services.slice();
                var service_temp1 = [];
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item != null) {
                        var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                        if (fined != -1) {
                            var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                        }
                    }
                }
                this.services[index].items = service_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;


            },
            // delete item from list
            deleteItem(type = null, index) {
                this.editKey = false;
                if (type != null) {
                    // console.log(type);
                    if (type == 'inventory') {
                        this.inventories.splice(index, 1);
                    }
                    if (type == 'service') {
                        this.services.splice(index, 1);
                    }
                    if (type == 'payment') {
                        this.payments.splice(index, 1);
                    }
                }

            },
            // submit the form
            submitForm() {

                if (this.isError == true) {
                    alert('there is no item');
                    return false;
                }
                v.disabled = true;
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("sales-form").submit()
                    } else {
                        v.disabled = false;
                    }
                });

            },
            defaultValue() {
                this.selected_customer = null;
                this.selected_index = 0;

                this.inventories = [{
                    inventory: null,
                    item: null,
                    item_category: this.selected_iventory_category
                }, ];
                this.services = [{
                        items: all_services,
                        item: null,
                    },
                    {
                        items: all_services,
                        item: null,
                    },
                ];
                this.payments = [{
                    items: all_services,
                    item: null,
                }];

                this.invoiceDescription = null;
                this.saleOrderList = [];
                this.selected_sale_order = null;
                this.member_id = null;
                this.discountFiled = 0;
                this.commissionFiled = 0;
                this.temp_items = [];

            },
            saveAndNew() {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                            v.disabled = true;
                            var url = "{{route('sale.store')}}";
                            form_id = 'sales-form';
                            var data = $('#' + form_id).serialize();
                            toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    if (response.data.result == 1) {
                                        $('#' + form_id).trigger('reset');
                                        //$('#success-sound')[0].play();
                                        toastr.success('', response.data.message);
                                        v.number = Number(v.old_number) + 1;
                                        v.old_number = Number(v.old_number) + 1;
                                        v.ref_no = null;
                                        
                                        // factorPrint(response.data.sale_id)
                                        // v.defaultValue();
                                        location.reload();
                                    } else {
                                        var message = "{{__('message.Warning')}}";
                                        v.disabled = false;
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }
                                })
                                .catch(function(error) {
                                    toggleBlock(0);
                                    v.disabled = false;
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },
        },

    });
</script>


@endpush