@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('inventory_category');
$_description=in_array('description', $report);
$_name=in_array('name', $report);
$_parent=in_array('parent', $report);

?>
    <h3 class="table-caption" style="text-align: center;">@lang('layout.TaxationReport')</h3>
    <table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
<br>

  <table class="report-table">


  <tr class="bg">

   <td colspan="4" class="center"><div style="font-weight: bold;">@lang('layout.Sales')</div></td>
   <td colspan="3" class="center"><div style="font-weight: bold;">@lang('menu.Taxation')</div></td>
   <td colspan="3" class="center"><div style="font-weight: bold;">@lang('layout.Amount')</div></td>



 </tr>  

 <tr class="bg">

   <td class="center" ><div> @lang('layout.Record') </div></td>
   <td class="center" ><div> @lang('layout.Date') </div></td>
   <td class="center" ><div> @lang('layout.SaleNumber') </div></td>
   <td class="center" ><div> @lang('layout.Customer') </div></td>
   <td class="center" ><div> @lang('layout.Name') </div></td>
   <td class="center" ><div> @lang('layout.Percent') </div></td>
   <td class="center" ><div> @lang('layout.Vendor') </div></td>
   <td class="center" ><div> @lang('layout.Currency') </div></td>
   <td class="center" ><div> @lang('layout.Rate') </div></td>
   <td class="center" ><div> @lang('layout.Amount') </div></td>




 </tr>
 <?php
 $count = 0;
 $total_home_currency=0;
  $currencies=[];
 ?>
 @foreach($data AS $record)

 <?php
    
   $total_home_currency+=$record->exchanged_amount;
   if(array_key_exists($record->tax_currency, $currencies))
   {
    $currencies[$record->tax_currency]=$currencies[$record->tax_currency]+$record->tax_amount;
  }
  else
  {

    $currencies[$record->tax_currency]=$record->tax_amount;
  }
  ?>


 <tr>
 <td class="center">{{++$count}}</td>

 <td  class="center">{{convertDate($record->sale_date)}}</td>
 <td  class="center">{{$record->sale_number}}</td>
 <td  class="center">{{$record->customer_name}}</td>
 <td  class="center">{{$record->name}}</td>
 <td  class="center">{{$record->percent}}</td>
 <td  class="center">{{$record->vendor_name}}</td>
 <td  class="center">{{$record->tax_currency}}</td>
 <td  class="center">{{$record->tax_rate}}</td>
 <td  class="center"><b>{{myRound($record->tax_amount)}}</b></td>

</tr>
  @endforeach   
</table>



<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center"> @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>
<!-- <tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{round($total_home_currency,2)}} {{getReportCurrency()}}</div></td>

</tr> -->

</table>


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection