@extends('layouts.app')
@section('content')
@section('style')
@stop
<div class="row">

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.DiscountDateCreate')</span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;" id="taxation">
            <!-- BEGIN FORM-->
            {!! Form::open(array('route' => 'saleDiscountDate.store','method'=>'POST','class'=>'form-horizontal')) !!}
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-2">@lang('layout.Name'):</label>
                            <div class="col-md-10">
                                {{Form::text('name',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Name'),'placeholder' => __('layout.Name'),'autofocus'=>'autofocus'])}}
                                <span class="required">@{{ errors.first('name') }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-4">@lang('layout.Days'):</label>
                            <div class="col-md-8">
                                {{Form::number('days',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Days'),'placeholder' => __('layout.Days'),'autofocus'=>'autofocus'])}}
                                <span class="required">@{{ errors.first('days') }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-2">@lang('layout.Discount'):</label>
                            <div class="col-md-10">
                                {{Form::number('discount',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Discount'),'placeholder' => __('layout.Discount'),'autofocus'=>'autofocus'])}}
                                <span class="required">@{{ errors.first('discount') }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-2">@lang('layout.Description'):</label>
                            <div class="col-md-10">
                                {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 60)) !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                <button @click="handleSubmit($event)" type="button" class="btn green">@lang('layout.Submit')</button>
                <a href="{{route('taxation.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>

@endsection

@push('scripts')

<script>
    @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

    Vue.component("v-select", VueSelect.VueSelect);

    let vu = new Vue({
        el: '#taxation',
        data: {
            // selected_member: null
        },
        methods: {
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        regForm(e.target);
                    }
                });
            },
        }
    })
</script>
@endpush