@extends('layouts.app')
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'saleArea'"
                      @closed="closeModal">
        </report-modal>
    </div>


    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.SaleAreaList')</span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">

                    @permission('saleArea-export')

                    <!--  <span id="anchore-modal">
                          <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                             <i class="fa fa-print"></i>
                          </a>
                      </span> -->
                    @endpermission
                    @permission('saleArea-create')
                    <a href="{{route('saleArea.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_filter_data">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="saleArea">
                    <thead>
                    <tr>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Parent')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#saleArea').DataTable({
                ajax: '{{route("saleArea.index")}}',
                pageLength: '{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'name', name: 'name'},
                    {data: 'parent', name: 'parent', searchable: false, orderable: false},
                    {data: 'description', name: 'description'},
                    {data: 'action', searchable: false, orderable: false},
                ]
            });
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        new Vue({
            el: '#company_filter_data',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload()
                    }
                }
            }
        });
    </script>


@endpush
