@extends('layouts.app')
@section('content')
@section('style')
@stop
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.UpdateSaleArea')</span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;" id="sale-area">
            <!-- BEGIN FORM-->
            {!! Form::model($saleArea, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['saleArea.update',$saleArea->id]]) !!}
            <div class="form-body" id="app">
                <div class="col-md-9">
                    <div class="form-group">
                        <label class="control-label col-md-3">@lang('layout.Name'):</label>
                        <div class="col-md-9">
                            {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.Name')])}}
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-md-3">@lang('layout.ParentID'):</label>
                        <div class="col-md-9">
                            <v-select label="name" :options="parent" v-model="selected_parent"
                                      @input="memberClassChange()"></v-select>
                            <input type="hidden" name="parent_id" :value="!selected_parent?null:selected_parent.id">

                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-md-3">@lang('layout.Description'):</label>
                        <div class="col-md-9">
                            {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 6, 'cols' => 30)) !!}

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>

                <button href="{{url('inventorySite.index')}}" class="btn default"><i
                            class="fa fa-mail-reply"></i> @lang('layout.Cancel')</button>
            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection

@push('scripts')

    <script>

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component("v-select", VueSelect.VueSelect);

        var parent ={!! $parent !!};
        var saleArea ={!! $saleArea !!};

        let vu = new Vue({
            el: '#sale-area',
            data: {
                parent: parent,
                selected_parent: null,
                saleArea: saleArea
            },
            mounted: function () {
                if (this.saleArea) {
                    this.selected_parent = _.find(this.parent, (c) => c.id == this.saleArea.parent_id);
                }
            },
            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },

            }
        })
    </script>
@endpush
