@extends('layouts.app')
@section('content')
@section('style')
@stop
<div class="row">

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.AddNewSaleArea')</span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>


        </div>


        <div class="portlet-body form" style="margin-bottom:50%;" id="sale-area">
            <!-- BEGIN FORM-->
            {!! Form::open(array('route' => 'saleArea.store','method'=>'POST','class'=>'form-horizontal','id'=>'sale-area-form')) !!}
            {{ csrf_field() }}
            <div class="form-body">
                <div class="col-md-9">
                    <div class="form-group">
                        <label class="control-label col-md-3">@lang('layout.Name'):</label>
                        <div class="col-md-9">
                            {{Form::text('name',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.SiteName'),'placeholder' => __('layout.Name')])}}
                            <span class="required">@{{ errors.first('name') }}</span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-md-3">@lang('layout.ParentID'):</label>
                        <div class="col-md-9">
                            <v-select label="name" :options="parent" v-model="selected_parent"
                                      @input="memberClassChange()"></v-select>
                            <input type="hidden" name="parent_id" :value="!selected_parent?null:selected_parent.id">

                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-md-3">@lang('layout.Description'):</label>
                        <div class="col-md-9">
                            {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 6, 'cols' => 30)) !!}

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                <button @click="handleSubmit($event)" type="button" class="btn green">@lang('layout.Submit')</button>
                <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>

                <a href="{{route('inventorySite.index')}}" class="btn default"><i
                            class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>

@endsection

@push('scripts')

    <script>

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component("v-select", VueSelect.VueSelect);

        var parent ={!! $parent !!};

        let vu = new Vue({
            el: '#sale-area',
            data: {
                parent: parent,
                selected_parent: null,
            },
            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                saveAndNew('sale-area-form', "{{route('saleArea.store')}}")
                            }
                        })
                }
            }
        })
    </script>
@endpush
