@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.InvoiceInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th width="20px;">
                                <i class="fa  fa-bars"></i> @lang('layout.SalesNumber')
                            </th>

                            <th class="">
                                <i class="fa fa-user"></i> @lang('layout.Customer')
                            </th>
                            <th>
                                <i class="fa fa-file-excel-o"></i> @lang('layout.Account')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Date')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.OverdueDate')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Hour')
                            </th>
                            <th width="20px;">
                                <i class="fa  "></i> @lang('layout.Rate')
                            </th>
                            <th>
                                <i class="fa "></i> @lang('layout.Amount')
                            </th>
                            <th>
                                <i class="fa "></i> @lang('layout.Discount')
                            </th>
                            <th>
                                <i class="fa  "></i> @lang('layout.Currency')
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class=" "> {{ $invoice->number}}  </td>
                            <td class=""> {{ $invoice->member_name }}  </td>
                            <td class=""> {{ $invoice->account_name}}  </td>
                            <td class=""> {{ convertDate($invoice->date)}}  </td>
                            <td class=""> {{ convertDate($invoice->overdue_date)}}  </td>
                            <td class=""> {{ $invoice->hour}}  </td>
                            <td class=""> {{ $invoice->rate }}  </td>
                            <td class=""> {{ myRound($invoice->amount) }}  </td>
                            <td class=""> {{ myRound($invoice->discount) }}  </td>
                            <td class=""> {{ $invoice->currency }}  </td>
                        </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th width="">
                            <i class=" fa fa-text-width"></i> @lang('layout.Description')
                        </th>
                        <th width=" ">
                            <i class=" fa fa-text-width"></i> @lang('layout.Memo')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class=" "> {{ $invoice->description}}  </td>
                        <td class=" "> {{ $invoice->memo}}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.InvoiceDetails') </span>
                    </div>
                    <div class="tools"></div>
                    <div class="actions">
                        {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                        <input type="hidden" name="type" value="saleByTypeDetail"/>
                        <input type="hidden" name="id" value="{{$invoice->invoice_id}}"/>
                        <button type="submit" class="btn btn-success"><i
                                    class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}}

                        {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                        <input type="hidden" name="type" value="saleByTypeDetail"/>
                        <input type="hidden" name="id" value="{{$invoice->invoice_id}}"/>
                        <button type="submit" class="btn btn-success"><i
                                    class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="invoices">
                        <thead>
                        <tr>
                            <th>@lang('layout.ItemName')</th>
                            <th>@lang('layout.Unit/M')</th>
                            <th>@lang('layout.PurchaseDate')</th>
                            <th>@lang('layout.SleepStaff')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.Price')</th>
                            <th>@lang('layout.Cost')</th>
                            <th>@lang('layout.Income')</th>
                            <th>@lang('layout.Total')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')

    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#invoices').DataTable({
                ajax: '{{route("saleByType.show",$invoice->invoice_id)}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'name', name: 'name', orderable: false, searchable: false},
                    {data: 'symbol', name: 'symbol', orderable: false, searchable: false},
                    {data: 'stocks_date', name: 'stocks_date', orderable: false, searchable: false},
                    {data: 'sleepDate', name: 'sleepDate', orderable: false, searchable: false},
                    {data: 'qty', name: 'qty', orderable: false, searchable: false},
                    {data: 'price', name: 'price', orderable: false, searchable: false},
                    {data: 'avgCost', name: 'avgCost', orderable: false, searchable: false},
                    {data: 'income', name: 'income', orderable: false, searchable: false},
                    {data: 'total', name: 'total', orderable: false, searchable: false},
                ]
            });


        });
    </script>


@endpush
