@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@section('content')
    @include("layouts.Cmodal")
    @include("invoices.modal")
    <div class="row">
        <div class="portlet light bordered">
            <!-- BEGIN TAB PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.EditFactor')</span>
                    </div>
                    <div class="actions">
                    </div>
                </div>
                <div id="appInvoice" class="portlet-body">

                    <div class="tabbable tabbable-tabdrop">

                        <div>

                            {!! Form::model($invoice, ['method' => 'PATCH','class'=>'form-horizontal','id'=>'sales-form','route' => ['saleByType.update',$invoice->id]]) !!}
                            {{ csrf_field() }}
                            <div class="tab-content">

                                <div class="tab-pane active" id="tab1">

                                    <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                        <!-- begin sale order modal -->
                                        <div id="salOrderApp" v-cloak>
                                        <!-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}} -->
                                            <input type="hidden" name="type" value="invoicelist"/>
                                            <!-- use the modal component, pass in the prop -->
                                            <modal v-if="showModalSaleOrder" @close="showModalSaleOrder = false">
                                                <div slot="body">
                                                    <div class="row">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label ">@lang('layout.Select') </label>
                                                                <select class="form-control"
                                                                        style="border: 1px solid black !important"
                                                                        v-model="selected_sale_order"
                                                                        @input="saleOrderChang()">
                                                                    <option v-for="order in saleOrderList"
                                                                            :value="order">
                                                                      <span>
                                                                         @{{order.type+':'+order.number+' '+order.description}}
                                                                      </span>
                                                                    </option>
                                                                </select>
                                                            </div>


                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="form-group">

                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.Currency') </label>
                                                                <input type="text" name=""
                                                                       :value="(!selected_sale_order)?null:selected_sale_order.currency"
                                                                       class="form-control" disabled="disabled">
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.Rate') </label>
                                                                <input type="text" name=""
                                                                       :value="(!selected_sale_order)?null:selected_sale_order.rate"
                                                                       class="form-control" disabled="disabled">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="form-group">

                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.Date') </label>
                                                                <input type="text" name=""
                                                                       :value="(!selected_sale_order)?null:selected_sale_order.date"
                                                                       class="form-control" disabled="disabled">
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.DeliveryDate') </label>
                                                                <input type="text" name=""
                                                                       :value="(!selected_sale_order)?null:selected_sale_order.delivery_date"
                                                                       class="form-control" disabled="disabled">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label ">@lang('layout.Description') </label>
                                                                <input type="text" name=""
                                                                       :value="(!selected_sale_order)?null:selected_sale_order.description"
                                                                       class="form-control" disabled="disabled">
                                                            </div>

                                                        </div>
                                                    </div>
                                                    <br>
                                                    <p style="color: red">@lang('layout.SOmsg')

                                                </div>

                                                <div slot="footer">
                                                    <button type="button" v-if="selected_sale_order"
                                                            @click="getsalesOrders" class="btn btn-success">
                                                        @lang('layout.Submit')
                                                    </button>
                                                    <button type="button" class="btn btn-danger"
                                                            v-on:click="showModalSaleOrder=false">
                                                        @lang('layout.Cancel')
                                                    </button>
                                                </div>
                                            </modal>
                                        <!-- {{Form::close()}} -->
                                        </div>
                                        <!-- end sale order modal -->

                                        <!-- BEGIN FORM-->


                                        <div class="form-body">
                                            <div class="row">
                                                <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                                                    <!-- begin inputs -->
                                                    <div class="row">
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Customer')</label>

                                                                    <v-select label="name" @input="memberChange()"
                                                                        @search="MemberSearch" :options="customer"
                                                                        v-model="selected_customer"></v-select>
                                                                    <input type="hidden" name="customer"
                                                                           v-validate="'required'"
                                                                           data-vv-as="@lang('layout.Customer')"
                                                                           :value="!selected_customer?null:selected_customer.id"
                                                                           required>
                                                                    <span class="required">@{{ errors.first('customer') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>


                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label col-md-12"><br></label>

                                                                    <button type="button" class="btn blue btn-block"
                                                                            @click="showModal = true">@lang('layout.NewCustomer')</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.InvoiceNumber')</label>

                                                                    <input type="number" name="number"
                                                                           v-validate="'required|numeric'"
                                                                           data-vv-as="@lang('layout.InvoiceNumber')"
                                                                           value="{{$invoice->number}}"
                                                                           class="form-control">
                                                                    <span class="required">@{{ errors.first('number') }}</span>
                                                                </div>
                                                            </div>
                                                        </div> 
                                                    </div> 
                                                    <div class="row"> 
                                                        <div class="{{auth()->user()->company()->first()->tag != 1 ? 'col-lg-3 col-md-3' : 'col-lg-4 col-md-4'}} col-sm-12 col-xs-12">
                                                            <div class="form-group"> 
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Currency')</label> 
                                                                    <v-select label="code" @input="selectedRate"
                                                                              :options="setRates"
                                                                              v-model="selected_currency"></v-select>
                                                                    <input type="hidden" name="currency"
                                                                           v-validate="'required'"
                                                                           data-vv-as="@lang('layout.Currency')"
                                                                           :value="selected_currency.code">
                                                                    <span class="required">@{{ errors.first('currency') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="{{auth()->user()->company()->first()->tag != 1 ? 'col-lg-3 col-md-3' : 'col-lg-4 col-md-4'}} col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Rate')</label>

                                                                    <input type="number"
                                                                           name="currency_rate"
                                                                           v-validate="'required'"
                                                                           data-vv-as="@lang('layout.Rate')"
                                                                           v-model="!selected_currency?0:selected_currency.rate"
                                                                           class="form-control"
                                                                           :class="{'has-error':rate<=0}">
                                                                    <span class="required">@{{ errors.first('currency_rate') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        @if(auth()->user()->company()->first()->tag != 1)
                                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                <div class="form-group">

                                                                    <div class="col-md-12">
                                                                        <label class="control-label">@lang('layout.ExchangeRateHQ')</label>

                                                                        <input type="number" name="currency_rate_hq"
                                                                               v-validate="'required'"
                                                                               data-vv-as="@lang('layout.ExchangeRateHQ')"
                                                                               v-model="!selected_currency?0:selected_currency.hq_rate"
                                                                               class="form-control"
                                                                               :class="{'has-error':rate<=0}">
                                                                        <span class="required">@{{ errors.first('currency_rate') }}</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endif

                                                        <div class="{{auth()->user()->company()->first()->tag != 1 ? 'col-lg-3 col-md-3' : 'col-lg-4 col-md-4'}} col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Discount')</label>

                                                                    <div class="input-group">

                                                                        <input v-model="discountFiled"
                                                                               class="form-control"
                                                                               type="number" min="0" max="100">
                                                                        <span v-if="discountIsAmount"
                                                                              @click="discountIsAmount = !discountIsAmount"
                                                                              class="input-group-addon">@{{selected_currency.symbol}}
                                                                          <input type="hidden" class="input-group-addon"
                                                                                 name="discount_type"
                                                                                 value="currency">
                                                                      </span>
                                                                        <span v-else
                                                                              @click="discountIsAmount = !discountIsAmount"
                                                                              class="input-group-addon">%
                                                                          <input type="hidden" name="discount_type"
                                                                                 value="percent">
                                                                      </span>
                                                                        <input type="hidden" name="discountTotal"
                                                                               :value="discount">
                                                                        <input type="hidden" name="discount"
                                                                               :value="discountFiled">
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">

                                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Description')</label>
                                                                    <textarea name="description" class="form-control" rows="1">{{$invoice->description}}</textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Date')</label>
                                                                    <input type="text" name="date"
                                                                           value="{{$invoice->date}}"
                                                                           class="form-control date" autocomplete="off">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.OverdueDate')</label>
                                                                    <input type="text" name="overdue_date"
                                                                           class="form-control date" autocomplete="off"
                                                                           value="{{$invoice->overdue_date}}">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Hour')</label>
                                                                    <div class="input-group">
                                                                        @if(getHourType() == 24)
                                                                        <input type="text" class="form-control timepicker timepicker-24" name="hour" value="{{$invoice->hour}}">
                                                                        @else
                                                                        <input type="text" class="form-control timepicker timepicker-no-seconds" name="hour" value="{{$invoice->hour}}" >
                                                                        @endif
                                                                        <span class="input-group-btn">
                                                                            <button class="btn default" type="button">
                                                                                <i class="fa fa-clock-o"></i>
                                                                            </button>
                                                                        </span>
                                                                    </div>
                                                                    {{-- <label class="control-label">@lang('layout.OverdueDate')</label>
                                                                    <input type="text" name="overdue_date"
                                                                           class="form-control date" autocomplete="off"
                                                                           value="{{$invoice->overdue_date}}"> --}}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.Type')</label>
                                                                    <select name="type" class="form-control"
                                                                            v-model="selected_type"
                                                                            v-validate="'required'"
                                                                            data-vv-as="@lang('layout.Type')">
                                                                        <option value="">@lang('layout.SelectType')</option>
                                                                        <option value="purchase">@lang('layout.Purchases')</option>
                                                                    <!-- <option value="inventoryTransfer">@lang('layout.InventoryTransfer')</option> -->
                                                                        <option value="transferAndLoading">@lang('layout.TransferAndLoading')</option>
                                                                    </select>
                                                                    <span class="required">@{{ errors.first('type_number') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.TypeNumber')</label>
                                                                    <input type="number" name="type_number"
                                                                           v-model="type_number"
                                                                           class="form-control" v-validate="'required'"
                                                                           data-vv-as="@lang('layout.Number')">

                                                                    <span class="required">@{{ errors.first('type_number') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div v-if="selected_type!='purchase'"
                                                             class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.Driver')</label>
                                                                    <v-select label="name"
                                                                              :options="driver"
                                                                              v-model="selected_driver"></v-select>
                                                                    <input type="hidden" name="driver_id"
                                                                           v-validate="'required'"
                                                                           data-vv-as="@lang('layout.Customer')"
                                                                           :value="!selected_driver?null:selected_driver.id"
                                                                           required>
                                                                    <span class="required">@{{ errors.first('driver_id') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>

                                                    <div class="row">
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <button type="button" @click="searchItemByType" class="btn btn-info">@lang('layout.Search')</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!-- end inputs -->
                                                </div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                                                    <!-- begin total -->
                                                    <div class="dashboard-stat2 ">
                                                        <table class="dashboard-tabel" width="100%">
                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Total') :</small>
                                                                </td>
                                                                <td class="text-right"><span data-counter="counterup"
                                                                                             data-value="7800">@{{ Number.parseFloat((subtotal - (discount*(subtotal - discountFiledRow)/100) - discountFiledRow)-payeds).toFixed(precision())}}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>

                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Discount'): (@{{
                                                                        Number.parseFloat(discount).toFixed(precision())
                                                                        }}%)
                                                                    </small>
                                                                </td>
                                                                <td class="text-right">
                                                                   <span class="text-right" data-counter="counterup"
                                                                         data-value="7800">@{{ Number.parseFloat((discount*(subtotal - discountFiledRow)/100) + discountFiledRow).toFixed(precision()) }}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>

                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Payment'):</small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <small class="font-green-sharp">
                                                                      <span class="text-right" data-counter="counterup"
                                                                            data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                                        <small class="font-green-sharp">
                                                                            @{{selected_currency.symbol}}
                                                                        </small>
                                                                    </small>
                                                                </td>
                                                            </tr>


                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Sub-Total'):</small>
                                                                </td>
                                                                <td class="text-right">
                                                                  <span class="text-right" data-counter="counterup"
                                                                        data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>


                                                        </table>

                                                    </div>

                                                    <!-- end total -->
                                                </div>

                                            </div>

                                            <div class="row" style="overflow-x: scroll;">
                                                <table id="table_content" class="table table-bordered table-advance">
                                                    <thead>
                                                    <tr>
                                                        <th>#</th>

                                                        <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                                        <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                                        <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                                        <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                        <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                                        <th v-show="showWhat('other_measure')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue1') </th>
                                                        <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue2') </th>
                                                        <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                        <th style="min-width: 100px">@lang('layout.NewCost') </th>
                                                        <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 50px">@lang('layout.Discount') </th>
                                                        <th style="min-width: 100px">@lang('layout.Total') </th>
                                                        @if(auth()->user()->company()->first()->tag != 1)
                                                            <th style="min-width: 100px">@lang('layout.TotalHQ') </th>
                                                        @endif
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(item,index) in inventories">
                                                        <td>@{{index+1}}</td>
                                                        <!--td>
                                                          <v-select label="name" v-model="item.item_category" :options="inventory_category" @input="itemCategoryChange()"></v-select>
                                                          <input type="hidden" name="inventory_category_id[]" :value="(!item.item_category)?null:item.item_category.id">
                                                        </td -->


                                                        <td class="highlight">
                                                            <!-- @click.native="addNew('inventory',index)" -->
                                                            <v-select label="name" @Click.native="setIndex(index)"
                                                                      v-model="item.item" :options="temp_items"
                                                                      @search="onItemSearch" disabled="true"></v-select>
                                                            <input type="hidden" :name="'inventory_id['+index+']'"
                                                                   v-validate="''" data-vv-as="@lang('layout.ItemName')"
                                                                   :value="(!item.item)?null:item.item.id">
                                                            <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                                            <input type="hidden"
                                                                   :value="(!item.item)?null:item.item.sale_order_detail_id"
                                                                   name="sale_order_detail_id[]">
                                                        </td>
                                                        <td class="highlight">
                                                            <select disabled="true"
                                                                    v-model="(item.item==null)?null:item.item.site"
                                                                    class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item != null)">
                                                                  <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                                          :value="site">
                                                                    @{{site.site_name}}
                                                                  </option>
                                                                </span>
                                                            </select>

                                                            <input type="hidden" name="inventory_site[]"
                                                                   :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                        </td>
                                                        <td v-show="showWhat('sale_description')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')"
                                                                   name="inventory_description[]" class="form-control">
                                                        </td>

                                                        <td>


                                                            <input type="number" :name="'inventory_quantity['+index+']'"
                                                                   v-validate="''" data-vv-as="@lang('layout.Quantity')"
                                                                   v-model.number="(item.item==null)?null:item.item.quantity"
                                                                   class="form-control input-style input-number"
                                                                   placeholder="@lang('layout.Quantity')">
                                                            <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                        </td>

                                                        <td>
                                                            @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                                        </td>
                                                        <td v-show="showWhat('other_measure')=='yes'">
                                                            <input type="number" name="other_measure_amount[]" v-model.number="(item.item==null)?null:item.item.other_measure"
                                                                   class="form-control input-style input-number"
                                                                   placeholder="@lang('layout.OMeasureValue1')">
                                                        </td>
                                                        <td v-show="showWhat('other_measure2')=='yes'">
                                                            <input type="number" name="other_measure_amount2[]" v-model.number="(item.item==null)?null:item.item.other_measure2"
                                                                   class="form-control input-style input-number"
                                                                   placeholder="@lang('layout.OMeasureValue2')">
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure"
                                                                    class="form-control" @change="measureChange(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                      <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                                              :value="measure">
                                                                      @{{measure.measure_name}}
                                                                    </option>
                                                                  </span>


                                                            </select>

                                                            <input type="hidden" name="inventory_measure[]"
                                                                   :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>
                                                        <td>
                                                            <vue-numeric v-if="item.item"
                                                                class="form-control chan_length"
                                                                oninput = "autowidths(event)"
                                                                v-model="item.item.cost"
                                                                :max="99999999999999"
                                                                currency=""
                                                                :precision="precision()"
                                                                @input="setNewRate('inventory',index)"
                                                                >
                                                            </vue-numeric>
                                                            <input type="hidden" name="inventory_price[]" placeholder="@lang('layout.Price')" v-bind:value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)" ref="in" >
                                                            
                                                        </td>
                                                        <td v-show="showWhat('sale_discount')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="inventory_discount[]" placeholder="@lang('layout.Discount')" v-model.number="(item.item==null)?null:item.item.discount" oninput = "autowidths(event)" class="form-control chan_length">
                                                                <span class="input-group-addon" v-if="discountIsAmount"> @{{selected_currency.symbol}} </span>
                                                                <span class="input-group-addon" v-if="!discountIsAmount"> % </span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            @{{ (item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount, null, null, null, selected_currency.static_rate).result }}
                                                            @{{selected_currency.symbol}}
                                                        </td>
                                                        @if(auth()->user()->company()->first()->tag != 1)
                                                            <td>
                                                                @{{ (item.item==null)?null:
                                                                getItemTotal(item.item,selected_currency.rate, null,
                                                                null, selected_currency.hq_rate, null, selected_currency.static_rate).result }}
                                                                @{{selected_currency.symbol}}
                                                            </td>
                                                        @endif


                                                    </tr>

                                                    </tbody>
                                                </table>

                                                <hr>
                                                <!-- begin service -->
                                                <table id="table_content"
                                                       class="table table-striped table-bordered table-advance table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center"
                                                            style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                                        <th class="text-center"
                                                            style="min-width: 160px;">@lang('layout.Quantity')</th>
                                                        <th class="text-center"
                                                            style="min-width: 160px;">@lang('layout.Measure')</th>
                                                        <th class="text-center"
                                                            style="min-width: 160px;">@lang('layout.Price')</th>

                                                        <th class="text-center"
                                                            style="min-width: 120px;">@lang('layout.Total')</th>
                                                        @if(auth()->user()->company()->first()->tag != 1)
                                                            <th class="text-center"
                                                                style="min-width: 120px;">@lang('layout.TotalHQ')</th>
                                                        @endif
                                                        <th></th>

                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(service,index) in services">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="service.item"
                                                                      :options="(service.items)"
                                                                      @click.native="addNew('service',index)"
                                                                      @input="checkExistingService(index)">

                                                            </v-select>
                                                            <input type="hidden" name="sale_order_service_id[]" :value="(service.item==null)?null:service.item.order_detail_id">
                                                            <input type="hidden" name="service_id[]" :value="(service.item==null)?null:service.item.id">
                                                        </td>

                                                        <td>
                                                            <input class="form-control" name="service_quantity[]"
                                                                   v-model.number="(!service.item)?null:service.item.quantity"
                                                                   placeholder="@lang('layout.Quantity')">
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(service.item == null)?null:service.item.measure"
                                                                    class="form-control"
                                                                    @change="measureChangeservice(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(service.item ==null)?false:true">
                                                                      <option v-for="measure in (service.item==null)?null:service.item.measure_list"
                                                                              :value="measure">
                                                                      @{{measure.measure_name}}
                                                                    </option>
                                                                  </span>

                                                            </select>

                                                            <input type="hidden" name="service_measure[]"
                                                                   :value="(service.item==null)?null:service.item.measure.measure_id">
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" name="service_price[]"
                                                                       placeholder="@lang('layout.Price')"
                                                                       :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate, null , selected_currency.static_rate)"
                                                                       ref="ser" @input="setNewRate('service',index)"
                                                                       class="form-control">


                                                                <span class="input-group-addon">
                                                                  @{{selected_currency.symbol}}
                                                                </span>
                                                            </div>

                                                        </td>
                                                        <td>
                                                            @{{
                                                            (service.item==null)?null:getItemTotalService(service.item,selected_currency.rate,selected_currency.hq_rate, selected_currency.static_rate).result
                                                            }}
                                                            @{{selected_currency.symbol}}
                                                        </td>
                                                        @if(auth()->user()->company()->first()->tag != 1)
                                                            <td>
                                                                @{{
                                                                (service.item==null)?null:getItemTotalService(service.item,selected_currency.rate,selected_currency.hq_rate,selected_currency.static_rate).resultHQ
                                                                }}
                                                                @{{selected_currency.symbol}}
                                                            </td>
                                                        @endif
                                                        <td>
                                                            <span v-on:click="deleteItem('service',index)"><i
                                                                        class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>

                                                    </tbody>
                                                </table>
                                                <!-- end service -->
                                                <hr>
                                                <!-- begin payments -->
                                                @permission('receive-create')
                                                <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center"
                                                            style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                                        <th class="text-center"
                                                            style="min-width: 100px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center"
                                                            style="min-width: 120px;"> @lang('layout.Rate')</th>
                                                        <th class="text-center"
                                                            style="min-width: 80px;">@lang('layout.Currency')</th>
                                                        <th class="text-center"
                                                            style="min-width: 80px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center"
                                                            style="min-width: 120px;">@lang('layout.Total')</th>
                                                        @if(auth()->user()->company()->first()->tag != 1)
                                                            <th class="text-center"
                                                                style="min-width: 120px;">@lang('layout.TotalHQ')</th>
                                                        @endif
                                                        <th></th>

                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(payment,index) in payments">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="payment.item"
                                                                      :options="(payment.items)"
                                                                      @click.native="addNew('payment',index)"
                                                                      @input="checkExistingPayment(index)">

                                                            </v-select>
                                                            <input type="hidden" name="payment_id[]"
                                                                   :value="(payment.item==null)?null:payment.item.id">
                                                        </td>

                                                        <td>
                                 
                                                          <span v-if="payment.item !=null">
                                                            @{{myRound(Number((payment.item==null)?null:payment.item.balance)+Number((payment.item==null)?null:payment.item.amount))}}
                                                          </span>
                                                        </td>
                                                        <td>
                                                            <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                                                   type="number"
                                                                   v-model.number="(payment.item==null)?null:payment.item.rate "
                                                                   class="form-control"
                                                                   placeholder="@lang('layout.Rate')"/>
                                                            <input v-if="payment.item !=null" type="hidden"
                                                                   name="payment_rate[]"
                                                                   v-bind:value="payment.item.rate">
                                                            <input v-if="payment.item !=null" type="hidden"
                                                                   name="payment_rate_hq[]"
                                                                   v-bind:value="payment.item.hq_rate">
                                                        </td>
                                                        <td>
                                                            <input type="text" name="payment_currency[]"
                                                                   class="form-control"
                                                                   v-model="(payment.item==null)?null:payment.item.code"
                                                                   placeholder="@lang('layout.Currency')" disabled
                                                                   reqiured/>

                                                            <input v-if="payment.item !==null" type="hidden"
                                                                   name="payment_currency[]"
                                                                   v-bind:value="payment.item.code"/>
                                                        </td>
                                                        <td>
                                                            <vue-numeric v-if="payment.item"
                                                                class="form-control"
                                                                v-model="payment.item.amount"
                                                                :max="99999999999999"
                                                                :currency="payment.item.code"
                                                                :precision="precision()"
                                                                >
                                                            </vue-numeric>
                                                            <input v-if="payment.item !=null" type="hidden" name="payment_amount[]" v-bind:value="payment.item.amount">
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control"
                                                                       :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate,selected_currency.hq_rate, selected_currency.static_rate).result"
                                                                       placeholder="@lang('layout.Total')"
                                                                       style="min-width: 100px"/>
                                                                <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                                            </div>
                                                        </td>
                                                        @if(auth()->user()->company()->first()->tag != 1)
                                                            <td>
                                                                <div class="input-group">
                                                                    <input type="number" class="form-control"
                                                                           :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate,selected_currency.hq_rate, selected_currency.static_rate).resultHQ"
                                                                           placeholder="@lang('layout.Total')"
                                                                           style="min-width: 100px"/>
                                                                    <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                                                </div>
                                                            </td>
                                                        @endif
                                                        <td>
                                                            <span v-on:click="deleteItem('payment',index)"><i
                                                                        class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                    </tbody>

                                                </table>
                                                @endpermission
                                                <!-- end payments -->

                                                @if(getTransferRent()=="true")
                                                <hr>
                                                <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th colspan="10" style="min-width: 100px;">@lang('layout.TransferRent')</th>
                                                        </tr>
                                                        <tr>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.Type')</th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.Transmitter')</th>
                                                            <th class="text-center" style="min-width: 160px;" v-show="transfer_rent_type=='cash'">@lang('layout.SelectBank')</th>
                                                            <th class="text-center" style="min-width: 120px;" v-show="transfer_rent_type=='cash'"> @lang('layout.Rate')</th>
                                                            <th class="text-center" style="min-width: 80px;" v-show="transfer_rent_type=='cash'">@lang('layout.Currency')</th>
                                                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                                            <th class="text-center" style="min-width: 120px;">@lang('layout.Description')</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>
                                                                <select class="form-control" name="transfer_rent_type" v-model="transfer_rent_type">
                                                                    <option value="cash">@lang('type.cash')</option>
                                                                    <option value="credit">@lang('type.credit')</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <v-select label="name" @search="VendorSearch" :options="transfer_rent_vendor" v-model="transfer_rent_vendor_selected"></v-select>
                                                                <input type="hidden" name="transfer_rent_vendor" :value="!transfer_rent_vendor_selected?null:transfer_rent_vendor_selected.id">
                                                            </td>

                                                            <td class="highlight" v-show="transfer_rent_type=='cash'">
                                                                <v-select label="name" v-model="transfer_rent_bank_selected" :options="banks">

                                                                </v-select>
                                                                <input type="hidden" v-if="transfer_rent_bank_selected !=null" name="transfer_rent_bank" :value="(transfer_rent_bank_selected==null)?null:transfer_rent_bank_selected.id">
                                                            </td>
                                                            <td v-show="transfer_rent_type=='cash'">
                                                                <input v-bind:disabled="(transfer_rent_bank_selected==null)?false:(transfer_rent_bank_selected.code =='{{getHomeCurrency()["code"]}}')" type="number" v-model.number="(transfer_rent_bank_selected==null)?null:transfer_rent_bank_selected.rate " class="form-control" placeholder="@lang('layout.Rate')" />
                                                                <input v-if="transfer_rent_bank_selected !=null" type="hidden" name="transfer_rent_rate" v-bind:value="transfer_rent_bank_selected.rate">
                                                            </td>
                                                            <td v-show="transfer_rent_type=='cash'">
                                                                <input type="text" name="transferRent_currency[]" class="form-control" v-model="(transfer_rent_bank_selected==null)?null:transfer_rent_bank_selected.code" placeholder="@lang('layout.Currency')" disabled reqiured />

                                                                <input v-if="transfer_rent_bank_selected !==null" type="hidden" name="transfer_rent_currency" v-bind:value="transfer_rent_bank_selected.code" />
                                                            </td>

                                                            <td>
                                                                <div class="input-group">
                                                                    <input type="number" name="transfer_rent_amount" v-model="transfer_rent_amount" class="form-control" placeholder="@lang('layout.PayAmount')">

                                                                    <span v-show="transfer_rent_type=='cash'" class="input-group-addon">@{{(transfer_rent_bank_selected==null)?null:transfer_rent_bank_selected.code}}</span>
                                                                    <span v-show="transfer_rent_type=='credit'" class="input-group-addon">@{{selected_currency.symbol}}</span>

                                                                </div>
                                                            </td>

                                                            <td>
                                                                <textarea class="form-control" name="transfer_rent_description" v-model="transfer_rent_description" rows="2" placeholder="@lang('layout.Description')"></textarea>
                                                            </td>
                                                        </tr>
                                                    </tbody>

                                                </table>
                                                <hr>
                                                @endif
                                                <!--End Transfer Rent-->

                                            </div>
                                            <div class="row">
                                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Memo')</label>
                                                            <textarea name="memo" class="form-control" rows="2">{{$invoice->memo}}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                            <button type="button" v-if="!isError" @click="handleSubmit($event)"
                                                    class="btn green">@lang('layout.Submit')</button>
                                            <a href="{{route('saleByType.index')}}" class="btn default"><i
                                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                        </div>
                                        <cmodal :show='showModal' @close="showModal=false">

                                        </cmodal>
                                    </div>


                                </div>


                                {!! Form::close() !!}

                            </div>

                        </div>


                    </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
            </div>
            <!-- END TAB PORTLET-->
        </div>
    </div>

@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>

    <script type="text/javascript">

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);
        Vue.use(VueNumeric.default);

        Vue.component("modal", {
            template: "#modal-template",
            props: ['show'],

        });

        //begin new member
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    types: [],
                    classes: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectedClass: null,
                    selectReceive: null,
                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Customer") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if(this.receivables.length>0)
                        {
                            this.selectReceive=this.receivables[0];
                        }
                        if(this.payables.length>0)
                        {
                            this.selectPay=this.payables[0];
                        }


                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    v.showModal = false;
                    //this.member.type = this.member.type.id;
                    var datas = $("#modalForm").serializeArray();
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        if (response) {
                            v.selected_customer = response.customer;
                        }
                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }

        });

        // end new member
        var selectedCustomer ={!! $selectedCustomer !!};
        var currency ={!! $currency !!};
        var banks = {!! $banks !!};
        var all_services = {!! $all_services !!};
        var inventory_category = {!! $inventory_category !!};
        var contracts = {!!$contracts!!};

        let homeCurrency = {!! $homeCurrency !!};
        let ratesFetched = {!! $rates !!};
        let mainHomeCurrency = {!! $mainHomeCurrency !!};
        var driver = {!! $driver !!};
        var invoice = {!! $invoice !!};
        var selectedItem = {!! $selectedItem !!};
        var selectedBanks = {!! $selectedBanks !!};
        var selectedService ={!! $selectedService !!};
        var selectedCurrency = {!! $selectedCurrency !!};
        var transferRent = {!!$transferRent!!};
        var transfer_rent_vendor_selected = {!!$transfer_rent_vendor_selected!!};

        var v = new Vue({
            el: '#appInvoice',
            data: {

                showModalSaleOrder: false,
                showModal: false,
                invoiceDescription: null,
                saleOrderList: [],
                selected_sale_order: null,
                setDatas: [],
                customer: [],
                contracts: contracts,
                selected_customer: selectedCustomer,
                member_id: null,
                banks: banks,
                all_services: all_services,
                selected_banks: selectedBanks,
                currency: currency,
                selected_currency: selectedCurrency,
                rate: 0,
                discountFiled: 0,
                discountIsAmount: false,
                discountFiledRow: 0,
                temp_items: [],
                totalAmountes: [],
                types: null,
                inventory_category: inventory_category,
                selected_index: 0,

                inventories: [],
                services: [],
                payments: [],
                CusTypes: null,
                selected_type: 'transferAndLoading',
                type_number: null,
                driver: driver,
                selected_driver: null,
                invoice: invoice,
                selected_item: selectedItem,
                selected_service: selectedService,

                transferRent: transferRent,
                transfer_rent_vendor: [],
                transfer_rent_vendor_selected: transfer_rent_vendor_selected,
                transfer_rent_bank_selected: null,
                transfer_rent_type: null,
                transfer_rent_description: null,
                transfer_rent_amount: null
            },
            computed: {
                setRates() {

                    let rates = [];
                    this.currency.forEach((b) => {
                        ratesFetched.forEach((a) => {

                            if (a.currency_id == b.id) {
                                rates.push({
                                    name: a.name,
                                    code: a.code,
                                    static_rate: a.static_rate,
                                    symbol: a.symbol,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                    currency: b.id,
                                    id: b.id
                                });
                            }
                        })
                    });

                    this.currency.forEach((a) => {
                        let found = false;
                        rates.forEach((b) => {
                            if (a.id == b.id) {
                                found = true;
                                return;
                            }
                        });

                        if (!found) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                static_rate: a.static_rate,
                                rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency: a.id,
                                id: a.id
                            })
                        }
                    });
                    
                    this.banks = []; 

                    banks.forEach((a) => {
                        rates.forEach((r) => {
                            if (a.code == r.code) {
                                this.banks.push({
                                    amount: a.amount,
                                    balance: a.balance,
                                    static_rate: a.static_rate,
                                    code: a.code,
                                    id: a.id,
                                    name: a.name,
                                    rate: r.rate,
                                    hq_rate: r.hq_rate
                                })
                            }
                        });
                    });

                    return rates;

                },

                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;

                    if (this.selected_currency) {
                        for (var i = 0; i < this.inventories.length; i++) {
                            if (this.inventories[i].item && this.inventories[i].item != null) {
                                if (this.inventories[i].item.new_rate) {
                                    @if(systemConfig()[30] == 1)
                                        this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                                    @else
                                        this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.rate;
                                    @endif

                                }
                            }
                        }
                    }
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal - this.discountFiledRow);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    var sum_discount = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {

                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            var discount = this.inventories[i]['item']['discount'];
                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                                if (this.discountIsAmount) {
                                    if (discount > 0) {
                                        sum_discount += (discount * quantity);
                                    }
                                } else {
                                    if (discount > 0) {
                                        @if(systemConfig()[30] == 1)
                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate)) / 100;
                                        @else 
                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                        @endif
                                    }
                                }
                            }
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
                                if (this.discountIsAmount) {
                                    if (discount > 0) {
                                        sum_discount += (discount * quantity);
                                    }
                                } else {

                                    if (discount > 0) {
                                        @if(systemConfig()[30] == 1)
                                        sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate))) / 100;
                                        @else 
                                        sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
                                        @endif
                                    }
                                }
                            }

                        }

                    }
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item && this.services[i].item != null) {

                            var rate = this.services[i]['item']['rate'];
                            var new_rate = this.services[i]['item']['new_rate'];
                            var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.services[i]['item']['measure_unit'];
                            var quantity = this.services[i]['item']['quantity'];
                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                            }
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
                            }

                        }
                    }
                    this.discountFiledRow = sum_discount;
                    return sum;
                },

                // check payed amount
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                                @endif
                            }
                        }
                    }
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;

                    if (this.selected_customer == null) {
                        isError = true;
                    }
                    return isError;


                },
            },
            mounted: function () {


                // initialize the selected item

                for (var i = 0; i < this.selected_item.length; i++) {
                    this.inventories.push({
                        inventory: this.selected_item[i],
                        item: this.selected_item[i],
                        item_category: this.selected_item[i].item_category
                    });
                }
                // end item

                // begin payment initialization

                for (var t = 0; t < this.selected_banks.length; t++) {
                    var foundFlag = false;
                    var tempBank = null;
                    for (var y = 0; y < this.banks.length; y++) {
                        if (this.selected_banks[t].id == this.banks[y].id) {
                            foundFlag = true;
                            tempBank = this.banks[y];
                            tempBank.amount = this.selected_banks[t].balance;
                            
                            if (this.selected_currency.code == tempBank.code) {
                                tempBank.rate = this.selected_currency.rate;
                            } else {
                                tempBank.rate = this.selected_banks[t].rate;
                            }
                        }
                    }
                    if (foundFlag) {

                        this.payments.push({item: tempBank, items: this.banks});
                    }
                }
                for (var w = 1; w > this.selected_banks.length; w--) {
                    this.payments.push({item: null, items: banks});
                }
                // end payment initialization

                // begin service

                for (var r = 0; r < this.selected_service.length; r++) {
                    var flag = false;
                    var tempService;
                    for (var h = 0; h < this.all_services.length; h++) {
                        if (this.all_services[h].id == this.selected_service[r].item_id) {
                            flag = true;
                            tempService = this.all_services[h];
                            tempService.quantity = this.selected_service[r].qty;
                            tempService.rate = this.selected_service[r].sales_price;
                            tempService.new_rate = this.selected_service[r].sales_price;
                            tempService.order_detail_id = this.selected_service[r].order_detail_id;
                        }
                    }
                    if (flag) {
                        this.services.push({item: tempService, items: this.all_services})
                    }
                }
                for (var w = 1; w > this.selected_service.length; w--) {
                    this.services.push({item: null, items: all_services});
                }
                // end service

                if (this.invoice) {
                    this.selected_type = this.invoice.sale_type;
                    this.type_number = '{{$type_number}}'
                    this.selected_driver = _.find(this.driver, (d) => d.id == this.invoice.driver_id);
                    this.selected_class = _.find(this.memberClass, (c) => c.id == this.invoice.class_id);
                    this.selected_area = _.find(this.saleArea, (s) => s.id == this.invoice.sale_area_id);
                    this.discountFiled = this.invoice.discount;
                    if (this.invoice.discount_type) {
                        if (this.invoice.discount_type == 'percent') {
                            this.discountIsAmount = false;
                        }
                        else {
                            this.discountIsAmount = true;
                        }
                    }
                }

                @if(getTransferRent() == "true")
                if (this.transferRent) {
                    this.transfer_rent_type = this.transferRent.type
                    this.transfer_rent_description = this.transferRent.description,
                        this.transfer_rent_amount = this.transferRent.receivable_amount

                    // for (var tr = 0; tr < this.banks.length; tr++) {
                        if (this.transferRent.b_account_id != null && this.transferRent.b_account_id != "") {
                            this.transfer_rent_bank_selected = _.find(banks, (b) => b.id == this.transferRent.b_account_id);
                            // console.log(23, this.transfer_rent_bank_selected, this.transferRent.b_account_id, banks);
                        }
                    // }

                }
                @endif

            },
            methods:
                {
                    searchItemByType() {
                        if (this.selected_type && this.type_number) {
                            if (this.selected_type != 'purchase') {

                                if (!this.selected_driver) {
                                    return false;
                                }
                            }
                            let driver_id = (this.selected_driver) ? this.selected_driver.id : null;
                            v.inventories = [];
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    type: this.selected_type,
                                    method_name: 'saleByType',
                                    type_number: this.type_number,
                                    driver_id: driver_id
                                }
                            })
                                .then(function (response) {
                                    if (response.data.length > 0) {

                                        for (var r = 0; r < response.data.length; r++) {
                                            v.inventories.push({item: response.data[r], item_category: null});
                                        }
                                    }

                                })
                                .catch(function (error) {
                                    console.log(error);
                                });
                        }
                    },
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                //console.log(v.member_chack());
                                if (v.member_chack() == 'true') {
                                    var r = confirm("@lang('layout.member_payable_levels')");
                                    if (r == true) {
                                        v.submitForm(e.target);
                                    }
                                } else {
                                    v.submitForm(e.target);
                                }
                            }
                        });
                    },

                    // chack_member_payable_levels
                    member_chack() {
                        var chack = 'false';
                        var member_id = v.member_id;
                        if (member_id != null) {

                            var totals = Number.parseFloat((v.subtotal - (v.discount * v.subtotal / 100)) - v.payeds);
                            var currency = $("input[name=currency]").val();


                            $.ajax({
                                url: "{{route('callMethod.search')}}",
                                async: false,
                                data: {
                                    member_id: v.member_id,
                                    method_name: 'Search_member_payable_levels',
                                    currency: currency,
                                },
                                success: function (data) {
                                    var r_amount = Number.parseFloat(data.amount);
                                    var r_m_amount = Number.parseFloat(data.m_amount);
                                    var totalss = Number.parseFloat(((isNaN(r_m_amount) ? 0 : r_m_amount) + totals));
                                    //console.log(r_m_amount);
                                    //console.log('--');
                                    //console.log(totals);
                                    if (r_amount != 0 && r_amount < totalss) {
                                        chack = 'true';
                                    } else {
                                        chack = 'false';
                                    }


                                }.bind(this),

                                error: function (error) {
                                    console.log(error)
                                }
                            });

                        }
                        return chack;
                    },

                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },

                    // calculate item price based on measure change
                    measureChangeservice(index) {

                        if (this.services[index].item != null) {
                            var item = this.services[index].item;
                            @if(systemConfig()[30] == 1)
                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                            @endif
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.services[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    // detect member change and searh
                    memberChange() {
                        if (this.selected_customer) {
                            v.member_id = this.selected_customer.id;
                            // get member contract
                            // this.saleOrderSearch(this.selected_customer.id, this);
                        }
                    },

                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                class_id: class_id,
                                type: 'Customer'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.customer = [];
                                v.customer = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    //Vendor Search for Transfer Rent
                    VendorSearch: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchMember',
                                    keyword: search,
                                    type: 'Vendor'
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    // console.log(response.data);
                                    v.transfer_rent_vendor = [];
                                    v.transfer_rent_vendor = response.data;
                                }
                                loading(false);
                            })
                            .catch(function(error) {
                                loading(false);
                                console.log(error);
                            })
                    }, getDebounceTime()),


                    // sale order change
                    saleOrderChang() {
                        console.log('test 33');
                    },
                    // end sale order change
                    // set new price
                    setNewRate(type = null, index = null) {
                        if (type == 'inventory') {
                            if (this.inventories[index].item) {
                                @if(systemConfig()[30] == 1)
                                this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.rate;
                                @endif
                                // this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                            }
                        }
                        if (type == 'service') {
                            if (this.services[index].item) {
                                // console.log('service changed');
                                @if(systemConfig()[30] == 1)
                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                                @endif
                            }
                        }
                    },


                    //ajax call to get items
                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);

                        axios.get("{{route('callMethod.search')}}",
                            {

                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSaleContract',
                                    keyword: search,
                                    //inventory_category_id:inventory_category_id
                                },
                            })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                    }, getDebounceTime()),

                    // end item search
                    setIndex(e) {
                        console.log('e', e);
                        this.selected_index = e;
                        console.log('uuu', this.selected_index);
                    },
                    itemCategoryChange() {
                        let inventory_category_id = this.inventories[this.selected_index]['item_category'].id;
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSale',
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                    },

                    //
                    contractChange() {

                        //let inventory_category_id = this.inventories[this.selected_index]['item_category'].id;
                        let contract_id = this.inventories[this.selected_index]['contract'].id;

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSaleContract',
                                //inventory_category_id: inventory_category_id,
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                    },


                    // contract search


                    saleOrderSearch(id, vm) {
                        vm.saleOrderList = [];
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberSaleOrder',
                                member_id: id,
                            }
                        })
                            .then(function (response) {
                                if (response.data.length > 0) {
                                    vm.showModalSaleOrder = true;
                                    vm.saleOrderList = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    },
                    getsalesOrders() {
                        this.showModalSaleOrder = false;
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SaleOrderItems',
                                sale_order_id: this.selected_sale_order.id,
                                type: 'saleOrder'
                            }
                        })
                            .then(function (response) {
                                if (response.data.length > 0) {
                                    v.inventories = [];
                                    for (var r = 0; r < response.data.length; r++) {
                                        v.inventories.push({item: response.data[r]});
                                    }
                                    v.inventories.push({item: null});
                                    console.log('test check', v.inventories);
                                    v.invoiceDescription = v.selected_sale_order.description;

                                }

                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    },
                    // end contract search

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, item_category: null, contract: null});
                                }
                            }
                            if (type == 'service') {
                                if (this.services[index + 1] == undefined) {
                                    this.checkExistingService(index, '');
                                    this.services.push({
                                        items: this.all_services,
                                        item: null,
                                    });
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },

                    // in here you can check and decide to allow duplicate service or not
                    checkExistingService(index = null, name = '') {
                        var service_temp = this.all_services.slice();
                        var service_temp1 = [];
                        for (var i = 0; i < this.services.length; i++) {
                            if (this.services[i].item != null) {
                                var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                                if (fined != -1) {
                                    var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                                }
                            }
                        }
                        this.services[index].items = service_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'service') {
                                this.services.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("sales-form").submit()

                            }
                            else {

                            }
                        });

                    },
                },


        });

    </script>



@endpush