@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('sales_detail');
$_item_name=in_array('item_name', $report);
$_symbol=in_array('symbol', $report);
$_purchase_date=in_array('purchase_date', $report);
$_sleep_day=in_array('sleep_day', $report);
$_quantity=in_array('quantity', $report);
$_price=in_array('price', $report);
$_purchase_rate=in_array('purchase_rate', $report);
$_income=in_array('income', $report);
$_total=in_array('total', $report);
?>
<table  class="main-table">
 @if($info)

 <tr>
  <td>
    <span>@lang('layout.Number')</span>:
    <span>{{$info->number}}</span>
  </td>
   <td>
    <span>@lang('layout.ReferenceNumber')</span>:
    <span>{{$info->ref_Number}}</span>
  </td>
  <td>
    <span>@lang('layout.Customer')</span> :
    <span>{{$info->member_name}}</span>
  </td>
  <td>
    <span>@lang('layout.Account')</span>:
    <span>{{$info->account_name}}</span>
  </td>
  <td>
    <span>@lang('layout.Amount')</span>:
    <span>{{$info->amount}}</span>
  </td>
</tr>
<tr>

 <td>
  <span>@lang('layout.Currency')</span>:
  <span>{{$info->currency}}</span>
</td>
<td>
  <span>@lang('layout.Rate')</span>:
  <span>{{$info->rate}}</span>
</td>
<td>
  <span>@lang('layout.Discount')</span>:
  <span>{{$info->discount}}</span>
</td>

</tr>
@endif

</table>


<h3 class="table-caption" style="text-align: center;">@lang('layout.SaleseReport')</h3>
<table class="main-table">

<thead>
  <tr class="bg">
 <td class="center"><div class="center"> @lang('layout.Record') </div></td>

  @if($_item_name)<th >@lang('layout.ItemName')</th>@endif
  @if($_symbol) <th>@lang('layout.Symbol')</th>@endif
  @if($_purchase_date) <th>@lang('layout.PurchaseDate')</th>@endif
  @if($_sleep_day) <th>@lang('layout.SleepStaff')</th>@endif
  @if($_quantity)<th>@lang('layout.Quantity')</th>@endif
  @if($_price)<th>@lang('layout.Price')</th>@endif
  @if($_purchase_rate)<th>@lang('layout.Cost')</th>@endif
  @if($_income)<th>@lang('layout.Income')</th>@endif
  @if($_total)<th>@lang('layout.Total')</th>@endif

</tr>
</thead>
<?php
$count = 0;
?>
@foreach($data AS $record)
<tr>
<td  class="center">{{++$count}}</td>


@if($_item_name)<td class="center">{{$record->name}}</td>@endif
@if($_symbol)<td  class="center">{{$record->symbol}}</td>@endif
@if($_purchase_date)<td class="center">{{$record->stocks_date}}</td>@endif
@if($_sleep_day)<td  class="center">{{$record->sleepDate}}</td>@endif
@if($_quantity)<td  class="center">{{$record->qty}}</td>@endif
@if(systemConfig()[30] == 1)
@if($_price)<td  class="center">{{myRound($record->price * $record->static_rate / $record->sale_rate)}}</td>@endif
@else 
@if($_price)<td  class="center">{{myRound($record->price * $record->sale_rate)}}</td>@endif
@endif
@if(systemConfig()[30] == 1)
@if($_purchase_rate)<td  class="center">{{myRound($record->avgCost  * $record->static_rate / $record->sale_rate)}}</td>@endif
@else 
@if($_purchase_rate)<td  class="center">{{myRound($record->avgCost  * $record->sale_rate)}}</td>@endif
@endif
@if(systemConfig()[30] == 1)
@if($_income)<td  class="center">{{myRound($record->income * $record->static_rate / $record->sale_rate)}}</td>@endif
@else 
@if($_income)<td  class="center">{{myRound($record->income * $record->sale_rate)}}</td>@endif
@endif
@if(systemConfig()[30] == 1)
@if($_total)<td  class="center">{{myRound($record->qty*$record->price * $record->static_rate / $record->sale_rate)}}</td>@endif
@else 
@if($_total)<td  class="center">{{myRound($record->qty*$record->price * $record->sale_rate)}}</td>@endif
@endif

</tr>
@endforeach   
</table>

<table>
  <tr>

  </tr>
</table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection