@extends('layouts.app')
@section('style')
<style type="text/css">
   table.td{
        border-top:0px;
    }
    .header{
    
    }

</style>
@stop

@section('content')
 
      <div class="row">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered sale">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.SalaryDetails')</span>
                    </div>
                    <div class="tools"></div>
                </div>
                <div class="portlet-body">
                    <div class="row">
                       <div class="col-md-12">
                           <table class="table">
                                <thead>
                                 <tr class="header">
                                      <th>@lang('layout.Title')</th>
                                      <th>@lang('layout.Data')</th>
                                  </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <i class="fa fa-user"></i> <b>@lang('layout.Name')</b>
                                        </td>
                                        <td>
                                            {{$salaryDetails->name}}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <b>@lang('layout.EmploymentType')</b>
                                        </td>
                                        <td>
                                            @php
                                                $s_type = "";
                                                if($salaryDetails->type=="salary"){
                                                    $s_type = __('layout.SalaryBased');
                                                }
                                                if($salaryDetails->type=="contract"){
                                                    $s_type = __('layout.ContractBased');
                                                }

                                            @endphp
                                            {{$s_type}}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <i class="fa fa-clock-o"></i><b> @lang('layout.Date')</b>
                                        </td> 
                                        <td>
                                            {{convertDate($salaryDetails->Date)}}
                                        </td>
                                    </tr> 
 
                                    <tr>
                                        <td>
                                            <i class="fa  "></i> <b>@lang('layout.Amount')</b>
                                        </td> 
                                        <td>
                                            {{myRound($salaryDetails->amount)}}
                                             
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <i class="fa  "></i> <b>@lang('layout.Rent')</b>
                                        </td> 
                                        <td>
                                            {{myRound($salaryDetails->rent)}}
                                             
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <i class="fa "></i> <b>@lang('layout.Currency')</b>
                                        </td> 
                                        <td>
                                            {{$salaryDetails->currency}}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <i class="fa "></i> <b>@lang('layout.ExpenseAccount')</b>
                                        </td> 
                                        <td>
                                            {{$salaryDetails->account}}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <i class="fa "></i> <b>@lang('layout.Item')</b>
                                        </td> 
                                        <td>
                                            {{$salaryDetails->payrollName}}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <i class="fa "></i> <b>@lang('layout.JobTitle')</b>
                                        </td> 
                                        <td>
                                            {{$salaryDetails->priceLevelname}}
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                       </div> 
                    </div>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
    </div>
@endsection
 