@extends('layouts.app')

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditSalaryDetials') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div class="portlet-body form" id="app" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::model($salaryDetails, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['salaryDetails.update',$salaryDetails->id]]) !!}
                <div class="form-body">
                    <div class="col-md-9">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.EmployeeName'):</label>
                            <div class="col-md-9">
                                {{Form::text('name',null,['class' => 'form-control','disabled'])}}
                                {{Form::hidden('emp_id',null,['class' => 'form-control',])}}
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="employment"
                                   class="control-label col-md-3">@lang('layout.EmploymentType')</label>
                            <div class="col-md-9">
                                <select id="employment" class="form-control" v-model="selectedEmployment">
                                    <option disabled> @lang('layout.Select')</option>
                                    <option v-for="em in employementType" :value="em" :selected="em"> @{{ em.type }}</option>
                                </select>
                            </div>
                            <input type="hidden" name="employmentType"
                                   :value="selectedEmployment? selectedEmployment.tag: null">
                        </div>
                        <div class="form-group" v-if="selectedEmployment != null ">
                            <label class="control-label col-md-3">@lang('layout.Amount'):</label>
                            <div class="col-md-9">
                                {{Form::number('amount',null,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                            </div>
                        </div>
                        <div class="form-group" v-if="selectedEmployment != null && selectedEmployment.tag == 'salary'">
                            <label class="control-label col-md-3">@lang('layout.Rent'):</label>
                            <div class="col-md-9">
                                {{Form::number('rent',null,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Date'):</label>
                            <div class="col-md-9">
                                {{Form::text('date',null,['class' => 'form-control date','autocomplete'=>'off'])}}
                            </div>
                        </div>
						<div class="form-group">
							<label class="control-label col-md-3">@lang('layout.ExpenseAccount')</label>
							<div class="col-md-9">
							   <v-select label="name" v-model="SelectedCost" :options="costAccount">
								</v-select>
								<input type="hidden" name="expense_account_id" :value="(SelectedCost==null)?null:SelectedCost.id">
							</div>
						</div>
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Currency'):</label>
                            <div class="col-md-9">
                                <select name="currency" class="form-control">
                                    @foreach($currency as  $curr)
                                        <?php
                                        $selected = '';
                                        if ($curr->code == $salaryDetails->currency) {
                                            $selected = 'selected';
                                        }
                                        ?>
                                        <option <?=$selected?> value="{{$curr->code}}">{{$curr->code}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="form-group" v-if="selectedEmployment != null && selectedEmployment.tag == 'contract'">
                            {{-- <label class="control-label col-md-3">@lang('layout.Item'):</label>
                            <div class="col-md-3">
                                <v-select label="name" @input="filterJobTitles" v-model="SelectedPayrollPrice" :options="payrollPrice"></v-select>
								<input type="hidden" name="item_type_payrolls_id" v-model.number="(!SelectedPayrollPrice)?null:SelectedPayrollPrice.id">
                            </div> --}}
                            <label class="control-label col-md-3">@lang('menu.JobTitle'):</label>
                            <div class="col-md-9">
                                <v-select label="name" v-model="SelectedTypePayroll" :options="payrollType"></v-select>
								<input type="hidden" name="payroll_price_levels_id" :value="(SelectedTypePayroll==null)?null:SelectedTypePayroll.id">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('salaryDetails.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection

@push('scripts')
    <script>
	Vue.component("v-select", VueSelect.VueSelect);
        let payrollPrice = {!! $payrollPrice !!};
        let payrollType = {!! $payrollType !!};
        let salaryDetails = {!! $salaryDetails !!};
        var selectPayrollPrice ={!! json_encode($selectPayrollPrice) !!};
        var selectPayrollType ={!! json_encode($selectPayrollType) !!};
        new Vue({
            el: '#app',
            data: {
                employementType: [
                    {tag: 'salary', type: '@lang('layout.SalaryBased')'},
                    {tag: 'contract', type: '@lang("layout.ContractBased")'}],
                selectedEmployment: null,
				SelectedCost:null,
                costAccount: {!! json_encode($cost) !!},
                SelectedPayrollPrice:selectPayrollType,
                SelectedTypePayroll:selectPayrollPrice,
                filteredPayrollType: [],
                payrollPrice: payrollPrice,
                payrollType: payrollType,
            },
            created() {
                console.log('salary details', salaryDetails);
                this.employementType.forEach((emp) => {
                    if (emp.tag == salaryDetails.type) {
                        this.selectedEmployment = emp;
                        return;
                    }
                })
                if (salaryDetails && salaryDetails.expense_account_id != null) {
                    this.SelectedCost=_.find(this.costAccount,(v)=>v.id==salaryDetails.expense_account_id);
                }
            },
            mounted: function(){
               
            },
            methods: {
                filterJobTitles(){
                    if(this.SelectedPayrollPrice){
                        this.filteredPayrollType = this.payrollType.filter((a) => {
                            return (a.item_type_id == this.SelectedPayrollPrice.id)
                        });
                    }
                }
            }
        });
    </script>
@endpush