@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">  @lang('layout.CreateNewSalaryDetails')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;" v-cloak>
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'salaryDetails.store','method'=>'POST','class'=>'form-horizontal', 'id'=>'salary-details-form')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="col-md-9">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.EmployeeName'):</label>
                            <div class="col-md-9">
                                <v-select placeholder="@lang('layout.SelectEmployee')" label="name"
                                          v-model="selectedEmployee"
                                          :options="{{json_encode($employee)}}">
                                </v-select>
                                <input type="hidden" name="employee_id"
                                       v-model.number="(!selectedEmployee)?null:selectedEmployee.id">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="employment" class="control-label col-md-3">@lang('layout.EmploymentType')</label>
                            <div class="col-md-9">
                                <select id="employment" class="form-control" v-model="selectedEmployment">
                                    <option disabled> @lang('layout.Select')</option>
                                    <option v-for="em in employementType" :value="em"> @{{ em.type }}</option>
                                </select>
                            </div>
                            <input type="hidden" name="employmentType" :value="selectedEmployment? selectedEmployment.tag: null">
                        </div>
                        <div class="form-group" v-if="selectedEmployment != null">
                            <label class="control-label col-md-3">@lang('layout.Amount'):</label>
                            <div class="col-md-9">
                                {{Form::number('amount',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Amount'),'step' => 'any','min' =>'0'])}}
                                <span class="required">@{{ errors.first('amount') }}</span>
                            </div>
                        </div>
                        <div class="form-group" v-if="selectedEmployment != null && selectedEmployment.tag == 'salary'">
                            <label class="control-label col-md-3">@lang('layout.Rent'):</label>
                            <div class="col-md-9">
                                {{Form::number('rent',null,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Date'):</label>
                            <div class="col-md-9">
                                <input type="text" name="date" class="form-control date" autocomplete="off">
                            </div>
                        </div>
						<div class="form-group">
							<label class="control-label col-md-3">@lang('layout.ExpenseAccount')</label>
							<div class="col-md-9">
							   <v-select label="name" v-model="SelectedCost" :options="costAccount">
								</v-select>
								<input type="hidden" name="expense_account_id" :value="(SelectedCost==null)?null:SelectedCost.id">
							</div>
						</div>
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Currency'):</label>
                            <div class="col-md-9">
                                <v-select placeholder="@lang('layout.SelectCurrency')" label="code" v-model="selectedCurrency" :options="{{json_encode($currency)}}">
                                </v-select>
                                <input type="hidden" name="currency" v-model.number="(!selectedCurrency)?null:selectedCurrency.code" v-validate ="'required'" data-vv-as = "{{ __('layout.Currency')}}" >
								<span class="required">@{{ errors.first('currency') }}</span> 
                            </div>
                        </div>

                        <div class="form-group" v-if="selectedEmployment != null && selectedEmployment.tag == 'contract'">
                            <label class="control-label col-md-3">@lang('layout.JobTitle'):</label>
                            <div class="col-md-9">
                                <v-select label="name" v-model="SelectedTypePayroll" :options="payrollType"></v-select>
                                <input type="hidden" name="payroll_price_levels_id" :value="(SelectedTypePayroll==null)?null:SelectedTypePayroll.id">
                                <span class="required">@{{ errors.first('currency') }}</span> 
                            </div>
                        </div>
 
                    </div>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>
                    <button type="button" class="btn blue"
                            @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                    <a href="{{route('salaryDetails.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
 
        Vue.component("v-select", VueSelect.VueSelect);
        let payrollPrice = {!! $payrollPrice !!};
        let payrollType = {!! $payrollType !!};

        let vu = new Vue({
            el: '#app',
            data: {
                selectedCurrency: null,
                selectedEmployee: null,
                employementType: [
                    {tag: 'salary', type:'@lang('layout.SalaryBased')'},
                    {tag: 'contract', type:'@lang("layout.ContractBased")'} ],
                selectedEmployment: null,
				SelectedCost:null,
                SelectedPayrollPrice:null,
                SelectedTypePayroll:null,
                payrollPrice: payrollPrice,
                payrollType: payrollType,
                filteredPayrollType: payrollType,
                costAccount: {!! json_encode($cost) !!},
            },

            mounted() {
                console.log();
            },

            methods: {
                filterJobTitles(){
                    if(this.SelectedPayrollPrice){
                        // console.log(132, this.filteredPayrollType, this.payrollType);
                        this.filteredPayrollType = this.payrollType.filter((a) => {
                            return (a.item_type_id == this.SelectedPayrollPrice.id)
                        });
                        // this.filteredPayrollType = this.payrollType.filter(job => job.payroll_price_levels_id == this.SelectedPayrollPrice.id);
                    }
                },
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                var url = "{{route('salaryDetails.store')}}";
                                form_id = 'salary-details-form';
                                var data = $('#' + form_id).serialize();
                                toggleBlock(true);
                                axios.post(url, data)
                                    .then(function (response) {
                                        toggleBlock(0);
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);


                                            vu.selectedEmployee = null;
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        }
                                    })
                                    .catch(function (error) {
                                        toggleBlock(0);
                                        console.log(error);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                }
            }
        })

    </script>
@endpush 