@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReportNew('salaryDetails_index');
$_record = !in_array('record', $report);
$_date = !in_array('date', $report);
$_name = !in_array('name', $report);
$_class = !in_array('class', $report);
$_phone = !in_array('phone', $report);
$_currency = !in_array('currency', $report);
$_amount = !in_array('amount', $report);
$_rent = !in_array('rent', $report);
$_expense_account = !in_array('expense_account', $report);
$_user = !in_array('user', $report);


// dd($_record);

$report_percent = customeReportNewPercent('salaryDetails_index');
    $_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_name_percent= (array_key_exists('name___percent', $report_percent))?$report_percent['name___percent']:null;
    $_class_percent= (array_key_exists('class___percent', $report_percent))?$report_percent['class___percent']:null;
    $_phone_percent= (array_key_exists('phone___percent', $report_percent))?$report_percent['phone___percent']:null;
    $_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
    $_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
    $_rent_percent= (array_key_exists('rent___percent', $report_percent))?$report_percent['rent___percent']:null;
    $_expense_account_percent= (array_key_exists('expense_account___percent', $report_percent))?$report_percent['expense_account___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;


    $setting_jalali = isset(uSetting()->jalali_and_gerogarian_date);
    $setting_date_type = isset(uSetting()->date_type);

    
?>


<h3 class="table-caption" style="text-align: center;">@lang('layout.SalaryDetailsReport')</h3>
<table class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">    @if($setting_jalali == 'true')  {{convertDate($from_date, null, null, (($setting_date_type == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">    @if($setting_jalali == 'true')  {{convertDate($to_date, null, null, (($setting_date_type == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>


@if($member_name || $member_class_name)
<table class="main-table" style="margin: 6px 0px;" >
   
    <tr>
      @if($member_name)
      <td>
        <span>@lang('layout.Customer')</span>: {{$member_name}}
      </td>
      @endif
   
      @if($member_class_name)
      <td>
        <span>@lang('layout.MemberClass')</span>: {{$member_class_name}}
      </td>
      @endif

    </tr>
</table>
@endif


<br>
<table class="main-table">

  <thead>
    <tr class="bg">
    @if($_record)<td  @if($_record_percent) width="{{$_record_percent}}%" @endif  class="center" ><div > @lang('layout.Record') </div></td>@endif
    @if($_date)<td  @if($_date_percent) width="{{$_date_percent}}%" @endif  class="center" ><div > @lang('layout.Date')</div></td>@endif
    @if(!$member_name)
    @if($_name)<td  @if($_name_percent) width="{{$_name_percent}}%" @endif  class="center" ><div > @lang('layout.Name') </div></td>@endif
    @endif
    @if(!$member_class_name)
    @if($_class)<td  @if($_class_percent) width="{{$_class_percent}}%" @endif  class="center" ><div > @lang('layout.Class') </div></td>@endif
    @endif
    @if($_phone)<td  @if($_phone_percent) width="{{$_phone_percent}}%" @endif  class="center" ><div > @lang('layout.Phone')</div></td>@endif
    @if($_currency)<td  @if($_currency_percent) width="{{$_currency_percent}}%" @endif  class="center" ><div > @lang('layout.Currency')</div></td>@endif
    @if($_amount)<td  @if($_amount_percent) width="{{$_amount_percent}}%" @endif  class="center" ><div > @lang('layout.Amount')</div></td>@endif
    @if($_rent)<td  @if($_rent_percent) width="{{$_rent_percent}}%" @endif  class="center" ><div > @lang('layout.Rent')</div></td>@endif
    @if($_expense_account)<td  @if($_expense_account_percent) width="{{$_expense_account_percent}}%" @endif  class="center" ><div > @lang('layout.ExpenseAccount')</div></td>@endif
    @if($_user)<td  @if($_user_percent) width="{{$_user_percent}}%" @endif  class="center" ><div > @lang('layout.User')</div></td>@endif
  </tr>
  </thead>
  <?php

  $count = 0;
  $total_home_currency=0;
  $currencies=[];
  ?>
  @foreach($data AS $record)
  <tr>
    <?php
   $total_home_currency+=$record->exchanged_amount;
   if(array_key_exists($record->Currency, $currencies))
   {
    $currencies[$record->Currency]=$currencies[$record->Currency]+$record->Amount;
  }
  else
  {

    $currencies[$record->Currency]=$record->Amount;
  }
  ?>
     @if($_record)<td class="center">{{++$count}}</td>@endif
    @if($_date)<td class="center">{{convertDate($record->Date)}}</td>@endif
    @if(!$member_name)
    @if($_name)<td class="center">{{$record->Name}}</td>@endif
    @endif
    @if(!$member_class_name)
    @if($_class)<td class="center">{{$record->member_class}}</td>@endif
    @endif
    @if($_phone)<td  class="center">{{$record->Phone}}</td>@endif
    @if($_currency)<td  class="center">{{$record->Currency}}</td>@endif
    @if($_amount)<td  class="center">{{myRound($record->Amount)}}</td>@endif
    @if($_rent)<td  class="center">{{myRound($record->rent)}}</td>@endif
    @if($_expense_account)<td  class="center">{{$record->account}}</td>@endif
    @if($_user)<td  class="center">{{$record->user}}</td>@endif
  </tr>
  @endforeach
</table>
<table class="main-table">
   <tr class="bg">
      <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
    </tr>
    <tr>
      <td><div class="center"> @lang('layout.Record') </div></td>
      <td><div class="center"> @lang('layout.Currency') </div></td>
      <td><div class="center"> @lang('layout.Amount') </div></td>
    </tr>
  <?php
  $count=0;
    foreach($currencies As $key=>$currency)
    {
      ?>
    <tr>
      <td><div class="center">{{++$count}}</div></td>
      <td><div class="center">{{$key}}</div></td>
      <td><div class="center">{{myRound($currency)}}</div></td>
       
    </tr>
    <?php
  }
    ?>
  
  </table>

   <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection