@extends('layouts.app')
@section('content')


<!-- END PAGE HEADER-->

<!-- BEGIN TAB PORTLET-->


<div class="row">

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.RoleManagement')</span>
            </div>
            <div class="tools"> </div> 
             <div class="btn-group pull-right">
                     @permission('role-create')
                    <a class="btn btn-success" href="{{ route('roles.create') }}"> @lang('layout.CreateNewRole') <i class="fa fa-plus-circle"></i></a>
                    @endpermission 
                </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" cellspacing="0" id="roles">
                <thead>
                <tr> 
                    <th>@lang('layout.Name')</th>
                    <th>@lang('layout.Description')</th>
                    <th>@lang('layout.Actions')</th>
                </tr>
                </thead> 
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>

<!-- END TAB PORTLET-->
<!-- END CONTENT BODY -->

@stop

@push('scripts')

<script>

    $(document).ready(function() { 
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#roles').DataTable( {
            ajax:           '{{route("roles.index")}}',
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true,
            paging:         true,
            columns: [  
            { data: 'display_name', name: 'display_name' },
            { data: 'description', name: 'description' },
            { data: 'action' ,searchable:false,orderable:false },
            ] 
    } );
    } );
</script>


@endpush
