@extends('layouts.app')
@section('style')
<link rel="stylesheet" type="text/css" href="{{URL::asset('css/permission.css')}}">
<style>

    form{
        display: block;
    }

    .setting_menu li.active a,
    .ver-inline-menu li.active i {
        background-color: #d4d7dc !important;
        color: #393a3d !important;
    }

    .ver-inline-menu li a {
        background: #eceef1 !important;
        border-left: solid 2px #eceef1;
        color: #393a3d !important;
    }

    .ver-inline-menu li i {
        background: #eceef1 !important;

    }




</style>
@stop
@section('content')
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditRole')</span>
            </div>
        </div>
        <div class="portlet-body form">
            {!! Form::model($role, ['method' => 'PATCH','route' => ['roles.update', $role->id]]) !!}
            <div class="form-body" id="app" v-cloak>
                <div class="col-md-4">
                    <div>
                        <label class="control-label">@lang('layout.Name'):</label>
                        {!! Form::text('name', null, array('placeholder' => 'Name','class' => 'form-control')) !!}
                    </div>
                </div>
                <div class="col-md-4">
                    <div>
                        <label class="control-label">@lang('layout.DisplayName'):</label>
                        {!! Form::text('display_name', null, array('placeholder' => 'Display Name','class' => 'form-control')) !!}
                    </div>
                </div>
                <div class="col-md-4">
                    <div>
                        <label class="control-label">@lang('layout.Description'):</label>
                        {!! Form::textarea('description', null, array('placeholder' => 'Description','class' => 'form-control','rows'=>'1')) !!}
                    </div>
                </div>


                <div class="portlet-body form">
                    <div id="system_setting">
                        <div class="profile">
                            <div class="tabbable-line tabbable-full-width">
                                <ul class="nav nav-tabs">
                                    <!-- <li class="">
                                        <a href="#tab_1_1" data-toggle="tab" aria-expanded="false"> Overview </a>
                                    </li>
                                    <li class="">
                                        <a href="#tab_1_3" data-toggle="tab" aria-expanded="false"> Account </a>
                                    </li>
                                    <li class="active">
                                        <a href="#tab_1_6" data-toggle="tab" aria-expanded="true"> Help </a>
                                    </li> -->
                                </ul>
                                <div class="tab-content">

                                    <div class="tab-pane active" id="tab_1_6">
                                        <div class="row">
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-md-12">
                                                <ul class="ver-inline-menu tabbable margin-bottom-10 setting_menu">

                                                    <li class="active">
                                                        <a data-toggle="tab" href="#tab_1" aria-expanded="true">
                                                            <i class="fa fa-cog" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.General') </a>
                                                    </li>
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_2" aria-expanded="true">
                                                            <i class="fa fa-group" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.Members') </a>
                                                    </li>
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_3" aria-expanded="true">
                                                            <i class="fa fa-group" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.Employee')</a>
                                                    </li>
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_4" aria-expanded="true">
                                                            <i class="icon-briefcase" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.Account') </a>
                                                    </li>
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_11" aria-expanded="true">
                                                            <i class="icon-briefcase" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.Transactions') </a>
                                                    </li>
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_5" aria-expanded="true">
                                                            <i class="icon-basket" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.Sales') </a>
                                                    </li>
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_6" aria-expanded="true">
                                                            <i class="fa fa-industry" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.BuildSetting') </a>
                                                    </li>

                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_7" aria-expanded="true">
                                                            <i class="fa fa-database" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.Inventory') </a>
                                                    </li>
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_8" aria-expanded="true">
                                                            <i class="fa fa-money" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.Expense') </a>
                                                    </li>
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_9" aria-expanded="true">
                                                            <i class="icon-basket" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.Purchase') </a>
                                                    </li>
                                                    @if(systemConfig()[5] != 0 )
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_10" aria-expanded="true">
                                                            <i class="fa fa-tasks" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.Project') </a>
                                                    </li>
                                                    @endif
                                                    @if(systemConfig()[19] == 1)
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_13" aria-expanded="true">
                                                            <i class="fa fa-tasks" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.NGOProject') </a>
                                                    </li>
                                                    @endif
                                                    @if(systemConfig()[25] != 0 )
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_12" aria-expanded="true">
                                                            <i class="fa fa-tasks" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.CargoContract') </a>
                                                    </li>
                                                    @endif
                                                </ul>
                                            </div>


                                            <div class="col-lg-10 col-md-10 col-sm-12 col-md-12">
                                                <div class="tab-content">

                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN general
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_1" class="tab-pane active ">

                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <!-- <input id="general_checkall" class="checkall_box" v-model="checkAllGeneral" name="role_group[]" :disabled="isDisableSelectGeneral()" type="checkbox">
                                                                            <label for="general_checkall">@lang('layout.Checkall')</label> -->
                                                                            <label> ( @lang('layout.General') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="general1 in general_per">
                                                                            <legend>
                                                                                <!-- <input class="sub_checkall_box" id="checkall_2" title="Check all" type="checkbox" :value='general1' v-model="general"> -->
                                                                                <label for="checkall_2" class="permissionlabel">@{{ general1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in general1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" :checked="(permission.checked=='true')?'checked':''" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End general
                                                    |---------------------------------------------------------------------------->

                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN member
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_2" class="tab-pane ">

                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <!-- <input id="member_checkall" class="checkall_box" v-model="checkAllMember" name="role_group[]" :disabled="isDisableSelectMember()" type="checkbox">
                                                                            <label for="member_checkall">@lang('layout.Checkall')</label> -->
                                                                            <label> ( @lang('layout.Members') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="member1 in member_per">
                                                                            <legend>
                                                                                <!-- <input class="sub_checkall_box" id="checkall_3" title="Check all" type="checkbox" :value='member1' v-model="member"> -->
                                                                                <label for="checkall_3" class="permissionlabel">@{{ member1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in member1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" :checked="(permission.checked=='true')?'checked':''" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End member
                                                    |---------------------------------------------------------------------------->

                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN Employee
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_3" class="tab-pane ">

                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <!-- <input id="employee_checkall" class="checkall_box" v-model="checkAllEmployee" name="role_group[]" :disabled="isDisableSelectEmployee()" type="checkbox">
                                                                            <label for="employee_checkall">@lang('layout.Checkall')</label> -->
                                                                            <label> ( @lang('layout.Employee') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="employee1 in employee_per">
                                                                            <legend>
                                                                                <!-- <input class="sub_checkall_box" id="checkall_4" title="Check all" type="checkbox" :value='employee1' v-model="employee"> -->
                                                                                <label for="checkall_4" class="permissionlabel">@{{ employee1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in employee1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" :checked="(permission.checked=='true')?'checked':''" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End employee
                                                    |---------------------------------------------------------------------------->


                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN Account
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_4" class="tab-pane ">

                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <!-- <input id="account_checkall" class="checkall_box" v-model="checkAllAccount" name="role_group[]" :disabled="isDisableSelectAccount()" type="checkbox">
                                                                            <label for="account_checkall">@lang('layout.Checkall')</label> -->
                                                                            <label> ( @lang('layout.Account') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="account1 in account_per">
                                                                            <legend>
                                                                                <!-- <input class="sub_checkall_box" id="checkall_5" title="Check all" type="checkbox" :value='account1' v-model="account"> -->
                                                                                <label for="checkall_5" class="permissionlabel">@{{ account1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in account1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" :checked="(permission.checked=='true')?'checked':''" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End Account
                                                    |---------------------------------------------------------------------------->

                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN currency Exchange
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_11" class="tab-pane ">

                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <!-- <input id="currencyExchange_checkall" class="checkall_box" v-model="checkAll_currencyExchange" name="role_group[]" :disabled="isDisableSelectCurrencyExchange()" type="checkbox">
                                                                            <label for="currencyExchange_checkall">@lang('layout.Checkall')</label> -->
                                                                            <label> ( @lang('menu.Transactions') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="currencyExchange1 in currencyExchange_per">
                                                                            <legend>
                                                                                <!-- <input class="sub_checkall_box" id="checkall_5" title="Check all" type="checkbox" :value='currencyExchange1' v-model="currencyExchange"> -->
                                                                                <label for="checkall_5" class="permissionlabel">@{{ currencyExchange1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in currencyExchange1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" :checked="(permission.checked=='true')?'checked':''" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End currency Exchange
                                                    |---------------------------------------------------------------------------->


                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN Sale
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_5" class="tab-pane ">

                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <!-- <input id="sale_checkall" class="checkall_box" v-model="checkAll_sale" name="role_group[]" :disabled="isDisableSelect_sale()" type="checkbox">
                                                                            <label for="sale_checkall">@lang('layout.Checkall')</label> -->
                                                                            <label> ( @lang('menu.Sales') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="sale1 in sale_per">
                                                                            <legend>
                                                                                <!-- <input class="sub_checkall_box" id="checkall_6" title="Check all" type="checkbox" :value='sale1' v-model="sale"> -->
                                                                                <label for="checkall_6" class="permissionlabel">@{{ sale1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in sale1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" :checked="(permission.checked=='true')?'checked':''" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End Sale
                                                    |---------------------------------------------------------------------------->

                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN BuildSetting
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_6" class="tab-pane ">

                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <!-- <input id="build_checkall" class="checkall_box" v-model="checkAll_build" name="role_group[]" :disabled="isDisableSelect_build()" type="checkbox">
                                                                            <label for="build_checkall">@lang('layout.Checkall')</label> -->
                                                                            <label> ( @lang('layout.BuildSetting') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="build1 in build_per">
                                                                            <legend>
                                                                                <!-- <input class="sub_checkall_box" id="checkall_7" title="Check all" type="checkbox" :value='build1' v-model="build"> -->
                                                                                <label for="checkall_7" class="permissionlabel">@{{ build1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in build1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" :checked="(permission.checked=='true')?'checked':''" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End BuildSetting
                                                    |---------------------------------------------------------------------------->

                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN Inventory
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_7" class="tab-pane ">
                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <!-- <input id="site_checkall" class="checkall_box" v-model="checkAllSite" name="role_group[]" :disabled="isDisableSelectSite()" type="checkbox">
                                                                            <label for="site_checkall">@lang('layout.Checkall')</label> -->
                                                                            <label> ( @lang('layout.Inventory') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="site1 in site_per">
                                                                            <legend>
                                                                                <!-- <input class="sub_checkall_box" id="checkall_1" title="Check all" type="checkbox" :value='site1' v-model="site"> -->
                                                                                <label for="checkall_1" class="permissionlabel">@{{ site1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in site1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" :checked="(permission.checked=='true')?'checked':''" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End Inventory
                                                    |---------------------------------------------------------------------------->

                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN expense
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_8" class="tab-pane ">

                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <!-- <input id="expense_checkall" class="checkall_box" v-model="checkAll_expense" name="role_group[]" :disabled="isDisableSelect_expense()" type="checkbox">
                                                                            <label for="expense_checkall">@lang('layout.Checkall')</label> -->
                                                                            <label> ( @lang('layout.Expense') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="expense1 in expense_per">
                                                                            <legend>
                                                                                <!-- <input class="sub_checkall_box" id="checkall_8" title="Check all" type="checkbox" :value='expense1' v-model="expense"> -->
                                                                                <label for="checkall_8" class="permissionlabel">@{{ expense1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in expense1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" :checked="(permission.checked=='true')?'checked':''" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End expense
                                                    |---------------------------------------------------------------------------->


                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN Purchase
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_9" class="tab-pane ">

                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <!-- <input id="purchase_checkall" class="checkall_box" v-model="checkAll_purchase" name="role_group[]" :disabled="isDisableSelect_purchase()" type="checkbox">
                                                                            <label for="purchase_checkall">@lang('layout.Checkall')</label> -->
                                                                            <label> ( @lang('layout.Purchase') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="purchase1 in purchase_per">
                                                                            <legend>
                                                                                <!-- <input class="sub_checkall_box" id="checkall_9" title="Check all" type="checkbox" :value='purchase1' v-model="purchase"> -->
                                                                                <label for="checkall_9" class="permissionlabel">@{{ purchase1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in purchase1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" :checked="(permission.checked=='true')?'checked':''" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End Purchase
                                                    |---------------------------------------------------------------------------->


                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN Project
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_10" class="tab-pane ">

                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <!-- <input id="project_checkall" class="checkall_box" v-model="checkAll_project" name="role_group[]" :disabled="isDisableSelect_project()" type="checkbox">
                                                                            <label for="project_checkall">@lang('layout.Checkall')</label> -->
                                                                            <label> ( @lang('layout.Project') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="project1 in project_per">
                                                                            <legend>
                                                                                <!-- <input class="sub_checkall_box" id="checkall_10" title="Check all" type="checkbox" :value='project1' v-model="project"> -->
                                                                                <label for="checkall_10" class="permissionlabel">@{{ project1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in project1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" :checked="(permission.checked=='true')?'checked':''" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End Project
                                                    |---------------------------------------------------------------------------->


                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN NGOProject
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_13" class="tab-pane ">

                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <!-- <input id="NGOProject_checkall" class="checkall_box" v-model="checkAll_NGOProject" name="role_group[]" :disabled="isDisableSelect_NGOProject()" type="checkbox">
                                                                            <label for="NGOProject_checkall">@lang('layout.Checkall')</label> -->
                                                                            <label> ( @lang('layout.NGOProject') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="NGOProject1 in NGOProject_per">
                                                                            <legend>
                                                                                <!-- <input class="sub_checkall_box" id="checkall_10" title="Check all" type="checkbox" :value='NGOProject1' v-model="NGOProject"> -->
                                                                                <label for="checkall_10" class="permissionlabel">@{{ NGOProject1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in NGOProject1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" :checked="(permission.checked=='true')?'checked':''" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End NGOProject
                                                    |---------------------------------------------------------------------------->


                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN cargoContract
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_12" class="tab-pane ">

                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <!-- <input id="cargoContract_checkall" class="checkall_box" v-model="checkAll_cargoContract" name="role_group[]" :disabled="isDisableSelect_cargoContract()" type="checkbox">
                                                                            <label for="cargoContract_checkall">@lang('layout.Checkall')</label> -->
                                                                            <label> ( @lang('menu.CargoContract') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="cargoContract1 in cargoContract_per">
                                                                            <legend>
                                                                                <!-- <input class="sub_checkall_box" id="checkall_10" title="Check all" type="checkbox" :value='cargoContract1' v-model="cargoContract"> -->
                                                                                <label for="checkall_10" class="permissionlabel">@{{ cargoContract1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in cargoContract1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" :checked="(permission.checked=='true')?'checked':''" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End cargoContract
                                                    |---------------------------------------------------------------------------->

                                                </div>
                                            </div>



                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--end tab-pane-->

                <!-- <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group last">

                            <div class="col-md-12">
                                {{--<input name="username" value="" type="hidden"><input name="hostname" value="localhost"--}}
                                {{--type="hidden"><input name="dbname" value="" type="hidden">--}}
                                {{--<input name="token" value="" type="hidden">--}}
                                {{--<input name="grant_count" value="27" type="hidden">--}}
                                <fieldset id="fieldset_user_global_rights">
                                    <legend data-submenu-label="Global">@lang('layout.Permission')
                                    </legend>



                                    

                                    <fieldset v-for="group in groups">
                                        <legend>
                                           
                                            <label
                                                    for="checkall_Structure_priv"
                                                    class="permissionlabel">@{{ group.display_name }}</label>
                                        </legend>
                                        {{--@foreach($permission->permissions as $value)--}}
                                        <div v-for="permission in group.permissions " class="item">
                                            <label>
                                                <input  type="checkbox" name="permission[]"   :value="permission.id" :checked="(permission.checked=='true')?'checked':''">
                                                {{--{{ Form::checkbox('permission[]',permission.id, null, array('class' => 'name')) }}--}}
                                                <dfn :title="permission.description">@{{permission.display_name}}</dfn>
                                            </label>
                                        </div>

                                    </fieldset>



                                </fieldset>
                            </div>

                        </div>
                    </div> -->

            </div>
            <div class="form-actions">
                <div class="row">
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-md-offset-3 col-md-9">
                                <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                                <button type="button" class="btn default">@lang('layout.Cancel')</button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6"></div>
                </div>
            </div>
            {!! Form::close() !!}
            <!-- END FORM-->
        </div>
    </div>

</div>


@endsection
@push('scripts')
<script>
        var site_per = {!! json_encode($site_per) !!};
        var account_per = {!! json_encode($account_per) !!};
        var currencyExchange_per = {!! json_encode($currencyExchange_per) !!};
        var sale_per = {!! json_encode($sale_per) !!};
        var member_per = {!! json_encode($member_per) !!};
        var employee_per = {!! json_encode($empolyee_per) !!};
        var general_per = {!! json_encode($general_per) !!};
        var purchase_per = {!! json_encode($purchase_per) !!};
        var build_per = {!! json_encode($build_per) !!};
        var expense_per = {!! json_encode($expense_per) !!};
        var project_per = {!! json_encode($project_per) !!};
        var NGOProject_per = {!! json_encode($NGOproject_per) !!};
        var cargoContract_per = {!! json_encode($cargoContract_per) !!};
        var rolePermissions = {!!$rolePermissions !!};
  

    new Vue({
        el: '#app',
        data: {
            list: {!!$rolePermissions!!},
            checkAll: false,
            guroplist: [],
            groups: {!!$permission_group!!},

            checkAllGeneral: false,
            general_per: general_per,
            general: [],
            general_list: [],

            checkAllSite: false,
            site_per: site_per,
            site: [],
            site_list: [],

            checkAllMember: false,
            member_per: member_per,
            member: [],
            member_list: [],

            checkAllEmployee: false,
            employee_per: employee_per,
            employee: [],
            employee_list: [],

            checkAllAccount: false,
            account_per: account_per,
            account: [],
            account_list: [],

            checkAll_currencyExchange: false,
            currencyExchange_per: currencyExchange_per,
            currencyExchange: [],
            currencyExchange_list: [],

            checkAll_sale: false,
            sale_per: sale_per,
            sale: [],
            sale_list: [],

            checkAll_build: false,
            build_per: build_per,
            build: [],
            build_list: [],

            checkAll_expense: false,
            expense_per: expense_per,
            expense: [],
            expense_list: [],

            checkAll_purchase: false,
            purchase_per: purchase_per,
            purchase: [],
            purchase_list: [],

            checkAll_project: false,
            project_per: project_per,
            project: [],
            project_list: [],

            checkAll_NGOProject: false,
            NGOProject_per: NGOProject_per,
            NGOProject: [],
            NGOProject_list: [],

            checkAll_cargoContract: false,
            cargoContract_per: cargoContract_per,
            cargoContract: [],
            cargoContract_list: [],

        },
        watch: {
            checkAll: function() {
                this.list = [];
                this.guroplist = [];
                if (this.checkAll) {
                    for (var i = 0; i < this.groups.length; i++) {
                        this.guroplist.push(this.groups[i]);
                    }
                }

            },
            guroplist: function() {
                this.list = [];
                for (var i = 0; i < this.guroplist.length; i++) {

                    for (var j = 0; j < this.guroplist[i].permissions.length; j++) {

                        this.list.push(this.guroplist[i].permissions[j].id)
                    }

                }
            }
        }


    })
</script>
@endpush