@extends('layouts.app')
@section('style')
<link rel="stylesheet" type="text/css" href="{{URL::asset('css/permission.css')}}">
<style>

    form{
        display: block;
    }

    .setting_menu li.active a,
    .ver-inline-menu li.active i {
        background-color: #d4d7dc !important;
        color: #393a3d !important;
    }

    .ver-inline-menu li a {
        background: #eceef1 !important;
        border-left: solid 2px #eceef1;
        color: #393a3d !important;
    }

    .ver-inline-menu li i {
        background: #eceef1 !important;

    }



</style>
@stop
@section('content')
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.NewRole')</span>
            </div>

        </div>
        <div class="portlet-body form">
            {!! Form::open(array('route' => 'roles.store','method'=>'POST')) !!}
            <div class="form-body" id="app" v-cloak>
                <div class="col-md-4">
                    <div>
                        <label class="control-label">@lang('layout.Name'):</label>
                        {!! Form::text('name', null, array('placeholder' =>__('layout.Name'),'class' => 'form-control')) !!}
                    </div>
                </div>
                <div class="col-md-4">
                    <div>
                        <label class="control-label">@lang('layout.DisplayName'):</label>
                        {!! Form::text('display_name', null, array('placeholder' =>__('layout.DisplayName'),'class' => 'form-control')) !!}
                    </div>
                </div>
                <div class="col-md-4">
                    <div>
                        <label class="control-label">@lang('layout.Description'):</label>
                        {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows'=>'1')) !!}
                    </div>
                </div>


                <div class="col-xs-12 col-sm-12 col-md-12">
                    <div class="form-group last">
                        <div class="col-md-12">
                            <fieldset id="fieldset_user_global_rights">
                                <legend data-submenu-label="Global">@lang('layout.Permission')
                                    <input id="addUsersForm_checkall" class="checkall_box" v-model="checkAll" name="role_group[]" :disabled="isDisableSelectAll()" type="checkbox">
                                    <label for="addUsersForm_checkall">@lang('layout.Checkall')</label>
                                </legend>
                            </fieldset>
                        </div>
                    </div>
                </div>



                <div class="portlet-body form">
                    <div id="system_setting">
                        <div class="profile">
                        <div class="tabbable-line tabbable-full-width">
                                <ul class="nav nav-tabs">
                                    <!-- <li class="">
                                        <a href="#tab_1_1" data-toggle="tab" aria-expanded="false"> Overview </a>
                                    </li>
                                    <li class="">
                                        <a href="#tab_1_3" data-toggle="tab" aria-expanded="false"> Account </a>
                                    </li>
                                    <li class="active">
                                        <a href="#tab_1_6" data-toggle="tab" aria-expanded="true"> Help </a>
                                    </li> -->
                                </ul>
                                <div class="tab-content">

                                    <div class="tab-pane active" id="tab_1_6">
                                        <div class="row">
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-md-12">
                                                <ul class="ver-inline-menu tabbable margin-bottom-10 setting_menu">

                                                    <li class="active">
                                                        <a data-toggle="tab" href="#tab_1" aria-expanded="true">
                                                            <i class="fa fa-cog" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.General') </a>
                                                    </li>
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_2" aria-expanded="true">
                                                            <i class="fa fa-group" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.Members') </a>
                                                    </li>
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_3" aria-expanded="true">
                                                            <i class="fa fa-group" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.Employee')</a>
                                                    </li>
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_4" aria-expanded="true">
                                                            <i class="icon-briefcase" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.Account') </a>
                                                    </li>
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_11" aria-expanded="true">
                                                            <i class="icon-briefcase" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.Transactions') </a>
                                                    </li>
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_5" aria-expanded="true">
                                                            <i class="icon-basket" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.Sales') </a>
                                                    </li>
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_6" aria-expanded="true">
                                                            <i class="fa fa-industry" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.BuildSetting') </a>
                                                    </li>

                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_7" aria-expanded="true">
                                                            <i class="fa fa-database" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.Inventory') </a>
                                                    </li>
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_8" aria-expanded="true">
                                                            <i class="fa fa-money" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.Expense') </a>
                                                    </li>
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_9" aria-expanded="true">
                                                            <i class="icon-basket" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.Purchase') </a>
                                                    </li>
                                                    @if(systemConfig()[5] != 0 )
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_10" aria-expanded="true">
                                                            <i class="fa fa-tasks" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.Project') </a>
                                                    </li>
                                                    @endif
                                                    @if(systemConfig()[19] == 1)
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_13" aria-expanded="true">
                                                            <i class="fa fa-tasks" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.NGOProject') </a>
                                                    </li>
                                                    @endif
                                                    @if(systemConfig()[25] != 0 )
                                                    <li class="">
                                                        <a data-toggle="tab" href="#tab_12" aria-expanded="true">
                                                            <i class="fa fa-tasks" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.CargoContract') </a>
                                                    </li>
                                                    @endif
                                                </ul>
                                            </div>




                                            <div class="col-lg-10 col-md-10 col-sm-12 col-md-12">
                                                <div class="tab-content">
                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN general
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_1" class="tab-pane active ">
                                                        
                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <input id="general_checkall" class="checkall_box" v-model="checkAllGeneral" name="role_group[]" :disabled="isDisableSelectGeneral()" type="checkbox">
                                                                            <label for="general_checkall">@lang('layout.Checkall')</label>
                                                                            <label> ( @lang('layout.General') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="general1 in general_per">
                                                                            <legend>
                                                                                <input class="sub_checkall_box" id="checkall_2" :disabled="isDisable(general1.permissions)" title="Check all" type="checkbox" :value='general1' v-model="general">
                                                                                <label for="checkall_2" class="permissionlabel">@{{ general1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in general1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" v-model="general_list" :disabled="!permission.enable" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End general
                                                    |---------------------------------------------------------------------------->

                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN member
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_2" class="tab-pane ">
                                                        
                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <input id="member_checkall" class="checkall_box" v-model="checkAllMember" name="role_group[]" :disabled="isDisableSelectMember()" type="checkbox">
                                                                            <label for="member_checkall">@lang('layout.Checkall')</label>
                                                                            <label> ( @lang('layout.Members') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="member1 in member_per">
                                                                            <legend>
                                                                                <input class="sub_checkall_box" id="checkall_3" :disabled="isDisable(member1.permissions)" title="Check all" type="checkbox" :value='member1' v-model="member">
                                                                                <label for="checkall_3" class="permissionlabel">@{{ member1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in member1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" v-model="member_list" :disabled="!permission.enable" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End member
                                                    |---------------------------------------------------------------------------->

                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN Employee
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_3" class="tab-pane ">
                                                        
                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <input id="employee_checkall" class="checkall_box" v-model="checkAllEmployee" name="role_group[]" :disabled="isDisableSelectEmployee()" type="checkbox">
                                                                            <label for="employee_checkall">@lang('layout.Checkall')</label>
                                                                            <label> ( @lang('layout.Employee') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="employee1 in employee_per">
                                                                            <legend>
                                                                                <input class="sub_checkall_box" id="checkall_4" :disabled="isDisable(employee1.permissions)" title="Check all" type="checkbox" :value='employee1' v-model="employee">
                                                                                <label for="checkall_4" class="permissionlabel">@{{ employee1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in employee1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" v-model="employee_list" :disabled="!permission.enable" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End employee
                                                    |---------------------------------------------------------------------------->


                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN Account
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_4" class="tab-pane ">
                                                        
                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <input id="account_checkall" class="checkall_box" v-model="checkAllAccount" name="role_group[]" :disabled="isDisableSelectAccount()" type="checkbox">
                                                                            <label for="account_checkall">@lang('layout.Checkall')</label>
                                                                            <label> ( @lang('layout.Account') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="account1 in account_per">
                                                                            <legend>
                                                                                <input class="sub_checkall_box" id="checkall_5" :disabled="isDisable(account1.permissions)" title="Check all" type="checkbox" :value='account1' v-model="account">
                                                                                <label for="checkall_5" class="permissionlabel">@{{ account1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in account1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" v-model="account_list" :disabled="!permission.enable" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End Account
                                                    |---------------------------------------------------------------------------->


                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN currency Exchange
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_11" class="tab-pane ">
                                                        
                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <input id="currencyExchange_checkall" class="checkall_box" v-model="checkAll_currencyExchange" name="role_group[]" :disabled="isDisableSelectCurrencyExchange()" type="checkbox">
                                                                            <label for="currencyExchange_checkall">@lang('layout.Checkall')</label>
                                                                            <label> ( @lang('menu.Transactions') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="currencyExchange1 in currencyExchange_per">
                                                                            <legend>
                                                                                <input class="sub_checkall_box" id="checkall_5" :disabled="isDisable(currencyExchange1.permissions)" title="Check all" type="checkbox" :value='currencyExchange1' v-model="currencyExchange">
                                                                                <label for="checkall_5" class="permissionlabel">@{{ currencyExchange1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in currencyExchange1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" v-model="currencyExchange_list" :disabled="!permission.enable" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End Currency Exchange
                                                    |---------------------------------------------------------------------------->


                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN Sale
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_5" class="tab-pane ">
                                                        
                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <input id="sale_checkall" class="checkall_box" v-model="checkAll_sale" name="role_group[]" :disabled="isDisableSelect_sale()" type="checkbox">
                                                                            <label for="sale_checkall">@lang('layout.Checkall')</label>
                                                                            <label> ( @lang('menu.Sales') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="sale1 in sale_per">
                                                                            <legend>
                                                                                <input class="sub_checkall_box" id="checkall_6" :disabled="isDisable(sale1.permissions)" title="Check all" type="checkbox" :value='sale1' v-model="sale">
                                                                                <label for="checkall_6" class="permissionlabel">@{{ sale1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in sale1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" v-model="sale_list" :disabled="!permission.enable" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End Sale
                                                    |---------------------------------------------------------------------------->

                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN BuildSetting
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_6" class="tab-pane ">
                                                        
                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <input id="build_checkall" class="checkall_box" v-model="checkAll_build" name="role_group[]" :disabled="isDisableSelect_build()" type="checkbox">
                                                                            <label for="build_checkall">@lang('layout.Checkall')</label>
                                                                            <label> ( @lang('layout.BuildSetting') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="build1 in build_per">
                                                                            <legend>
                                                                                <input class="sub_checkall_box" id="checkall_7" :disabled="isDisable(build1.permissions)" title="Check all" type="checkbox" :value='build1' v-model="build">
                                                                                <label for="checkall_7" class="permissionlabel">@{{ build1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in build1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" v-model="build_list" :disabled="!permission.enable" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End BuildSetting
                                                    |---------------------------------------------------------------------------->

                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN Inventory
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_7" class="tab-pane ">
                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <input id="site_checkall" class="checkall_box" v-model="checkAllSite" name="role_group[]" :disabled="isDisableSelectSite()" type="checkbox">
                                                                            <label for="site_checkall">@lang('layout.Checkall')</label>
                                                                            <label> ( @lang('layout.Inventory') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="site1 in site_per">
                                                                            <legend>
                                                                                <input class="sub_checkall_box" id="checkall_1" :disabled="isDisable(site1.permissions)" title="Check all" type="checkbox" :value='site1' v-model="site">
                                                                                <label for="checkall_1" class="permissionlabel">@{{ site1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in site1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" v-model="site_list" :disabled="!permission.enable" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End Inventory
                                                    |---------------------------------------------------------------------------->

                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN expense
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_8" class="tab-pane ">
                                                        
                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <input id="expense_checkall" class="checkall_box" v-model="checkAll_expense" name="role_group[]" :disabled="isDisableSelect_expense()" type="checkbox">
                                                                            <label for="expense_checkall">@lang('layout.Checkall')</label>
                                                                            <label> ( @lang('layout.Expense') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="expense1 in expense_per">
                                                                            <legend>
                                                                                <input class="sub_checkall_box" id="checkall_8" :disabled="isDisable(expense1.permissions)" title="Check all" type="checkbox" :value='expense1' v-model="expense">
                                                                                <label for="checkall_8" class="permissionlabel">@{{ expense1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in expense1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" v-model="expense_list" :disabled="!permission.enable" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End expense
                                                    |---------------------------------------------------------------------------->


                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN Purchase
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_9" class="tab-pane ">
                                                        
                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <input id="purchase_checkall" class="checkall_box" v-model="checkAll_purchase" name="role_group[]" :disabled="isDisableSelect_purchase()" type="checkbox">
                                                                            <label for="purchase_checkall">@lang('layout.Checkall')</label>
                                                                            <label> ( @lang('layout.Purchase') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="purchase1 in purchase_per">
                                                                            <legend>
                                                                                <input class="sub_checkall_box" id="checkall_9" :disabled="isDisable(purchase1.permissions)" title="Check all" type="checkbox" :value='purchase1' v-model="purchase">
                                                                                <label for="checkall_9" class="permissionlabel">@{{ purchase1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in purchase1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" v-model="purchase_list" :disabled="!permission.enable" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End Purchase
                                                    |---------------------------------------------------------------------------->


                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN Project
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_10" class="tab-pane ">
                                                        
                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <input id="project_checkall" class="checkall_box" v-model="checkAll_project" name="role_group[]" :disabled="isDisableSelect_project()" type="checkbox">
                                                                            <label for="project_checkall">@lang('layout.Checkall')</label>
                                                                            <label> ( @lang('layout.Project') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="project1 in project_per">
                                                                            <legend>
                                                                                <input class="sub_checkall_box" id="checkall_10" :disabled="isDisable(project1.permissions)" title="Check all" type="checkbox" :value='project1' v-model="project">
                                                                                <label for="checkall_10" class="permissionlabel">@{{ project1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in project1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" v-model="project_list" :disabled="!permission.enable" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End Project
                                                    |---------------------------------------------------------------------------->


                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN CargoContract
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_12" class="tab-pane ">
                                                    
                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <input id="cargoContract_checkall" class="checkall_box" v-model="checkAll_cargoContract" name="role_group[]" :disabled="isDisableSelect_cargoContract()" type="checkbox">
                                                                            <label for="cargoContract_checkall">@lang('layout.Checkall')</label>
                                                                            <label> ( @lang('menu.CargoContract') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="cargoContract1 in cargoContract_per">
                                                                            <legend>
                                                                                <input class="sub_checkall_box" id="checkall_10" :disabled="isDisable(cargoContract1.permissions)" title="Check all" type="checkbox" :value='cargoContract1' v-model="cargoContract">
                                                                                <label for="checkall_10" class="permissionlabel">@{{ cargoContract1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in cargoContract1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" v-model="cargoContract_list" :disabled="!permission.enable" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End CargoContract
                                                    |---------------------------------------------------------------------------->


                                                    <!----------------------------------------------------------------------------
                                                    | BEGIN NGOProject
                                                    |---------------------------------------------------------------------------->
                                                    <div id="tab_13" class="tab-pane ">
                                                        
                                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                                            <div class="form-group last">

                                                                <div class="col-md-12">
                                                                    <fieldset id="fieldset_user_global_rights">
                                                                        <legend data-submenu-label="Global">@lang('layout.Permission')
                                                                            <input id="NGOProject_checkall" class="checkall_box" v-model="checkAll_NGOProject" name="role_group[]" :disabled="isDisableSelect_NGOProject()" type="checkbox">
                                                                            <label for="NGOProject_checkall">@lang('layout.Checkall')</label>
                                                                            <label> ( @lang('layout.NGOProject') ) </label>
                                                                        </legend>
                                                                        <fieldset v-for="NGOProject1 in NGOProject_per">
                                                                            <legend>
                                                                                <input class="sub_checkall_box" id="checkall_10" :disabled="isDisable(NGOProject1.permissions)" title="Check all" type="checkbox" :value='NGOProject1' v-model="NGOProject">
                                                                                <label for="checkall_10" class="permissionlabel">@{{ NGOProject1.display_name }}</label>
                                                                            </legend>
                                                                            <div v-for="permission in NGOProject1.permissions " class="item">
                                                                                <label>
                                                                                    <input type="checkbox" name="permission[]" v-model="NGOProject_list" :disabled="!permission.enable" :value="permission.id">
                                                                                    <dfn :title="permission.description">
                                                                                        @{{permission.display_name}}
                                                                                    </dfn>
                                                                                </label>
                                                                            </div>

                                                                        </fieldset>
                                                                    </fieldset>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!----------------------------------------------------------------------------
                                                    | End NGOProject
                                                    |---------------------------------------------------------------------------->



                                                    </div>
                                            </div>



                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--end tab-pane-->


                <!-- <div class="col-xs-12 col-sm-12 col-md-12">
                    <div class="form-group last">

                        <div class="col-md-12">
                            {{--<input name="username" value="" type="hidden"><input name="hostname" value="localhost"--}}
                            {{--type="hidden"><input name="dbname" value="" type="hidden">--}}
                            {{--<input name="token" value="" type="hidden">--}}
                            {{--<input name="grant_count" value="27" type="hidden">--}}
                            <fieldset id="fieldset_user_global_rights">
                                <legend data-submenu-label="Global">@lang('layout.Permission')
                                    <input id="addUsersForm_checkall" class="checkall_box" v-model="checkAll" name="role_group[]" :disabled="isDisableSelectAll()" type="checkbox">
                                    <label for="addUsersForm_checkall">@lang('layout.Checkall')</label>
                                </legend>

                                <fieldset v-for="group in groups">
                                    <legend>
                                        <input class="sub_checkall_box" id="checkall_Structure_priv" :disabled="isDisable(group.permissions)" title="Check all" type="checkbox" :value='group' v-model="guroplist">
                                        <label for="checkall_Structure_priv" class="permissionlabel">@{{ group.display_name }}</label>
                                    </legend>
                                    {{--@foreach($permission->permissions as $value)--}}
                                    <div v-for="permission in group.permissions " class="item">
                                        <label>
                                            <input type="checkbox" name="permission[]" v-model="list" :disabled="!permission.enable" :value="permission.id">
                                            {{--{{ Form::checkbox('permission[]',permission.id, null, array('class' => 'name')) }}--}}
                                            <dfn :title="permission.description">
                                                @{{permission.display_name}}</dfn>
                                        </label>
                                    </div>

                                </fieldset>
                            </fieldset>
                        </div>

                    </div>
                </div> -->
            </div>
            <div class="form-actions">
                <div class="row">
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-md-offset-3 col-md-9">
                                <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                                <a href="{{route('roles.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-6"></div>
                </div>
            </div>
            {!! Form::close() !!}
            <!-- END FORM-->
        </div>
    </div>
</div>
@endsection
@push('scripts')


<script>

    var site_per = {!! json_encode($site_per) !!};
    var account_per = {!! json_encode($account_per) !!};
    var currencyExchange_per = {!! json_encode($currencyExchange_per) !!};
    var sale_per = {!! json_encode($sale_per) !!};
    var member_per = {!! json_encode($member_per) !!};
    var employee_per = {!! json_encode($empolyee_per) !!};
    var general_per = {!! json_encode($general_per) !!};
    var purchase_per = {!! json_encode($purchase_per) !!};
    var build_per = {!! json_encode($build_per) !!};
    var expense_per = {!! json_encode($expense_per) !!};
    var project_per = {!! json_encode($project_per) !!};
    var NGOProject_per = {!! json_encode($NGOproject_per) !!};
    var cargoContract_per = {!! json_encode($cargoContract_per) !!};

    new Vue({
        el: '#app',
        data: {
            list: [],
            checkAll: false,
            guroplist: [],
            groups: {!!$permission_group!!},

            checkAllGeneral: false,
            general_per: general_per,
            general: [],
            general_list: [],

            checkAllSite: false,
            site_per: site_per,
            site: [],
            site_list: [],

            checkAllMember: false,
            member_per: member_per,
            member: [],
            member_list: [],

            checkAllEmployee: false,
            employee_per: employee_per,
            employee: [],
            employee_list: [],

            checkAllAccount: false,
            account_per: account_per,
            account: [],
            account_list: [],

            checkAll_currencyExchange: false,
            currencyExchange_per: currencyExchange_per,
            currencyExchange: [],
            currencyExchange_list: [],

            checkAll_sale: false,
            sale_per: sale_per,
            sale: [],
            sale_list: [],

            checkAll_build: false,
            build_per: build_per,
            build: [],
            build_list: [],

            checkAll_expense: false,
            expense_per: expense_per,
            expense: [],
            expense_list: [],

            checkAll_purchase: false,
            purchase_per: purchase_per,
            purchase: [],
            purchase_list: [],

            checkAll_project: false,
            project_per: project_per,
            project: [],
            project_list: [],

            checkAll_NGOProject: false,
            NGOProject_per: NGOProject_per,
            NGOProject: [],
            NGOProject_list: [],

            checkAll_cargoContract: false,
            cargoContract_per: cargoContract_per,
            cargoContract: [],
            cargoContract_list: [],
        },
        created: function() {
            /* console.log('grop',this.groups);*/
        },
        watch: {
            checkAll: function() {
                this.list = [];
                this.guroplist = [];
                this.site_list = [];
                this.site = [];
                this.general_list = [];
                this.general = [];
                this.member_list = [];
                this.member = [];
                this.employee_list = [];
                this.employee = [];
                this.account_list = [];
                this.account = [];
                this.currencyExchange_list = [];
                this.currencyExchange = [];
                this.sale_list = [];
                this.sale = [];
                this.build_list = [];
                this.build = [];
                this.expense_list = [];
                this.expense = [];
                this.purchase_list = [];
                this.purchase = [];
                this.project_list = [];
                this.project = [];
                this.NGOProject_list = [];
                this.NGOProject = [];
                this.cargoContract_list = [];
                this.cargoContract = [];

                if (this.checkAll) {
                    // for (var i = 0; i < this.groups.length; i++) {
                    //     this.guroplist.push(this.groups[i]);
                    // }

                    for (var i = 0; i < this.site_per.length; i++) {
                        this.site.push(this.site_per[i]);
                    }
                    
                    for (var i = 0; i < this.general_per.length; i++) {
                        this.general.push(this.general_per[i]);
                    }

                    for (var i = 0; i < this.member_per.length; i++) {
                        this.member.push(this.member_per[i]);
                    }

                    for (var i = 0; i < this.employee_per.length; i++) {
                        this.employee.push(this.employee_per[i]);
                    }

                    for (var i = 0; i < this.account_per.length; i++) {
                        this.account.push(this.account_per[i]);
                    }

                    for (var i = 0; i < this.currencyExchange_per.length; i++) {
                        this.currencyExchange.push(this.currencyExchange_per[i]);
                    }

                    for (var i = 0; i < this.sale_per.length; i++) {
                        this.sale.push(this.sale_per[i]);
                    }

                    for (var i = 0; i < this.build_per.length; i++) {
                        this.build.push(this.build_per[i]);
                    }

                    for (var i = 0; i < this.expense_per.length; i++) {
                        this.expense.push(this.expense_per[i]);
                    }

                    for (var i = 0; i < this.purchase_per.length; i++) {
                        this.purchase.push(this.purchase_per[i]);
                    }

                    for (var i = 0; i < this.project_per.length; i++) {
                        this.project.push(this.project_per[i]);
                    }

                    for (var i = 0; i < this.NGOProject_per.length; i++) {
                        this.NGOProject.push(this.NGOProject_per[i]);
                    }

                    for (var i = 0; i < this.cargoContract_per.length; i++) {
                        this.cargoContract.push(this.cargoContract_per[i]);
                    }

                }
            },
            // guroplist: function() {
            //     this.list = [];
            //     for (var i = 0; i < this.guroplist.length; i++) {

            //         for (var j = 0; j < this.guroplist[i].permissions.length; j++) {
            //             if (this.guroplist[i].permissions[j].enable) {
            //                 this.list.push(this.guroplist[i].permissions[j].id)
            //             }

            //         }

            //     }
            // },
            checkAllSite: function() {
                this.site_list = [];
                this.site = [];
                if (this.checkAllSite) {
                    for (var i = 0; i < this.site_per.length; i++) {
                        this.site.push(this.site_per[i]);
                    }
                }

            },
            site: function() {
                this.site_list = [];
                for (var i = 0; i < this.site.length; i++) {

                    for (var j = 0; j < this.site[i].permissions.length; j++) {
                        if (this.site[i].permissions[j].enable) {
                            this.site_list.push(this.site[i].permissions[j].id)
                        }

                    }

                }
            },
            checkAllGeneral: function() {
                this.general_list = [];
                this.general = [];
                if (this.checkAllGeneral) {
                    for (var i = 0; i < this.general_per.length; i++) {
                        this.general.push(this.general_per[i]);
                    }
                }

            },
            general: function() {
                this.general_list = [];
                for (var i = 0; i < this.general.length; i++) {

                    for (var j = 0; j < this.general[i].permissions.length; j++) {
                        if (this.general[i].permissions[j].enable) {
                            this.general_list.push(this.general[i].permissions[j].id)
                        }

                    }

                }
            },
            checkAllMember: function() {
                this.member_list = [];
                this.member = [];
                if (this.checkAllMember) {
                    for (var i = 0; i < this.member_per.length; i++) {
                        this.member.push(this.member_per[i]);
                    }
                }

            },
            member: function() {
                this.member_list = [];
                for (var i = 0; i < this.member.length; i++) {

                    for (var j = 0; j < this.member[i].permissions.length; j++) {
                        if (this.member[i].permissions[j].enable) {
                            this.member_list.push(this.member[i].permissions[j].id)
                        }

                    }

                }
            },
            checkAllEmployee: function() {
                this.employee_list = [];
                this.employee = [];
                if (this.checkAllEmployee) {
                    for (var i = 0; i < this.employee_per.length; i++) {
                        this.employee.push(this.employee_per[i]);
                    }
                }

            },
            employee: function() {
                this.employee_list = [];
                for (var i = 0; i < this.employee.length; i++) {

                    for (var j = 0; j < this.employee[i].permissions.length; j++) {
                        if (this.employee[i].permissions[j].enable) {
                            this.employee_list.push(this.employee[i].permissions[j].id)
                        }

                    }

                }
            },
            checkAllAccount: function() {
                this.account_list = [];
                this.account = [];
                if (this.checkAllAccount) {
                    for (var i = 0; i < this.account_per.length; i++) {
                        this.account.push(this.account_per[i]);
                    }
                }

            },
            account: function() {
                this.account_list = [];
                for (var i = 0; i < this.account.length; i++) {

                    for (var j = 0; j < this.account[i].permissions.length; j++) {
                        if (this.account[i].permissions[j].enable) {
                            this.account_list.push(this.account[i].permissions[j].id)
                        }

                    }

                }
            },
            checkAll_currencyExchange: function() {
                this.currencyExchange_list = [];
                this.currencyExchange = [];
                if (this.checkAll_currencyExchange) {
                    for (var i = 0; i < this.currencyExchange_per.length; i++) {
                        this.currencyExchange.push(this.currencyExchange_per[i]);
                    }
                }

            },
            currencyExchange: function() {
                this.currencyExchange_list = [];
                for (var i = 0; i < this.currencyExchange.length; i++) {

                    for (var j = 0; j < this.currencyExchange[i].permissions.length; j++) {
                        if (this.currencyExchange[i].permissions[j].enable) {
                            this.currencyExchange_list.push(this.currencyExchange[i].permissions[j].id)
                        }

                    }

                }
            },
            checkAll_sale: function() {
                this.sale_list = [];
                this.sale = [];
                if (this.checkAll_sale) {
                    for (var i = 0; i < this.sale_per.length; i++) {
                        this.sale.push(this.sale_per[i]);
                    }
                }

            },
            sale: function() {
                this.sale_list = [];
                for (var i = 0; i < this.sale.length; i++) {

                    for (var j = 0; j < this.sale[i].permissions.length; j++) {
                        if (this.sale[i].permissions[j].enable) {
                            this.sale_list.push(this.sale[i].permissions[j].id)
                        }

                    }

                }
            },
            checkAll_build: function() {
                this.build_list = [];
                this.build = [];
                if (this.checkAll_build) {
                    for (var i = 0; i < this.build_per.length; i++) {
                        this.build.push(this.build_per[i]);
                    }
                }

            },
            build: function() {
                this.build_list = [];
                for (var i = 0; i < this.build.length; i++) {

                    for (var j = 0; j < this.build[i].permissions.length; j++) {
                        if (this.build[i].permissions[j].enable) {
                            this.build_list.push(this.build[i].permissions[j].id)
                        }

                    }

                }
            },
            checkAll_expense: function() {
                this.expense_list = [];
                this.expense = [];
                if (this.checkAll_expense) {
                    for (var i = 0; i < this.expense_per.length; i++) {
                        this.expense.push(this.expense_per[i]);
                    }
                }

            },
            expense: function() {
                this.expense_list = [];
                for (var i = 0; i < this.expense.length; i++) {

                    for (var j = 0; j < this.expense[i].permissions.length; j++) {
                        if (this.expense[i].permissions[j].enable) {
                            this.expense_list.push(this.expense[i].permissions[j].id)
                        }

                    }

                }
            },
            checkAll_purchase: function() {
                this.purchase_list = [];
                this.purchase = [];
                if (this.checkAll_purchase) {
                    for (var i = 0; i < this.purchase_per.length; i++) {
                        this.purchase.push(this.purchase_per[i]);
                    }
                }

            },
            purchase: function() {
                this.purchase_list = [];
                for (var i = 0; i < this.purchase.length; i++) {

                    for (var j = 0; j < this.purchase[i].permissions.length; j++) {
                        if (this.purchase[i].permissions[j].enable) {
                            this.purchase_list.push(this.purchase[i].permissions[j].id)
                        }

                    }

                }
            },
            checkAll_project: function() {
                this.project_list = [];
                this.project = [];
                if (this.checkAll_project) {
                    for (var i = 0; i < this.project_per.length; i++) {
                        this.project.push(this.project_per[i]);
                    }
                }

            },
            project: function() {
                this.project_list = [];
                for (var i = 0; i < this.project.length; i++) {

                    for (var j = 0; j < this.project[i].permissions.length; j++) {
                        if (this.project[i].permissions[j].enable) {
                            this.project_list.push(this.project[i].permissions[j].id)
                        }

                    }

                }
            },
            checkAll_NGOProject: function() {
                this.NGOProject_list = [];
                this.NGOProject = [];
                if (this.checkAll_NGOProject) {
                    for (var i = 0; i < this.NGOProject_per.length; i++) {
                        this.NGOProject.push(this.NGOProject_per[i]);
                    }
                }

            },
            NGOProject: function() {
                this.NGOProject_list = [];
                for (var i = 0; i < this.NGOProject.length; i++) {

                    for (var j = 0; j < this.NGOProject[i].permissions.length; j++) {
                        if (this.NGOProject[i].permissions[j].enable) {
                            this.NGOProject_list.push(this.NGOProject[i].permissions[j].id)
                        }

                    }

                }
            },
            checkAll_cargoContract: function() {
                this.cargoContract_list = [];
                this.cargoContract = [];
                if (this.checkAll_cargoContract) {
                    for (var i = 0; i < this.cargoContract_per.length; i++) {
                        this.cargoContract.push(this.cargoContract_per[i]);
                    }
                }

            },
            cargoContract: function() {
                this.cargoContract_list = [];
                for (var i = 0; i < this.cargoContract.length; i++) {

                    for (var j = 0; j < this.cargoContract[i].permissions.length; j++) {
                        if (this.cargoContract[i].permissions[j].enable) {
                            this.cargoContract_list.push(this.cargoContract[i].permissions[j].id)
                        }

                    }

                }
            }
            
        },
        methods: {
            isDisable(permission) {
                let p = [];
                permission.forEach((a) => {
                    if (a.enable)
                        p.push(true);
                });
                return (permission.length != p.length)
            },
            isDisableSelectAll() {
                let p = [];
                this.groups.forEach((group) => {
                    if (!this.isDisable(group.permissions))
                        p.push(true)
                })
                return (p.length != this.groups.length)
            },
            isDisableSelectSite() {
                let p = [];
                this.site_per.forEach((site) => {
                    if (!this.isDisable(site.permissions))
                        p.push(true)
                })
                return (p.length != this.site_per.length)
            },
            isDisableSelectGeneral() {
                let p = [];
                this.general_per.forEach((general) => {
                    if (!this.isDisable(general.permissions))
                        p.push(true)
                })
                return (p.length != this.general_per.length)
            },
            isDisableSelectMember() {
                let p = [];
                this.member_per.forEach((member) => {
                    if (!this.isDisable(member.permissions))
                        p.push(true)
                })
                return (p.length != this.member_per.length)
            },
            isDisableSelectEmployee() {
                let p = [];
                this.employee_per.forEach((employee) => {
                    if (!this.isDisable(employee.permissions))
                        p.push(true)
                })
                return (p.length != this.employee_per.length)
            },
            isDisableSelectAccount() {
                let p = [];
                this.account_per.forEach((account) => {
                    if (!this.isDisable(account.permissions))
                        p.push(true)
                })
                return (p.length != this.account_per.length)
            },
            isDisableSelectCurrencyExchange() {
                let p = [];
                this.currencyExchange_per.forEach((CurrencyExchange) => {
                    if (!this.isDisable(CurrencyExchange.permissions))
                        p.push(true)
                })
                return (p.length != this.currencyExchange_per.length)
            },
            isDisableSelect_sale() {
                let p = [];
                this.sale_per.forEach((sale) => {
                    if (!this.isDisable(sale.permissions))
                        p.push(true)
                })
                return (p.length != this.sale_per.length)
            },
            isDisableSelect_build() {
                let p = [];
                this.build_per.forEach((build) => {
                    if (!this.isDisable(build.permissions))
                        p.push(true)
                })
                return (p.length != this.build_per.length)
            },
            isDisableSelect_expense() {
                let p = [];
                this.expense_per.forEach((expense) => {
                    if (!this.isDisable(expense.permissions))
                        p.push(true)
                })
                return (p.length != this.expense_per.length)
            },
            isDisableSelect_purchase() {
                let p = [];
                this.purchase_per.forEach((purchase) => {
                    if (!this.isDisable(purchase.permissions))
                        p.push(true)
                })
                return (p.length != this.purchase_per.length)
            },
            isDisableSelect_project() {
                let p = [];
                this.project_per.forEach((project) => {
                    if (!this.isDisable(project.permissions))
                        p.push(true)
                })
                return (p.length != this.project_per.length)
            },
            isDisableSelect_NGOProject() {
                let p = [];
                this.NGOProject_per.forEach((NGOProject) => {
                    if (!this.isDisable(NGOProject.permissions))
                        p.push(true)
                })
                return (p.length != this.NGOProject_per.length)
            },
            isDisableSelect_cargoContract() {
                let p = [];
                this.cargoContract_per.forEach((cargoContract) => {
                    if (!this.isDisable(cargoContract.permissions))
                        p.push(true)
                })
                return (p.length != this.cargoContract_per.length)
            }
        }
    })
</script>
@endpush