@extends('layouts.app')
@section('content')
@include('member_classes.modal')
<!-- END PAGE HEADER-->
<!-- BEGIN TAB PORTLET--> 
<div class="row"> 
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.RiskStepList') </span>
            </div>
             <div class="btn-group pull-right">
                   <!--  <a href="{{route('riskStep.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button></a>  -->
                    <div id="riskStep" v-cloak> 
                         <button class="btn btn-success" id="show-modal" @click="showModal =true">@lang('layout.AddNew')</button>
                         <modal v-if="showModal" @close="showModal = false">
                            <div slot="header">
                                <div class="col-md-12 col-sm-12 col-xs-12">
                                    <h3>
                                        @lang('layout.RiskStepCreate')
                                    </h3>
                                </div>
                                <div class="col-md-4">
                                    <div v-if="fieldErrors.length > 0">
                                        <p class="text-danger" fieldErrors>
                                            <spna v-text="fieldErrors"></spna>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div slot="body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Category')</label>
                                            <select class="form-control" name="category" v-model="category" >
                                                <option value="CustomerTypes">@lang('type.CustomerTypes')</option>
                                                <option value="ProductsAndServices">@lang('type.ProductsAndServices')</option>
                                                <option value="DistributionChannels">@lang('type.DistributionChannels')</option>
                                                <option value="GeographicalLocations">@lang('type.GeographicalLocations')</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Name") <span class="required"> * </span></label>
                                            <input type="text" class="form-control" name="name" v-model="riskName">
                                        </div>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.RiskPercentage") <span class="required"> * </span></label>
                                            <input type="number" class="form-control" name="percentage" v-model="percentage">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Description") <span class="required"> * </span></label>
                                            <textarea class="form-control" name="description" v-model="description">
                                                
                                            </textarea>
                                        </div>

                                    </div>
                                    
                                </div>
                            </div>


                            <div slot="footer">
                                <button type=button class="btn btn-success" @click="addClass" >
                                    @lang('layout.OK')
                                </button>
                                <button type=button class="btn btn-danger"
                                       @click="showModal =false" >
                                    @lang('layout.Cancel')
                                </button>
                            </div>
                        </modal>
                        
                    </div>

            </div>
        </div>
        <div class="portlet-body">

            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>

            <table class="table table-striped table-bordered table-hover" cellspacing="1" id="riskStepes" width="100%">
                <thead>
                <tr> 
                   {{-- <th># </th>--}}
                    <th>@lang('layout.Category')</th>
                    <th>@lang('layout.Name')</th>
                    <th>@lang('layout.RiskPercentage') %</th>
                    <th>@lang('layout.Description') </th>
                    <th>@lang('layout.CreatedAt') </th>
                    <th>@lang('layout.Action') </th>
                </tr>
                </thead> 
            </table>
        </div>
    </div>
</div> 
@stop
@include('groupCompanyFilter.select')
@push('scripts')
<script>
    let data_table;
     $(document).ready(function() { 
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        data_table = $('#riskStepes').DataTable( {
            ajax:'{{route("riskStep.index")}}',
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging:         true,
            columns: [
            /*{ data: 'id', name: 'id' },*/
            { data: 'category', name: 'risk_steps.category' },
            { data: 'name', name: 'risk_steps.name' },
            { data: 'percentage', name: 'risk_steps.percentage' },
            { data: 'description', name: 'risk_steps.description' },
            { data: 'created_at', name: 'risk_steps.created_at' },
            { data: 'action', name: 'action', orderable:false, searchable:false},
            ] 
    }); 
    });
        Vue.component('modal',{
            template: '#modal-template'
        });

     let vu = new Vue({
        el: '#riskStep',
        data:{
            showModal:false,
            fieldErrors:[],
            category: 'CustomerTypes',
            riskName: null,
            percentage: null,
            description: null,
        },
        methods:{
            addClass(){
             
                axios.post("{{route('riskStep.store')}}",{
                    category:this.category,
                    name:this.riskName,
                    percentage:this.percentage,
                    description:this.description
                })
                .then(function(response){
                    vu.showModal = false;
                    vu.category = 'CustomerTypes';
                    vu.riskName = null;
                    vu.percentage = null;
                    vu.description = null;
                    $('#riskStepes').DataTable().ajax.reload();
                })
            }
        }
     });

     new Vue({
         el: '#company_ll',
         methods: {
             setCompany: function (event) {
                 if (typeof data_table == 'object'){
                     data_table.clear();
                     data_table.ajax.reload();
                 }
             }
         }
     });


</script>

@endpush
