@extends('layouts.app')

@section('style')
    <style type="text/css">
        /* Cubic Bezier Transition */
        /***
        Pricing Table 1
        ***/
        .pricing-content-1 {
            background-color: #fff;
        }

        .pricing-content-1:before, .pricing-content-1:after {
            content: " ";
            display: table;
        }

        .pricing-content-1:after {
            clear: both;
        }

        .pricing-content-1 .arrow-down {
            width: 0;
            height: 0;
            border-left: 15px solid transparent;
            border-right: 15px solid transparent;
            border-top: 15px solid;
            margin: auto;
        }

        .pricing-content-1 .arrow-down.arrow-blue {
            border-top-color: #3598DC;
        }

        .pricing-content-1 .arrow-down.arrow-green {
            border-top-color: #32C5D2;
        }

        .pricing-content-1 .arrow-down.arrow-dark {
            border-top-color: #2F353B;
        }

        .pricing-content-1 .arrow-down.arrow-grey {
            border-top-color: #f7f9fb;
        }

        .pricing-content-1 .price-ribbon {
            position: absolute;
            top: 75px;
            right: -4px;
            width: 90px;
            font-size: 14px;
            text-transform: uppercase;
            font-weight: 300;
            padding: 6px 20px 6px 15px;
            color: #fff;
            background-color: #D91E18;
            text-shadow: 0px 1px 2px #bbb;
            -webkit-box-shadow: 0px 2px 4px #888;
            -moz-box-shadow: 0px 2px 4px #888;
            box-shadow: 0px 2px 4px #888;
        }

        .pricing-content-1 .price-ribbon:after {
            content: ' ';
            position: absolute;
            width: 0;
            height: 0;
            right: 0px;
            top: 100%;
            border-width: 5px 10px;
            border-style: solid;
            border-color: #64120f transparent transparent #64120f;
        }

        .pricing-content-1 .pricing-title {
            border-bottom: 1px solid;
            border-color: #fff;
        }

        .pricing-content-1 .pricing-title > h1 {
            margin: 20px 0;
        }

        .pricing-content-1 .price-column-container {
            text-align: center;
            margin: 0;
            background-color: #fff;
        }

        .pricing-content-1 .price-column-container.border-active {
            border: 1px solid #e5e9ee;
        }

        .pricing-content-1 .price-column-container:first-child {
            margin-left: 0;
        }

        .pricing-content-1 .price-column-container:last-child {
            margin-right: 0;
        }

        .pricing-content-1 .price-table-head {
            color: #fff;
            padding: 20px 0;
        }

        .pricing-content-1 .price-table-head h2 {
            font-size: 26px;
        }

        .pricing-content-1 .price-table-head.price-1 {
            background-color: #3598DC;
        }

        .pricing-content-1 .price-table-head.price-2 {
            background-color: #32C5D2;
        }

        .pricing-content-1 .price-table-head.price-3 {
            background-color: #2F353B;
        }

        .pricing-content-1 .price-table-pricing > h3 {
            font-size: 60px;
            position: relative;
        }

        .pricing-content-1 .price-table-pricing > h3 > .price-sign {
            font-size: 24px;
            position: absolute;
            margin-left: -15px;
        }

        .pricing-content-1 .price-table-pricing > p {
            margin-top: 0;
        }

        .pricing-content-1 .price-table-content {
            background-color: #f7f9fb;
            color: #5c6d7e;
            font-weight: 600;
            font-size: 16px;
        }

        .pricing-content-1 .price-table-content .row {
            padding-top: 10px;
            padding-bottom: 10px;
        }

        .pricing-content-1 .price-table-content .row i {
            color: #6cade6;
        }

        .pricing-content-1 .price-table-content .row:first-child {
            padding-top: 20px;
        }

        .pricing-content-1 .price-table-content .row:last-child {
            padding-bottom: 20px;
        }

        .pricing-content-1 .price-table-footer {
            padding: 20px 0;
        }

        .pricing-content-1 .price-table-footer > .price-button {
            font-weight: bold;
            padding: 10px 20px;
        }

        @media (max-width: 1024px) {
            .pricing-content-1 .mobile-padding {
                padding: 0;
                margin: 0;
            }

            .pricing-content-1 .mobile-padding > i {
                margin-right: 5px;
            }

            .pricing-content-1 .price-table-content {
                padding-left: 10px;
                padding-right: 10px;
            }
        }

        @media (max-width: 1024px) {
            .pricing-content-1 .mobile-padding {
                padding: 0 15px;
                margin: 0 -15px;
            }

            .pricing-content-1 .mobile-padding > i {
                margin-right: 20px;
            }

            .pricing-content-1 .price-table-content {
                padding-left: 15px;
                padding-right: 15px;
            }
        }

        /***
        Pricing Table 2
        ***/
        .pricing-content-2 {
            background-color: #fff;
        }

        .pricing-content-2 .no-padding {
            padding: 0;
        }

        .pricing-content-2 .text-left {
            text-align: left;
        }

        .pricing-content-2 .text-right {
            text-align: right;
        }

        .pricing-content-2.pricing-bg-dark {
            background-color: #2F353B;
        }

        .pricing-content-2 .pricing-title {
            border-color: #444;
        }

        .pricing-content-2 .pricing-title > h1 {
            color: #fff;
        }

        .pricing-content-2 .pricing-table-container {
            padding-top: 40px;
            padding-bottom: 40px;
        }

        .pricing-content-2 .pricing-table-container .padding-fix {
            padding-left: 15px;
            padding-right: 15px;
        }

        .pricing-content-2 .pricing-table-container .price-column-container {
            background-color: #fff;
            margin: 30px 0;
            padding: 60px 0;
            text-align: center;
            border-bottom: 4px solid #ccc;
        }

        .pricing-content-2 .pricing-table-container .price-column-container.border-right {
            border-right: 1px solid #ccc;
        }

        .pricing-content-2 .pricing-table-container .price-column-container.border-left {
            border-left: 1px solid #ccc;
        }

        .pricing-content-2 .pricing-table-container .price-column-container.border-top {
            border-top: 1px solid #ccc;
        }

        .pricing-content-2 .pricing-table-container .price-column-container.featured-price {
            margin: 0;
            padding: 89px 0;
            border: 1px solid;
            border-bottom: 4px solid;
            border-color: #ccc;
        }

        .pricing-content-2 .pricing-table-container .price-column-container.featured-price > .price-feature-label {
            position: absolute;
            top: 0;
            left: 50%;
            display: inline-block;
            width: 110px;
            margin: 0 0 0 -60px;
            padding: 7px 15px;
            color: #fff;
            font-weight: 300;
        }

        .pricing-content-2 .pricing-table-container .price-column-container > .price-table-head > h2 {
            letter-spacing: 1px;
            font-weight: 600;
            font-size: 18px;
            color: #ACB5C3;
        }

        .pricing-content-2 .pricing-table-container .price-column-container > .price-table-head > h2.opt-pricing-5 {
            padding: 7px 15px;
            display: inline;
            margin: 0 auto 20px auto;
            font-size: 16px;
        }

        .pricing-content-2 .pricing-table-container .price-column-container > .price-table-pricing > h3 {
            font-size: 60px;
            position: relative;
            font-weight: 600;
        }

        .pricing-content-2 .pricing-table-container .price-column-container > .price-table-pricing > h3 > .price-sign {
            font-size: 24px;
            position: absolute;
            margin-left: -15px;
        }

        .pricing-content-2 .pricing-table-container .price-column-container > .price-table-pricing > p {
            margin-top: 0;
        }

        .pricing-content-2 .pricing-table-container .price-column-container > .price-table-content {
            color: #333;
            font-weight: 300;
            font-size: 16px;
        }

        .pricing-content-2 .pricing-table-container .price-column-container > .price-table-content .row {
            padding-top: 20px;
            padding-bottom: 20px;
            border-bottom: 1px solid;
            border-color: #eee;
        }

        .pricing-content-2 .pricing-table-container .price-column-container > .price-table-content .row:first-child {
            border-top: 1px solid;
            border-color: #eee;
        }

        .pricing-content-2 .pricing-table-container .price-column-container > .price-table-footer {
            padding: 40px 0 0 0;
        }

        .pricing-content-2 .pricing-table-container .price-column-container > .price-table-footer > .featured-price {
            font-size: 20px;
            font-weight: 300;
            border-bottom: 3px solid #3FABA4;
        }

        @media (max-width: 991px) {
            .pricing-content-2 .price-column-container {
                border-left: 1px solid;
                border-right: 1px solid;
                border-color: #ccc;
            }
        }

    </style>
@stop
@section('content')

    @include('receives.modal')
    <!-- BEGIN CONTENT -->
    <div id="print-modal">

        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="'member_transfer_details'"
                      @closed="closeModal">

            <div slot="body">
                <div class="row">
                    <div class="form-group">

                    </div>
                </div>

                  <div class="row">
                    <div class="form-group">
                       <input type="hidden" name="id" value="{{$memberTransfer->id}}"/>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>


    <div class="row">
        @if (count($errors) > 0)
            <div class="m-heading-1 border-red m-bordered errors-action">

                <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
                <ul class="error-body">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>

            </div>
        @endif
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.TransferInformation')</span>

                </div>
             
            </div>
            <div class="portlet-body form" id="item-service" style="margin-bottom:50%;">
                <div class="caption" align="center">

                    <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.MemberTransfer')</span>
                </div>
                <br><br>
                   <div class="pull-right">
                        <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                     </span>
        
                </div>



                <div class="portlet light portlet-fit bordered">
                    <div class="portlet-body">
                        <div class="pricing-content-1">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="price-column-container border-active">
                                        <div class="price-table-head bg-blue">
                                            <h2 class="no-margin">@lang('layout.FromMember')</span></h2>
                                        </div>
                                        <div class="arrow-down border-top-blue"></div>
                                        <div class="price-table-pricing">
                                            <h4>
                                                <span>{{$memberTransfer->from_member_name}}</span></h4>
                                        </div>
                                        <div class="price-table-content">


                                            <div class="row mobile-padding">
                                                <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                    <i><b> @lang('layout.Currency'):</b><br></i>
                                                </div>
                                                <div class="col-md-8 col-xs-9 text-left mobile-padding">

                                                    <p>{{$memberTransfer->currency}}</p>


                                                </div>
                                                <div class="row mobile-padding">
                                                    <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                        <i><b> @lang('layout.Receivable'):</b><br></i>
                                                    </div>
                                                    <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                        <p>{{myRound($memberTransfer->receivable)}}</p></div>
                                                </div>
                                                <div class="row mobile-padding">
                                                    <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                        <i><b> @lang('layout.Rate'):</b><br></i>
                                                    </div>
                                                    <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                        <p>{{myRound($memberTransfer->rate)}}</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row mobile-padding">
                                                <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                    <i><b> @lang('layout.Payable'):</b><br></i>
                                                </div>
                                                <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                    <p>{{myRound($memberTransfer->payable)}}</p></div>
                                            </div>
                                            <div class="row mobile-padding">
                                                <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                    <i><b> @lang('layout.Date'):</b><br></i>
                                                </div>
                                                <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                    <p>{{convertDate($memberTransfer->date)}}</p></div>
                                            </div>
                                            <div class="row mobile-padding">
                                                <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                    <i><b> @lang('layout.Description'):</b><br></i>
                                                </div>
                                                <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                    <p>{{$memberTransfer->description}}</p></div>
                                            </div>

                                        </div>
                                        <div class="arrow-down arrow-grey"></div>

                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="price-column-container border-active">
                                        <div class="price-table-head bg-blue">
                                            <h2 class="no-margin">@lang('layout.ToMember')</span></h2>
                                        </div>
                                        <div class="arrow-down border-top-blue"></div>
                                        <div class="price-table-pricing">
                                            <h4>
                                                <span>{{$memberTransfer->to_member_name}}</span></h4>
                                        </div>
                                        <div class="price-table-content">


                                            <div class="row mobile-padding">
                                                <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                    <i><b> @lang('layout.Currency'):</b><br></i>
                                                </div>
                                                <div class="col-md-8 col-xs-9 text-left mobile-padding">

                                                    <p>{{$memberTransfer->currency2}}</p>


                                                </div>
                                                <div class="row mobile-padding">
                                                    <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                        <i><b> @lang('layout.Receivable'):</b><br></i>
                                                    </div>
                                                    <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                        <p>{{myRound($memberTransfer->receivable2)}}</p></div>
                                                </div>
                                                <div class="row mobile-padding">
                                                    <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                        <i><b> @lang('layout.Rate'):</b><br></i>
                                                    </div>
                                                    <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                        <p>{{myRound($memberTransfer->rate2)}}</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row mobile-padding">
                                                <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                    <i><b> @lang('layout.Payable'):</b><br></i>
                                                </div>
                                                <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                    <p>{{myRound($memberTransfer->payable2)}}</p></div>
                                            </div>
                                            <div class="row mobile-padding">
                                                <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                    <i><b> @lang('layout.Date'):</b><br></i>
                                                </div>
                                                <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                    <p>{{convertDate($memberTransfer->date)}}</p></div>
                                            </div>
                                            <div class="row mobile-padding">
                                                <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                    <i><b> @lang('layout.Description'):</b><br></i>
                                                </div>
                                                <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                    <p>{{$memberTransfer->description2}}</p></div>
                                            </div>

                                        </div>
                                        <div class="arrow-down arrow-grey"></div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
@include('print.modal')

@push('scripts')

    <script>



        $('#excell_all').on('click', function (e) {
            $('#show-modal2').click();
            e.preventDefault();
        })

        var vm = new Vue({

            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAny') !!}',
                excelRoute: '{!! route('export.exportCsv') !!}'
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });

    </script>
@endpush
