@extends('layouts.app')

@section('content')

<!-- END PAGE HEADER-->
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'riskManagementList'" @closed="closeModal">
        <div slot="body">
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop">

                    <ul class="nav nav-tabs">

                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['customreport-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.Type') </label>
                                                    <select name="re_type" class="form-control">
                                                        <option value="baseCurrency">@lang('layout.BaseCurrency')</option>
                                                        <option value="perCurrency">@lang('layout.PerCurrency')</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.Currency') </label>
                                                    <select name="currency" id="" class="form-control">
                                                        <option value="">@lang('layout.Select')</option>
                                                        @foreach($currency as $curr)
                                                        <option value="{{$curr['code']}}">{{$curr['code']}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="control-label">@lang('layout.Member')</label>
                                                    <v-select v-model="selectedMember" label="name" @search="MemberSearch" :options="member">
                                                    </v-select>
                                                    <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="control-label">@lang('layout.MemberClass')</label>
                                                    <select name="member_class_id" id="" class="form-control">
                                                        <option value="">@lang('layout.Select')</option>
                                                        @foreach($memberClass as $mc)
                                                        <option value="{{$mc->id}}">{{$mc->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="col-md-12">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                    <div class="input-group">
                                                        <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                        <input class="form-control date" id="range-to-example" name="to_date">

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="risk_management_index">
                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                        <tr>
                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td style="text-align: center;">
                                                                <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" :checked="row.checkedColumn">
                                                                    <span class="slider round"></span>
                                                                </label>
                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    <option value="2">2 %</option>
                                                                    <option value="6">6 %</option>
                                                                    <option value="10">10 %</option>
                                                                    <option value="15">15 %</option>
                                                                    <option value="20">20 %</option>
                                                                    <option value="25">25 %</option>
                                                                    <option value="30">30 %</option>
                                                                    <option value="40">40 %</option>
                                                                    <option value="50">50 %</option>
                                                                    <option value="60">60 %</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10">
                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
        </div>
    </report-modal>
</div>

<!-- BEGIN TAB PORTLET-->

<div class="row">

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.RiskManagementList') &nbsp; &nbsp; &nbsp; </span>
            </div>
            <div class="tools"></div>
            <div class=" pull-right">
                @permission('RiskManagement-export')
                <span id="anchore-modal">
                    &nbsp;
                    <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                    </a> &nbsp;
                </span>
                @endpermission

                <!-- <a href="{{route('riskManagement.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a> -->

            </div>
            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>
        </div>
        <div class="portlet-body">
            <ul class="nav nav-tabs mytabs" id="mytabs">
                <li class="active">
                    <a href="#tab" data-toggle="tab" id="default">@lang('layout.BaseCurrency')</a>
                </li>
                <li class="">
                    <a href="#tab1" onclick="getCurrencyRecord()" data-toggle="tab" id="default1">@lang('layout.PerCurrency')</a>
                </li>
                @permission('RiskManagement-create')
                <li class="">
                    <a href="#tab2" data-toggle="tab" id="default1">@lang('layout.AddNew')</a>
                </li>
                @endpermission
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="tab">

                    <div class="page-toolbar">
                        <div class="pull-right">
                        </div>
                    </div>

                    <table class="table table-striped table-bordered table-hover" cellspacing="0" id="transferAccounts">
                        <thead>
                            <tr>
                                <th>@lang('layout.Code')</th>
                                <th>@lang('layout.Member')</th>
                                <th>@lang('layout.Phone')</th>
                                <th>@lang('layout.FatherName')</th>
                                <th>@lang('layout.SSID') </th>
                                <th>@lang('layout.Type')</th>
                                <th>@lang('layout.Amount')</th>
                                <th>@lang('layout.Currency')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
                <div class="tab-pane" id="tab1">
                    <table class="table table-striped table-bordered table-hover" cellspacing="0" id="transferAccounts1">
                        <thead>
                            <tr>
                                <th>@lang('layout.Code')</th>
                                <th>@lang('layout.Member')</th>
                                <th>@lang('layout.Phone')</th>
                                <th>@lang('layout.FatherName')</th>
                                <th>@lang('layout.SSID') </th>
                                <th>@lang('layout.Type')</th>
                                <th>@lang('layout.Amount')</th>
                                <th>@lang('layout.Currency')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
                <div class="tab-pane" id="tab2">
                    <div id="curr_id">
                        {!! Form::open(array('route' => 'riskManagement.store','method'=>'POST','class'=>'form-horizontal','id'=>'currency-form')) !!}
                        {{ csrf_field() }}
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                                <th style="min-width: 150px">@lang('layout.ID')</th>
                                <th style="min-width: 150px">@lang('layout.Currency')</th>
                                <th style="min-width: 150px">@lang('layout.Rate')</th>
                                <th style="min-width: 500px">@lang('layout.Amount')</th>
                            </thead>
                            <tbody>
                                <tr v-for="curr in currency">
                                    <td class="hilight">
                                        <div class="input-group">
                                            <span>@{{curr.id}}</span>

                                        </div>
                                    </td>
                                    <td class="hilight">
                                        <div class="input-group">
                                            <label>@{{curr.code}}</label>
                                            <input type="hidden" name="currency_code[]" :value="(!curr)?null:curr.code">
                                        </div>
                                    </td>
                                    <td class="hilight">
                                        <div class="input-group">
                                            <label>@{{curr.exchange_rate}}</label>
                                            <input type="hidden" name="currency_rate[]" :value="(!curr)?null:curr.exchange_rate">
                                        </div>
                                    </td>
                                    <td class="hilight">
                                        <div class="input-group">
                                            <input class="form-control" type="number" @input="setvalue()" name="level[]" v-model="(!curr)?null:curr.level">
                                            <input class="form-control" type="hidden" name="type[]" value="simple">
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="hilight">
                                        <div class="input-group">
                                            <span>@lang('layout.BaseCurrency')</span>
                                        </div>
                                    </td>
                                    <td class="hilight">
                                        <div class="input-group">
                                            <label>@{{base_currency.code}}</label>
                                            <input type="hidden" name="currency_code[]" :value="(!base_currency)?null:base_currency.code">
                                        </div>
                                    </td>
                                    <td class="hilight">
                                        <div class="input-group">
                                            <label>@{{base_currency.exchange_rate}}</label>
                                            <input type="hidden" name="currency_rate[]" :value="(!base_currency)?null:base_currency.exchange_rate">
                                        </div>
                                    </td>
                                    <td class="hilight">
                                        <div class="input-group">
                                            <input class="form-control" type="number" name="level[]" v-model="base_level">
                                            <input class="form-control" type="hidden" name="type[]" value="base">
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                            <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>

<!-- END TAB PORTLET-->
<!-- END CONTENT BODY -->

@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')

<script>
    function getAllRecord() {
        let data_table;
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        data_table = $('#transferAccounts').DataTable({
            ajax: '{{route("riskManagement.index")}}',
            pageLength: '100',
            scrollCollapse: true,
            order: [
                ["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]
            ],
            responsive: '{{responsiveDataTable()}}',
            pagingType: '{{paginationType()}}',
            serverSide: true,
            paging: true,
            buttons: [{
                extend: 'excel',
                text: '',
                key: {
                    key: 'x',
                    altkey: true
                }
            }],
            columns: [{
                    data: 'code',
                    name: 'code'
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'phone',
                    name: 'phone'
                },
                {
                    data: 'father_name',
                    name: 'father_name'
                },
                {
                    data: 'ss_id',
                    name: 'ss_id'
                },
                {
                    data: 'type',
                    name: 'type'
                },
                {
                    data: 'amountValue',
                    name: 'amountValue'
                },
                {
                    data: 'currency',
                    name: 'currency'
                },
            ]
        });
    }

    $(document).ready(function() {
        getAllRecord();
    });

    function getCurrencyRecord() {
        let data_table;
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        data_table = $('#transferAccounts1').DataTable({
            ajax: {
                url: '{{route("riskManagement.index")}}',
                data: {
                    type: 'currency',
                }
            },
            pageLength: '100',
            scrollCollapse: true,
            order: [
                ["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]
            ],
            responsive: '{{responsiveDataTable()}}',
            pagingType: '{{paginationType()}}',
            serverSide: true,
            paging: true,
            destroy: true,
            buttons: [{
                extend: 'excel',
                text: '',
                key: {
                    key: 'x',
                    altkey: true
                }
            }],
            columns: [{
                    data: 'code',
                    name: 'code'
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'phone',
                    name: 'phone'
                },
                {
                    data: 'father_name',
                    name: 'father_name'
                },
                {
                    data: 'ss_id',
                    name: 'ss_id'
                },
                {
                    data: 'type',
                    name: 'type'
                },
                {
                    data: 'amountValue',
                    name: 'amountValue'
                },
                {
                    data: 'currency',
                    name: 'currency'
                },
            ]
        });
    }

    Vue.component('v-select', VueSelect.VueSelect)

    var cust_rep = {!!customeReportNewData('risk_management_index') !!};
    var vm = new Vue({
        el: '#print-modal',
        data: {
            member: [],
            selectedMember: null,
            is_show: false,
            pdfRoute: '{!!route("riskManagement.report") !!}',
            excelRoute: '{!! route("riskManagement.report") !!}',
            customReportData: [
                {
                    Name: '@lang("layout.Code")',
                    column_name: 'code',
                    checkedColumn: (cust_rep.code) ? 'checked' : '',
                    column_percentage:(cust_rep.code___percent)?cust_rep.code___percent:''
                },
                {
                    Name: '@lang("layout.Type")',
                    column_name: 'type',
                    checkedColumn: (cust_rep.type) ? 'checked' : '',
                    column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''
                },
                {
                    Name: '@lang("layout.Phone")',
                    column_name: 'phone',
                    checkedColumn: (cust_rep.phone) ? 'checked' : '',
                    column_percentage:(cust_rep.phone___percent)?cust_rep.phone___percent:''
                },
                {
                    Name: '@lang("layout.Phone")2',
                    column_name: 'phone2',
                    checkedColumn: (cust_rep.phone2) ? 'checked' : '',
                    column_percentage:(cust_rep.phone2___percent)?cust_rep.phone2___percent:''
                },
                {
                    Name: '@lang("layout.Member")',
                    column_name: 'member',
                    checkedColumn: (cust_rep.member) ? 'checked' : '',
                    column_percentage:(cust_rep.member___percent)?cust_rep.member___percent:''
                },
                {
                    Name: '@lang("layout.Amount")',
                    column_name: 'amount',
                    checkedColumn: (cust_rep.amount) ? 'checked' : '',
                    column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''
                },
                {
                    Name: '@lang("layout.FatherName")',
                    column_name: 'fatherName',
                    checkedColumn: (cust_rep.fatherName) ? 'checked' : '',
                    column_percentage:(cust_rep.fatherName___percent)?cust_rep.fatherName___percent:''
                },
                {
                    Name: '@lang("layout.SSID")',
                    column_name: 'SSID',
                    checkedColumn: (cust_rep.SSID) ? 'checked' : '',
                    column_percentage:(cust_rep.SSID___percent)?cust_rep.SSID___percent:''
                },
                {
                    Name: '@lang("layout.MemberClass")',
                    column_name: 'memberClass',
                    checkedColumn: (cust_rep.memberClass) ? 'checked' : '',
                    column_percentage:(cust_rep.memberClass___percent)?cust_rep.memberClass___percent:''
                },
                {
                    Name: '@lang("layout.Currency")',
                    column_name: 'currency',
                    checkedColumn: (cust_rep.currency) ? 'checked' : '',
                    column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''
                },
            ],
            cust_rep: cust_rep
        },
        methods: {
            MemberSearch: _.debounce((search, loading) => {
                loading(true);

                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.member = [];
                            vm.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
            }, getDebounceTime()),

            closeModal: function() {
                this.is_show = !this.is_show
            },
        }
    });


    new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vm.$data.is_show = true;

            }
        }
    });

    new Vue({
        el: '#company_ll',
        methods: {
            setCompany: function(event) {
                if (typeof data_table == 'object') {
                    data_table.clear();
                    data_table.ajax.reload();
                }
            }
        }
    });  

    var currency={!! json_encode($currency) !!};

    new Vue({
        el: '#curr_id',
        data: {
            currency: currency,
            base_currency: defaultCurrency(),
            base_level: {{ $base }}
        },
        methods: {
            setvalue: function() {
                var sum = 0;
                for (i = 0; i < this.currency.length; i++) {
                    // console.log(this.currency[i]);
                    if (this.currency[i].level) {
                    @if(systemConfig()[30] == 1)
                        sum += (Number.parseFloat(this.currency[i].level) / Number.parseFloat(this.currency[i].static_rate) * Number.parseFloat(this.currency[i].exchange_rate));
                    @else
                        sum += (Number.parseFloat(this.currency[i].level) / Number.parseFloat(this.currency[i].exchange_rate));
                    @endif
                    }
                }
                this.base_level = myRound(sum);
            }

        }
    });
</script>
@endpush