@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>


    </style>
@stop
@section('content')
    <div class="">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.MemberTransfer') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">

                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="member-transfer">
                <!-- BEGIN FORM-->

                {!! Form::model($memberTransfer,array('route' => ['memberTransfer.update',$memberTransfer->id],'method'=>'patch','class'=>'form-horizontal','id'=>'member-transfer-form')) !!}
                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-md-8 col-lg-8">
                            <div class="">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.FromMember')</label>
                                        <v-select @input="getSummary" v-model="selectedFromMember" label="name"
                                                  :options="fromMember">
                                        </v-select>

                                        <input type="hidden" name="from_member_id"
                                               v-model.number="(!selectedFromMember)?null:selectedFromMember.id"
                                               v-validate="'required'" data-vv-as="@lang('layout.FromMember')">
                                        <span class="required">@{{errors.first('from_member_id')}}</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.ToMember')</label>
                                        <v-select v-model="selectedToMember" label="name" @input="setAmount1(), getSummary2()"
                                                  :options="toMember">
                                        </v-select>

                                        <input type="hidden" name="to_member_id"
                                               v-model.number="(!selectedToMember)?null:selectedToMember.id"
                                               v-validate="'required'" data-vv-as="@lang('layout.ToMember')">
                                        <span class="required">@{{errors.first('to_member_id')}}</span>
                                    </div>
                                </div>

                                <div class="row">

                                    <div class="col-md-6">
										<div class="col-md-6">
											<label class="control-label">@lang('layout.Currency')</label>

											<v-select label="code" :options="currency" v-model="selected_currency"
													  @input="setAmount()"></v-select>
											<input type="hidden" name="currency" v-validate="'required'"
												   data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
											<span class="required">@{{ errors.first('currency') }}</span>
										</div>
										<div class="col-md-6">
											<label class="control-label">@lang('layout.Rate')</label>

											<input type="number" name="currency_rate" v-validate="'required'"
												   data-vv-as="@lang('layout.Rate')" @input="setAmount1()" 
												   v-model="!selected_currency?0:selected_currency.rate"
												   class="form-control">
											<span class="required">@{{ errors.first('currency_rate') }}</span>
										</div>
                                    </div>

									<div class="col-md-6">
										<div class="col-md-6">
                                             <label class="control-label">@lang('layout.ToCurrency2')</label>
                                            <v-select label="code" :options="currency" v-model="selected_currency2"
                                                      @input="setAmount1()"></v-select>
                                            <input type="hidden" name="currency2" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Currency')" :value="selected_currency2.code">
                                            <span class="required">@{{ errors.first('currency2') }}</span>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="control-label">@lang('layout.ToRate')</label>

                                            <input type="number" name="currency_rate2" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Rate')" @input="setAmount1()"
                                                   v-model="!selected_currency2?0:selected_currency2.rate"
                                                   class="form-control">
                                            <span class="required">@{{ errors.first('currency_rate2') }}</span>
                                        </div>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-6">
										<div class="col-md-7">
											<label class="control-label">@lang('layout.Payable')</label>

											<input type="number" :readonly="payable < receivable" v-validate=""
												   data-vv-as="@lang('layout.Payable')" class="form-control" name="payable"
												   @input="setAmount1()" v-model="payable" />
											<span class="required">@{{ errors.first('payable') }}</span>
										</div>
												   
										<div class="col-md-5">
											<label class="control-label">@lang('layout.Payable')</label>
											<input type="number" readonly v-validate=""
												   data-vv-as="@lang('layout.Payable')" class="form-control" name="payable2"
												   v-model="payable2" />
												   
											<span class="required">@{{ errors.first('payable2') }}</span>
										</div>
                                    </div>

                                    <div class="col-md-6">
										<div class="col-md-7">
											<label class="control-label">@lang('layout.Receivable')</label>
											<input type="number" :readonly="payable > receivable" class="form-control"
												   name="receivable" v-model="receivable" v-validate="" 
												   @input="setAmount1()" data-vv-as="@lang('layout.Receivable')">
                                            <span class="required">@{{ errors.first('receivable') }}</span>
										</div>
										<div class="col-md-5">
											<label class="control-label">@lang('layout.Receivable')</label>
											<input type="number" readonly class="form-control"
												   name="receivable2" v-model="receivable2" v-validate=""
												   data-vv-as="@lang('layout.Receivable')" />
                                            <span class="required">@{{ errors.first('receivable2') }}</span>
										</div>
									</div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Date')</label>

                                        <input type="text" class="form-control date" value="{{$memberTransfer->date}}"
                                               autocomplete="off" name="date">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Number')</label>
                                        <input type="number" class="form-control" name="number" v-validate="'required'" value="{{ $memberTransfer->number }}"
                                               data-vv-as="@lang('layout.Number')" />
										<span class="required">@{{ errors.first('number') }}</span>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Description') 1</label>
                                        <textarea name="description" rows="2" class="form-control">{{$memberTransfer->description}}</textarea>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Description') 2</label>
                                        <textarea name="description2" rows="2" class="form-control">{{$memberTransfer->description2}}</textarea>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="col-md-4 col-lg-4">
                            <div class="panel panel-default"
                                 style="background-color:rgb(204, 216, 228);position: relative;top: 24px;">
                                 <h3>@lang('layout.FromMember')</h3>
                                <div class="panel-body">
                                    <table class="table table-bordered">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.Currency') </th>
                                            <th>@lang('layout.Payable')</th>
                                            <th>@lang('layout.Receivable')</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                                 <span v-if="selectedFromMember">
                                                   <tr v-for="summ in summary">
                                                      <td class="highlight">
                                                         @{{ summ.currency }}
                                                      </td>
                                                      <td class="hidden-xs"> @{{ summ.payment }}</td>
                                                      <td>
                                                          @{{summ.invoice }}
                                                      </td>
                                                    </tr>
                                                </span>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="panel panel-default"
                                 style="background-color:rgb(204, 216, 228);position: relative;top: 24px;">
                                 <h3>@lang('layout.ToMember')</h3>
                                <div class="panel-body">
                                    <table class="table table-bordered">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.Currency') </th>
                                            <th>@lang('layout.Payable')</th>
                                            <th>@lang('layout.Receivable')</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                                 <span v-if="selectedToMember">
                                                   <tr v-for="summ in summary2">
                                                      <td class="highlight">
                                                         @{{ summ.currency }}
                                                      </td>
                                                      <td class="hidden-xs"> @{{ myRound(summ.payment) }}</td>
                                                      <td>
                                                          @{{myRound(summ.invoice) }}
                                                      </td>
                                                    </tr>
                                                </span>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>

                    <a href="{{route('inventorySite.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection

@push('scripts')

    <script>
        /**
         * for creating shortcuts
         */


        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);

        var member ={!! $member !!};
        var currency ={!! $currency !!};
        var selectedCurrency = {!! $selectedCurrency !!};
        var selectedCurrency2 = {!! $selectedCurrency2 !!};
        let vm = new Vue({
            el: '#member-transfer',
            data: {
                memberTransfer:{!! $memberTransfer !!},
                selectedCurrency: selectedCurrency,
                selectedCurrency2: selectedCurrency2,
                fromMember: member,
                toMember: member,
                selectedFromMember: null,
                selectedToMember: null,
                summary: [],
                summary2: [],
                currency: currency,
                selected_currency: defaultCurrency(),
				selected_currency2: defaultCurrency(),
                payable2: 0,
                receivable2: 0,
                payable: 0,
                receivable: 0,
                maxpayable: 0,
                maxreceivable: 0,
                payable_flag: false,
                receivable_flag: false,
                flag: false,
            },
            mounted: function () {
                if (this.memberTransfer) {
                    this.selectedFromMember = _.find(this.fromMember, (fm) => fm.id == this.memberTransfer.from_member_id);
                    this.selected_currency = this.selectedCurrency;
                    this.selected_currency2 = this.selectedCurrency2;

                    setTimeout(function () {
                        this.selectedToMember = _.find(this.toMember, (tm) => tm.id == this.memberTransfer.to_member_id);
                        this.payable = this.memberTransfer.payable;
                        this.receivable = this.memberTransfer.receivable;
						this.payable2 = this.memberTransfer.payable2;
                        this.receivable2 = this.memberTransfer.receivable2;
                        this.payable_flag = false;

                        this.receivable_flag = false;
                        if (this.payable > this.receivable) {
                            this.payable_flag = true;
                        }
                        else {
                            this.receivable_flag = true;
                        }
                    }.bind(this), 2000);


                }


            },
            methods: {

                setAmount() {

                    this.payable = 0;
                    this.receivable = 0;
                    this.payable2 = 0;
                    this.receivable2 = 0;
                    this.maxpayable = 0;
                    this.maxreceivable = 0;
                    if (this.selected_currency && this.selectedFromMember) {
						this.selected_currency2 = this.selected_currency;
                        this.payable_flag = false;

                        this.receivable_flag = false;

                        if (this.summary.length > 0) {
                            for (var i = 0; i < this.summary.length; i++) {
                                if (this.summary[i].currency == this.selected_currency.code) {


                                    this.payable = this.summary[i].payment;
                                    this.payable2 = this.summary[i].payment;
                                    this.receivable = this.summary[i].invoice;
                                    this.receivable2 = this.summary[i].invoice;
                                    if (this.payable > this.receivable) {
                                        this.payable_flag = true;
                                    }
                                    else {
                                        this.receivable_flag = true;
                                    }
                                    this.maxpayable = this.payable;
                                    this.maxreceivable = this.receivable;
                                }
                            }


                        }
                    }

                },
				setAmount1() {
                    var payable = 0;
                    var receivable = 0;
                    if (this.selected_currency2 && this.selectedToMember) {
						console.log(this.selected_currency2 , this.selectedToMember);
                    if (this.payable > this.receivable) {
						
						if (this.selected_currency2.rate > 0 && this.selected_currency.rate > 0) {
							payable = myRound((this.payable / this.selected_currency.rate) * this.selected_currency2.rate);
							this.payable2 = payable;
						}
                            
                    }
                    if (this.receivable > this.payable) {
						if (this.selected_currency2.rate > 0 && this.selected_currency.rate > 0) {
							receivable = myRound((this.receivable / this.selected_currency.rate) * this.selected_currency2.rate);
							this.receivable2 = receivable;
						}
                            
                    }
                    }

                },
                getSummary() {
                    if (this.selectedFromMember) {
                        this.selectedToMember = null;
                        this.getSummaryRecor(this.selectedFromMember.id, this);

                    }

                },
                getSummaryRecor(id, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberStatment',
                            member_id: id,
                        }
                    })
                        .then(function (response) {

                            if (response.data.length > 0) {

                                vm.summary = response.data;
                                if (vm.selected_currency != null) {
                                    vm.setAmount();
                                }
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                },
                getSummary2() {
                    if (this.selectedToMember) {
                        // this.fillToMember();
                        this.getSummaryRecor2(this.selectedToMember.id, this);

                    }

                },
                getSummaryRecor2(id, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberStatment',
                            member_id: id,
                        }
                    })
                        .then(function (response) {

                            if (response.data.length > 0) {

                                vm.summary2 = response.data;
                                // console.log(12222,response.data);
                                // if (vm.selected_currency != null) {
                                //     vm.setAmount();
                                // }
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                },
                handleSubmit(e) {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {
                                if (Number.parseFloat(this.payable) > 0 || Number.parseFloat(this.receivable) > 0) {
									regForm(e.target);
                                }
                                else {
                                    var message = "{{__('message.Warning')}}";
                                    toastr.warning('', message);
                                }
                            }
                        })
                },


            }
        })
    </script>
@endpush