@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReportNew('risk_management_index');
$_type = !in_array('type', $report);
$_code = !in_array('code', $report);
$_member = !in_array('member', $report);
$_phone = !in_array('phone', $report);
$_phone2 = !in_array('phone2', $report);
$_fatherName = !in_array('fatherName', $report);
$_SSID = !in_array('SSID', $report);
$_amount = !in_array('amount', $report);
$_memberClass = !in_array('memberClass', $report);
$_currency = !in_array('currency', $report);



$report_percent = customeReportNewPercent('risk_management_index');
    $_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
    $_code_percent= (array_key_exists('code___percent', $report_percent))?$report_percent['code___percent']:null;
    $_member_percent= (array_key_exists('member___percent', $report_percent))?$report_percent['member___percent']:null;
    $_phone_percent= (array_key_exists('phone___percent', $report_percent))?$report_percent['phone___percent']:null;
    $_phone2_percent= (array_key_exists('phone2___percent', $report_percent))?$report_percent['phone2___percent']:null;
    $_fatherName_percent= (array_key_exists('fatherName___percent', $report_percent))?$report_percent['fatherName___percent']:null;
    $_SSID_percent= (array_key_exists('SSID___percent', $report_percent))?$report_percent['SSID___percent']:null;
    $_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
    $_memberClass_percent= (array_key_exists('memberClass___percent', $report_percent))?$report_percent['memberClass___percent']:null;
    $_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
   

?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.RiskManagementReport')</h3>
<table class="main-table">
    <tr>
        @if($from_date)
        <td>
            <span>@lang('layout.FromDate')</span>:
            <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
        </td>
        @endif
        @if($to_date)
        <td>
            <span>@lang('layout.ToDate')</span>:
            <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
        </td>
        @endif
    </tr>
</table>
<br>
<table class="main-table">

    <thead>
        <tr class="bg">
            <th><div class="center"> @lang('layout.Record')</div></th>
            @if($_code)<th @if($_code_percent) width="{{$_code_percent}}%" @endif><div class="center">@lang('layout.Code')</div></th>@endif
            @if($_member)<th @if($_member_percent) width="{{$_member_percent}}%" @endif><div class="center">@lang('layout.Member')</div></th>@endif
            @if($_phone)<th @if($_phone_percent) width="{{$_phone_percent}}%" @endif><div class="center">@lang('layout.Phone')</div></th>@endif
            @if($_phone2)<th @if($_phone2_percent) width="{{$_phone2_percent}}%" @endif><div class="center">@lang('layout.Phone') 2</div></th>@endif
            @if($_fatherName)<th @if($_fatherName_percent) width="{{$_fatherName_percent}}%" @endif><div class="center">@lang('layout.FatherName')</div></th>@endif
            @if($_SSID)<th @if($_SSID_percent) width="{{$_SSID_percent}}%" @endif><div class="center">@lang('layout.SSID') </div></th>@endif
            @if($_memberClass)<th @if($_memberClass_percent) width="{{$_memberClass_percent}}%" @endif><div class="center">@lang('layout.MemberClass') </div></th>@endif
            @if($_type)<th @if($_type_percent) width="{{$_type_percent}}%" @endif><div class="center">@lang('layout.Type')</div></th>@endif
            @if($_amount)<th @if($_amount_percent) width="{{$_amount_percent}}%" @endif><div class="center">@lang('layout.Amount')</div></th>@endif
            @if($_currency)<th @if($_currency_percent) width="{{$_currency_percent}}%" @endif><div class="center">@lang('layout.Currency')</div></th>@endif
        </tr>
    </thead>
    <?php
    $count = 0;
    $total_home_currency = 0;
    $currencies = [];
    $comm_home_currency = 0;
    $comm_currencies = [];
    ?>
    @foreach($data1 AS $record)
    <tr>
        <?php
            $total_home_currency += $record['amountValue'];
            if (array_key_exists($record['currency'], $currencies)) {
                $currencies[$record['currency']] = $currencies[$record['currency']] + $record['amountValue'];
            } else {
                $currencies[$record['currency']] = $record['amountValue'];
            }
        ?>
        <td class="center">{{++$count}}</td>
        @if($_code)<td class="center">{{$record['code']}}</td>@endif
        @if($_member)<td class="center">{{$record['name']}}</td>@endif
        @if($_phone)
        <td class="center">{{$record['phone']}}</td>@endif
        @if($_phone2)
        <td class="center">{{$record['phone2']}}</td>@endif
        @if($_fatherName)
        <td class="center">{{$record['father_name']}}</td>@endif
        @if($_SSID)
        <td class="center">{{$record['ss_id']}}</td>@endif
        @if($_memberClass)
        <td class="center">{{$record['class']}}</td>@endif
        @if($_type)
        <td class="center">{{$record['type']}}</td>@endif
        @if($_amount)
        <td class="center">{{$record['amountValue']}}</td>@endif
        @if($_currency)
        <td class="center">{{$record['currency']}}</td>@endif

    </tr>
    @endforeach

</table>

<table class="main-table">
    <tr class="bg">
        <td colspan="4">
            <div class="center">@lang('layout.Total')</div>
        </td>
    </tr>

</table>
<table class="main-table">
    <tr class="bg">
        <td colspan="3">
            <div class="center">@lang('layout.PerCurrency')</div>
        </td>
    </tr>
    <tr>
        <td>
            <div class="center"> @lang('layout.Record')</div>
        </td>
        <td>
            <div class="center"> @lang('layout.Currency') </div>
        </td>
        <td>
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key => $currency) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{myRound($currency)}}</div>
            </td>

        </tr>
    <?php
    }
    ?>
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection