@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.RefundInfo')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th> 
                                <i class="fa  fa-bars"></i>@lang('layout.PurchaseNumber') 
                            </th> 
                            <th class="hidden-xs">
                                <i class="fa fa-user"></i>  @lang('layout.Vendor')
                            </th>
                            
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Date')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Amount')
                            </th>
                            <th>
                                <i class="fa  "></i>@lang('layout.Currency') 
                            </th>
                            <th>
                                <i class="fa  "></i> @lang('layout.Rate')
                            </th>
                        
                        
                            <th> 
                                <i class="fa "></i>@lang('layout.Discount') 
                            </th>
                        
                            <th>
                                <i class="fa fa-text-width"></i>@lang('layout.Description') 
                            </th>
                        </tr> 
                    </thead>
                    <tbody>
                        <tr>  
                            <td class="hidden-xs"> {{ $return->purchase_number}}  </td>
                            <td class="hidden-xs"> {{ $return->vendor }}  </td>
                            <td class="hidden-xs"> {{ convertDate($return->date) }}  </td>
                            <td class="hidden-xs"> {{ myRound($return->amount) }}  </td>
                            <td class="hidden-xs"> {{ $return->currency }}  </td>
                            <td class="hidden-xs"> {{ $return->rate }}  </td>
                            <td class="hidden-xs"> {{ $return->discount }}  </td>
                            <td class="hidden-xs"> {{ $return->description }}  </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
     <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.RefundDetails')</span>
                    </div>
                    <div class="tools"></div>
                    <div class="actions">
                        {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="return_Details"/>
                           <input type="hidden" name="id" value="{{$return->id}}"/> 
                           <input type="hidden" name="refund_type" value="{{$return->type}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 
                        {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="return_Details"/>
                           <input type="hidden" name="id" value="{{$return->id}}"/> 
                           <input type="hidden" name="refund_type" value="{{$return->type}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="sales">
                        <thead>
                            <tr>  
                                <th>@lang('layout.ItemName')</th>
                                <th>@lang('layout.Site')</th>
                                @if(getOtherMeasure()=="true")
                                <th>@lang('layout.OMeasureValue1')</th>
                                @endif
                                @if(getOtherMeasure2()=="true")
                                <th>@lang('layout.OMeasureValue2')</th>
                                @endif
                                <th>@lang('layout.Symbol')</th>
                                <th>@lang('layout.Quantity')</th>
                                <th>@lang('layout.Price')</th> 
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
 @push('scripts')
<script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#sales').DataTable({
            ajax:'{{route("return.show",$return->id)}}',
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [  

                { data: 'itemName',  name: 'itemName' },
                { data: 'site',      name: 'site'},
                @if(getOtherMeasure()=="true")
                { data: 'other_measure', name: 'other_measure', orderable: false, searchable: false },
                @endif
                @if(getOtherMeasure2()=="true")
                { data: 'other_measure2', name: 'other_measure2', orderable: false, searchable: false},
                @endif
                { data: 'measure',        name: 'measure'},
                { data: 'qty',       name: 'qty'},
                { data: 'price',     name: 'price'}, 
        ]
        });

    });
</script>


@endpush 