@extends('layouts.app')
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'returnList'"
                      @closed="closeModal">
            <div slot="body">
                <input type="hidden" name="category" value="WriteCheck"/>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    <!-- END PAGE HEADER-->
    <div class="tabbable-line">
        <ul class="nav nav-tabs">
            <li class="active">
                <a href="#tab2" data-toggle="tab" style="font-size: 16px; font-style: bold">@lang('layout.BillReturns')
                    <i class="icon-note"></i> </a>
            </li>
            <li>
                <a href="#tab1" data-toggle="tab"
                   style="font-size: 16px; font-style: bold">@lang('layout.WriteCheckReturn') <i
                            class="icon-book-open"></i></a>
            </li>

        </ul>
        <div class="tab-content">
            <div class="tab-pane" id="tab1">
                <!-- BEGIN TAB PORTLET-->
                <div class="row">


                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.WriteCheckReturnList')</span>
                            </div>
                            <div class="tools"></div>
                            <div class="pull-right">
                                @permission('return-export')

                                <span id="anchore-modal">
                                    <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                        <i class="fa fa-print"></i>
                                    </a>
                                </span>
                                @endpermission
                                @permission('return-create')
                                <a href="{{route('simpleReturnWriteCheck.create')}}">
                                    <button id="sample_editable_1_new" class="btn btn-success">
                                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                    </button>
                                </a>
                                @endpermission

                            </div>
                        </div>
                        <div class="portlet-body">

                            <template v-cloak id="purchase_return_data_table">
                                <company @company="setCompany"></company>
                            </template>
                            <table class="table table-striped table-bordered " cellspacing="0" id="purchase_return">
                                <thead>
                                <tr>
                                    <th>@lang('layout.PurchaseNumber')</th>
                                    <th>@lang('layout.ReturnNo')</th>
                                    <th>@lang('layout.ReferenceNumber')</th>
                                    <th>@lang('layout.Vendor')</th>
                                    <th>@lang('layout.Currency')</th>
                                    <th>@lang('layout.Rate')</th>
                                    <th>@lang('layout.Amount')</th>
                                    <th>@lang('layout.Date')</th>
                                    <th>@lang('layout.User')</th>
                                    <th style="width: 40% !important;">@lang('layout.Actions')</th>
                                </tr>
                                </thead>

                            </table>
                        </div>
                    </div>
                    <!-- END EXAMPLE TABLE PORTLET-->
                </div>
            </div>

            <div class="tab-pane active" id="tab2">

                <div id="print-modal-bill">
                    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'returnList'" @closed="closeModal">
                        <div slot="body">
                            <input type="hidden" name="category" value="Bill"/>
                            <div class="row">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.Date')</label>
                                            <div class="input-group">
                                                <input class="form-control date" id="range-from-example"
                                                       name="from_date">

                                                <span class="input-group-addon"> @lang('layout.To') </span>
                                                <input class="form-control date" id="range-to-example" name="to_date">

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </report-modal>
                </div>

                <div class="row">

                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.BillReturnList')</span>
                            </div>
                            <div class="tools"></div>
                            <div class="pull-right">
                                @permission('return-export')
                                <span id="bill-modal">
                                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                        <i class="fa fa-print"></i>
                                     </a>
                                 </span>
                                @endpermission
                                @permission('return-create')
                                <a href="{{route('simpleReturnBill.create')}}">
                                    <button id="sample_editable_1_new" class="btn btn-success">
                                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                    </button>
                                </a>
                                @endpermission

                            </div>
                        </div>
                        <div class="portlet-body">

                            <template v-cloak id="bill_return_data_table">
                                <company @company="setCompany"></company>
                            </template>

                            <table class="table table-striped table-bordered table-hover" cellspacing="0"
                                   id="bill_return">
                                <thead>
                                    <tr>
                                        <th>@lang('layout.PurchaseNumber')</th>
                                        <th>@lang('layout.ReturnNo')</th>
                                        <th>@lang('layout.ReferenceNumber')</th>
                                        <th>@lang('layout.Vendor')</th>
                                        <th>@lang('layout.Currency')</th>
                                        <th>@lang('layout.Rate')</th>
                                        <th>@lang('layout.Amount')</th>
                                        <th>@lang('layout.Date')</th>
                                        <th>@lang('layout.User')</th>
                                        <th>@lang('layout.Actions')</th>
                                    </tr>
                                </thead>

                            </table>
                        </div>
                    </div>
                    <!-- END EXAMPLE TABLE PORTLET-->
                </div>
            </div>

        </div>
    </div>

    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY
<div id="factor-obj" >
    @if (Session('message'))
        <object  data="{{url('factor22.pdf')}}" type="application/pdf" width="0" height="0"> </object>

    @endif
            </div> -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        let data_table_purchase_return;
        let data_table_bill_return;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table_purchase_return = $('#purchase_return').DataTable({
                ajax: {
                    url: '{{route("return.index")}}',
                    data: function (d) {
                        d.type = 'WriteCheck';
                    }
                },
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?1:7}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [

                    {data: 'purchase_number', name: 'purchase_number', searchable: false, orderable: false},
                    {data: 'number', name: 'return_backs.number'},
                    {data: 'ref_no', name: 'return_backs.ref_no'},
                    {data: 'member_name', name: 'members.name'},
                    {data: 'currency', name: 'return_backs.currency'},
                    {data: 'rate', name: 'currency', searchable: false, orderable: false},
                    {data: 'amount', name: 'amount', searchable: false, orderable: false},
                    {data: 'date', name: 'date'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'action', searchable: false, orderable: false},
//            

                ]
            });
            data_table_bill_return = $('#bill_return').DataTable({
                ajax: {
                    url: '{{route("return.index")}}',
                    data: function (d) {
                        d.type = 'Bill';
                    }
                },
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                order: [["{{orderByColumn()=='number'?1:7}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'purchase_number', name: 'purchase_number', searchable: false, orderable: false},
                    {data: 'number', name: 'return_backs.number'},
                    {data: 'ref_no', name: 'return_backs.ref_no'},
                    {data: 'member_name', name: 'members.name'},
                    {data: 'currency', name: 'return_backs.currency'},
                    {data: 'rate', name: 'currency', searchable: false, orderable: false},
                    {data: 'amount', name: 'amount', searchable: false, orderable: false},
                    {data: 'date', name: 'date'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'action', searchable: false, orderable: false},

                ]
            });

        });

        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });

        // for new modal

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        // /for new modal

        // for new modal bill return tub

        var vm1 = new Vue({
            el: '#print-modal-bill',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#bill-modal',
            methods: {
                showModal: function () {
                    console.log('bill modal')
                    vm1.$data.is_show = true;

                }
            }
        });
        // /for new modal

        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#appp',
            data: {
                showModal: false,
                selectedMember: null,
                member: null,
            },
            methods: {
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample: function () {

                    this.member ={!!$member!!}
                        //Your other code that launches the modal
                        this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
        $('#print_pdf').on('click', function (e) {
            $('#show-modal1').click();
            e.preventDefault();
        })


        new Vue({
            el: '#app4',
            data: {
                showModal: false,
                selectedMember: null,
                member: null,
            },
            methods: {
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample4: function () {
                    this.member ={!!$member!!}

                        //Your other code that launches the modal
                        this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
        $('#excell_all4').on('click', function (e) {
            $('#show-modal4').click();
            e.preventDefault();
        })


        new Vue({
            el: '#rr',
            data: {
                showModal: false
            },
            methods: {
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExamplerr: function () {

                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
        $('#addNewRefundd').on('click', function (e) {
            $('#show-modalrr').click();
            e.preventDefault();
        })

        new Vue({
            el: '#ww',
            data: {
                showModal: false
            },
            methods: {
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExampleww: function () {

                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
        $('#addNewRefundpp').on('click', function (e) {
            $('#show-modalww').click();
            e.preventDefault();
        });


        new Vue({
            el: '#purchase_return_data_table',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table_purchase_return == 'object') {
                        data_table_purchase_return.clear();
                        data_table_purchase_return.ajax.reload();
                    }
                }
            }
        });

        new Vue({
            el: '#bill_return_data_table',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table_bill_return == 'object') {
                        data_table_bill_return.clear();
                        data_table_bill_return.ajax.reload();
                    }
                }
            }
        });
    </script>


@endpush
